import { a4 as sanitize_props, a5 as rest_props, a6 as fallback, $ as setContext, a7 as attributes, a8 as clsx, a0 as slot, a9 as bind_props, a1 as store_get, a3 as unsubscribe_stores, ad as attr_class, am as getContext, aa as escape_html } from "./index2.js";
import { c as createEventDispatcher } from "./index-server.js";
import { w as writable } from "./index.js";
import { c as classnames } from "./Theme.svelte_svelte_type_style_lang.js";
function Accordion($$renderer, $$props) {
  const $$sanitized_props = sanitize_props($$props);
  const $$restProps = rest_props($$sanitized_props, ["class", "flush", "stayOpen", "theme"]);
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let classes;
    const dispatch = createEventDispatcher();
    let className = fallback($$props["class"], "");
    let flush = fallback($$props["flush"], false);
    let stayOpen = fallback($$props["stayOpen"], false);
    let theme = fallback($$props["theme"], void 0);
    const open = writable(null);
    setContext("accordion", {
      open,
      stayOpen,
      toggle: (element) => {
        if (store_get($$store_subs ??= {}, "$open", open) === element) {
          open.set(null);
        } else {
          open.set(element);
        }
        dispatch("toggle", {
          [element]: store_get($$store_subs ??= {}, "$open", open) === element
        });
      }
    });
    classes = classnames(className, "accordion", { "accordion-flush": flush });
    $$renderer2.push(`<div${attributes({
      class: clsx(classes),
      "data-bs-theme": theme,
      ...$$restProps
    })}><!--[-->`);
    slot($$renderer2, $$props, "default", {}, null);
    $$renderer2.push(`<!--]--></div>`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, { class: className, flush, stayOpen, theme });
  });
}
function AccordionHeader($$renderer, $$props) {
  const $$sanitized_props = sanitize_props($$props);
  const $$restProps = rest_props($$sanitized_props, ["class"]);
  $$renderer.component(($$renderer2) => {
    let classes;
    let className = fallback($$props["class"], "");
    classes = classnames(className, "accordion-button");
    $$renderer2.push(`<h2${attributes({ class: "accordion-header", ...$$restProps })}><button type="button"${attr_class(clsx(classes))}><!--[-->`);
    slot($$renderer2, $$props, "default", {}, null);
    $$renderer2.push(`<!--]--></button></h2>`);
    bind_props($$props, { class: className });
  });
}
function Collapse($$renderer, $$props) {
  const $$sanitized_props = sanitize_props($$props);
  const $$restProps = rest_props($$sanitized_props, [
    "isOpen",
    "class",
    "horizontal",
    "navbar",
    "onEntering",
    "onEntered",
    "onExiting",
    "onExited",
    "expand",
    "toggler"
  ]);
  $$renderer.component(($$renderer2) => {
    let classes;
    const dispatch = createEventDispatcher();
    let isOpen = fallback($$props["isOpen"], false);
    let className = fallback($$props["class"], "");
    let horizontal = fallback($$props["horizontal"], false);
    let navbar = fallback($$props["navbar"], false);
    let onEntering = fallback($$props["onEntering"], () => dispatch("opening"));
    let onEntered = fallback($$props["onEntered"], () => dispatch("open"));
    let onExiting = fallback($$props["onExiting"], () => dispatch("closing"));
    let onExited = fallback($$props["onExited"], () => dispatch("close"));
    let expand = fallback($$props["expand"], false);
    let toggler = fallback($$props["toggler"], null);
    let windowWidth = 0;
    let _wasMaximized = false;
    const minWidth = {};
    minWidth["xs"] = 0;
    minWidth["sm"] = 576;
    minWidth["md"] = 768;
    minWidth["lg"] = 992;
    minWidth["xl"] = 1200;
    classes = classnames(className, { "collapse-horizontal": horizontal, "navbar-collapse": navbar });
    if (navbar && expand) {
      if (windowWidth >= minWidth[expand] && !isOpen) {
        isOpen = true;
        _wasMaximized = true;
      } else if (windowWidth < minWidth[expand] && _wasMaximized) {
        isOpen = false;
        _wasMaximized = false;
      }
    }
    if (isOpen) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<div${attributes({
        style: navbar ? void 0 : "overflow: hidden;",
        ...$$restProps,
        class: clsx(classes)
      })}><!--[-->`);
      slot($$renderer2, $$props, "default", {}, null);
      $$renderer2.push(`<!--]--></div>`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]-->`);
    bind_props($$props, {
      isOpen,
      class: className,
      horizontal,
      navbar,
      onEntering,
      onEntered,
      onExiting,
      onExited,
      expand,
      toggler
    });
  });
}
function AccordionItem($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let classes, isOpen;
    let className = fallback($$props["class"], "");
    let header = fallback($$props["header"], "");
    let active = fallback($$props["active"], false);
    const { stayOpen, toggle, open } = getContext("accordion");
    let accordionRef;
    classes = classnames(className, "accordion-item");
    isOpen = stayOpen ? active : store_get($$store_subs ??= {}, "$open", open) === accordionRef;
    $$renderer2.push(`<div${attr_class(clsx(classes))}>`);
    AccordionHeader($$renderer2, {
      class: !isOpen && "collapsed",
      children: ($$renderer3) => {
        $$renderer3.push(`<!--[-->`);
        slot($$renderer3, $$props, "header", {}, null);
        $$renderer3.push(`<!--]--> ${escape_html(header)}`);
      },
      $$slots: { default: true }
    });
    $$renderer2.push(`<!----> `);
    Collapse($$renderer2, {
      isOpen,
      class: "accordion-collapse",
      children: ($$renderer3) => {
        $$renderer3.push(`<div class="accordion-body"><!--[-->`);
        slot($$renderer3, $$props, "default", {}, null);
        $$renderer3.push(`<!--]--></div>`);
      },
      $$slots: { default: true }
    });
    $$renderer2.push(`<!----></div>`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, { class: className, header, active });
  });
}
export {
  Accordion as A,
  AccordionItem as a
};
