import React, { lazy, useEffect } from 'react';
import { Route, Routes, useNavigate } from 'react-router-dom';
import AuthLayout from '../container/profile/authentication/Index';

const ForgotPass = lazy(() => import('../container/profile/authentication/overview/ForgotPassword'));
const Login = lazy(() => import('../container/profile/authentication/overview/SignIn'));
const FbLogin = lazy(() => import('../container/profile/authentication/overview/FbSignIn'));
const SignUp = lazy(() => import('../container/profile/authentication/overview/Signup'));
const FbSignUp = lazy(() => import('../container/profile/authentication/overview/FbSignup'));

const AuthRoot = () => {
  const navigate = useNavigate();
  useEffect(() => navigate('/'));
};

const FrontendRoutes = React.memo(() => {
  return (
    <Routes>
      <Route index element={<Login />} />
      <Route path="forgotPassword" element={<ForgotPass />} />
      <Route path="register" element={<SignUp />} />
      <Route path="fbSignIn" element={<FbLogin />} />
      <Route path="fbRegister" element={<FbSignUp />} />
      <Route path="*" element={<AuthRoot />} />
    </Routes>
  );
});
FrontendRoutes.displayName = 'FrontendRoutes';

export default AuthLayout(FrontendRoutes);