import React from 'react';
import { Form, Input, Select } from 'antd';
import { Button } from '../../components/buttons/buttons';
import { Modal } from '../../components/modals/antd-modals';
import { BasicFormWrapper } from '../styled';

const { Option } = Select;

function SupportCreate({ visible, onCancel, handleSubmit }) {
  // const [form] = Form.useForm();

  const handleOk = (value) => {
    handleSubmit(value);
  };

  const handleCancel = () => {
    onCancel();
  };

  return (
    <Modal
      getContainer={false}
      type="primary"
      title="Create Support"
      visible={visible}
      footer={null}
      onCancel={handleCancel}
    >
      <div className="project-modal">
        <BasicFormWrapper>
          <Form name="supportCreate" onFinish={handleOk}>
            <Form.Item
              name="email"
              label="Email"
              rules={[
                {
                  required: true,
                  type: 'email',
                },
              ]}
            >
              <Input />
            </Form.Item>
            <Form.Item
              name="subject"
              label="Subject"
              rules={[
                {
                  required: true,
                },
              ]}
            >
              <Input />
            </Form.Item>
            <Form.Item name="priority" initialValue="high" label="Priority">
              <Select style={{ width: '100%' }}>
                <Option value="high">High</Option>
                <Option value="medium">Medium</Option>
                <Option value="low">Low</Option>
              </Select>
            </Form.Item>
            <Form.Item name="status" initialValue="open" label="Status">
              <Select style={{ width: '100%' }}>
                <Option value="open">Open</Option>
                <Option value="close">Close</Option>
                <Option value="pending">Pending</Option>
              </Select>
            </Form.Item>
            <Form.Item
              name="description"
              label="Description"
              rules={[
                {
                  required: true,
                },
              ]}
            >
              <Input.TextArea rows={4} />
            </Form.Item>
            <Form.Item>
              <Button size="default" htmlType="submit" type="primary" key="submit" onClick={() => handleOk}>
                Submit Ticket
              </Button>
            </Form.Item>
          </Form>
        </BasicFormWrapper>
      </div>
    </Modal>
  );
}


export default SupportCreate;
