 
 
import React, { useState, useMemo } from 'react';
import { Input, Modal, Progress } from 'antd';
import { useSelector, useDispatch } from 'react-redux';
import { Link } from 'react-router-dom';
import UilTimes from '@iconscout/react-unicons/icons/uil-times';
import UilCheckSquare from '@iconscout/react-unicons/icons/uil-check-square';
import { ChecklistWrap } from '../Style';
import { Dropdown } from '../../../components/dropdown/dropdown';
import { Checkbox } from '../../../components/checkbox/checkbox';
import { Button } from '../../../components/buttons/buttons';
import { ToAddTask } from '../../../redux/kanban/actionCreator';

function UpdateTask({ data, modalVisible, handleCancel }) {
  const { checklist } = data;
  const dispatch = useDispatch();
  // Memoize selector to prevent unnecessary re-renders
  const tasksSelector = useMemo(() => (state) => state.KanbanBoard.taskData, []);
  const tasks = useSelector(tasksSelector);

  const [state, setState] = useState({
    editable: false,
    checkListPopup: '',
  });
  const { editable, checkListPopup } = state;

  const handleTaskEdit = () => {
    setState({
      ...state,
      editable: !editable,
    });
  };

  const onCancelEdit = (e) => {
    e.preventDefault();
    setState({
      ...state,
      editable: false,
    });
  };

  const onChange = (value, listId, taskId) => {
    tasks.map((task) => {
      if (data.id === task.id) {
        return task.checklist.map((list) => {
          if (list.id === listId) {
            return list.checkListTask.map((item) => {
              if (item.id === taskId) {
                const singleItem = item;
                singleItem.checked = value;
              }
              return item;
            });
          }
          return list;
        });
      }
      return task;
    });
    dispatch(ToAddTask(tasks));
  };

  const onCheckListItemDelete = (listId, taskId) => {
    const confirm = window.confirm('Are you sure to delete this?');
    if (confirm) {
      tasks.map((task) => {
        if (data.id === task.id) {
          return task.checklist.map((list) => {
            if (list.id === listId) {
              return list.checkListTask.map((item) => {
                if (item.id === taskId) {
                  const index = list.checkListTask.indexOf(item);
                  list.checkListTask.splice(index, 1);
                }
                return item;
              });
            }
            return list;
          });
        }
        return task;
      });
      dispatch(ToAddTask(tasks));
    }
    return false;
  };

  const onCheckListItemAdd = (listId, checkListTask) => {
    const arrayData = [];
    const checkItem = document.querySelector(`input[name="checkListAddInputValue"]`).value;
    checkListTask.map((item) => {
      return arrayData.push(item.id);
    });
    const max = checkListTask.length ? Math.max(...arrayData) : 0;
    tasks.map((task) => {
      if (data.id === task.id) {
        return task.checklist.map((list) => {
          if (list.id === listId) {
            return list.checkListTask.push({
              id: `${max + 1}`,
              label: checkItem,
              checked: false,
            });
          }
          return list;
        });
      }
      return task;
    });
    dispatch(ToAddTask(tasks));
    setState({
      ...state,
      checkListPopup: '',
    });
  };

  const onCheckListSubmit = (id, boardId, checkList) => {
    const arrayData = [];
    const checkItem = document.querySelector(`input[name="checkListInputValue"]`).value;
    checkList.map((item) => {
      return arrayData.push(item.id);
    });
    const max = checkList.length ? Math.max(...arrayData) : 0;
    tasks.map((item) => {
      if (item.id === id && item.boardId === boardId) {
        return item.checklist.push({
          id: `${max + 1}`,
          label: checkItem,
          checkListTask: [],
        });
      }
      return item;
    });
    dispatch(ToAddTask(tasks));
    setState({
      ...state,
      editable: false,
    });
  };

  const onCheckListDelete = (id, boardId, checkList, delId, event) => {
    event.preventDefault();
    const confirm = window.confirm('Are you sure to delete this?');
    if (confirm) {
      tasks.map((item) => {
        if (item.id === id && item.boardId === boardId) {
          return item.checklist.map((listItem) => {
            if (listItem.id === delId) {
              const index = item.checklist.indexOf(listItem);
              item.checklist.splice(index, 1);
            }
            return listItem;
          });
        }
        return item;
      });
      dispatch(ToAddTask(tasks));
    }
    return false;
  };

  const onShowChecklistAddPopup = (id) => {
    setState({
      ...state,
      checkListPopup: id,
    });
  };

  const onHideChecklistAddPopup = () => {
    setState({
      ...state,
      checkListPopup: '',
    });
  };

  return (
    <Modal
      title={
        <>
          <h4>{data.title}</h4> <span className="sub-text">in list Active Project</span>
        </>
      }
      wrapClassName="ninjadash-task-details"
      visible={modalVisible}
      footer={null}
      onCancel={handleCancel}
    >
      <div className="ninjadash-task-details-modal">
        <div className="ninjadash-task-details-modal__description">
          <span className="ninjadash-task-details__label">Description</span>
          <textarea name="task-details-label" placeholder="Add a more detailed description…" />
        </div>
      </div>

      <ChecklistWrap>
        <div className="ninjadash-checklist-block">
          <div className="addChecklist-wrap">
            <Button onClick={handleTaskEdit} className="btn-checklist" type="primary">
              <UilCheckSquare />
              Add Checklist
            </Button>
            {!editable ? null : (
              <div className="addChecklist-form">
                <Input
                  name="checkListInputValue"
                  className="add-checklist"
                  placeholder="Checklist Title"
                  onPressEnter={() => onCheckListSubmit(data.id, data.boardId, checklist)}
                />
                <div className="addChecklist-form-action">
                  <Button
                    onClick={() => onCheckListSubmit(data.id, data.boardId, checklist)}
                    className="btn-add"
                    size="small"
                    type="primary"
                  >
                    Add
                  </Button>
                  <Link onClick={onCancelEdit} to="#">
                    <UilTimes />
                  </Link>
                </div>
              </div>
            )}
          </div>
          <div className="ninjadash-checklist-row">
            {checklist.map((item, i) => {
              const checkedLength = item.checkListTask.filter((checked) => checked.checked === true);
              return (
                <div className="ninjadash-checklist-item" key={item.id}>
                  <div className="ninjadash-checklist-item__top">
                    <h4 className="ninjadash-checklist-item__title">{item.label} </h4>
                    <Button
                      onClick={(event) => onCheckListDelete(data.id, data.boardId, checklist, item.id, event)}
                      className="btn-delete"
                      type="light"
                    >
                      Delete
                    </Button>
                  </div>
                  <div className="ninjadash-checklist__progress">
                    {item.checkListTask.length ? (
                      <Progress percent={Math.round((100 * checkedLength.length) / item.checkListTask.length)} />
                    ) : null}
                  </div>
                  <div className="ninjadash-checklist-tasks-wrap">
                    <ul className="ninjadash-checklist-tasks">
                      {item.checkListTask.map((task) => {
                        return (
                          <li className="ninjadash-checklist-tasks__single" key={`${item.id}-${task.id}`}>
                            <Checkbox checked={task.checked} onChange={(value) => onChange(value, item.id, task.id)}>
                              <span className="ninjadash-task-label">{task.label}</span>
                            </Checkbox>
                            <Dropdown
                              content={
                                <Link onClick={() => onCheckListItemDelete(item.id, task.id)} to="#">
                                  <span>Delete List</span>
                                </Link>
                              }
                              action={['click']}
                              className="wide-dropdwon kanbanCard-more"
                            >
                              <Link to="#" className="btn-more">
                                <UilTimes />
                              </Link>
                            </Dropdown>
                          </li>
                        );
                      })}
                    </ul>
                    <div className="addChecklistTask-wrap">
                      {checkListPopup !== `cp-${item.id}` ? (
                        <Button
                          onClick={() => onShowChecklistAddPopup(`cp-${item.id}`)}
                          className="add-item"
                          type="light"
                        >
                          Add an Item
                        </Button>
                      ) : (
                        <div className="addChecklistTask-form">
                          <Input
                            name="checkListAddInputValue"
                            className="add-checklistTask"
                            placeholder="Checklist Title"
                            onPressEnter={() => onCheckListItemAdd(item.id, item.checkListTask)}
                          />
                          <div className="addChecklistTask-form-action">
                            <Button
                              onClick={() => onCheckListItemAdd(item.id, item.checkListTask)}
                              className="btn-add"
                              size="small"
                              type="primary"
                            >
                              Add
                            </Button>
                            <Link onClick={onHideChecklistAddPopup} to="#">
                              <UilTimes />
                            </Link>
                          </div>
                        </div>
                      )}
                    </div>
                  </div>
                </div>
              );
            })}
          </div>
        </div>
      </ChecklistWrap>
    </Modal>
  );
}


export default UpdateTask;
