import UilEllipsisH from '@iconscout/react-unicons/icons/uil-ellipsis-h';
import React from 'react';
import { Link } from 'react-router-dom';
import styled from 'styled-components';
import { Dropdown } from '../../dropdown/dropdown';
import { Cards } from '../frame/cards-frame';

const CardWrapper = styled.figure`
  display: flex;
  margin: 0;
  position: relative;
  h2,
  p {
    margin: 0;
  }
  figcaption {
    .more {
      position: absolute;
      top: 0px;
      ${({ theme }) => (theme.rtl ? 'left' : 'right')}: 0;
      a {
        color: ${({ theme }) => theme['extra-light-color']};
      }
    }
    h2 {
      font-size: 20px;
      font-weight: 600;
    }
    p {
      font-size: 14px;
      color: ${({ theme }) => theme['light-color']};
    }
  }
`;

const Icon = styled.div`
  width: 60px;
  height: 60px;
  border-radius: 12px;
  display: flex;
  align-items: center;
  justify-content: center;
  background: ${({ theme, className }) => theme[`${className}-color`]};
  ${({ theme }) => (theme.rtl ? 'margin-left' : 'margin-right')}: 20px;
`;

function SampleCardSix({ item = undefined }) {
  const { content, title, img, className } = item;
  return (
    <Cards headless>
      <CardWrapper>
        <Icon className={className}>
          <img src={require(`../../../${img}`)} alt="" />
        </Icon>
        <figcaption>
          <div className="more">
            <Dropdown
              action={['click']}
              className="wide-dropdwon"
              content={
                <>
                  <Link to="#">Edit</Link>
                  <Link to="#">Delete</Link>
                  <Link to="#">View</Link>
                </>
              }
            >
              <Link to="#">
                <UilEllipsisH />
              </Link>
            </Dropdown>
          </div>
          <h2>{title}</h2>
          <p>{content}</p>
        </figcaption>
      </CardWrapper>
    </Cards>
  );
}



export default SampleCardSix;
