import React, { useEffect, useLayoutEffect, useState } from 'react';
import { Row, Col } from 'antd';
import { Line } from 'peity-react';
import { PageHeader } from '../../components/page-headers/page-headers';
import { Cards } from '../../components/cards/frame/cards-frame';
import Prism from "prismjs";
import { Main } from '../styled';

const Peity = () => {
  const PageRoutes = [
    {
      path: 'index',
      breadcrumbName: 'Dashboard',
    },
    {
      path: 'first',
      breadcrumbName: 'Peity Chart',
    },
  ];
  const [state, setState] = useState({
    responsive: 0,
  });
  const { responsive } = state;

  useLayoutEffect(() => {
    function updateSize() {
      const element = document.querySelector('.recharts-wrapper');
      const width =
        element !== null
          ? element.closest('.ant-card-body').clientWidth
          : document.querySelector('.ant-card-body').clientWidth;
      setState({ responsive: width - 50 });
    }
    window.addEventListener('resize', updateSize);
    updateSize();
    return () => window.removeEventListener('resize', updateSize);
  }, []);
  useEffect(() => {
    Prism.highlightAll();
  }, []);
  return (
    <>
      <PageHeader className="ninjadash-page-header-main" title="Peity Chart" routes={PageRoutes} />
      <Main>
        <Row gutter={25}>
          <Col md={12} sm={24} xs={24}>
            <Cards title="LINE CHART" size="large">
              <Line
                values={[5, 3, 9, 6, 5, 9, 7, 3, 5, 2, 5, 3, 9, 6, 5, 9, 7, 3, 5, 2]}
                height={300}
                width={responsive}
                fillColor="none"
              />
              <div className="docs-highlighter mt-35">
                        <pre>
                            <code className="language-javascript">
{
`
import { Line } from 'peity-react';

<Line
  values={[5, 3, 9, 6, 5, 9, 7, 3, 5, 2, 5, 3, 9, 6, 5, 9, 7, 3, 5, 2]}
  height={300}
  width={responsive}
  fillColor="none"
/>
`
}
                            </code>
                        </pre>
                    </div>
            </Cards>
          </Col>
          <Col md={12} sm={24} xs={24}>
            <Cards title="AREA CHART" size="large">
              <Line
                values={[5, 3, 9, 6, 5, 9, 7, 3, 5, 2, 5, 3, 9, 6, 5, 9, 7, 3, 5, 2]}
                height={300}
                width={responsive}
              />
              <div className="docs-highlighter mt-35">
                        <pre>
                            <code className="language-javascript">
{
`
import { Line } from 'peity-react';

<Line
  values={[5, 3, 9, 6, 5, 9, 7, 3, 5, 2, 5, 3, 9, 6, 5, 9, 7, 3, 5, 2]}
  height={300}
  width={responsive}
/>
`
}
                            </code>
                        </pre>
                    </div>
            </Cards>
          </Col>
        </Row>
      </Main>
    </>
  );
};

export default Peity;
