const express = require('express')
const router = express.Router()
const FeatureController = require('../controllers/feature')
const authMiddleware = require('../middlewares/auth')
const localeMiddleware = require('../middlewares/locale')

router.get('/chart/chartjs/:language(en|gr|ar)', [localeMiddleware.localized, authMiddleware.isAuthenticated], FeatureController.chartJs)
router.get('/chart/google-chart/:language(en|gr|ar)', [localeMiddleware.localized, authMiddleware.isAuthenticated], FeatureController.googleChart)
router.get('/chart/peity-chart/:language(en|gr|ar)', [localeMiddleware.localized, authMiddleware.isAuthenticated], FeatureController.peityChart)

router.get('/form/basic-form/:language(en|gr|ar)', [localeMiddleware.localized, authMiddleware.isAuthenticated], FeatureController.basicForm)
router.get('/form/form-layout/:language(en|gr|ar)', [localeMiddleware.localized, authMiddleware.isAuthenticated], FeatureController.formLayout)
router.get('/form/form-element/:language(en|gr|ar)', [localeMiddleware.localized, authMiddleware.isAuthenticated], FeatureController.formElement)
router.get('/form/components/:language(en|gr|ar)', [localeMiddleware.localized, authMiddleware.isAuthenticated], FeatureController.formComponent)
router.get('/form/validations/:language(en|gr|ar)', [localeMiddleware.localized, authMiddleware.isAuthenticated], FeatureController.formValidation)

router.get('/table/basic/:language(en|gr|ar)', [localeMiddleware.localized, authMiddleware.isAuthenticated], FeatureController.basicTable)
router.get('/table/datatable/:language(en|gr|ar)', [localeMiddleware.localized, authMiddleware.isAuthenticated], FeatureController.dataTable)

router.get('/widget/chart/:language(en|gr|ar)', [localeMiddleware.localized, authMiddleware.isAuthenticated], FeatureController.chartWidget)
router.get('/widget/mixed/:language(en|gr|ar)', [localeMiddleware.localized, authMiddleware.isAuthenticated], FeatureController.mixedWidget)
router.get('/widget/card/:language(en|gr|ar)', [localeMiddleware.localized, authMiddleware.isAuthenticated], FeatureController.cardWidget)

router.get('/wizard/one/:language(en|gr|ar)', [localeMiddleware.localized, authMiddleware.isAuthenticated], FeatureController.wizardOne)
router.get('/wizard/one-two/:language(en|gr|ar)', [localeMiddleware.localized, authMiddleware.isAuthenticated], FeatureController.wizardOneTwo)
router.get('/wizard/one-three/:language(en|gr|ar)', [localeMiddleware.localized, authMiddleware.isAuthenticated], FeatureController.wizardOneThree)
router.get('/wizard/one-four/:language(en|gr|ar)', [localeMiddleware.localized, authMiddleware.isAuthenticated], FeatureController.wizardOneFour)
router.get('/wizard/one-five/:language(en|gr|ar)', [localeMiddleware.localized, authMiddleware.isAuthenticated], FeatureController.wizardOneFive)
router.get('/wizard/two/:language(en|gr|ar)', [localeMiddleware.localized, authMiddleware.isAuthenticated], FeatureController.wizardTwo)
router.get('/wizard/two-two/:language(en|gr|ar)', [localeMiddleware.localized, authMiddleware.isAuthenticated], FeatureController.wizardTwoTwo)
router.get('/wizard/two-three/:language(en|gr|ar)', [localeMiddleware.localized, authMiddleware.isAuthenticated], FeatureController.wizardTwoThree)
router.get('/wizard/two-four/:language(en|gr|ar)', [localeMiddleware.localized, authMiddleware.isAuthenticated], FeatureController.wizardTwoFour)
router.get('/wizard/two-five/:language(en|gr|ar)', [localeMiddleware.localized, authMiddleware.isAuthenticated], FeatureController.wizardTwoFive)
router.get('/wizard/three/:language(en|gr|ar)', [localeMiddleware.localized, authMiddleware.isAuthenticated], FeatureController.wizardThree)
router.get('/wizard/three-two/:language(en|gr|ar)', [localeMiddleware.localized, authMiddleware.isAuthenticated], FeatureController.wizardThreeTwo)
router.get('/wizard/three-three/:language(en|gr|ar)', [localeMiddleware.localized, authMiddleware.isAuthenticated], FeatureController.wizardThreeThree)
router.get('/wizard/three-four/:language(en|gr|ar)', [localeMiddleware.localized, authMiddleware.isAuthenticated], FeatureController.wizardThreeFour)
router.get('/wizard/three-five/:language(en|gr|ar)', [localeMiddleware.localized, authMiddleware.isAuthenticated], FeatureController.wizardThreeFive)
router.get('/wizard/four/:language(en|gr|ar)', [localeMiddleware.localized, authMiddleware.isAuthenticated], FeatureController.wizardFour)
router.get('/wizard/four-two/:language(en|gr|ar)', [localeMiddleware.localized, authMiddleware.isAuthenticated], FeatureController.wizardFourTwo)
router.get('/wizard/four-three/:language(en|gr|ar)', [localeMiddleware.localized, authMiddleware.isAuthenticated], FeatureController.wizardFourThree)
router.get('/wizard/four-four/:language(en|gr|ar)', [localeMiddleware.localized, authMiddleware.isAuthenticated], FeatureController.wizardFourFour)
router.get('/wizard/four-five/:language(en|gr|ar)', [localeMiddleware.localized, authMiddleware.isAuthenticated], FeatureController.wizardFourFive)
router.get('/wizard/five/:language(en|gr|ar)', [localeMiddleware.localized, authMiddleware.isAuthenticated], FeatureController.wizardFive)
router.get('/wizard/five-two/:language(en|gr|ar)', [localeMiddleware.localized, authMiddleware.isAuthenticated], FeatureController.wizardFiveTwo)
router.get('/wizard/five-three/:language(en|gr|ar)', [localeMiddleware.localized, authMiddleware.isAuthenticated], FeatureController.wizardFiveThree)
router.get('/wizard/five-four/:language(en|gr|ar)', [localeMiddleware.localized, authMiddleware.isAuthenticated], FeatureController.wizardFiveFour)

router.get('/icon/unicons/:language(en|gr|ar)', [localeMiddleware.localized, authMiddleware.isAuthenticated], FeatureController.uniconIcon)
router.get('/icon/fontawesome/:language(en|gr|ar)', [localeMiddleware.localized, authMiddleware.isAuthenticated], FeatureController.fontAwesomeIcon)
router.get('/icon/lineawesome/:language(en|gr|ar)', [localeMiddleware.localized, authMiddleware.isAuthenticated], FeatureController.lineAwesomeIcon)

router.get('/editor/:language(en|gr|ar)', [localeMiddleware.localized, authMiddleware.isAuthenticated], FeatureController.editor)

router.get('/map/google/:language(en|gr|ar)', [localeMiddleware.localized, authMiddleware.isAuthenticated], FeatureController.googleMap)
router.get('/map/leaflet/:language(en|gr|ar)', [localeMiddleware.localized, authMiddleware.isAuthenticated], FeatureController.leafletMap)
router.get('/map/vector/:language(en|gr|ar)', [localeMiddleware.localized, authMiddleware.isAuthenticated], FeatureController.vectorMap)

module.exports = router