import { useLayoutEffect, useState } from 'react';
import { Row, Col } from 'antd';
import { RadialBarChart, RadialBar, Legend } from 'recharts';
import { PageHeaders } from '@/components/page-headers';
import { Cards } from '@/components/cards/frame/cards-frame';

const style = {
  top: 0,
  right: '20%',
  lineHeight: '24px',
};
const data = [
  {
    name: '18-24',
    uv: 31.47,
    pv: 2400,
    fill: '#8884d8',
  },
  {
    name: '25-29',
    uv: 26.69,
    pv: 4567,
    fill: '#83a6ed',
  },
  {
    name: '30-34',
    uv: 15.69,
    pv: 1398,
    fill: '#8dd1e1',
  },
  {
    name: '35-39',
    uv: 8.22,
    pv: 9800,
    fill: '#82ca9d',
  },
  {
    name: '40-49',
    uv: 8.63,
    pv: 3908,
    fill: '#a4de6c',
  },
  {
    name: '50-59',
    uv: 2.63,
    pv: 4800,
    fill: '#d0ed57',
  },
  {
    name: '60+',
    uv: 6.67,
    pv: 4800,
    fill: '#ffc658',
  },
];

function ReChartRadial() {
  const PageRoutes = [
    {
      path: 'index',
      breadcrumbName: 'Dashboard',
    },
    {
      path: 'first',
      breadcrumbName: 'Radial Chart',
    },
  ];
  const [state, setState]:any = useState({
    responsive: 1096,
  });

  const { responsive } = state;

  useLayoutEffect(() => {
    function updateSize() {
      const element:HTMLElement | null = document.querySelector('.recharts-wrapper');
      const cardBody:HTMLElement | null = document.querySelector('.ant-card-body');
      const closestElement = element !== null ? element.closest('.ant-card-body') : null;
      const width = closestElement !== null ? closestElement.clientWidth : cardBody ? cardBody.clientWidth : 1096;
      setState({ responsive: width });
    }
    window.addEventListener('resize', updateSize);
    updateSize();
    return () => window.removeEventListener('resize', updateSize);
  }, []);
  
  const height = responsive >= 797 ? responsive / 3 : responsive / 1.5;
  const width = responsive - (5 * responsive) / 100;
  
  return (
    <>
      <PageHeaders
        className="flex items-center justify-between px-8 xl:px-[15px] pt-[18px] pb-6 sm:pb-[30px] bg-transparent sm:flex-col"
        title="Radial Chart"
        routes={PageRoutes}
      />
      <main className="min-h-[715px] lg:min-h-[580px] px-8 xl:px-[15px] pb-[30px] bg-transparent">
        <Row gutter={25}>
          <Col xs={24}>
            <Cards className="ant-card-extra-none" title="SIMPLE RADIAL BAR CHART" size="large">
              <RadialBarChart
                width={width}
                height={height}
                cx={responsive >= 1200 ? responsive / 2.2 : responsive / 3}
                cy={responsive >= 797 ? responsive / 2 - height : responsive / 2 - height / 3 + 15}
                innerRadius={responsive >= 797 ? 20 : 10}
                outerRadius={responsive >= 797 ? 140 : 90}
                barSize={10}
                data={data}
              > 
                <RadialBar
                  // minAngle={15}
                  // clockWise
                  dataKey="uv"
                  background
                  label={{ position: 'insideStart', fill: '#fff' }}
                />
                <Legend
                  iconSize={10}
                  width={responsive / 9}
                  height={responsive / 9}
                  layout="vertical"
                  verticalAlign="middle"
                  wrapperStyle={style}
                />
              </RadialBarChart>
            </Cards>
          </Col>
        </Row>
      </main>
    </>
  );
}

export default ReChartRadial;
