<?php

/**
 * Get Status Meta
 *
 * @param string $status_key
 * @return array Status
 */
function get_status_meta( $status_key = '' ) {
    $metas = [
        'active'   => [
            'label' => 'Active',
            'class' => 'success',
        ],
        'inactive' => [
            'label' => 'Inactive',
            'class' => 'warning',
        ],
        'blocked'  => [
            'label' => 'Blocked',
            'class' => 'danger',
        ],
    ];

    if ( empty( $status_key ) ) {
        return $metas;
    }

    if ( in_array( $status_key, array_keys( $metas ) ) ) {
        return $metas[ $status_key ];
    }

    return [];
}

/**
 * Get Status Class
 *
 * @param string $status_key
 * @return string Status Class
 */
function get_status_class( $status_key = '' ) {

    $status_meta = get_status_meta( $status_key );

    if ( empty( $status_meta['class'] ) ) {
        return '';
    }

    return $status_meta['class'];
}

/**
 * Get Status label
 *
 * @param string $status_key
 * @return string Status label
 */
function get_status_label( $status_key = '' ) {
    $status_meta = get_status_meta( $status_key );

    if ( empty( $status_meta['label'] ) ) {
        return '';
    }

    return $status_meta['label'];
}
