<?php
/**
 * @author     Manual
 * @copyright  (c) Copyright by Manual
 * @link       https://smartwpthemes.com/
 * @package    Manual
 * @since      4.0
 */
 
/******************************************
 ***  WOOCOMMERCE DROPDOWN CART ***
******************************************/
class manual__woocommerce_menu_cart extends WP_Widget {

	public function __construct() {
		parent::__construct(
	 		'manual-woocommerce-menu-cart', // Base ID
			esc_html__('WooCommerce Shop Cart', 'manual-framework'),
			array( 'description' => __( 'Manual WooCommerce Shop Cart', 'manual-framework' ), ) // Args
		);
	}

	public function widget( $args, $instance ) {
		extract( $args );
		global $post, $woocommerce;
		if( !empty($woocommerce->cart) ) {
		if( $woocommerce ) {
		$defaults = array(
			'add_to_card_padding' => '0px 0px 0px 0px',
		);
		$icon_padding = ( isset( $instance['add_to_card_padding'] ) && '' !== $instance['add_to_card_padding'] ) ? $instance['add_to_card_padding'] : $defaults['add_to_card_padding'];
		echo '<div class="shopping_cart_outer" style="padding:'.$icon_padding.'">
		<div class="shopping_cart_inner">
		<div class="shopping_cart_header">
		<a class="fa fa-shopping-basket header_cart" href="'.wc_get_cart_url().'"><span class="header_cart_span">'. $woocommerce->cart->cart_contents_count.'</span></a>
			<div class="shopping_cart_dropdown">
			<div class="shopping_cart_dropdown_inner">';
            
			$cart_is_empty = sizeof( $woocommerce->cart->get_cart() ) <= 0;
			$list_class = array( 'cart_list', 'product_list_widget' );
					echo '<ul class="'. implode(' ', $list_class).'">';
						if ( !$cart_is_empty ) : 
							foreach ( $woocommerce->cart->get_cart() as $cart_item_key => $cart_item ) :
								$_product = $cart_item['data'];
								// Only display if allowed
								if ( ! $_product->exists() || $cart_item['quantity'] == 0 ) {
									continue;
								}
								// Get price
								$product_price = get_option( 'woocommerce_tax_display_cart' ) == 'excl' ? ( function_exists( 'wc_get_price_excluding_tax' )? wc_get_price_excluding_tax( $_product ): $_product->get_price_excluding_tax() ) /*$_product->get_price_excluding_tax()*/ : $_product->get_price_including_tax();
								$product_price = apply_filters( 'woocommerce_cart_item_price_html', wc_price( $product_price ), $cart_item, $cart_item_key );
								echo '<li>';
								echo '<a href="'. get_permalink( $cart_item['product_id'] ) .'">';
								echo ''.$_product->get_image().''; 
								echo apply_filters('woocommerce_widget_cart_product_title', $_product->get_title(), $_product );
								echo '</a>';
								echo wc_get_formatted_cart_item_data( $cart_item ); 
								echo apply_filters( 'woocommerce_widget_cart_item_quantity', '<span class="quantity">' . sprintf( '%s &times; %s', $cart_item['quantity'], $product_price ) . '</span>', $cart_item, $cart_item_key ); 
							    echo '</li>';
						endforeach;
						else :
					echo '<li>'. __( 'No products in the cart.', 'manual-framework' ).'</li>';
				endif;
                echo '</ul></div>';
	         if ( sizeof( $woocommerce->cart->get_cart() ) <= 0 ) :
                endif; 
			 echo '<a href="'. wc_get_cart_url() .'" class="qbutton white view-cart">'. __( 'Cart', 'manual-framework' ).'<i class="fa fa-shopping-basket"></i></a>';
			 echo '<span class="total">'. __( 'Total', 'manual-framework' ).':<span>'. $woocommerce->cart->get_cart_subtotal() .'</span></span>';
			 if ( sizeof( $woocommerce->cart->get_cart() ) <= 0 ) : 
			 endif;
		echo '</div></div></div></div>';
		}
	}
	}
	
	public function form( $instance ) {
		$defaults = array(
			'add_to_card_padding' => '0px 0px 0px 0px',
		);
		$add_to_card_padding = ( isset( $instance[ 'add_to_card_padding' ] ) && '' !== $instance[ 'add_to_card_padding' ] ) ? $instance[ 'add_to_card_padding' ] : $defaults['add_to_card_padding'];
		?>
		 <p><label><input class="widefat" style="max-width:145px;" id="<?php echo esc_attr($this->get_field_id( 'add_to_card_padding' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'add_to_card_padding' )); ?>" type="text" value="<?php echo esc_attr($add_to_card_padding); ?>"><br> <?php esc_html_e( 'Padding', 'manual-framework' ); ?> (top, right, buttom, left)</label></p>
         <?php
	}

	public function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['add_to_card_padding'] = $new_instance['add_to_card_padding'];
		return $instance;
	}
} 
add_action( 'widgets_init', function() { register_widget( 'manual__woocommerce_menu_cart' ); } );
?>