<?php
/**
 * @author     SmartWpThemes
 * @copyright  (c) Copyright by SmartWpThemes
 * @link       https://smartwpthemes.com/
 * @package    Manual
 * @since      5.0
 */
 
// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
}

/***************************
*** PORTFOLIO POST TYPE  ***
****************************/
add_action( 'init', 'manual_portfolio_post_type' );
if ( ! function_exists( 'manual_portfolio_post_type' ) ) {

	
	function manual_portfolio_post_type() {
		
	global $theme_options;
	
	if( isset($theme_options['portfolio-slug-name']) && $theme_options['portfolio-slug-name'] != ''  ) {
		$new_portfolio_slug_name = $theme_options['portfolio-slug-name'];
	} else {
		$new_portfolio_slug_name = 'work';
	}
	
	if( isset($theme_options['portfolio-comment-status']) && $theme_options['portfolio-comment-status'] == true ) {
		$activate_comment = 'comments';
	} else {
		$activate_comment = '';
	}
	
	if( isset($theme_options['portfolio-breadcrumb-name']) && $theme_options['portfolio-breadcrumb-name'] != ''  ) {
		$portfolio_breadcrumb_name = $theme_options['portfolio-breadcrumb-name'];
	} else {
		$portfolio_breadcrumb_name = 'Portfolio';
	}
	
	
	if( isset($theme_options['portfolio-post-type-support-custom-fields']) && $theme_options['portfolio-post-type-support-custom-fields'] == true ) {
		$custom_fields = 'custom-fields';
	} else {
		$custom_fields = '';
	} 
		
		register_post_type( 'manual_portfolio',
			array(
			'labels' => array(
					'name' => esc_html__( 'Portfolio', 'manual-framework' ),
					'singular_name' => sprintf( esc_html( _x('%s', 'portfolio', 'manual-framework') ), $portfolio_breadcrumb_name),			
					'add_new' => esc_html__('Add Portfolio', 'manual-framework'),  
					'add_new_item' => esc_html__('Add New Portfolio', 'manual-framework'),  
					'edit_item' => esc_html__('Edit Portfolio', 'manual-framework'),  
					'new_item' => esc_html__('New Portfolio', 'manual-framework'),  
					'view_item' => esc_html__('View Portfolio', 'manual-framework'),  
					'search_items' => esc_html__('Search Portfolio', 'manual-framework'),  
					'not_found' =>  esc_html__('No Portfolio found', 'manual-framework'),  
					'not_found_in_trash' => esc_html__('No Portfolio found in Trash', 'manual-framework')
				),
			'taxonomies'  => array( 'manualportfoliocategory' ),	
			'public' => true,
			'menu_position' => 5,
			'rewrite' => array(	'slug' => $new_portfolio_slug_name,
								'hierarchical' => 'true',
								'with_front' => false),
			'supports' => array(
				'title',
				'editor',
				'page-attributes','thumbnail', $activate_comment, $custom_fields),
			'public' => true,
			'show_ui' => true,
			'publicly_queryable' => true,
			'capability_type' => 'page',
			'hierarchical' => true,
			'exclude_from_search' => false,
			'show_in_nav_menus'  => true,
			'menu_icon'  => plugin_dir_url( __FILE__ ) . 'img/portfolio.png',
			)
		);	
		
	}

}


if ( ! function_exists('manual_portfolio_category_taxonomy') ) {
// Register faq Category Custom Taxonomy
function manual_portfolio_category_taxonomy()  {
	
	global $theme_options;
	
	if( isset($theme_options['portfolio-cat-slug-name']) && $theme_options['portfolio-cat-slug-name'] != ''  ) {
		$pof_new_cat_slug_name = $theme_options['portfolio-cat-slug-name'];
	} else {
		$pof_new_cat_slug_name = 'pfocat';
	}

	$labels = array(
		'name'                       => esc_html__( 'Portfolio Categories', 'manual-framework' ),
		'singular_name'              => esc_html__( 'Portfolio Category', 'manual-framework' ),
		'menu_name'                  => esc_html__( 'Portfolio Categories', 'manual-framework' ),
		'all_items'                  => esc_html__( 'All Categories', 'manual-framework' ),
		'parent_item'                => esc_html__( 'Parent Category', 'manual-framework' ),
		'parent_item_colon'          => esc_html__( 'Parent Category:', 'manual-framework' ),
		'new_item_name'              => esc_html__( 'New Category Name', 'manual-framework' ),
		'add_new_item'               => esc_html__( 'Add New Category', 'manual-framework' ),
		'edit_item'                  => esc_html__( 'Edit Category', 'manual-framework' ),
		'update_item'                => esc_html__( 'Update Category', 'manual-framework' ),
		'separate_items_with_commas' => esc_html__( 'Separate categories with commas', 'manual-framework' ),
		'search_items'               => esc_html__( 'Search categories', 'manual-framework' ),
		'add_or_remove_items'        => esc_html__( 'Add or remove categories', 'manual-framework' ),
		'choose_from_most_used'      => esc_html__( 'Choose from the most used categories', 'manual-framework' ),
	);

	$rewrite = array(
		'slug'                       => $pof_new_cat_slug_name,
		'with_front'                 => false,
		'hierarchical'               => true,
	);

	$args = array(
		'labels'                     => $labels,
		'hierarchical'               => true,
		'public'                     => true,
		'show_ui'                    => true,
		'show_admin_column'          => true,
		'show_in_nav_menus'          => true,
		'show_tagcloud'              => false,
		'query_var'                  => true,
		'rewrite'                    => $rewrite,
	);

	register_taxonomy( 'manualportfoliocategory', 'manual_portfolio', $args );
	flush_rewrite_rules();
}

// Hook into the 'init' action
add_action( 'init', 'manual_portfolio_category_taxonomy', 0 );

}
?>