<?php
/**
 * @author     SmartWpThemes
 * @copyright  (c) Copyright by SmartWpThemes
 * @link       https://smartwpthemes.com/
 * @package    Manual
 * @since      5.0
 */
 
// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
}

/*********************
*** FAQ POST TYPE  ***
**********************/
add_action( 'init', 'manual_faq_post_type' );
if ( ! function_exists( 'manual_faq_post_type' ) ) {

	function manual_faq_post_type() {
		global $theme_options;
		if( isset($theme_options['faq-slug-name']) && $theme_options['faq-slug-name'] != ''  ) {
			$new_slug_name = $theme_options['faq-slug-name'];
		} else {
			$new_slug_name = 'faqs';
		}
		
		if( isset($theme_options['faq-breadcrumb-name']) && $theme_options['faq-breadcrumb-name'] != ''  ) {
			$faq_breadcrumb_name = $theme_options['faq-breadcrumb-name'];
		} else {
			$faq_breadcrumb_name = 'FAQ';
		}
		
		if( isset($theme_options['faq-gutenberg-editor-onoff']) && $theme_options['faq-gutenberg-editor-onoff'] == true ) {
			$faq_gutenberg_editor = true;
		} else {
			$faq_gutenberg_editor = false;
		}
		
		if( isset($theme_options['faq-post-type-support-custom-fields']) && $theme_options['faq-post-type-support-custom-fields'] == true ) {
			$custom_fields = 'custom-fields';
		} else {
			$custom_fields = '';
		} 
		
		register_post_type( 'manual_faq',
			array(
			'labels' => array(
					'name' => esc_html__( 'FAQs', 'manual-framework' ),
					'singular_name' => sprintf( esc_html( _x('%s', 'FAQ', 'manual-framework') ), $faq_breadcrumb_name),
					'add_new' => esc_html__('Add FAQ', 'manual-framework'),  
					'add_new_item' => esc_html__('Add New FAQ', 'manual-framework'),  
					'edit_item' => esc_html__('Edit FAQ', 'manual-framework'),  
					'new_item' => esc_html__('New FAQ', 'manual-framework'),  
					'view_item' => esc_html__('View FAQ', 'manual-framework'),  
					'search_items' => esc_html__('Search FAQs', 'manual-framework'),  
					'not_found' =>  esc_html__('No FAQs found', 'manual-framework'),  
					'not_found_in_trash' => esc_html__('No FAQs found in Trash', 'manual-framework')
				),
			'taxonomies'  => array( 'manualfaqcategory' ),	
			'public' => true,
			'menu_position' => 5,
			'rewrite' => array(	'slug' => $new_slug_name,
								'hierarchical' => 'true',
								'with_front' => false),
			'supports' => array(
				'title',
				'editor',
				'page-attributes','thumbnail', $custom_fields),
			'public' => true,
			'show_ui' => true,
			'publicly_queryable' => true,
			'capability_type' => 'page',
			'hierarchical' => true,
			'exclude_from_search' => false,
			'show_in_nav_menus'  => true,
			'menu_icon'  => plugin_dir_url( __FILE__ ) . 'img/faq.png',
			'show_in_rest'  => $faq_gutenberg_editor,
			)
		);	
		
	}

}


if ( ! function_exists('manual_faq_category_taxonomy') ) {
// Register faq Category Custom Taxonomy
function manual_faq_category_taxonomy()  {
	
	global $theme_options;
	
	if( isset($theme_options['faq-cat-slug-name']) && $theme_options['faq-cat-slug-name'] != ''  ) {
		$faq_new_cat_slug_name = $theme_options['faq-cat-slug-name'];
	} else {
		$faq_new_cat_slug_name = 'faq';
	}
	
	if( isset($theme_options['faq-gutenberg-editor-onoff']) && $theme_options['faq-gutenberg-editor-onoff'] == true ) {
		$faq_gutenberg_editor = true;
	} else {
		$faq_gutenberg_editor = false;
	}

	$labels = array(
		'name'                       => esc_html__( 'FAQ Categories', 'manual-framework' ),
		'singular_name'              => esc_html__( 'FAQ Category', 'manual-framework' ),
		'menu_name'                  => esc_html__( 'FAQ Categories', 'manual-framework' ),
		'all_items'                  => esc_html__( 'All Categories', 'manual-framework' ),
		'parent_item'                => esc_html__( 'Parent Category', 'manual-framework' ),
		'parent_item_colon'          => esc_html__( 'Parent Category:', 'manual-framework' ),
		'new_item_name'              => esc_html__( 'New Category Name', 'manual-framework' ),
		'add_new_item'               => esc_html__( 'Add New Category', 'manual-framework' ),
		'edit_item'                  => esc_html__( 'Edit Category', 'manual-framework' ),
		'update_item'                => esc_html__( 'Update Category', 'manual-framework' ),
		'separate_items_with_commas' => esc_html__( 'Separate categories with commas', 'manual-framework' ),
		'search_items'               => esc_html__( 'Search categories', 'manual-framework' ),
		'add_or_remove_items'        => esc_html__( 'Add or remove categories', 'manual-framework' ),
		'choose_from_most_used'      => esc_html__( 'Choose from the most used categories', 'manual-framework' ),
	);

	$rewrite = array(
		'slug'                       => $faq_new_cat_slug_name,
		'with_front'                 => false,
		'hierarchical'               => true,
	);

	$args = array(
		'labels'                     => $labels,
		'hierarchical'               => true,
		'public'                     => true,
		'show_ui'                    => true,
		'show_admin_column'          => true,
		'show_in_nav_menus'          => true,
		'show_tagcloud'              => false,
		'query_var'                  => 'article_category',
		'rewrite'                    => $rewrite,
		'show_in_rest'               => $faq_gutenberg_editor,
	);

	register_taxonomy( 'manualfaqcategory', 'manual_faq', $args );
	flush_rewrite_rules();
}

// Hook into the 'init' action
add_action( 'init', 'manual_faq_category_taxonomy', 0 );

}
?>