<?php
/**
 * @author     SmartWpThemes
 * @copyright  (c) Copyright by SmartWpThemes
 * @link       https://smartwpthemes.com/
 * @package    Manual
 * @since      5.0
 */
 
// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
}

/*****************************
  MANUAL PLUGIN THEME OPTIONS
******************************/
add_action("admin_init", "manual_plugin__generalsettings");
function manual_plugin__generalsettings() {
	/* Register Settings */
	register_setting("manual_plugin__generalsettings_options", "manual_plugin__themeoptions");
	register_setting("manual_plugin__generalsettings_options_reset", "manual_plugin__themeoptions_reset", "manual_plugin__themoptreset_msg");
	/* Add Section */
	add_settings_section("manual_plugin__generalsettings_options", '', "manualplugin__callback_content_1", "manual-plugin-theme-posttype-options");
	add_settings_section("manual_plugin__generalsettings_options_reset", __('', 'manual-framework' ), "manualplugin__callback_content_2", "manual-plugin-theme-posttype-options-reset");
	/* Add fields */
	add_settings_field("manual_plugin__themeoptions", "Post Type", "manual_plugin__display_posttypes", "manual-plugin-theme-posttype-options", "manual_plugin__generalsettings_options");
	add_settings_field("manual_plugin__themeoptions_reset", "Reset Post Type Stats", "manual_plugin__display_posttypes_stats", "manual-plugin-theme-posttype-options-reset", "manual_plugin__generalsettings_options_reset");
}

function manual_plugin__themoptreset_msg($input){  
	if (isset($_POST['manualposttypestatsreset'])) {
            add_settings_error('manual_plugin__error', 'manual_plugin__error_reset', __('Selected \'post type\' posts likes/dislikes & impression reset to zero. No any action performed if selected empty \'post type\'.', 'manual-framework'), 'updated');
     }
	 return $input;
}

function manualplugin__callback_content_1(){
	echo esc_attr__('Turn the menu on or off in the admin sidebar', 'manual-framework');
}

function manualplugin__callback_content_2(){
	echo esc_attr__('Reset all post likes, dislikes, and impressions globally.', 'manual-framework');
}

function manual_plugin__display_posttypes(){
	$settings = manual_plugin__get_themeoptions('manual_plugin__themeoptions');
	?>
    <input <?php if( isset($settings['knowledgebase']) && $settings['knowledgebase'] == 1 ) checked($settings['knowledgebase']); ?> type="checkbox" id="manualpluginkb" name="manual_plugin__themeoptions[knowledgebase]" value="1" />&nbsp;
    <label for="manualknowledgebase"><?php _e('Knowledge Base', 'manual-framework'); ?></label>
    <br />
    <input <?php if( isset($settings['faq']) && $settings['faq'] == 1 ) checked($settings['faq']); ?> type="checkbox" id="manualpluginfaq" name="manual_plugin__themeoptions[faq]" value="1" />&nbsp;
    <label for="manualfaq"><?php _e('FAQs', 'manual-framework'); ?></label>
    <br />
    <input <?php if( isset($settings['portfolio']) && $settings['portfolio'] == 1 ) checked($settings['portfolio']); ?> type="checkbox" id="manualpluginportfolio" name="manual_plugin__themeoptions[portfolio]" value="1" />&nbsp;
    <label for="manualportfolio"><?php _e('Portfolio', 'manual-framework'); ?></label>
    <br />
    <input <?php if( isset($settings['documentation']) && $settings['documentation'] == 1 ) checked($settings['documentation']); ?> type="checkbox" id="manualplugindoc" name="manual_plugin__themeoptions[documentation]" value="1" />&nbsp;
    <label for="manualdocumentation"><?php _e('Documentation', 'manual-framework'); ?></label>
    <br /><br />
    <?php
	echo esc_attr__('If this option is enabled, the system will hide the selected post type from the admin sidebar.', 'manual-framework');
	echo '<br><br>';
	echo esc_attr__('[IMPORTANT] One can access the hidden post type section by using the direct link', 'manual-framework');
}

function manual_plugin__display_posttypes_stats(){
	$settings = manual_plugin__get_themeoptions('manual_plugin__themeoptions_reset');
	?>
    <input <?php if(isset($settings['post_type'])) checked($settings['post_type'] == "knowledgebase"); ?> type="radio" id="manualpluginkbreset" name="manual_plugin__themeoptions_reset[post_type]" value="knowledgebase" />&nbsp;
    <label for="manualknowledgebase"><?php _e('Knowledge Base', 'manual-framework'); ?></label>
    <br />
    <input <?php if(isset($settings['post_type'])) checked($settings['post_type'] == "documentation"); ?> type="radio" id="manualplugindocreset" name="manual_plugin__themeoptions_reset[post_type]" value="documentation" />&nbsp;
    <label for="manualdocumentation"><?php _e('Documentation', 'manual-framework'); ?></label>
    <br /><br />
    <?php
	echo esc_attr__('[ALERT] The reset process is irreversible.', 'manual-framework');
}

function manual_plugin__get_themeoptions($option_name) {
	$db_settings = get_option($option_name);
	$settings = wp_parse_args($db_settings);
	return $settings;
}

function manual__remove_menu_items() {
	$settings = manual_plugin__get_themeoptions('manual_plugin__themeoptions');
	if( isset($settings['knowledgebase']) && $settings['knowledgebase'] == 1 ) remove_menu_page( 'edit.php?post_type=manual_kb' );
	if( isset($settings['faq']) && $settings['faq'] == 1 ) remove_menu_page( 'edit.php?post_type=manual_faq' );
	if( isset($settings['portfolio']) && $settings['portfolio'] == 1 ) remove_menu_page( 'edit.php?post_type=manual_portfolio' );
	if( isset($settings['documentation']) && $settings['documentation'] == 1 ) remove_menu_page( 'edit.php?post_type=manual_documentation' );
	if( isset($settings['homehelpblock']) && $settings['homehelpblock'] == 1 ) remove_menu_page( 'edit.php?post_type=manual_hp_block' );
	if( isset($settings['homeorgblock']) && $settings['homeorgblock'] == 1 ) remove_menu_page( 'edit.php?post_type=manual_org_block' );
	if( isset($settings['testimonial']) && $settings['testimonial'] == 1 ) remove_menu_page( 'edit.php?post_type=manual_tmal_block' );
}
add_action( 'admin_menu', 'manual__remove_menu_items' );

/*-----------------------------------------------------------------------------------*/
/*	BULK RESET LIKE, UNLIKE, VISITOR COUNT
/*-----------------------------------------------------------------------------------*/
function manual_plugin__reset_views_and_likes(){
     /*Reset Stats*/
	$reset_options = manual_plugin__get_themeoptions('manual_plugin__themeoptions_reset');
	if( (isset($reset_options['post_type']) && $reset_options['post_type'] == 'knowledgebase') || 
		(isset($reset_options['post_type']) && $reset_options['post_type'] == 'documentation') ) {
			
			if( $reset_options['post_type'] == 'knowledgebase' ) {
				$post_type = 'manual_kb';
			} else {
				$post_type = 'manual_documentation';
			}
			$args = array(
					'post_type' => $post_type, 
					'posts_per_page' => -1,
			);
			$the_query = new WP_Query( $args );
			if( $the_query->have_posts() ) {
				while ( $the_query->have_posts() ) {
					$the_query->the_post();
					update_post_meta( get_the_ID(), "votes_unlike_doc_manual", 0 );
					update_post_meta( get_the_ID(), "votes_count_doc_manual", 0 );
					update_post_meta( get_the_ID(), "manual_post_visitors", 0 );
				}
			}
			update_option('manual_plugin__themeoptions_reset','');
			wp_reset_postdata();
 }
}
add_action('init', 'manual_plugin__reset_views_and_likes');
?>