jQuery( function ( $ ) {
	if ( $( '.manual-theme-admin-header-wrap' ).length ) {
		
		// Tabs
		jQuery( ".manual-theme-admin-header-wrap #tabs > ul a" ).on('click', function() {
			jQuery( ".manual-theme-admin-header-wrap #tabs > ul a" ).removeClass( 'selected' );
			jQuery( this ).addClass( 'selected' );

			jQuery( '.manual-theme-admin-header-wrap #tabs .tab-item' ).hide();
			jQuery( jQuery( this ).attr( 'href' ) ).show();

			return false;
		});
		
		
		// Activation button
		$('#pixelacehq-activate-theme-license').on('click', function() {
			if ( $(this).attr('loading') ) {
				return false;
			}
			
			var domainname = $("#redirectdomainname").val();
			
			popupWindow = window.open(
				'https://smartwpthemes.com/api/?iky=ffc744274b2bf219269184bb48152f94',
				'Theme activation',
				'resizable,width=840,height=570'
			);

			window.onmessage = (value) => {
				popupWindow.close();
				
				$(this).attr('loading', true).addClass('btn-spinner').text('Proceeding..');
				
				jQuery.post(window.ajaxurl, {
					'action': 'manual_theme_save_license_code',
					'license': value.data
				}, () => {
					window.location.reload();
				});
			};

			return false;
		});

		return 0;
	}
});


/*********************
META BOX :: SHOW HIDE  
**********************/
jQuery(document).ready(function() {
								
		"use strict";						
		
		// OnClick action.
        jQuery('#_manual_remove_nav_header_bg_opacity').click(function(){
			manualframework__meta_value_checkuncheck( '#_manual_remove_nav_header_bg_opacity', ".cmb2-id--manual-nav-header-bg-color", ".cmb2-id--manual-nav-header-bg-color-opacity" );
        });
        jQuery('#_manual_remove_nav_border_line').click(function(){
			manualframework__meta_value_checkuncheck( '#_manual_remove_nav_border_line', ".cmb2-id--manual-nav-border-color", ".cmb2-id--manual-nav-border-opacity" );
        });
        jQuery('#_manual_header_searh_box').click(function(){
			manualframework__meta_value_checkuncheck( '#_manual_header_searh_box', ".cmb2-id--manual-search-box-display-grid" );
        });
		
		//inital check-uncheck meta value
		manualframework__meta_value_checkuncheck( '#_manual_remove_nav_header_bg_opacity', ".cmb2-id--manual-nav-header-bg-color", ".cmb2-id--manual-nav-header-bg-color-opacity" );
		manualframework__meta_value_checkuncheck( '#_manual_remove_nav_border_line', ".cmb2-id--manual-nav-border-color", ".cmb2-id--manual-nav-border-opacity" );
		manualframework__meta_value_checkuncheck( '#_manual_header_searh_box', ".cmb2-id--manual-search-box-display-grid" );
		
		// check-uncheck meta value
		function manualframework__meta_value_checkuncheck( chkbox_classorid, showhide_classorid_one = '', showhide_classorid_two = '' ){
			if( jQuery(chkbox_classorid).is(':checked') ) {
				if( showhide_classorid_one != '' ) jQuery(showhide_classorid_one).show("slow");
				if( showhide_classorid_two != '' ) jQuery(showhide_classorid_two).show("slow");											  
			} else {
				if( showhide_classorid_one != '' ) jQuery(showhide_classorid_one).hide("slow");
				if( showhide_classorid_two != '' ) jQuery(showhide_classorid_two).hide("slow");
			}
		}
		
});			  