<?php
/**
 * @author     SmartWpThemes
 * @copyright  (c) Copyright by SmartWpThemes
 * @link       https://smartwpthemes.com/
 * @package    Manual
 * @since      5.0
 */
 
// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
}

$license = explode("%", get_option( 'manual_license', false ));
if ( isset($license[0]) && $license[0] != '' ) {   ?>
<div class="manual-theme-admin-body-group">

  <div class="manual-theme-admin-body-group-headline">
    <h3>
      <?php _e( 'Theme Overview', 'manual-framework' ); ?>
    </h3>
    <div class="license-section"><a id="manual_license_status" href="#remove" class="btn btn-danger"> <?php _e( 'Remove License', 'manual-framework' ); ?> </a></div>
  </div>
  
  <div class="manual-theme-admin-body-group-details">
    <?php _e( 'You\'ve successfully registered the theme, which means you can now install all theme updates and premium bundled plugins.', 'manual-framework' ); ?>
  </div>
  <table class="manual-theme-admin-body-group-content manual-theme-admin-body-group-table table-col-2">
    <tbody>
      <tr>
        <td><?php _e( 'License type', 'manual-framework' ); ?>:</td>
        <td><label class="active"><mark class="yes"><?php _e( 'Activated', 'manual-framework' ); ?></mark></label>
          &nbsp; <?php echo $license[1]; ?> <a class="tips" target="_blank" href="https://themeforest.net/licenses/terms/regular"><i class="dashicons dashicons-info-outline"></i></a></td>
      </tr>
      <tr>
        <td><?php _e( 'License key', 'manual-framework' ); ?>:</td>
        <td><b><?php echo 'XXXXXXXX-XXXX-XXXX-XXXX-XXXXXXXXX'.substr($license[0], -3); ?></b></td>
      </tr>
      <tr>
        <td><?php _e( 'Purchase date', 'manual-framework' ); ?>:</td>
        <td><?php echo date('F-d-Y h:i A', strtotime($license[2])); ?></td>
      </tr>
      <tr>
        <td><?php _e( 'Registered domain', 'manual-framework' ); ?>:</td>
        <td><a href="<?php echo '//' . $_SERVER['HTTP_HOST']; ?>"><?php echo $_SERVER['HTTP_HOST']; ?>/</a> <a class="tips" target="_blank" href="https://themeforest.net/licenses/terms/regular"><i class="dashicons dashicons-info-outline"></i></a></td>
      </tr>
      <tr>
        <td><?php _e( 'Theme directory', 'manual-framework' ); ?>:</td>
        <td><?php echo '..' . get_raw_theme_root( get_stylesheet() ) . '/' . get_stylesheet(); ?></td>
      </tr>
    </tbody>
  </table>
</div>
<div class="manual-theme-admin-body-group">
  <div class="manual-theme-admin-body-group-headline">
    <h3>
      <?php _e( 'Theme Support', 'manual-framework' ); ?>
    </h3>
    <div> <a class="tips" target="_blank" href="https://help.market.envato.com/hc/en-us/articles/207886473-Extending-and-Renewing-Item-Support"><i class="dashicons dashicons-info-outline"></i></a> <a target="_blank" href="https://themeforest.net/downloads" class="btn btn-primary">
      <?php _e( 'Upgrade Support', 'manual-framework' ); ?>
      </a> </div>
  </div>
  <div class="manual-theme-admin-body-group-details">
    <?php _e( 'Find answers to many support queries and technical questions on our:', 'manual-framework' ); ?>
    <ol>
    <li><a target="_blank" href="https://smartwpthemes.com/documentation/manual/"><?php _e( ' Documentation', 'manual-framework' ); ?></a></li>
    <li><a target="_blank" href="https://smartwpthemes.com/community-forum/"><?php _e( ' Community Forum', 'manual-framework' ); ?></a></li>
    <li><a target="_blank" href="https://smartwpthemes.com/submit-a-ticket/"><?php _e( ' Private Ticket Support (use only if required)', 'manual-framework' ); ?></a></li>
    </ol>
    </div>
  <table class="manual-theme-admin-body-group-content manual-theme-admin-body-group-table table-col-2">
    <tbody>
      <tr>
        <td><?php _e( 'Support status', 'manual-framework' ); ?></td>
        <td><?php			$support_timestamp = strtotime(date('Y-m-d', strtotime($license[3])));
							if(isset( $support_timestamp ) && $support_timestamp != '' ) {  
								$diff_timestamp = $support_timestamp - time();
								if ($diff_timestamp > 0) {
									echo '<label class="active"><mark class="yes">Supported</mark></label>';
									$days = ceil( $diff_timestamp / 60 / 60 / 24 );
									echo '&nbsp;<b> ' . $days . ' days left </b>';
								} else {
									echo '<label class="inactive"><mark class="no">Unsupported</mark></label>';
								}
							} else {
								echo '<label class="inactive"><mark class="no">Unsupported</mark></label>';
							}
						?></td>
      </tr>
    </tbody>
  </table>
</div>
<?php } else { ?>
<div class="manual-theme-admin-body-group">
  <div class="manual-theme-admin-body-group-headline">
    <h3>
      <?php _e( 'Activation', 'manual-framework' ); ?>
    </h3>
  </div>
  <div class="manual-theme-admin-body-group-details">
    <?php _e( 'Activate your theme by connecting with the Envato to receive updates upon their availability.', 'manual-framework' ); ?>
  </div>
  <div class="manual-theme-admin-body-group-content">
    <div class="manual-theme-admin-register-steps">
      <div class="manual-theme-admin-register-steps-item">
        <div class="step-number">1</div>
        <p>
          <?php _e( 'Hint the Activate License button below', 'manual-framework' ); ?>
          :</p>
      </div>
      <div class="manual-theme-admin-register-steps-item">
        <div class="step-number">2</div>
        <p>
          <?php _e( 'Login with your', 'manual-framework' ); ?>
          <br>
          <a target="_blank" href="#">
          <?php _e( 'Envato Account', 'manual-framework' ); ?>
          </a></p>
      </div>
      <div class="manual-theme-admin-register-steps-item">
        <div class="step-number">3</div>
        <p>
          <?php _e( 'Choose the valid', 'manual-framework' ); ?>
          <br>
          <a target="_blank" href="https://help.market.envato.com/hc/en-us/articles/202822600-Where-Is-My-Purchase-Code-">
          <?php _e( 'Purchase Code', 'manual-framework' ); ?>
          </a></p>
      </div>
      <div class="manual-theme-admin-register-steps-item">
        <div class="step-number">4</div>
        <p>
          <?php _e( 'That is it, you are all set!', 'manual-framework' ); ?>
          <br>
          <?php _e( 'Product is activated.', 'manual-framework' ); ?>
        </p>
      </div>
    </div>
    <input id="redirectdomainname" type="hidden" value="<?php echo get_site_url(); ?>">
    <a href="#" class="btn btn-large btn-activate" id="pixelacehq-activate-theme-license">
    <svg width="18" height="20" viewBox="0 0 18 20" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M15.2849 0.120735C14.7711 -0.1293 12.9731 -0.00428241 10.9182 0.620805C7.32212 3.12115 4.23976 6.62164 3.9829 12.3724C3.9829 12.4975 3.59761 12.3724 3.46918 12.3724C2.57016 10.4972 2.18486 8.49691 2.95545 5.74652C3.21231 5.49649 2.69859 5.24645 2.57016 5.24645C2.44172 5.49649 1.67114 6.24659 1.15741 7.12171C-1.28279 11.2473 0.25839 16.623 4.62506 18.8734C8.99173 21.2487 14.3858 19.7485 16.826 15.4979C19.5231 10.6222 16.9545 0.995857 15.2849 0.120735Z" fill="white"/>
    </svg>
    &nbsp;&nbsp;<span>
    <?php _e( 'Activate License', 'manual-framework' ); ?>
    </span></a>
     <div class="manual-theme-admin-body-group-details licensepg"> 
		<div><b><?php _e( 'Frequent Customer Queries', 'manual-framework' ); ?></b></div>
        <p><?php _e( '1. Unable to activate the theme through the theme dashboard?', 'manual-framework' ); ?></p>
        <p><?php  _e( 'If you encounter an issue where, after clicking the \'Activate License\' button in the theme dashboard, a new window opens briefly, performs some operations, then closes quickly with a rotating green circle, here\'s what you can do. <strong>This typically occurs when certain browser extensions or addons block our activation popup. To resolve this, you can either disable browser extensions or consider using a different browser for this task.</strong>', 'manual-framework' ); ?></p>
                </li>
            </ul>
        </p>
     </div>
    </div>
</div>
<?php } ?>