<?php
/**
 * @author     SmartWpThemes
 * @copyright  (c) Copyright by SmartWpThemes
 * @link       https://smartwpthemes.com/
 * @package    Manual
 * @since      5.0
 */
 
// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
}
?>
<div class="manual-theme-admin-body-group">
  <div class="manual-theme-admin-body-group-headline">
    <h3>
      <?php _e( 'Theme Information', 'manual-framework' ); ?>
    </h3>
  </div>
  <table class="manual-theme-admin-body-group-content manual-theme-admin-body-group-table table-col-2">
    <tbody>
      <tr>
        <td><?php _e( 'Theme installed version', 'manual-framework' ); ?> :</td>
        <td><?php
						$manual_theme = wp_get_theme( get_template() );
						$manual_version = $manual_theme->get( 'Version' ) ? $manual_theme->get( 'Version' ) : '2.0.0';
						echo '<mark class="yes">' . $manual_version . '</mark>';
					?></td>
      </tr>
      <tr>
        <td><?php _e( 'Theme license', 'manual-framework' ); ?> :</td>
        <td><?php
						if ( get_option( 'manual_license', false ) ):
							echo '<label class="active"><mark class="yes">Activated</mark></label>';
						else:
							echo '<label class="inactive"><mark class="no">Not activated</mark></label>';
						endif;
					?></td>
      </tr>
      <tr>
        <td><?php _e( 'Theme directory', 'manual-framework' ); ?> :</td>
        <td><?php echo '..' . get_raw_theme_root( get_stylesheet() ) . '/' . get_stylesheet(); ?></td>
      </tr>
      <tr>
        <td><?php _e( 'Child theme', 'manual-framework' ); ?>
          :</td>
        <td><mark class="yes"><?php echo ( get_template_directory() === get_stylesheet_directory() ) ? 'Disabled' : 'Enabled'; ?></mark>
          <a class="tips" target="_blank" href="https://developer.wordpress.org/themes/advanced-topics/child-themes/"><i class="dashicons dashicons-info-outline"></i></a></td>
      </tr>
    </tbody>
  </table>
</div>
<!-- Group 3cl -->
<div class="manual-theme-admin-body-group">
  <div class="manual-theme-admin-body-group-headline">
    <h3>
      <?php _e( 'Server Environment', 'manual-framework' ); ?>
    </h3>
  </div>
  <table class="manual-theme-admin-body-group-details manual-theme-admin-body-group-table table-col-3">
    <tbody>
      <tr>
        <td><?php _e( 'Directive', 'manual-framework' ); ?></td>
        <td><?php _e( 'Required value', 'manual-framework' ); ?></td>
        <td><?php _e( 'Current value', 'manual-framework' ); ?></td>
      </tr>
    </tbody>
  </table>
  <table class="manual-theme-admin-body-group-content manual-theme-admin-body-group-table table-col-3">
    <tbody>
      <tr>
        <td><?php _e( 'PHP version:', 'manual-framework' ); ?></td>
        <td><?php _e( '7.0.0', 'manual-framework' ); ?></td>
        <td><?php
						if ( explode( ',', phpversion() )[0] >= 7 ) {
							echo '<mark class="yes">' . phpversion() . '</mark>';
						} else {
							echo '<mark class="no">' . phpversion() . '</mark>';
						}
					?></td>
      </tr>
      <tr>
        <td><?php _e( 'PHP time limit <span>(max_execution_time)</span>:', 'manual-framework' ); ?></td>
        <td><?php _e( '300', 'manual-framework' ); ?></td>
        <td><?php
						if ( ini_get( 'max_execution_time' ) >= 300 ) {
							echo '<mark class="yes">' . ini_get( 'max_execution_time' ) . '</mark>';
						} else {
							echo '<mark class="no">' . ini_get( 'max_execution_time' ) . '</mark>';
						}
					?></td>
      </tr>
      <tr>
        <td><?php _e( 'PHP memory limit <span>(memory_limit)</span>:', 'manual-framework' ); ?></td>
        <td><?php _e( '256M', 'manual-framework' ); ?></td>
        <td><?php
						if ( intval( ini_get( 'memory_limit' ) ) >= 256 ) {
							echo '<mark class="yes">' . ini_get( 'memory_limit' ) . '</mark>';
						} else {
							echo '<mark class="no">' . ini_get( 'memory_limit' ) . '</mark>';
						}
					?></td>
      </tr>
      <tr>
        <td><?php _e( 'Max upload size <span>(upload_max_filesize)</span>:', 'manual-framework' ); ?></td>
        <td><?php _e( '16M', 'manual-framework' ); ?></td>
        <td><?php
						if ( intval( ini_get( 'upload_max_filesize' ) ) >= 16 ) {
							echo '<mark class="yes">' . ini_get( 'upload_max_filesize' ) . '</mark>';
						} else {
							echo '<mark class="no">' . ini_get( 'upload_max_filesize' ) . '</mark>';
						}
					?></td>
      </tr>
      <tr>
        <td><?php _e( 'File upload permission <span>(file_uploads)</span>:', 'manual-framework' ); ?></td>
        <td><?php _e( 'Available', 'manual-framework' ); ?></td>
        <td><?php
						$file_uploads = is_numeric(ini_get('file_uploads')) ? (ini_get('file_uploads') ? 'On' : 'Off') : ini_get('file_uploads');
						if ( $file_uploads == 'On' ) {
							echo '<mark class="yes">Available</mark>';
						} else {
							echo '<mark class="no">Off</mark>';
						}
					?></td>
      </tr>
    </tbody>
  </table>
  <div class="manual-theme-admin-body-group-details">
    <?php _e( 'Contact your hosting provider and ask them to increase the limits to a minimum of the following.', 'manual-framework' ); ?>
  </div>
</div>
<!-- Group 1 -->
<div class="manual-theme-admin-body-group">
  <div class="manual-theme-admin-body-group-headline">
    <h3>
      <?php _e( 'Security', 'manual-framework' ); ?>
    </h3>
  </div>
  <table class="manual-theme-admin-body-group-content manual-theme-admin-body-group-table table-col-2">
    <tbody>
      <tr>
        <td><?php _e( 'Secure connection <span>(SSL Certificate)</span>:', 'manual-framework' ); ?></td>
        <td><?php
						if ( is_ssl() ) {
							echo '<mark class="yes">Secured</mark>';
						} else {
							echo '<mark class="no">Not secured</mark>';
						}
					?></td>
      </tr>
      <tr>
        <td><?php _e( 'Hide errors from visitors <span>(WP_DEBUG)</span>:', 'manual-framework' ); ?></td>
        <td><?php
						if ( defined('WP_DEBUG') && true === WP_DEBUG ) {
							echo '<mark class="no">Errors are displayed</mark>';
						} else {
							echo '<mark class="yes">Hidden</mark>';
						}
					?></td>
      </tr>
    </tbody>
  </table>
</div>
<!-- Group 2 -->
<div class="manual-theme-admin-body-group">
  <div class="manual-theme-admin-body-group-headline">
    <h3><?php _e( 'WordPress Environment', 'manual-framework' ); ?></h3>
  </div>
  <table class="manual-theme-admin-body-group-content manual-theme-admin-body-group-table table-col-2">
    <tbody>
      <tr>
        <td><?php _e( 'WordPress Version:', 'manual-framework' ); ?></td>
        <td><?php
						if ( !isset( $wp_verion ) && defined( 'ABSPATH' ) && defined( 'WPINC' ) ) {
							include ABSPATH . WPINC . '/version.php';
						}

						$wp_version_exploded = isset( $wp_version ) ? explode( '.', $wp_version ) : [ '1' ];

						if ( !isset( $wp_version ) ) {
							$wp_version = 'Undefined';
						}

						if ( $wp_version_exploded[0] >= 5 ) {
							echo '<mark class="yes">' . $wp_version . '</mark>';
						} else {
							echo '<mark class="no">' . $wp_version . '</mark>';
						}
					?></td>
      </tr>
      <tr>
        <td><?php _e( 'Admin language:', 'manual-framework' ); ?></td>
        <td><mark class="yes"><?php echo get_locale(); ?></mark></td>
      </tr>
    </tbody>
  </table>
</div>