<?php 
/**
 * @author     SmartWpThemes
 * @copyright  (c) Copyright by SmartWpThemes
 * @link       https://smartwpthemes.com/
 * @package    Manual
 * @since      5.0
 */
 
// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
}

$license = explode("%", get_option( 'manual_license', false ));
if ( isset($license[0]) && $license[0] != '' ) {  
	if ( !class_exists('OCDI_Plugin') ) { 
	?>
    <div class="manual-theme-admin-body-group manual-theme-admin-body-group-success manual-theme-admin-body-group-outline">
  <div class="manual-theme-admin-body-group-headline">
    <h3>
      <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
        <path d="M12 2c5.514 0 10 4.486 10 10s-4.486 10-10 10-10-4.486-10-10 4.486-10 10-10zm0-2c-6.627 0-12 5.373-12 12s5.373 12 12 12 12-5.373 12-12-5.373-12-12-12zm6 16.094l-4.157-4.104 4.1-4.141-1.849-1.849-4.105 4.159-4.156-4.102-1.833 1.834 4.161 4.12-4.104 4.157 1.834 1.832 4.118-4.159 4.143 4.102 1.848-1.849z"/>
      </svg><?php _e( 'Plugin Installation/Activation Required', 'manual-framework' ); ?></h3>
       <a class="btn" href="admin.php?page=manual-admin-install-plugins"><?php _e( 'Installation/Activation', 'manual-framework' ); ?></a> 
  </div>
  <div class="manual-theme-admin-body-group-content">
    <ul>
      <li><i class="dashicons dashicons-no"></i> <?php printf( __( 'To utilize our import function, you must install/activate the \'<b>One Click Demo Import</b>\' plugin' )); ?></li>
    </ul>
  </div>
</div>
    <?php
	} else {
	?>
    <style>
	.ocdi__intro-text { display:none; }
	.ocdi__content-container { padding-top:0px; }
	</style>
	<?php
	}
} else {
?>
	<style>
	.ocdi__intro-text, .ocdi__gl,  .ocdi__gl.js-ocdi-gl { display:none; }
	.ocdi__content-container { padding-top:0px; }
	</style>
    <div class="manual-theme-admin-body-group manual-theme-admin-body-group-warning manual-theme-admin-body-group-outline">
  <div class="manual-theme-admin-body-group-headline">
    <h3>
      <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
        <path d="M12 2c5.514 0 10 4.486 10 10s-4.486 10-10 10-10-4.486-10-10 4.486-10 10-10zm0-2c-6.627 0-12 5.373-12 12s5.373 12 12 12 12-5.373 12-12-5.373-12-12-12zm6 16.094l-4.157-4.104 4.1-4.141-1.849-1.849-4.105 4.159-4.156-4.102-1.833 1.834 4.161 4.12-4.104 4.157 1.834 1.832 4.118-4.159 4.143 4.102 1.848-1.849z"/>
      </svg><?php _e( 'License Activation', 'manual-framework' ); ?></h3>
       <a class="btn" href="admin.php?page=manual-admin"><?php _e( 'License Activation', 'manual-framework' ); ?></a> 
  </div>
  <div class="manual-theme-admin-body-group-content">
    <ul>
      <li><i class="dashicons dashicons-no"></i> <?php printf( __( 'To use the Demo Importer, please activate your theme within the Manual Dashboard.' )); ?></li>
    </ul>
  </div>
</div>
<?php } ?>