<?php
/**
 * @author     SmartWpThemes
 * @copyright  (c) Copyright by SmartWpThemes
 * @link       https://smartwpthemes.com/
 * @package    Manual
 * @since      5.0
 */
 
// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
}
?>
<div class="wp-header-end"></div>

<div class="manual-theme-admin-header-wrap">

	<div class="theme-admin-page-intro">
		<div class="container page-container">
			<div class="details">
				<h1><?php _e( 'Dashboard', 'manual-framework' ); ?></h1>
			</div>
		</div>
	</div>
    
	<div class="container page-container">
		<div id="tabs" class="manual-theme-nav">
			<ul class="manual-theme-block-layout manual-theme-nav-inner">
				<li><a href="#tabs-1" class="selected"><?php _e( 'Registration', 'manual-framework' ); ?></a></li>
				<li><a href="#tabs-2"><?php _e( 'System Status', 'manual-framework' ); ?></a></li>
				<li><a href="#tabs-3"><?php _e( 'What’s New', 'manual-framework' ); ?></a></li>
				<li><a href="#tabs-4"><?php _e( 'Help Policy', 'manual-framework' ); ?></a></li>
				<li><a href="#tabs-5" class="dashicons-before dashicons-admin-tools">&nbsp;<?php _e( 'Custom Work', 'manual-framework' ); ?></a></li>
			</ul>

			<div class="tab-item" id="tabs-1">
				<?php include 'parts/theme-license-section.php'; ?>
			</div>

			<div class="tab-item" id="tabs-2" style="display: none;">
				<?php include 'parts/system-status-section.php'; ?>
			</div>

			<div class="tab-item" id="tabs-3" style="display: none;">
				<?php include 'parts/whats-new-section.php'; ?>
			</div>

			<div class="tab-item" id="tabs-4" style="display: none;">
				<?php include 'parts/help-section.php'; ?>
			</div>

			<div class="tab-item" id="tabs-5" style="display: none;">
				<?php include 'parts/custom-work-section.php'; ?>
			</div>
		</div>
	</div>
    
	<!-- Footer -->
	<div class="theme-admin-page-footer">
		<div class="container">
			<div class="copyright">
				Copyright © <?php echo date("Y"); ?>, Manual Version <?php
						$manual_theme = wp_get_theme( get_template() );
						$manual_version = $manual_theme->get( 'Version' ) ? $manual_theme->get( 'Version' ) : '2.0.0';
						echo $manual_version;
					?> by <a target="_blank" href="https://themeforest.net/user/pixelacehq">Manual</a>.
			</div>
			<div class="social-networks">
				<a target="_blank" href="https://smartwpthemes.com/documentation/manual/">Documentation</a>&nbsp;|&nbsp;<a target="_blank" href="https://smartwpthemes.com/community-forum/">Forum</a>&nbsp;|&nbsp;<a target="_blank" href="https://smartwpthemes.com/submit-a-ticket/">Support</a>&nbsp;|&nbsp;Follow Us -&nbsp;<a target="_blank" href="https://www.facebook.com/smartwptheme/"><span class="dashicons dashicons-facebook"></span></a><a target="_blank" href="https://twitter.com/smartwpthemes"><span class="dashicons dashicons-twitter"></span></a><a target="_blank" href="https://www.youtube.com/channel/UCm8MzqkmoUsuKiDj42YP_GA"><span class="dashicons dashicons-youtube"></span></a>
			</div>	
		</div>
	</div>
</div>