<?php
/**
 * @author     SmartWpThemes
 * @copyright  (c) Copyright by SmartWpThemes
 * @link       https://smartwpthemes.com/
 * @package    Manual
 * @since      5.0
 */

/* Do not allow directly accessing this file. */
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
}

global $pagenow;

if (( $pagenow == 'admin.php' ) && (isset($_GET['page']) && ($_GET['page'] == 'manual-admin' || 
								    $_GET['page'] == 'manual-admin-adv-settings' || 
									$_GET['page'] == 'manual-admin-install-plugins' || 
									$_GET['page'] == 'manual-admin-demo-import')) ) {
	add_filter( 'admin_body_class', 'manual_framework_admin_body_class' );
	function manual_framework_admin_body_class( $classes ) {
		return $classes."manual-framework";
	}
}

/*****************
 MAIN MENU SECTION
******************/ 
add_action( 'admin_menu', 'register_manual__admin_page' );
function register_manual__admin_page() {
    add_menu_page(
        'Manual Theme',
        'Manual Theme', // side menu title
        'manage_options',
        'manual-admin',
        false,
        plugin_dir_url( __FILE__ ) . 'manual_icon.png', // icon
        2 // order
    );
}

/*******************************
 SUB PAGES MENU (1) :: DASHBOARD
*******************************/ 
add_action( 'admin_menu', 'register_manual__admin_subpage_dashboard' );
function register_manual__admin_subpage_dashboard() {
    add_submenu_page( 'manual-admin', 
					  esc_attr__('Dashboard', 'manual-framework'), 
					  esc_attr__('Dashboard', 'manual-framework'), 
					  'manage_options', 
					  'manual-admin', 
					  'manual__admin_dashboard_page' ); 
}
function manual__admin_dashboard_page() {
    include 'pages/dashboard-page.php';
}

/************************************
 SUB PAGES MENU (2) :: DEMO IMPORT
*************************************/ 
add_action( 'admin_menu', 'register_manual__admin_subpage_install_plugins' );
function register_manual__admin_subpage_install_plugins() {
    add_submenu_page( 'manual-admin', 
					   esc_attr__('Install Plugins', 'manual-framework'), 
					   esc_attr__('Install Plugins', 'manual-framework'), 
					   'manage_options', 
					   'manual-admin-install-plugins', 
					   'manual__admin_install_plugins_page' ); 
}
function manual__admin_install_plugins_page() {
   include 'pages/install-plugins.php';
}


/************************************
 SUB PAGES MENU (3) :: DEMO IMPORT
*************************************/ 
add_action( 'admin_menu', 'register_manual__admin_subpage_demoimport' );
function register_manual__admin_subpage_demoimport() {
    add_submenu_page( 'manual-admin', 
					   esc_attr__('Demo Import', 'manual-framework'), 
					   esc_attr__('Demo Import', 'manual-framework'), 
					   'manage_options', 
					   'manual-admin-demo-import', 
					   'manual__admin_demoimport_page' ); 
}
function manual__admin_demoimport_page() {
    include 'pages/demo-import.php';
}


/***************************************
 SUB PAGES MENU (5) :: ADVANCE SETTINGS
***************************************/ 
add_action( 'admin_menu', 'register_manual__admin_subpage_advancesettings' );
function register_manual__admin_subpage_advancesettings() {
    add_submenu_page( 'manual-admin', 
					   esc_attr__('Advance Settings', 'manual-framework'), 
					   esc_attr__('Advance Settings', 'manual-framework'), 
					   'manage_options', 
					   'manual-admin-adv-settings', 
					   'manual__admin_advancesettings_page' ); 
}
function manual__admin_advancesettings_page() {
    include 'pages/advance-settings-page.php';
}


/*****************************
 DASHBOARD :: AJAX CALL {{License Reg}}
******************************/
add_action( 'wp_ajax_manual_theme_save_license_code', 'manual_framework__save_license_code' );
function manual_framework__save_license_code() {
    $data = str_replace('\"', '"', $_POST['license'] );
    $data = json_decode($data);
    if (!$data) return false;
	add_option( 'manual_license', $data );
    wp_die();
}

/*****************************
 DASHBOARD :: AJAX CALL {{License Rev}}
******************************/
add_action( 'wp_ajax_manual_theme_remove_license_code', 'manual_framework__remove_license_code' );
function manual_framework__remove_license_code() {
	delete_option( 'manual_license' );
    wp_die();
}

/*****************************
 DASHBOARD :: License Message
******************************/
add_action( 'admin_notices', 'manual_framework__license_notice' );
function manual_framework__license_notice() {
	$license = explode("%", get_option( 'manual_license', false ));
	if ( isset($license[0]) && $license[0] == '' ) { ?>
    <div class="notice notice-error is-dismissible">
        <p>
            <?php _e( 'In order to install the demo content and access all of Manual\'s features, you need to activate your license. Please go to the dashboard to activate your Manual license.', 'manual-framework' ); ?> <a href="admin.php?page=manual-admin">Activate</a>
        </p>
    </div>
    <?php }
}