<?php
/**
 * The template for displaying a single doc
 *
 * To customize this template, create a folder in your current theme named "wedocs" and copy it there.
 */
$skip_sidebar = ( get_post_meta( $post->ID, 'skip_sidebar', true ) == 'yes' ) ? true : false;

get_header(); 
global $theme_options;
$col = 9;
if( isset($theme_options['wedocs-toc-settings']) && $theme_options['wedocs-toc-settings'] == true ) {
	$col = 6;
}
?>
<div class="container content-wrapper body-content">
<div class="row">
    <?php
        /**
         * @since 1.4
         *
         * @hooked wedocs_template_wrapper_start - 10
         */
        do_action( 'wedocs_before_main_content' );
    ?>
	<div class="col-md-12 col-sm-12 clearfix">
    <?php while ( have_posts() ) {
        the_post(); ?>

        <div class="wedocs-single-wrap">
			
			<div class="col-md-3 col-sm-12 wedocs_menu_wrap">
			<?php if ( !$skip_sidebar ) { ?>
                <?php wedocs_get_template_part( 'docs', 'sidebar' ); ?>
            <?php } ?>
			</div>
			
			<div class="col-md-<?php echo $col; ?> col-sm-12 wedocs-content-wrap">
            <div class="wedocs-single-content">

                <article id="post-<?php the_ID(); ?>" <?php post_class(); ?> itemscope itemtype="http://schema.org/Article">
					
					<div class="plugin_wedocs_single_content_wrap">
                    <div class="kb-single">
					<header class="entry-header">
					
						<!--Status-->
						<?php if( $theme_options['wedocs-breadcrumbs-on-page'] == 1 ) { ?>
						<div class="wpdocs-stats">
							<span class="wpdocs-stat-item page-breadcrumbs">
							<?php wedocs_breadcrumbs(); ?>
							</span>
						</div>
						<?php } ?>
						
						<?php if ( wedocs_get_general_settings( 'print', 'on' ) === 'on' ) { ?>
                            <div class="wedocs_print">
							<?php 
							if (class_exists('WP_Print_O_Matic') || class_exists('WP_Print_Pro_Matic')) { 
								echo do_shortcode('[print-me printstyle="pom-small-grey" tag="span" target=".plugin_wedocs_single_content_wrap"/]'); 
							}
							?>
							</div>
                        <?php } ?>
						
						<!--EOF Status-->
						<?php 
							if( isset($theme_options['wedocs-title-on-page']) && $theme_options['wedocs-title-on-page'] == true ) { 
								the_title( '<h1 class="entry-title" itemprop="headline">', '</h1>' ); 
							 }
						?>
                    </header><!-- .entry-header -->
					</div>

                    <div class="entry-content" itemprop="articleBody">
                        <?php
							echo '<content><div class="wedocscontent-wrap">';
                            the_content( sprintf(
                                wp_kses( __( 'Continue reading %s <span class="meta-nav">&rarr;</span>', 'manual' ), [ 'span' => [ 'class' => [] ] ] ),
                                the_title( '<span class="screen-reader-text">"', '"</span>', false )
                            ) );

                            wp_link_pages( [
                                'before' => '<div class="page-links">' . esc_html__( 'Docs:', 'manual' ),
                                'after'  => '</div>',
                            ] );

                            $children = wp_list_pages( 'title_li=&order=menu_order&child_of=' . $post->ID . '&echo=0&post_type=' . $post->post_type );

                            if ( $children ) {
                                echo '<div class="article-child well">';
                                echo '<h3>' . __( 'Articles', 'manual' ) . '</h3>';
                                echo '<ul>';
                                echo wp_kses_post($children);
                                echo '</ul>';
                                echo '</div>';
                            }

                            $tags_list = wedocs_get_the_doc_tags( $post->ID, '', ' ' );

                            if ( $tags_list ) {
                                printf( '<div class="tagcloud pt-4"><span class="screen-reader-text">%1$s </span>%2$s</div>',
                                    _x( 'Tags', 'Used before tag names.', 'manual' ),
                                    $tags_list
                                );
                            }
							echo '</div></content>';
                        ?>
                    </div><!-- .entry-content -->
					</div>

                    <?php if ( wedocs_get_general_settings( 'helpful', 'on' ) === 'on' ) { ?>
					 <div class='feedback-content'>
                        <?php wedocs_get_template_part( 'content', 'feedback' ); ?>
					 </div>	
                    <?php } ?>
					
					<footer class="entry-footer wedocs-entry-footer">
						
                            <div class='help-content wedocs-hide-mobile'>
                                <div class='help-panel'>
                                    <span class='help-icon'>
                                        <svg width="26" height="25" fill="none" class='wedocs-icon'>
                                            <path
                                                d="M1.429 21.292V9.924c0-.851.425-1.646 1.134-2.118l8.911-5.941c.855-.57 1.969-.57 2.825 0l8.911 5.941c.708.472 1.134 1.267 1.134 2.118v11.367m-22.914 0c0 1.406 1.14 2.546 2.546 2.546h17.822c1.406 0 2.546-1.14 2.546-2.546m-22.914 0l8.593-5.728m14.321 5.728l-8.593-5.728M1.429 9.835l8.593 5.728m14.321-5.728l-8.593 5.728m0 0l-1.452.968c-.855.57-1.969.57-2.825 0l-1.452-.968"
                                                stroke="#9559ff"
                                                stroke-width="1.67"
                                                stroke-linecap="round"
                                                stroke-linejoin="round"
                                            />
                                        </svg>
                                    </span>
                                    <span class="wedocs-help-link wedocs-hide-print wedocs-hide-mobile">
										<?php if ( wedocs_get_general_settings( 'email', 'on' ) === 'on' ) { ?>
                                        <?php printf( '%s <a id="wedocs-stuck-modal" href="%s">%s</a>', __( 'Still stuck? ', 'manual' ), '#', __( 'How can we help?', 'manual' ) ); ?>
										<?php } ?>
                                        <div class="wedocs-article-author" itemprop="author" itemscope itemtype="https://schema.org/Person">
                                            <meta itemprop="name" content="<?php echo get_the_author(); ?>" />
                                            <meta itemprop="url" content="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>" />
                                        </div>

                                        <meta itemprop="datePublished" content="<?php echo get_the_time( 'c' ); ?>"/>
                                        <time itemprop="dateModified" datetime="<?php echo esc_attr( get_the_modified_date( 'c' ) ); ?>"><?php printf( __( 'Updated on %s', 'manual' ), get_the_modified_date() ); ?></time>
                                    </span>
                                </div>
                            </div>
                        
                    </footer>
					
					
					 <?php wedocs_doc_nav(); ?>

                    <?php if ( wedocs_get_general_settings( 'email', 'on' ) === 'on' ) { ?>
                        <?php wedocs_get_template_part( 'content', 'modal' ); ?>
                    <?php } ?>

                    <?php if ( wedocs_get_general_settings( 'comments', 'off' ) === 'on' ) { ?>
                        <?php if ( comments_open() || get_comments_number() ) { ?>
                            <div class="wedocs-comments-wrap">
                                <?php comments_template(); ?>
                            </div>
                        <?php } ?>

                    <?php } ?>

                </article><!-- #post-## -->
            </div>
			</div><!-- .wedocs-single-content -->
			
			<?php if( isset($theme_options['wedocs-toc-settings']) && $theme_options['wedocs-toc-settings'] == true ) { ?>
			<div class="col-md-3 col-sm-12" id="sidebar-box">
				<div class="widget_manual_post_table_of_content wedocs-hide-mobile">
					<div id="toctoc"></div>	
				</div>
			</div>
			<?php } ?>
			
        </div><!-- .wedocs-single-wrap -->

    <?php } ?>
</div></div></div>
    <?php
        /**
         * @since 1.4
         *
         * @hooked wedocs_template_wrapper_end - 10
         */
        do_action( 'wedocs_after_main_content' );
    ?>

<?php get_footer(); ?>
