<?php 
/*-----------------------------------------------------------------------------------*/
/*	MANUAL KB :: META SECTION
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'manual__kb_belowtitle_meta_section' ) ) {
	function manual__kb_belowtitle_meta_section($postID, $post_author){
	global $theme_options;
		
	echo '<p class="entry-meta">'; 
    
	// Impression + Like Count
	if( $theme_options['knowledgebase-quick-stats-under-title'] != true ) {
			
		// Impression
		echo '<i class="fa fa-eye"></i> <span>';  
		if( get_post_meta( $postID, 'manual_post_visitors', true ) != '' ) { 
			echo get_post_meta( $postID, 'manual_post_visitors', true );
			echo '&nbsp;'.esc_html($theme_options['custom-record-post-view-text']);
		} else { 
			echo '0&nbsp;'.esc_html($theme_options['custom-record-post-view-text']); 
		} 
		echo '</span>';
		
		// Like count
		echo '<i class="fas fa-thumbs-up"></i> <span>'; 
		if( get_post_meta( $postID, 'votes_count_doc_manual', true ) == '' ) { 
			echo 0; 
		} else { 
			echo get_post_meta( $postID, 'votes_count_doc_manual', true ); 
		} 
		echo '</span>';
			
	}
	
	// Calender + Modified Date + Author
	if( isset($theme_options['kb-singlepg-display-style']) && $theme_options['kb-singlepg-display-style'] == 1 ) {	
	
		// Calender
		if( $theme_options['kb-singlepg-publish-date-status'] == true ) {
			echo '<i class="far fa-calendar-alt"></i> <span>';  
			echo get_the_date( get_option('date_format'), $postID ); echo '</span>';
		}
		// Modified Date
		 if( $theme_options['kb-singlepg-modified-date-status'] == true ) {
			if (get_post_modified_time(get_option('date_format'),'',$postID) != get_the_time(get_option('date_format'),$postID) ) { 
				echo '<i class="far fa-calendar-plus"></i> <span>'.$theme_options['date-modified-text'].' '.get_post_modified_time(get_option('date_format'),'',$postID).'</span>';
			} 
		} 
		// Author
		if( $theme_options['kb-disable-doc-author-name'] == true ) {
			echo '<i class="fa fa-user"></i> <span>';  
			$author_id = $post_author; 
			echo the_author_meta( $theme_options['kb-single-post-user-name'] , $author_id ); 
			echo '</span>';
		}
	
	}
		
	// Print Icon
	if( $theme_options['kb-single-pg-print-status'] == true ) {
		echo do_shortcode('[print-me printstyle="pom-small-grey" tag="span" target=".title-content-print"]'); 
	}
	
	// Edit Icon
	edit_post_link( esc_html__( 'Edit', 'manual' ), '<span></span><i class="fa fa-edit"></i> <span class="edit-link kb-single-pg">', '</span>' ); 
	echo '</p>';		
		
		
	}
}


/*-----------------------------------------------------------------------------------*/
/*	MANUAL KB :: META SECTION
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'manual__kb_catag_belowtitle_meta_section' ) ) {
	function manual__kb_catag_belowtitle_meta_section($postID){
	global $theme_options;
		echo '<p class="entry-meta">'; 
		if( $theme_options['knowledgebase-cat-quick-stats-under-title'] == false ) {
			
			// Impression
			echo '<i class="fa fa-eye"></i> <span>';  
			if( get_post_meta( $postID, 'manual_post_visitors', true ) != '' ) { 
				echo get_post_meta( $postID, 'manual_post_visitors', true );
				echo '&nbsp;'.esc_html($theme_options['custom-record-post-view-text']);
			} else { 
				echo '0&nbsp;'.esc_html($theme_options['custom-record-post-view-text']); 
			} 
			echo '</span>';
			
			// Calender
			echo '<i class="far fa-calendar-alt"></i> <span>';  
			echo get_the_date( get_option('date_format'), $postID ); echo '</span>';
			
			
		}
		echo '</p>';
	}
}


/*-----------------------------------------------------------------------------------*/
/*	MANUAL :: NEXT PREVIOUS LINK
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'manual__post_type_next_previous_link' ) ) {
	function manual__post_type_next_previous_link($type, $postID,$term_id,$post_type,$taxonomy,$include_children = false, $order = 'ASC', $orderby = 'date'){
		global $theme_options;
	
		$next_pre_args = array( 
			'numberposts' => -1, 
			'post_type'  => $post_type,
			'orderby' => $orderby,
			'order'  => $order,
			'tax_query' => array(
				array(
					'taxonomy' => $taxonomy,
					'field' => 'id',
					'include_children' => $include_children,
					'terms' => $term_id
				)
			)
		); 
		$next_pre_postlist = get_posts( $next_pre_args );
		// get ids of posts retrieved from get_posts
		$ids = array();
		foreach ($next_pre_postlist as $thepost) {
		   $ids[] = $thepost->ID;
		}
		// get and echo previous and next post in the same taxonomy
		$thisindex = array_search($postID, $ids);
		if( isset($ids[$thisindex-1]) ) { $previd = $ids[$thisindex-1]; } else { $previd = ''; }
		if( isset($ids[$thisindex+1]) ) { $nextid = $ids[$thisindex+1]; } else { $nextid = ''; }
		
		if( !empty($previd) || !empty($nextid) ) {
			$return = '';
			$return .= '<div class="portfolio-next-prv-bar post_type_next_previous"><div class="container"><div class="portfolio-prev col-md-6 col-sm-12"><p class="previous_post_link_hide">';
			if ( !empty($previd) ) { $return .= '<h5 class="hvr-icon-back"><i class="far fa-arrow-alt-circle-left"></i>&nbsp;&nbsp;<a rel="prev" href="' . get_permalink($previd). '">'.get_the_title( $previd ).'</a></h5>'; }
			$return .= '</p> </div> <div class="portfolio-next col-md-6 col-sm-12"> <p class="next_post_link_hide">';
			if ( !empty($nextid) ) { $return .= '<h5 class="hvr-icon-forward"><a rel="next" href="' . get_permalink($nextid). '">'.get_the_title( $nextid ).'</a>&nbsp;&nbsp;<i class="far fa-arrow-alt-circle-right"></i></h5>'; }
			$return .= '</p></div></div></div>';
		} else {
			$return = '';
		}
		
		return $return;

	}
}
?>