<?php
/*
Template Name: Home Page
*/
get_header();
 
// Home Help Section
if( $theme_options['home-help-section-status'] == true ) { 
?>
<div class="clearfix"></div>
<div class="padding-top-70-btm-70">
  <div class="container content-wrapper top-body-shadow body-content">
    <div class="row">
      <div class="margin-15 static-homepage-help-blocks">
        <div class="col-md-12 col-sm-12 margin-btm-20" style="text-align:center;">
          <h2 class="margin-btm-25 uppercase"><?php echo esc_html($theme_options['home-help-section-title-main']); ?></h2>
          <p class="custom-size subtitle"><?php echo esc_html($theme_options['home-help-section-msg-short']); ?></p>
        </div>
        <div class="col-md-12 col-sm-12">
          <div class="loop-help-desk">
            <?php 
			if (isset($theme_options['home-help-blocks']['block_title'])) {
				if (is_array($theme_options['home-help-blocks']['block_title']) && !empty($theme_options['home-help-blocks']['block_title'])) {
					$count_help_block = count($theme_options['home-help-blocks']['block_title']);
					$i=0;
					while( $i < ($count_help_block) ) {
					?>
					<div class="counter-text hvr-float">
					  <div class="browse-help-desk" style="background:<?php echo esc_attr($theme_options['home-help-blocks']['block_bg_color'][$i]); ?>;">
						<div class="browse-help-desk-div"> 
						<?php 
						if( isset($theme_options['home-help-blocks']['block_custom_icon'][$i]['url']) && $theme_options['home-help-blocks']['block_custom_icon'][$i]['url'] != '' ) {
							echo '<img src="'.esc_url($theme_options['home-help-blocks']['block_custom_icon'][$i]['url']).'">';
						} else {
							echo '<i class="'.esc_attr($theme_options['home-help-blocks']['block_icon'][$i]).'" style="color:'.esc_attr($theme_options['home-help-blocks']['block_icon_color'][$i]).';font-size:'.esc_attr($theme_options['home-help-blocks']['block_title_font_size'][$i]).'"></i>'; 
						} 
						?>
						</div>
						<div class="m-and-p">
						
						  <h5 style="color:<?php echo (($theme_options['home-help-blocks']['block_text_title_color'][$i] != '')?esc_attr($theme_options['home-help-blocks']['block_text_title_color'][$i]):'inherit'); ?>;">
							<?php echo esc_html($theme_options['home-help-blocks']['block_title'][$i]); ?>
						  </h5>
						  
						  <p style="color:<?php echo (($theme_options['home-help-blocks']['block_text_desc_color'][$i] != '')?esc_attr($theme_options['home-help-blocks']['block_text_desc_color'][$i]):'inherit'); ?>;">
						  <?php echo esc_html($theme_options['home-help-blocks']['block_desc'][$i]); ?>
						  </p>
						  
						  <p>
							<span class="custom-link hvr-icon-wobble-horizontal" >
							<a href="<?php echo esc_attr($theme_options['home-help-blocks']['block_link_url'][$i]); ?>" style="color:<?php echo (($theme_options['home-help-blocks']['block_link_color'][$i]['regular'] != '')?esc_attr($theme_options['home-help-blocks']['block_link_color'][$i]['regular']):'inherit'); ?>;" onmouseover="this.style.color='<?php echo (($theme_options['home-help-blocks']['block_link_color'][$i]['hover'] != '')?esc_attr($theme_options['home-help-blocks']['block_link_color'][$i]['hover']):'inherit'); ?>'" onmouseout="this.style.color='<?php echo (($theme_options['home-help-blocks']['block_link_color'][$i]['regular'] != '')?esc_attr($theme_options['home-help-blocks']['block_link_color'][$i]['regular']):'inherit'); ?>'">
							<?php 
							if( $theme_options['home-help-blocks']['block_link_text'][$i] != '' ) {
								echo esc_attr($theme_options['home-help-blocks']['block_link_text'][$i]);
							} else {
								esc_html_e( 'Browse all', 'manual' );  
							}
							?>
							</a>
							</span>
						  </p>
						  
						</div>
					  </div>
					</div>
					<?php
				    $i++;
					}
				}
			}
		  ?>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
<?php } ?>

<!--Testo-->

<?php if( $theme_options['home-testimonials-status'] == true ) { ?>
<div class="homepg-seprator-bg static-homepage-testo-block">
  <div class="static-homepage-testo-block-overlay">
    <div class="container">
      <div class="row">
        <div class="margin-15">
          <div class="home-testo-desk">
            <?php
			if (isset($theme_options['home-testimonials-blocks']['block_desc'])) {
				if (is_array($theme_options['home-testimonials-blocks']['block_desc']) && !empty($theme_options['home-testimonials-blocks']['block_desc'])) {
					$count_help_block = count($theme_options['home-testimonials-blocks']['block_desc']);
					$i=0;
					while( $i < ($count_help_block) ) {
					?>
					<div class="col-md-12 col-sm-12  testimonial">
					  <div class="testimonial-text">
						<div class="testimonial-quote">
						  <p class="testo-title"><?php echo esc_html($theme_options['home-testimonials-blocks']['block_desc'][$i]); ?></p>
						</div>
						<div class="testimonial-cite text-white-color testo-name"><?php echo esc_html($theme_options['home-testimonials-blocks']['block_title'][$i]); ?></div>
					  </div>
					</div>
					<?php
					$i++;
					}
				}
			}
			?>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
<!--Eof Testo-->
<?php } ?>

<?php if( $theme_options['home-org-block-status'] == true ) { ?>
<div class="clearfix">
  <div class="lightblue-break static-homepage-org-blocks">
    <div class="container padding-top-70-btm-70">
      <div class="row">
        <div class="margin-15">
          <div class="col-md-12 col-sm-12 margin-btm-20" style="text-align:center;">
            <h2 class="margin-btm-25"><?php echo esc_html($theme_options['home-org-block-main-title']); ?></h2>
            <p class="custom-size desc"><?php echo esc_html($theme_options['home-org-block-sub-title']); ?></p>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
<div class="col-md-4" style="min-height: 516px; background: url(<?php if( isset($theme_options['home-org-block-background-url']['url']) && $theme_options['home-org-block-background-url']['url'] != '' ) { echo esc_url($theme_options['home-org-block-background-url']['url']); } ?>) 50% 50% / cover no-repeat;"></div>
<div class="col-md-8" style="min-height: 516px;">
  <div class="row">
    <?php
	if (isset($theme_options['home-org-blocks']['org_block_title'])) {
		if (is_array($theme_options['home-org-blocks']['org_block_title']) && !empty($theme_options['home-org-blocks']['org_block_title'])) {
			$count_org_block = count($theme_options['home-org-blocks']['org_block_title']);
			$i=0;
			while( $i < ($count_org_block) ) {
			if( $i % 2 == 0 ) $css = 'browse-whyus-desk';
			else $css = 'browse-seprate';
			?>
			
			<?php 
			if( isset($theme_options['home-org-blocks']['org_block_url'][$i]) && $theme_options['home-org-blocks']['org_block_url'][$i] !='' ) { 
				echo '<a href="'.esc_url($theme_options['home-org-blocks']['org_block_url'][$i]).'" target="_blank">';
			}
			?>
			<div class="col-md-4 col-sm-6 org-box">
			  <div style="text-align:center">
				<div class="home-box">
				<?php
				if( isset($theme_options['home-org-blocks']['org_block_custom_icon'][$i]['url']) && $theme_options['home-org-blocks']['org_block_custom_icon'][$i]['url'] != '' ) {
					echo '<img src="'.esc_url($theme_options['home-org-blocks']['org_block_custom_icon'][$i]['url']).'">';
				} else {
					echo '<i class="'.esc_attr($theme_options['home-org-blocks']['org_block_icon'][$i]).'" style="color:'.($theme_options['home-org-blocks']['org_block_icon_color'][$i] != '' ? esc_attr($theme_options['home-org-blocks']['org_block_icon_color'][$i]):'inherit').';font-size:'.esc_attr($theme_options['home-org-blocks']['org_block_font_size'][$i]).'"></i>'; 
				}
				?>
				</div>
				
				<h5 style="color:<?php echo (($theme_options['home-org-blocks']['org_block_title_color'][$i] != '')?esc_attr($theme_options['home-org-blocks']['org_block_title_color'][$i]):'inherit'); ?>;">
				<?php echo esc_html($theme_options['home-org-blocks']['org_block_title'][$i]); ?>
				</h5>
				
				<p style="color:<?php echo (($theme_options['home-org-blocks']['org_block_desc_color'][$i] != '')?esc_attr($theme_options['home-org-blocks']['org_block_desc_color'][$i]):'inherit'); ?>;"><?php echo esc_html($theme_options['home-org-blocks']['org_block_desc'][$i]); ?></p>
			  </div>
			</div>
			<?php 
			if( isset($theme_options['home-org-blocks']['org_block_url'][$i]) && $theme_options['home-org-blocks']['org_block_url'][$i] !='' ) echo '</a>';
			$i++;
			}
		}
	}
	?>
  </div>
</div>
<?php } ?>
<div class="clearfix"></div>

<?php if( $theme_options['de-message-bar'] == true ) { ?>
<div class="clearfix">
  <div class="lightblue-break static-homepage-message-bar-block">
    <div class="container padding-top-70-btm-70">
      <div class="row">
        <div class="margin-15">
          <div class="col-md-12 col-sm-12 margin-btm-20" style="text-align:center;">
            <h2 class="margin-btm-25"><?php echo esc_html($theme_options['message-bar-main-title']); ?></h2>
            <p class="desc custom-size"><?php echo esc_html($theme_options['message-bar-sub-title']); ?></p>
          </div>
          <div class="col-md-12 col-sm-12 message-bar-trim">
			<p class="home-message-darkblue-bar" onmouseover="this.style.background='<?php echo (($theme_options['message_bar_botton_color']['hover'] != '')?esc_attr($theme_options['message_bar_botton_color']['hover']):'inherit'); ?>'" onmouseout="this.style.background='<?php echo (($theme_options['message_bar_botton_color']['regular'] != '')?esc_attr($theme_options['message_bar_botton_color']['regular']):'inherit'); ?>'"> 
			<a class="link hvr-icon-wobble-horizontal" href="<?php if( isset($theme_options['message-bar-bottom-url']) && $theme_options['message-bar-bottom-url']!= '' ){ echo esc_url($theme_options['message-bar-bottom-url']); } ?>"> 
			<?php echo esc_html($theme_options['message-bar-bottom-display-text']); ?> &nbsp;<i class="fa fa-arrow-right hvr-icon"></i></a> </p>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
<?php } ?>

<!--Fun Act-->
<?php if( $theme_options['home-funact-status'] == true ) { ?>
<div class="homepg-seprator-bg parallax-window static-homepage-funact-block">
  <div class="padding-top-70-btm-70 lightblue-break static-homepage-funact-block-overlay">
    <div class="funact-main-div">
      <div class="container content-wrapper">
        <div class="row">
          <div class="col-md-12 col-sm-12 margin-btm-20" style="text-align:center;">
            <h2  class="margin-btm-25"><?php echo esc_html($theme_options['home-funact-main-title']); ?></h2>
            <p class="custom-size desc"><?php echo esc_html($theme_options['home-funact-sub-title']); ?></p>
          </div>
          <div class="col-md-12 col-sm-12">
            <?php
			if (isset($theme_options['home-funact-stats']['fun_act_number'])) {
				if (is_array($theme_options['home-funact-stats']['fun_act_number']) && !empty($theme_options['home-funact-stats']['fun_act_number'])) {
					$count_help_block = count($theme_options['home-funact-stats']['fun_act_number']);
					$i=0;
					while( $i < ($count_help_block) ) {
					?>
					<div class="col-md-3 col-sm-6" style=" padding: 25px 3px;text-align: center;">
					  <p><b style="color:<?php echo (($theme_options['home-funact-stats']['fun_act_number_color'][$i] != '')?esc_attr($theme_options['home-funact-stats']['fun_act_number_color'][$i]):'inherit'); ?>;" class="timer counter-number funact counter-number-color"  data-to="<?php echo esc_html($theme_options['home-funact-stats']['fun_act_number'][$i]); ?>" data-speed="10000" ></b></p>
					  <p style="color:<?php echo (($theme_options['home-funact-stats']['fun_act_title_color'][$i] != '')?esc_attr($theme_options['home-funact-stats']['fun_act_title_color'][$i]):'inherit'); ?>;" class="counter-text countdown"><?php echo esc_html($theme_options['home-funact-stats']['fun_act_title'][$i]); ?></p>
					</div>
					<?php
					$i++;
					}
				}
			}
			?>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
<?php } ?>

<!--Notification Bar-->
<?php
manual_footer_notification_msg(1);
get_footer(); 
?>