<?php
/**
 * Template for displaying instructor of single course.
 *
 * Do not use in LP4.
 * Will remove after LearnPress and Eduma and all guest update 4.0.0
 *
 * @author   ThimPress
 * @package  Learnpress/Templates
 * @version  3.0.1
 */

/**
 * Prevent loading this file directly
 */
defined( 'ABSPATH' ) || exit();

$course = learn_press_get_course();
if ( ! $course ) {
	return;
}

$instructor = $course->get_instructor();
if ( ! $instructor instanceof LP_User ) {
	return;
}

$img_profile = $instructor->get_profile_picture();
?>
<div class="course-author"> <?php echo wp_kses_post( $img_profile ); ?>
  <div class="author-contain">
    <label itemprop="jobTitle">
      <?php esc_html_e( 'Teacher', 'manual' ); ?>
    </label>
    <div class="value" itemprop="name"> <?php echo wp_kses_post( $course->get_instructor_html() ); ?> </div>
  </div>
</div>
