<?php
/**
 * Template for displaying main user profile page.
 *
 * @author   ThimPress
 * @package  Learnpress/Templates
 * @version  4.0.2
 */

defined( 'ABSPATH' ) || exit();

if ( ! isset( $profile ) ) {
	return;
}

if (is_user_logged_in()) {
?>
	<div id="learn-press-profile" <?php $profile->main_class(); ?>>
		<div class="lp-content-area">
			<?php do_action( 'learn-press/user-profile', $profile ); ?>
		</div>
	</div>
<?php
} else {
	$profile = LP_Global::profile();
	learn_press_display_message( sprintf( __( 'Please <a href="%s">login</a> to see your profile content', 'manual' ), $profile->get_login_url() ) );
}