<?php
add_action( 'tgmpa_register', 'manual_theme_register_required_plugins' );
function manual_theme_register_required_plugins() {

	/*** CHECK THE UPDATE ***/
	$learnpress_paid_membership_pro = $Ultimate_VC_Addons = $manual_framework = $js_composer = $wpcustom_category_image = '';
	$latestVersion = array();
	$response = wp_remote_get('https://smartwpthemes.com/api/install/check-update.php?token=UGkAhhnCrI');
	if (!is_wp_error($response)) {
		$response_code = wp_remote_retrieve_response_code($response);
		if ($response_code === 200) {
			$jsonString = wp_remote_retrieve_body($response);
			$data = json_decode($jsonString, true);
			if ($data !== null) {
				foreach ($data as $key => $value) {
					$latestVersion[$key] = $value; 
				}
			}
			if (!empty($latestVersion)) {
				$learnpress_paid_membership_pro = (isset($latestVersion['learnpress-paid-membership-pro'])?$latestVersion['learnpress-paid-membership-pro']:'');
				$Ultimate_VC_Addons = (isset($latestVersion['Ultimate_VC_Addons'])?$latestVersion['Ultimate_VC_Addons']:''); 
				$manual_framework = (isset($latestVersion['manual-framework'])?$latestVersion['manual-framework']:''); 
				$js_composer = (isset($latestVersion['js_composer'])?$latestVersion['js_composer']:''); 
				$wpcustom_category_image = (isset($latestVersion['wpcustom-category-image'])?$latestVersion['wpcustom-category-image']:'');
			}
		}
	}
	/*** END CHECK THE UPDATE ***/

	$theme_url = trailingslashit( get_template_directory() );
	
	/*** Set default variables and verify the activation status of various plugins. ***/
	$required_learnpress__course_review = $required_learnpress__wishlist = $required_learnpress__learnpress_paid_membership_pro = $required_learnpress__paid_membership_pro = $required_learnpress__bbpress = $required_ultimate_addons_for_wpbakery_page_builder = '';
	
	$is_plugin_learnpress_active 		 = manual__plugin_active('LearnPress');
	$is_plugin_bbpress_active 			 = manual__plugin_active('bbPress');
	$is_plugin_pro_membership_pro_active = manual__plugin_active('PMPro_Membership_Level');
	$is_plugin_js_composer_active 		 = manual__plugin_active('Vc_Manager');
	
	/*** Learnpress ***/
	if ( $is_plugin_learnpress_active == true ) {
		
		if( $is_plugin_learnpress_active == true && $is_plugin_bbpress_active == true ) { 
			$required_learnpress__bbpress = array( 'name'      => 'LearnPress - bbPress Integration', 
												   'slug'      => 'learnpress-bbpress', 
												   'required'  => true, 
												 );
		}
		if( $is_plugin_learnpress_active == true && $is_plugin_pro_membership_pro_active == true ) { 
			$required_learnpress__learnpress_paid_membership_pro = array(
													'name'               => 'LearnPress - Paid Membership Pro Integration',
													'slug'               => 'learnpress-paid-membership-pro', 
													'source'             => 'https://smartwpthemes.com/api/install/learnpress-paid-membership-pro.zip',
													'external_url' 		 => 'https://smartwpthemes.com/api/install/learnpress-paid-membership-pro.zip',
													'required'           => true, 
													'version'      		 => $learnpress_paid_membership_pro,  
												);
		}
		$required_learnpress__wishlist = array( 'name'     => 'LearnPress - Course Wishlist', 
												'slug'     => 'learnpress-wishlist', 
												'required' => true, 
										       );
		$required_learnpress__course_review = array( 
												'name'     => 'Learnpress - Course Review', 
												'slug'     => 'learnpress-course-review', 
												'required' => true, 
											   );
		$required_learnpress__paid_membership_pro = array(
												'name'     => 'Paid Membership Pro',
												'slug'     => 'paid-memberships-pro', 
												'required' => false, 
												);
	}
	/*** EOF - Learnpress ***/
	
	/*** Visual Composer ***/
	if ( $is_plugin_js_composer_active == true ) {
		$required_ultimate_addons_for_wpbakery_page_builder = array(
														'name'         => 'Ultimate Addons for WPBakery Page Builder',
														'slug'         => 'Ultimate_VC_Addons', 
														'source'       => 'https://smartwpthemes.com/api/install/Ultimate_VC_Addons.zip', 
														'external_url' => 'https://smartwpthemes.com/api/install/Ultimate_VC_Addons.zip',
														'required'     => true, 
														'version'      => $Ultimate_VC_Addons,
												    );
	}
	/*** EOF - Visual Composer ***/
	
	$plugins = array(
		/**************
		** REQUIRED ***
		**************/
		array(
			'name'         => 'Redux Framework', 
			'slug'         => 'redux-framework', 
			'required'     => true, 
		),
		array(
			'name'         => 'Getwid', 
			'slug'         => 'getwid', 
			'required'     => true, 
		),
		array(
			'name'         => 'CMS Tree Page View',
			'slug'         => 'cms-tree-page-view', 
			'required'     => true, 
		),
		array(
			'name'         => 'CMB2',
			'slug'         => 'cmb2', 
			'required'     => true, 
		),
		array(
			'name'         => 'Elementor Website Builder', 
			'slug'         => 'elementor', 
			'required'     => false, 
		),
		array(
			'name'         => 'Taxonomy Terms Order', 
			'slug'         => 'taxonomy-terms-order', 
			'required'     => false, 
		),
		array(
			'name'         => 'One Click Demo Import', 
			'slug'         => 'one-click-demo-import', 
			'required'     => false, 
		),
		array(
			'name'         => 'Manual Framework',
			'slug'         => 'manual-framework', 
			'source'       => 'https://smartwpthemes.com/api/install/manual-framework.zip', 
			'external_url' => 'https://smartwpthemes.com/api/install/manual-framework.zip',
			'required'     => true, 
			'version'     => $manual_framework,
		),
		array(
			'name'         => 'WPBakery Page Builder', 
			'slug'         => 'js_composer', 
			'source'       => 'https://smartwpthemes.com/api/install/js_composer.zip', 
			'external_url' => 'https://smartwpthemes.com/api/install/js_composer.zip', 
			'required'     => false, 
			'version'      => $js_composer,
		),
		array(
			'name'         => 'WPCustom Category Image', 
			'slug'         => 'wpcustom-category-image', 
			'source'       => 'https://smartwpthemes.com/api/install/wpcustom-category-image.zip',
			'external_url' => 'https://smartwpthemes.com/api/install/wpcustom-category-image.zip',  
			'required'     => false, 
			'version'      => $wpcustom_category_image,
		),
		array(
			'name' => 'Envato Market',
			'slug' => 'envato-market',
			'source' => 'http://envato.github.io/wp-envato-market/dist/envato-market.zip',
			'required' => false,
		),
		
		$required_learnpress__course_review, 
		$required_learnpress__wishlist, 
		$required_learnpress__paid_membership_pro,
		$required_learnpress__learnpress_paid_membership_pro, 
		$required_learnpress__bbpress,
		$required_ultimate_addons_for_wpbakery_page_builder,
		
	);
	$config = array(
		'id'           => 'tgmpa',                 
		'default_path' => '',                      
		'menu'         => 'tgmpa-install-plugins', 
		'parent_slug'  => 'themes.php',            
		'capability'   => 'edit_theme_options',    
		'has_notices'  => true,                    
		'dismissable'  => true,                   
		'dismiss_msg'  => '',                      
		'is_automatic' => false,                   
		'message'      => '',                     
	);
	tgmpa( $plugins, $config );
}

/**
 * @param array $action_links The action link(s) for a required plugin.
 * @return array The action link(s) for a required plugin.
 */
function manual__edit_tgmpa_notice_action_links( $action_links ) {
		
		$current_screen = get_current_screen();
		
		if ( 'manual-theme_page_manual-admin-install-plugins' == $current_screen->id ) {
			$link_template = '<a id="manage-plugins" class="button-primary" style="margin-top:1em;" href="#">' . esc_attr__( 'Manage Plugins Below', 'manual' ) . '</a>';
			$action_links  = array(
				'install' => $link_template,
			);
		} else if ( 'manual_page_manual-admin-plugins' == $current_screen->id ) {
			$link_template = '<a id="manage-plugins" style="margin-top:1em;">' . esc_attr__( '>> Manage Plugins Below <<', 'manual' ) . '</a>';
			$action_links  = array(
				'install' => $link_template,
			);
		} else {
			$manual__theme_old_version_plugin = get_option( 'manual_theme_framework_version' );
			if( $manual__theme_old_version_plugin < 3.3 ) { 
				$link_template = '<a id="manage-plugins" class="button-primary" style="margin-top:1em;" href="' . esc_url( self_admin_url( 'admin.php?page=manual-admin-plugins' ) ) . '">' . esc_attr__( 'Go Manage Plugins', 'manual' ) . '</a>';
				$action_links  = array(
					'install' => $link_template,
				);
			} else {  
				$link_template = '<a id="manage-plugins" class="button-primary" style="margin-top:1em;" href="' . esc_url( self_admin_url( 'admin.php?page=manual-admin-install-plugins' ) ) . '">' . esc_attr__( 'Go Manage Plugins', 'manual' ) . '</a>';
				$action_links  = array(
					'install' => $link_template,
				);
			}
		}
		
		return $action_links;
}
	
$is_plugin_required_fortheme_active = manual__chkfunction_plugin_active('manual_framework_plugin_active');
if ( $is_plugin_required_fortheme_active == true ) {	
	add_filter( 'tgmpa_notice_action_links', 'manual__edit_tgmpa_notice_action_links' );
}


/*-----------------------------------------------------------------------------------*/
/*	ADMIN NOTICE
/*-----------------------------------------------------------------------------------*/
if (!function_exists('manual__admin_notice_missing_main_plugin')) {
	function manual__admin_notice_missing_main_plugin() {
		
		// Visual Composer
		$is_plugin_js_composer_active = manual__plugin_active('Vc_Manager');
		$is_plugin_elementor_active = manual__abs_plugin_active( 'elementor/elementor.php' );
		$is_plugin_manual_framework_active = manual__chkfunction_plugin_active('manual_framework_plugin_active');
		
		if ( $is_plugin_manual_framework_active == true ) {
			$message = sprintf(
				esc_html__( 'In order to make use of the "%1$s" feature, you must have either the "%2$s" or "%3$s" plugin installed and activated. %4$s. %5$s', 'manual' ),
				'<strong>' . esc_html__( 'Manual', 'manual' ) . '</strong>',
				'<strong>' . esc_html__( 'Elementor', 'manual' ) . '</strong>',
				'<strong>' . esc_html__( 'WPBakery', 'manual' ) . '</strong>',
				'<strong>' . esc_html__( 'However, it is recommended not to employ both plugins at the same time', 'manual' ) . '</strong>',
				'<a class="button-primary" href="'.esc_url_raw(admin_url( 'admin.php?page=manual-admin-install-plugins')).'">' . esc_html__( 'Install Now', 'manual' ) . '</a>'
			);
		} else {
			$message = sprintf(
				esc_html__( 'In order to make use of the "%1$s" feature, you must have either the "%2$s" or "%3$s" plugin installed and activated. %4$s. %5$s', 'manual' ),
				'<strong>' . esc_html__( 'Manual', 'manual' ) . '</strong>',
				'<strong>' . esc_html__( 'Elementor', 'manual' ) . '</strong>',
				'<strong>' . esc_html__( 'WPBakery', 'manual' ) . '</strong>',
				'<strong>' . esc_html__( 'However, it is recommended not to employ both plugins at the same time', 'manual' ) . '</strong>',
				'<a class="button-primary" href="'.esc_url_raw(admin_url( 'themes.php?page=tgmpa-install-plugins')).'">' . esc_html__( 'Install Now', 'manual' ) . '</a>'
			);
		}
		if ( ($is_plugin_js_composer_active == false) && ($is_plugin_elementor_active != 1) ) {
			printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message );
		}
	}
	add_action( 'admin_notices', 'manual__admin_notice_missing_main_plugin');
}
?>