<?php  
if ( ! class_exists( 'manual__customCategoryImage' ) ) {
class manual__customCategoryImage {

    protected $taxonomies;

    public static $instance = null;

    public static function getInstance() {
        if (!self::$instance) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    public static function initialize() {
        $instance = self::getInstance();

        // Shortcode
        add_shortcode('manual_custom_post_type_category_image_icon', array($instance, 'shortcode'));

        // Actions
        add_action('admin_init',                  array($instance, 'admin_init'));
        add_action('admin_enqueue_scripts',       array($instance, 'admin_enqueue_assets'));
        add_action('edit_term',                   array($instance, 'save_image'));
        add_action('create_term',                 array($instance, 'save_image'));
    }

    public static function shortcode($atts) {
        $args = shortcode_atts(array(
                'size'    => 'full',
                'term_id' => null,
                'alt'     => null,
                'onlysrc' => false
        ), $atts);

        return self::get_category_image(array(
            'size'    => $args['size'],
            'term_id' => $args['term_id'],
            'alt'     => $args['alt']
        ), (boolean) $args['onlysrc']);
    }

    public static function get_category_image($atts = array(), $onlysrc = false) {
        $params = array_merge(array(
            'size'    => 'full',
            'term_id' => null,
            'alt'     => null
        ), $atts);

        $term_id = $params['term_id'];
        $size    = $params['size'];

        if (!$term_id) {
            $term    = get_queried_object();
            $term_id = $term->term_id;
        }

        if (!$term_id) {
            return;
        }

        $attachment_id   = get_option('category_icon_image_'.$term_id);

        $attachment_meta = get_post_meta($attachment_id, '_wp_attachment_image_alt', true);
        $attachment_alt  = trim(strip_tags($attachment_meta));

        $attr = array(
            'alt'=> (is_null($params['alt']) ?  $attachment_alt : $params['alt'])
        );

        if ($onlysrc) {
            $src = wp_get_attachment_image_src($attachment_id, $size, false);
            return is_array($src) ? $src[0] : null;
        }

        return wp_get_attachment_image($attachment_id, $size, false, $attr);
    }

    public function manage_category_columns($columns) {
        return array_merge($columns, array('imageicon' => __('Image Icon', 'manual')));
    }

    public function manage_category_columns_fields($deprecated, $column_name, $term_id)
    {
        if ($column_name == 'imageicon' && $this->has_image($term_id)) {
            echo self::get_category_image(array(
                'term_id' => $term_id,
                'size'    => array(50, 50),
            ));
        }
    }

    public function admin_init()
    {
        $this->taxonomies = get_taxonomies();

        add_filter('manage_edit-category_columns', array($this, 'manage_category_columns'));
        add_filter('manage_category_custom_column', array($this, 'manage_category_columns_fields'), 10, 3);

        foreach ((array) $this->taxonomies as $taxonomy) {
            if( $taxonomy == 'manualdocumentationcategory' || $taxonomy == 'manualknowledgebasecat' ) {
				$this->add_custom_column_fields($taxonomy);
			}
        }
    }

    public function add_custom_column_fields($taxonomy)
    {
        add_action("{$taxonomy}_add_form_fields", array($this, 'add_taxonomy_field'));
        add_action("{$taxonomy}_edit_form_fields", array($this, 'edit_taxonomy_field'));

        // Add custom columns to custom taxonomies
        add_filter("manage_edit-{$taxonomy}_columns", array($this, 'manage_category_columns'));
        add_filter("manage_{$taxonomy}_custom_column", array($this, 'manage_category_columns_fields'), 10, 3);
    }

    /**
     * Enqueue assets into admin
     */
    public function admin_enqueue_assets($hook)
    {
        if ($hook != 'edit-tags.php' && $hook != 'term.php') {
            return;
        }

        wp_enqueue_media();
        wp_enqueue_script('post-type-category-icon-image-js', trailingslashit( get_template_directory_uri() ). 'framework/post-type-category/js/categoryimage.js', array('jquery'), '1.0.0', true );
		wp_localize_script('post-type-category-icon-image-js', 'CategoryImage', array(
                'label'      => array(
                    'title'  => __('Choose Category Image', 'manual'),
                    'button' => __('Choose Image', 'manual')
                )
            )
        );
        wp_enqueue_style('post-type-category-icon-image-css', trailingslashit(get_template_directory_uri()) . 'framework/post-type-category/css/categoryimage.css');
    }

    private function asset_url($file)
    {
        return plugins_url($file, __FILE__);
    }

    public function save_image($term_id)
    {
        // Ignore quick edit
        if (isset($_POST['action']) && $_POST['action'] == 'inline-save-tax') {
            return;
        }

        $attachment_id = isset($_POST['category_icon_image_attachment']) ? (int) $_POST['category_icon_image_attachment'] : null;

        if (! is_null($attachment_id) && $attachment_id > 0 && !empty($attachment_id)) {
            update_option('category_icon_image_'.$term_id, $attachment_id);
            return;
        }

        delete_option('category_icon_image_'.$term_id);
    }

    public function get_attachment_id($term_id)
    {
        return get_option('category_icon_image_'.$term_id);
    }

    public function has_image($term_id)
    {
        return ($this->get_attachment_id($term_id) !== false);
    }

    public function add_taxonomy_field($taxonomy)
    {
        echo $this->taxonomy_field('add-form-option-image', $taxonomy);
    }

    public function edit_taxonomy_field($taxonomy)
    {
        echo $this->taxonomy_field('edit-form-option-image', $taxonomy);
    }

    public function taxonomy_field($template, $taxonomy)
    {
        $params = array(
            'label'  => array(
                'image'        => __('Image icon', 'manual'),
                'upload_image' => __('Upload/Edit image icon', 'manual'),
                'remove_image' => __('Remove image icon', 'manual')
            ),
            'category_icon_image_attachment' => null
        );


        if (isset($taxonomy->term_id) && $this->has_image($taxonomy->term_id)) {
            $image = self::get_category_image(array(
                'term_id' => $taxonomy->term_id
            ), true);

            $attachment_id = $this->get_attachment_id($taxonomy->term_id);

            $params = array_replace_recursive($params, array(
                'category_icon_image_image'      => $image,
                'category_icon_image_attachment' => $attachment_id,
            ));
        }

        return manual___post_type_category_template($template, $params, false);
    }
}
add_action('init', array('manual__customCategoryImage', 'initialize'));
}

/**********************
** HELPING FUNCTIONS **
***********************/
if (!function_exists('manual___post_type_category_template')) {
    function manual___post_type_category_template($name, $params = array(), $echo_html = true) {  

        $filename = trailingslashit( get_template_directory() ) .'framework/post-type-category/templates/' . $name . '.php';

        if (! file_exists($filename)) {
            return;
        }

        foreach ($params as $param => $value) {
            $$param = $value;
        }

        ob_start();
        include $filename;
        $html = ob_get_contents();
        ob_end_clean();

        if (! $echo_html) {
            return $html;
        }

        echo $html;
    }
}
?>