<?php
class manual_menu_walker extends Walker {

  var $db_fields = array( 'parent' => 'menu_item_parent', 'id' => 'db_id' );
  
  function display_element( $element, &$children_elements, $max_depth, $depth, $args, &$output ) {
	$id_field = $this->db_fields['id'];
	if ( is_object( $args[0] ) ) {
			$args[0]->has_children = ! empty( $children_elements[$element->$id_field] );
	}
	return parent::display_element( $element, $children_elements, $max_depth, $depth, $args, $output );
  }

  function start_lvl( &$output, $depth = 0, $args = array() ) {
    $class = '';
	if( $depth == 0 || $depth > 0 ) { 
		$class = 'class="sub-menu"';
	}
	$indent = str_repeat("\t", $depth);
    $output .= "\n$indent<ul ".$class.">\n";
  }

  function end_lvl( &$output, $depth = 0, $args = array() ) {
    $indent = str_repeat("\t", $depth);
    $output .= "$indent</ul>\n";
  }

  function start_el( &$output, $item, $depth = 0, $args = array(), $id = 0 ) {

    global $wp_query;
    $indent = ( $depth ) ? str_repeat( "\t", $depth ) : '';
    $class_names = $value = '';
    $classes = empty( $item->classes ) ? array() : (array) $item->classes;

    /* Add active class */
    if(in_array('current-menu-item', $classes)) {
      $classes[] = 'active';
      unset($classes['current-menu-item']);
    }

    /* Check for children */
    $children = get_posts(array('post_type' => 'nav_menu_item', 'nopaging' => true, 'numberposts' => 1, 'meta_key' => '_menu_item_menu_item_parent', 'meta_value' => $item->ID));
    if (!empty($children)) {
      $classes[] = 'has-sub';
    }

    $class_names = join( ' ', apply_filters( 'nav_menu_css_class', array_filter( $classes ), $item, $args ) );
    $class_names = $class_names ? ' class="' . esc_attr( $class_names ) . '"' : '';

    $id = apply_filters( 'nav_menu_item_id', 'menu-item-'. $item->ID, $item, $args );
    $id = $id ? ' id="' . esc_attr( $id ) . '"' : '';

    $output .= $indent . '<li' . $id . $value . $class_names .'>';

    $attributes  = ! empty( $item->attr_title ) ? ' title="'  . esc_attr( $item->attr_title ) .'"' : '';
    $attributes .= ! empty( $item->target )     ? ' target="' . esc_attr( $item->target     ) .'"' : '';
    $attributes .= ! empty( $item->xfn )        ? ' rel="'    . esc_attr( $item->xfn        ) .'"' : '';
    $attributes .= ! empty( $item->url )        ? ' href="'   . esc_attr( $item->url        ) .'"' : '';

    $item_output = $args->before;
    $item_output .= '<a'. $attributes .'>';
    $item_output .= $args->link_before . apply_filters( 'the_title', $item->title, $item->ID ) . $args->link_after;
	
	// handle child
	if( $args->has_children != '' && $depth == 1 ) {
		$item_output .= '<i class="menu_arrow fa fa-angle-right"></i>';
	}
	// Eof handle child
	

	// parent child check
	if( $args->has_children != '' && $depth == 0 ) {
			$item_output .= ' <i class="menu_arrow_first_level fa fa-caret-down"></i>';
	}
	// Eof  parent child check
	
    $item_output .= '</a>';
	
	// parent child check
	if( $args->has_children != '' && $depth == 0 ) {
			$item_output .= ' <i class="mobile_menu_arrow fa fa-caret-down"></i>';
	}
	// Eof  parent child check
	
    $item_output .= $args->after;

    $output .= apply_filters( 'walker_nav_menu_start_el', $item_output, $item, $depth, $args );
  }

  function end_el( &$output, $item, $depth = 0, $args = array() ) {
    $output .= "</li>\n";
  }
}
?>