<?php
global $theme_options;
$custom_login_message  = $instance['custom_login_message'];
$custom_loggedin_message  = $instance['custom_loggedin_message'];
$custom_logout_text = $instance['custom_logout_text'];
$custom_lostpassword_text = $instance['custom_lostpassword_text'];
$custom_register_text = $instance['custom_register_text'];
$custom_no_member_register_text = $instance['custom_no_member_register_text'];

if( isset($theme_options['login_box_lostpwd_linkurl']) && $theme_options['login_box_lostpwd_linkurl'] != '' ) {
	$forget_password_link_url = $theme_options['login_box_lostpwd_linkurl'];
} else {
	$forget_password_link_url = wp_lostpassword_url();
}

if( isset($theme_options['login_box_register_linkurl']) && $theme_options['login_box_register_linkurl'] != '' ) {
	$register_link_url = $theme_options['login_box_register_linkurl'];
} else {
	$register_link_url =  wp_registration_url();
}
		
$return = '';
if( is_user_logged_in() ) {
	$return .= '<div class="manual_login_page"> <div class="custom_login_form">';
	$return .= '<h4>'.$custom_loggedin_message.'</h4>';
	$return .= '<p><a href="'.esc_url(wp_logout_url()).'" class="more-link hvr-icon-wobble-horizontal">'.esc_html($custom_logout_text).' &nbsp;<i class="fa fa-arrow-right hvr-icon"></i></a>';
	$return .= '</p></div></div>';
} else {
	$return .= '<div><div class="manual_login_page"><div class="custom_login_form">';
	$return .= '<h4>'.esc_html($custom_login_message).'</h4>';
	$args = array(
				'echo' => false,
				'label_username' => ((isset($theme_options['login_box_label_username']) && $theme_options['login_box_label_username'] != '' )?esc_html__($theme_options['login_box_label_username']):''),
				'label_password' => ((isset($theme_options['login_box_label_password']) && $theme_options['login_box_label_password'] != '' )?esc_html__($theme_options['login_box_label_password']):''),
				'label_remember' => ((isset($theme_options['login_box_label_remember']) && $theme_options['login_box_label_remember'] != '' )?esc_html__($theme_options['login_box_label_remember']):''),
				'label_log_in'   => ((isset($theme_options['login_box_label_log_in']) && $theme_options['login_box_label_log_in'] != '' )?esc_html__($theme_options['login_box_label_log_in']):''),
			);
	$return .= wp_login_form($args);
	$return .= '<ul class="custom_register">';
	$return .= '<li><a href=" '.esc_url($forget_password_link_url).'" class="more-link hvr-icon-wobble-horizontal margin-15">';
	$return .= $custom_lostpassword_text;
	$return .= ' &nbsp;&nbsp;<i class="fa fa-arrow-right hvr-icon"></i> </a></li>';
	
	$registration_enabled = get_option( 'users_can_register' );
	if ( $registration_enabled ) {
		$return .= '<li>' . $custom_no_member_register_text . ' <a href="'. esc_url($register_link_url).'" class="more-link">' . esc_html($custom_register_text) . '</a></li>';
	}
	
	$return .= '</ul>';
	$return .= '</div></div></div>';
}

echo ent2ncr( $return );