<?php
/*-----------------------------------------------------------------------------------*/
/*	THEME HEADER CONTROL
/*-----------------------------------------------------------------------------------*/
if (!function_exists('manual__theme_header_control')) {
	function manual__theme_header_control(){
		global $theme_options;
		
		$class_name = manual__gobal_landing_page_classname();
		
		echo '<nav class="navbar navbar-inverse '.$class_name.'">';
		if( (isset( $theme_options['website_nav_container_global_full_width'] ) && $theme_options['website_nav_container_global_full_width'] == true) && 
			(isset( $theme_options['website_box_layout'] ) && $theme_options['website_box_layout'] == false) ) { 
			echo '<div class="container-fluid nav-fix">';
		} else { 
			echo '<div class="container nav-fix">';
		}
		
		echo '<div class="navbar-header">';
		manual_responsive_layout_bar_icon_replacement();
		manual_global_header();
		echo '</div>';
		
		if( $theme_options['theme-global-menu-type'] == 1 || $theme_options['theme-global-menu-type'] == 2 ) {
			echo '<div id="navbar" class="navbar-collapse collapse">';
				// Hamburger Menu
				$hamburger_class = manual_css_hamburger_menu_control();
				manual_hamburger_menu_control(); 
				
				// Header Wiget
				if ( is_active_sidebar( 'manual-header-social-widgetnav' ) ) : 
					echo '<div class="theme_header_menu_social '. esc_html($hamburger_class).'">';
						dynamic_sidebar( 'manual-header-social-widgetnav' ); 
					echo '</div>';	
				endif;
				
				
				// Primary Menu
				if ( has_nav_menu( 'primary' ) ) { 
					 wp_nav_menu( array( 'theme_location' => 'primary', 'container' => false, 'menu_class' => 'nav navbar-nav '.$hamburger_class.'',  'walker' => new manual_menu_walker() )); 	
				} else { 
					echo '<ul class="nav navbar-nav '. esc_html($hamburger_class).' ">';
					echo wp_list_pages( array( 'title_li' => '' ) );
					echo '</ul>';
				} 	
			echo '</div>';
		}
		echo '</div>';
		
		// Type 3 || 4 menu
		if( ($theme_options['theme-global-menu-type'] == 3) || 
			($theme_options['theme-global-menu-type'] == 4) ) {
			if( (isset( $theme_options['website_nav_container_global_full_width'] ) && $theme_options['website_nav_container_global_full_width'] == true) && 
				(isset( $theme_options['website_box_layout'] ) && $theme_options['website_box_layout'] == false) ) { 
				echo '<div class="special-apperance-menu item-block"><div class="container-fluid menu_type_three clearfix">';
			} else { 
				echo '<div class="special-apperance-menu item-block"><div class="container menu_type_three clearfix">';
			}
			
			echo '<div id="navbar" class="navbar-collapse collapse">';
				
				if( $theme_options['theme-global-menu-type'] == 4 ) {
					$hamburger_class = '';
				} else {
					// Hamburger Menu
					$hamburger_class = manual_css_hamburger_menu_control();
					manual_hamburger_menu_control(); 
				}
				
				if( $theme_options['theme-global-menu-type'] == 3 ) {
					// Header Wiget
					if ( is_active_sidebar( 'manual-header-social-widgetnav' ) ) : 
						echo '<div class="theme_header_menu_social '. esc_html($hamburger_class).'">';
						dynamic_sidebar( 'manual-header-social-widgetnav' );
						echo '</div>';
					endif;
				}
				
				
				// Primary Menu
				if ( has_nav_menu( 'primary' ) ) { 
					 wp_nav_menu( array( 'theme_location' => 'primary', 'container' => false, 'menu_class' => 'nav navbar-nav '.$hamburger_class.'',  'walker' => new manual_menu_walker() )); 	
				} else { 
					echo '<ul class="nav navbar-nav '. esc_html($hamburger_class).' ">';
					echo wp_list_pages( array( 'title_li' => '' ) );
					echo '</ul>';
				} 
			echo '</div>';
			
			echo '</div></div>';
		}
	echo '</nav>';	
	}
}

/*-----------------------------------------------------------------------------------*/
/*	MANUAL RESPONSIVE LAYOUT "BAR ICON REPLACEMENT"
/*-----------------------------------------------------------------------------------*/
if (!function_exists('manual_responsive_layout_bar_icon_replacement')) {
	function manual_responsive_layout_bar_icon_replacement() { 
		global $theme_options;
		if( $theme_options['theme-responsive-bar-icon-replacement'] == false ) { 
			$barname = 'fa fa-bars';
			$replacement_html_text = '';
		} else { 
			$barname = ''; 
			$replacement_html_text = $theme_options['theme-responsive-bar-icon-replacement-text'];
		}
		echo '<i class="'.$barname.' navbar-toggle">'.$replacement_html_text.'</i>';
	}
}


/*-----------------------------------------------------------------------------------*/
/*	MANUAL :: HAMBURGER MENU
/*-----------------------------------------------------------------------------------*/
if (!function_exists('manual_css_hamburger_menu_control')) {
	function manual_css_hamburger_menu_control(){
		$hamburger_class = '';
		global $theme_options,$post;
			$current_post_type = get_post_type();
			// Hamburger Menu ON/OFF
			if( $theme_options['activate-hamburger-menu'] == true ) {
				$hamburger_class = 'hidemenu';
			} else {
				$hamburger_class = '';
			}
		return $hamburger_class;
	}
}

if (!function_exists('manual_hamburger_menu_control')) {
	function manual_hamburger_menu_control(){
		global $theme_options, $post;
		$activate_hemburger_menu = false;
		$current_post_type = get_post_type();

			if( isset($theme_options['activate-search-box-on-menu-bar']) && $theme_options['activate-search-box-on-menu-bar'] == true ) {
				$activate_hemburger_menu = true;
				if( is_404() ) {
					if( isset($theme_options['404page_header_menu']) && $theme_options['404page_header_menu'] == true ) {
						if( isset($theme_options['404page_header_menu_hamburger_search_box']) && $theme_options['404page_header_menu_hamburger_search_box'] == true ) {
							$activate_hemburger_menu = false;
						}
					}
				} else if( is_search() ) {
					if( isset($theme_options['searchpage_header_menu']) && $theme_options['searchpage_header_menu'] == true ) {
						if( isset($theme_options['search_header_menu_hamburger_search_box']) && $theme_options['search_header_menu_hamburger_search_box'] == true ) {
							$activate_hemburger_menu = false;
						}
					}
				} else if( $current_post_type == 'post' && is_single() ) {
					if( isset($theme_options['blog_single_pg_header_menu']) && $theme_options['blog_single_pg_header_menu'] == true ) {
						if( isset($theme_options['blog_single_header_menu_hamburger_search_box']) && $theme_options['blog_single_header_menu_hamburger_search_box'] == true ) {
							$activate_hemburger_menu = false;
						}
					}
				} else if($current_post_type == 'manual_faq') {
					if( isset($theme_options['faq_pages_header_menu']) && $theme_options['faq_pages_header_menu'] == true ) {
						if( isset($theme_options['faq_header_menu_hamburger_search_box']) && $theme_options['faq_header_menu_hamburger_search_box'] == true ) {
							$activate_hemburger_menu = false;
						}
					}
				} else if($current_post_type == 'manual_documentation') {
					if( isset($theme_options['documentation_pagetitlebar_header_menu']) && $theme_options['documentation_pagetitlebar_header_menu'] == true ) {
						if( isset($theme_options['documentation_header_menu_hamburger_search_box']) && $theme_options['documentation_header_menu_hamburger_search_box'] == true ) {
							$activate_hemburger_menu = false;
						}
					}
				} else if($current_post_type == 'manual_kb') {
					if( is_single() ) {
						if( isset($theme_options['knowledgebase_pagetitlebar_header_menu']) && $theme_options['knowledgebase_pagetitlebar_header_menu'] == true ) {
							if( isset($theme_options['manualkb_single_headermenu_hamburger_searchbox']) && $theme_options['manualkb_single_headermenu_hamburger_searchbox'] == true ) {
								$activate_hemburger_menu = false;
							}
						}
					} else {
						if( isset($theme_options['knowledgebase_pagetitlebar_cat_header_menu']) && $theme_options['knowledgebase_pagetitlebar_cat_header_menu'] == true ) {
							if( isset($theme_options['manualkb_cat_headermenu_hamburger_searchbox']) && $theme_options['manualkb_cat_headermenu_hamburger_searchbox'] == true ) {
								$activate_hemburger_menu = false;
							}
						}
					}
				} else if ( class_exists('bbPress') && is_bbPress() && !is_front_page() ) {
					if( isset($theme_options['bbpress_header_menu']) && $theme_options['bbpress_header_menu'] == true ) {
						if( isset($theme_options['bbPress_headermenu_hamburger_searchbox']) && $theme_options['bbPress_headermenu_hamburger_searchbox'] == true ) {
							$activate_hemburger_menu = false;
						}
					}
				} else if($current_post_type == 'docs' && is_single() ) {
					if( isset($theme_options['wedocs_header_menu']) && $theme_options['wedocs_header_menu'] == true ) {
						if( isset($theme_options['docs_headermenu_hamburger_searchbox']) && $theme_options['docs_headermenu_hamburger_searchbox'] == true ) {
							$activate_hemburger_menu = false;
						}
					}
				} else if(class_exists( 'LearnPress' ) && ($current_post_type == 'lp_course') && is_single() ) {
					if( isset($theme_options['learnpress_header_menu']) && $theme_options['learnpress_header_menu'] == true ) {
						if( isset($theme_options['learnpress_headermenu_hamburger_searchbox']) && $theme_options['learnpress_headermenu_hamburger_searchbox'] == true ) {
							$activate_hemburger_menu = false;
						}
					}
				} else if(function_exists("is_woocommerce") && (is_product() || is_product_category() || is_product_tag() ) ){ 
					if( is_product_category() || is_product_tag() ) {
						if( isset($theme_options['woocommerce_pagetitlebar_header_menu']) && $theme_options['woocommerce_pagetitlebar_header_menu'] == true ) {
							if( isset($theme_options['woocat_headermenu_hamburger_searchbox']) && $theme_options['woocat_headermenu_hamburger_searchbox'] == true ) {
								$activate_hemburger_menu = false;
							}
						}
					} else {
						if( isset($theme_options['woocommerce_singlepg_pagetitlebar_header_menu']) && $theme_options['woocommerce_singlepg_pagetitlebar_header_menu'] == true ) {
							if( isset($theme_options['woosingle_headermenu_hamburger_searchbox']) && $theme_options['woosingle_headermenu_hamburger_searchbox'] == true ) {
								$activate_hemburger_menu = false;
							}
						}
					}
				} else if( $current_post_type == 'page' ) {
					$menu_modify_status = get_post_meta( $post->ID, '__manual_page_header_menu_status', true );
					$menu_hamburger_search_bar = get_post_meta( $post->ID, '__manual_page_header_hamburger_search_box', true );
					if( isset($menu_modify_status) && $menu_modify_status == true ) {
						if( isset($menu_hamburger_search_bar) && $menu_hamburger_search_bar == true ) {
							$activate_hemburger_menu = false;
						}
					}
				}
			}
			
			
			// Hamburger Menu ON/OFF
			if( $theme_options['activate-hamburger-menu'] == true ) { 
				echo '<div class="hamburger-menu">
					<span></span> <span></span> <span></span> <span></span>
				</div>';
				
				if( $activate_hemburger_menu == true ) {
					 echo '<div class="form-group menu-bar-form col-md-offset-3">';
						if( $theme_options['replace-search-design-with-modern-bar'] == true ) { 
							manual_nav_bar_search_normal();
						} else {
							manual__standard_search_form();
						}
					 echo '</div>';
				}
			}
	}
}

if (!function_exists('manual_nav_bar_search_normal')) {
	function manual_nav_bar_search_normal(){
		global $theme_options;
        echo '<input type="hidden" id="oldplacvalue" value="'.$theme_options['global-search-text-paceholder'].'">
        <form role="search" method="get" id="searchform_nav" class="searchform" action="'.esc_url( home_url( '/' ) ).'">
          <i class="fa fa-search livesearch"></i>
		  <div class="form-group">
            <input type="text"  placeholder="'.$theme_options['global-search-text-paceholder'].'" value="'.get_search_query().'" name="s" id="s" class="form-control header-search custom-simple-header-search" />
            <input type="hidden" value="" name="post_type" id="search_post_type">
          </div>
        </form>';
	}
}

?>