<?php 
/*-----------------------------------------------------------------------------------*/
/*	MANUAL :: HEADER LOGO
/*-----------------------------------------------------------------------------------*/
if (!function_exists('manual_global_header')) {
	function manual_global_header() {
		global $theme_options;
		
		if( isset($theme_options['theme-custom-site-url']) && $theme_options['theme-custom-site-url'] != '' ) { 
			$custom_site_url = $theme_options['theme-custom-site-url'];
		} else {
			$custom_site_url = home_url('/');
		}
		
		if(  isset($theme_options['theme-logo-alt-text']) && $theme_options['theme-logo-alt-text'] != ''  ) {
			$alt_text_logo = 'alt="'.esc_attr($theme_options['theme-logo-alt-text']).'"';
		} else {
			$alt_text_logo = '';
		}
		
		if( $theme_options['hide-header-logo-status'] == false ) { 
		
			echo '<a class="navbar-brand" href="'.esc_url( $custom_site_url ).'">';
			
			if( isset($theme_options['theme-header-logo']['url']) && $theme_options['theme-header-logo']['url'] != '' ) { 
				$logo_url = esc_url($theme_options['theme-header-logo']['url']); 
			} else { 
				$logo_url = get_template_directory_uri().'/img/logo-dark.png'; 
			}
			
			if( isset($theme_options['theme-nav-homepg-logo-when-img-bg']['url']) && $theme_options['theme-nav-homepg-logo-when-img-bg']['url'] != '' ) {
				$white_url = esc_url($theme_options['theme-nav-homepg-logo-when-img-bg']['url']);
			} else {
				$white_url = get_template_directory_uri().'/img/logo-home.png';  
			}
			
			echo '<img src="'.esc_url( $logo_url ).'" class="pull-left custom-nav-logo home-logo-show" '.$alt_text_logo.'>'; 
			echo '<img src="'.esc_url( $white_url ).'" class="pull-left custom-nav-logo inner-page-white-logo" '.$alt_text_logo.'>'; 
			
			echo '</a>';
			
       } 
		
	}
}

/*----------------------------*/
/*	MANUAL CUSTOMIZE :: LOGO
/*----------------------------*/
if (!function_exists('manual__logo_customize_settings')) {
	function manual__logo_customize_settings() {
		global $theme_options;
		
		// Normal Logo
		$logo_readjust = $logo_readjust_top_margin = $logo_readjust_responsive = $logo_readjust_top_margin_responsive = $logo_readjust_sticky = $logo_readjust_sticky_margin = '';
		if( isset($theme_options['theme-logo-readjust-height']['height']) && $theme_options['theme-logo-readjust-height']['height'] != '' && $theme_options['theme-logo-readjust-height']['height'] != 'px' ) {
			$logo_readjust = 'height:'.esc_attr($theme_options['theme-logo-readjust-height']['height']).'!important;';
		}
		if( isset($theme_options['theme-logo-readjust-margin-top']['height']) &&  $theme_options['theme-logo-readjust-margin-top']['height'] != '' &&  $theme_options['theme-logo-readjust-margin-top']['height'] != 'px' ) { 
			$logo_readjust_top_margin = 'margin-top:'.esc_attr($theme_options['theme-logo-readjust-margin-top']['height']).';';
		}
		// Responsive Logo
		if( isset($theme_options['theme-logo-readjust-height-responsive']['height']) && $theme_options['theme-logo-readjust-height-responsive']['height'] != '' && $theme_options['theme-logo-readjust-height-responsive']['height'] != 'px' ) { 
			$logo_readjust_responsive = 'height:'.esc_attr($theme_options['theme-logo-readjust-height-responsive']['height']).'!important;';
		}
		if( isset($theme_options['theme-logo-readjust-margin-top-responsive']['height']) && $theme_options['theme-logo-readjust-margin-top-responsive']['height'] != '' && $theme_options['theme-logo-readjust-margin-top-responsive']['height'] != 'px' ) { 
			$logo_readjust_top_margin_responsive = 'margin-top:'.esc_attr($theme_options['theme-logo-readjust-margin-top-responsive']['height']).';';
		}
		// Sticky Menu
		if ( is_admin_bar_showing() ) {
			echo 'body.home nav.navbar.after-scroll-wrap, body nav.navbar.after-scroll-wrap { margin-top: 32px!important; }';
		}
		echo 'body.home nav.navbar.after-scroll-wrap, body nav.navbar.after-scroll-wrap { box-shadow: none; }';
		
		if( isset($theme_options['theme-logo-readjust-sticky-height']['height']) && $theme_options['theme-logo-readjust-sticky-height']['height'] != '' && $theme_options['theme-logo-readjust-sticky-height']['height'] != 'px' ) { 
			$logo_readjust_sticky = 'height: '.esc_attr($theme_options['theme-logo-readjust-sticky-height']['height']).'!important;'; 
		}
		if( isset($theme_options['theme-logo-readjust-sticky-margin-top']['height']) && $theme_options['theme-logo-readjust-sticky-margin-top']['height'] != '' && $theme_options['theme-logo-readjust-sticky-margin-top']['height'] != 'px' ) { 
			$logo_readjust_sticky_margin = 'margin-top: '.esc_attr($theme_options['theme-logo-readjust-sticky-margin-top']['height']).';'; 
		}
		if( isset($theme_options['theme-logo-readjust-sticky-hamburger-menu-top-margin']) && $theme_options['theme-logo-readjust-sticky-hamburger-menu-top-margin'] != '' ) { 
			$readjust_sticky_hamburger_menu_top_margin = 'margin-top: '.esc_attr($theme_options['theme-logo-readjust-sticky-hamburger-menu-top-margin']).'px;'; 
		}
		
		echo '.custom-nav-logo { '.$logo_readjust.' '.$logo_readjust_top_margin.'  } @media (max-width: 767px) { .custom-nav-logo {  '.$logo_readjust_responsive.'  '.$logo_readjust_top_margin_responsive.' }  } ';
		// Sticky menu login user design fix
		if( is_user_logged_in() == true ) { echo 'body.home nav.navbar.after-scroll-wrap, nav.navbar.after-scroll-wrap { margin-top: 32px; }'; }
		echo 'nav.navbar.after-scroll-wrap .custom-nav-logo { '.$logo_readjust_sticky.' '.$logo_readjust_sticky_margin.' } nav.navbar.after-scroll-wrap .hamburger-menu span { '.$readjust_sticky_hamburger_menu_top_margin.' }';
		
	}
}
?>