<?php 
/*-----------------------------------------------------------------------------------*/
/*	MANUAL :: ARTICLE LOCK STATUS CHECK
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'manual__default_login_form' ) ) {
	function manual__default_login_form($custom_login_message, $formcenter = '', $ajaxcall_login = '', $echotype = ''){
		global $theme_options;
		
		if( $formcenter == 1 ) { 
			$center_css = 'col-md-10 col-sm-12 col-xs-12 col-md-offset-1';
		} else { 
			$center_css = ''; 
		}
		
		if( isset($theme_options['login_box_lostpwd_linkurl']) && $theme_options['login_box_lostpwd_linkurl'] != '' ) {
			$forget_password_link_url = $theme_options['login_box_lostpwd_linkurl'];
		} else {
			$forget_password_link_url = wp_lostpassword_url();
		}
		
		if( isset($theme_options['login_box_register_linkurl']) && $theme_options['login_box_register_linkurl'] != '' ) {
			$register_link_url = $theme_options['login_box_register_linkurl'];
		} else {
			$register_link_url =  wp_registration_url();
		}
		
		if( isset($theme_options['login_box_custom_loginlink']) && $theme_options['login_box_custom_loginlink'] != '' ) {
			$doc_custom_login_link_url = $theme_options['login_box_custom_loginlink'];
		} else {
			$doc_custom_login_link_url =  site_url( 'wp-login.php', 'login_post' );
		}
		
		$return = '<div class="'.$center_css.'"><div class="manual_login_page"><div class="custom_login_form">';
		if( $custom_login_message != '' ) {
			$return .= '<h4>'.esc_html($custom_login_message).'</h4>';
		}
		if( $ajaxcall_login == '' ) {
			$args = array(
				'echo' => false,
				'label_username' => ((isset($theme_options['login_box_label_username']) && $theme_options['login_box_label_username'] != '' )?esc_html__($theme_options['login_box_label_username']):''),
				'label_password' => ((isset($theme_options['login_box_label_password']) && $theme_options['login_box_label_password'] != '' )?esc_html__($theme_options['login_box_label_password']):''),
				'label_remember' => ((isset($theme_options['login_box_label_remember']) && $theme_options['login_box_label_remember'] != '' )?esc_html__($theme_options['login_box_label_remember']):''),
				'label_log_in'   => ((isset($theme_options['login_box_label_log_in']) && $theme_options['login_box_label_log_in'] != '' )?esc_html__($theme_options['login_box_label_log_in']):''),
			);
			$return .= wp_login_form($args); 
		} else {
			$return .= ' <form action="' . esc_url( $doc_custom_login_link_url ) . '" method="post"><input type="submit" class="button-primary" value="'.((isset($theme_options['login_box_label_log_in']) && $theme_options['login_box_label_log_in'] != '' )?esc_html__($theme_options['login_box_label_log_in']):'').'"></form>';
		}
		
		$return .= '<ul class="custom_register">';
			$return .= '<li><a href=" '.esc_url($forget_password_link_url).'" class="more-link hvr-icon-wobble-horizontal margin-15">';
			$return .=  ((isset($theme_options['login_box_lostpwd_text']) && $theme_options['login_box_lostpwd_text'] != '' )?esc_html__($theme_options['login_box_lostpwd_text']):'');
			$return .= ' &nbsp;&nbsp;<i class="fa fa-arrow-right hvr-icon"></i> </a></li>';
			
			$registration_enabled = get_option( 'users_can_register' );
			if ( $registration_enabled ) {
				$return .= '<li>' . ((isset($theme_options['login_box_register_text_before']) && $theme_options['login_box_register_text_before'] != '' )?esc_html__($theme_options['login_box_register_text_before']):'') . ' <a href="'.esc_url($register_link_url).'" class="more-link">' . ((isset($theme_options['login_box_register_text']) && $theme_options['login_box_register_text'] != '' )?esc_html__($theme_options['login_box_register_text']):'') . '</a></li>';
			}
			$return .= '</ul>';
		$return .= '</div></div></div>';
		
		if( $echotype == 1 ) {
			return $return;
		} else {
			echo $return;
		}
		
	}
}

/*-----------------------------------------------------------------------------------*/
/*	MANUAL :: ARTICLE NO SUFFIENCT ACCESS
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'manual__no_sufficentaccess' ) ) {
	function manual__no_sufficentaccess($message, $echotype){
		$return = '<div class="doc_access_control"><p>';
		$return .= esc_html($message);
		$return .= '</p></div>';
		
		if( isset($echotype) && $echotype == 1 ) {
			return $return;
		} else {
			echo $return;
		}
	}
}
?>