<?php 
/*--------------------------------------------------------------*/
/*	Header below menu bar and above content box control
    * Use below function to control header design
	* Below function include header layout and CSS control
/*--------------------------------------------------------------*/

/*--------------------------------------------------------------*/
/*	MANUAL :: PAGE TEMPLATE "TEMPLATE-HOME.PHP" 
              HEADER CONTROL
/*--------------------------------------------------------------*/
if (!function_exists('manual_header_display_control_check')) {
	function manual_header_display_control_check() {
		global $theme_options;
		$check_home_current_page = basename( get_page_template() );
		manual_header_display_control_break();
	}
}

/*---------------------------------------------*/
/*	MANUAL :: HEADER DISPLAY CONTROL
			  BASED ON "MANUAL THEME OPTIONS"
/*---------------------------------------------*/
if (!function_exists('manual_header_display_control_break')) {
	function manual_header_display_control_break() {
		global $theme_options,$post;
		
		$current_post_type = get_post_type();
		
		if( function_exists("BuddyPress") && (bp_is_members_directory() || bp_is_activity_directory() || bp_is_groups_directory() || bp_is_register_page() || bp_is_activation_page() || bp_is_active() || bp_is_user() ) ) {
			$blank_ = '';
		} else if( is_404() ) {
			if( $theme_options['onoff-404-page-hrader'] == true ){	
				if( $theme_options['home-404-search-bar-status'] == true ) $searchbar = false;
				else  $searchbar = true;
				manual_header_design_control( '', '', false, $searchbar, '', false, '', false, false);
			}
		} else if( is_search() ) {
			if( $theme_options['onoff-search-page-title-bar'] == true  ) {
				if( $theme_options['search-page-header-search-bar-status'] == true ) $searchbar = true;
				else  $searchbar = false;
				
				if( $theme_options['search-page-header-title'] != '' ) $pagetitle = $theme_options['search-page-header-title'];
				else $pagetitle = '';
				
				if( $theme_options['search-page-header-sub-title'] != '' ) $subtitle = $theme_options['search-page-header-sub-title'];
				else $subtitle = '';
				
				manual_header_design_control( '', '', false, $searchbar, $pagetitle, false, $subtitle, false, false);
			}
		} else if( $current_post_type == 'manual_portfolio' ) {  
			manual_header_display_control_break_page($post->ID);
		} else if($current_post_type == 'manual_faq') {
			if( $theme_options['onoff-faq-catag-single-page-title-bar'] == true  ) {
				if( $theme_options['faq-cat-header-search-status'] == false )  $searchbar = true;
				else  $searchbar = false;
				if( $theme_options['faq-cat-header-breadcrumb-status'] == false )  $breadcrumb = true;
				else  $breadcrumb = false;
				manual_header_design_control($current_post_type, '', false, $searchbar, '', true, '', false, $breadcrumb);
			}
		} else if($current_post_type == 'docs' && is_single()) {
			if( $theme_options['onoff-wedocs-single-page-title-bar'] == true  ) {
				if( $theme_options['wedocs-single-pg-header-search-status'] == false )  $searchbar = true;
				else  $searchbar = false;
				if( $theme_options['wedocs-single-pg-header-breadcrumb-status'] == false )  $breadcrumb = true;
				else  $breadcrumb = false;
				if( $theme_options['wedocs-single-pg-title-text-status'] == true )  $title_text = true;
				else  $title_text = false;
				manual_header_design_control($current_post_type, '', false, $searchbar, '', true, '', false, $breadcrumb, $title_text);
			}
		} else if($current_post_type == 'lp_course' && is_single()) {
			if( $theme_options['onoff-learnpress-single-page-title-bar'] == true  ) {
				if( $theme_options['learnpress-single-pg-header-search-status'] == true )  $searchbar = true;
				else  $searchbar = false;
				if( $theme_options['learnpress-single-pg-header-breadcrumb-status'] == true )  $breadcrumb = true;
				else  $breadcrumb = false;
				if( $theme_options['learnpress-single-pg-title-text-status'] == false )  $title_text = true;
				else  $title_text = false;
				manual_header_design_control($current_post_type, '', false, $searchbar, '', true, '', false, $breadcrumb, $title_text);
			}
		} else if($current_post_type == 'manual_kb') {  
			if( is_single() ) {
				if( $theme_options['onoff-knowledgebase-single-page-title-bar'] == true  ) {
					if( $theme_options['kb-single-pg-header-search-status'] == false )  $searchbar = true;
					else  $searchbar = false;
					if( $theme_options['kb-single-pg-header-breadcrumb-status'] == false )  $breadcrumb = true;
					else  $breadcrumb = false;
					if( $theme_options['kb-single-pg-title-text-status'] == true )  $title_text = true;
					else  $title_text = false;
					manual_header_design_control($current_post_type, '', false, $searchbar, '', true, '', false, $breadcrumb, $title_text);
				}
			} else {
				if( $theme_options['onoff-knowledgebase-catag-page-title-bar'] == true  ) {
					if( $theme_options['kb-cat-header-search-status'] == false ) { $searchbar = true;
					} else { $searchbar = false; }
					if( $theme_options['kb-cat-header-breadcrumb-status'] == false ) { $breadcrumb = true;
					} else { $breadcrumb = false; }
					manual_header_design_control($current_post_type, '', false, $searchbar, '', true, '', false, $breadcrumb);
				}
			}
	   } else if($current_post_type == 'manual_documentation') {
			if( $theme_options['onoff-documentation-catag-single-page-title-bar'] == true  ) {
				if( $theme_options['documentation-disable-search-category-page'] == false ) { $searchbar = true; } else { $searchbar = false; }
				if( $theme_options['documentation-disable-breadcrumb-category-page'] == false ) { $breadcrumb = true; } else { $breadcrumb = false; }
				if( $theme_options['doc-cat-single-pg-title-text-status'] == true ) {  $title_text = true; } else {  $title_text = false; }
				manual_header_design_control($current_post_type, '', false, $searchbar, '', true, '', false, $breadcrumb, $title_text);
			}
	  } else if(function_exists("is_woocommerce") && (is_shop() || is_checkout() || is_account_page())){ // woo
			if(is_shop()){
				$page_id = get_option('woocommerce_shop_page_id');
			} elseif(is_checkout()) {
				$page_id = get_option('woocommerce_pay_page_id'); 
			} elseif(is_account_page()) {
				$page_id = get_option('woocommerce_myaccount_page_id'); 
			} elseif(is_account_page()) {
				$page_id = get_option('woocommerce_edit_address_page_id'); 
			} elseif(is_account_page()) {
				$page_id = get_option('woocommerce_view_order_page_id'); 
			}
			$woopage  = get_post( $page_id );
			if( isset($woopage->ID) && $woopage->ID != '' ) {
				manual_header_display_control_break_page($woopage->ID);
			}
			
		} else if(function_exists("is_woocommerce") && is_product() ){
			if( $theme_options['onoff-woocommerce-singlepg-title-bar'] == true  ) {		
				manual_header_design_control('', '', false, false, '', true, '', false, true, true);
			}	
		} else if(function_exists("is_woocommerce") && (is_product_category() || is_product_tag() ) ){
			if( $theme_options['onoff-woocommerce-catag-page-title-bar'] == true  ) {	
				if( $theme_options['woocommerce-disable-search-category-page'] == false ) { $searchbar = true; } else { $searchbar = false; }
				if( $theme_options['woocommerce-disable-breadcrumb-cat-tag-page'] == false ) { $breadcrumb = true; } else { $breadcrumb = false; }
				manual_header_design_control('', '', false, $searchbar, '', true, '', false, $breadcrumb, false);
			}	
		} else if ( class_exists('bbPress') && is_bbPress() && !is_front_page() ) {  // bbpress
			if( $theme_options['onoff-bbpress-page-title-bar'] == true  ) {
				manual_header_design_control('','',false);
			}
		} else if( is_home() && $current_post_type == 'post' ) { // post home page
			$postID = get_option('page_for_posts');
			if( $postID != '' && $postID != 0 ) {
				manual_header_display_control_break_page($postID);
			}
		} else if( $current_post_type == 'page' ) {   // page
			manual_header_display_control_break_page($post->ID);
		} else if( $current_post_type == 'post' && $theme_options['blog_single_page_global_header_settings'] == true && !is_single() ) { // post !single page
			$postID = get_option('page_for_posts');
			manual_header_display_control_break_page($postID);
		} else if( $current_post_type == 'post' && is_single() ) { // post single page
			if( isset($theme_options['blog_single_pagetitlebar_controls']) && $theme_options['blog_single_pagetitlebar_controls'] == true ) {
				if( $theme_options['blog_single_post_display_search'] == true ) $searchbar = true;
				else $searchbar = false; 
				manual_header_design_control($current_post_type, '', '', $searchbar);
			}
		} else if( class_exists( 'LearnPress' ) && manual__check_is_course() && is_archive()) {
			$learnpress_course_id = get_option('learn_press_courses_page_id');
			if( isset($learnpress_course_id) && $learnpress_course_id != '' ) { 
				manual_header_display_control_break_page($learnpress_course_id);
			}
		} else {
			$url = '';
			$parallax_effect = $searchbox = false;
			if( isset($theme_options['target-search-bar-display-on-the-header']) && $theme_options['target-search-bar-display-on-the-header'] != '') {
				foreach ( $theme_options['target-search-bar-display-on-the-header']  as $post_type ) {
						$activate_post_type[] = $post_type;
				}
				if( !empty( $activate_post_type ) && in_array($current_post_type, $activate_post_type) ) {
					if( $theme_options['activate-search-bar-on-the-header'] == true ) $searchbox = true;
				}
			}
			manual_header_design_control('', $url, $parallax_effect, $searchbox);	
		}
	}
}

/*-------------------------------------*/
/*	MANUAL :: "WP POST TYPE == PAGE" 
               HEADER DESIGN CONTROL
/*--------------------------------------*/
if (!function_exists('manual_header_display_control_break_page')) {
	function manual_header_display_control_break_page($postID) {
		global $theme_options,$post;
		$url = '';
		$searchbox = $parallax_effect = false;
		$revslider = get_post_meta($postID, "_manual_slider_rev_shortcode", true);
		if (!empty($revslider)){ 
			echo '<div class="q_slider"><div class="q_slider_inner">'.do_shortcode($revslider).'</div></div>';
		} else {
			
			$titlebar_display_status = get_post_meta( $postID, '__manual_page_title_bar', true );
			$titlebar_title_status = get_post_meta( $postID, '_manual_header_no_title', true );
			
			
			if( $titlebar_display_status == '' || $titlebar_display_status == 1 ) { 
				$pagetitle = get_post_meta( $postID, '_manual_page_tagline', true );
				if( get_post_meta( $postID, '__manual_page_title_bar_search_status', true ) == true ) { $searchbox = true; }
				
				if( get_post_meta( $postID, '_manual_header_plx_effect', true ) == true ) { 
					$page_title_bar_background = get_post_meta( $postID, '__manual__pagetitlebar_background', true );
					if( isset($page_title_bar_background['background-image']) && $page_title_bar_background['background-image'] != '' ) {
						$url = $page_title_bar_background['background-image'];
						$parallax_effect = true;
					}
				}
				
				if( $titlebar_title_status == '' || $titlebar_title_status == 1 ) $replace_title_act = true;
				else $replace_title_act =  false;
				
				
				if( get_post_meta( $postID, '_manual_page_desc', true ) != '' ) { 
					$subtitle = get_post_meta( $postID, '_manual_page_desc', true );
					$subtitle_act = true;
				} else {
					$subtitle = '';
					$subtitle_act = false;
				}
				
				if( get_post_meta( $postID, '_manual_header_breadcrumb_status', true ) == true ) $breadcrumb = true;
				else $breadcrumb = false;
					
				manual_header_design_control( get_post_type(), $url, $parallax_effect, $searchbox, $pagetitle, $replace_title_act, $subtitle, $subtitle_act, $breadcrumb, '', $postID);
			}
		}
	}
}
?>