<?php 
/*-----------------------------------------------------------------*/
/*	TYPOGRAPHY (body, h1, h2, h3, h4, h5, h6)  */
/*******************************************************************/
/*  CONTROLS :: MANUAL OPTIONS > TYPOGRAPHY                        */
/*-----------------------------------------------------------------*/

if (!function_exists('manual__typography_customize_settings')) {
	function manual__typography_customize_settings() {
		global $theme_options;
		
		// Body
		if( $theme_options['theme-typography-body']['font-family'] != '' ) {
			
			if( $theme_options['theme-typography-body']['font-family'] == 'Open Sans' && 
			    $theme_options['theme-typography-body']['line-height'] == '1.4px' ) {
				$body_lineheight = '1.7px';
			} else {
				$body_lineheight = $theme_options['theme-typography-body']['line-height'];
			}
			
			$body_font_bkup = $word_spacing = '';
			if ( !empty( $theme_options['theme-typography-body']['font-family'] ) && !empty( $theme_options['theme-typography-body']['font-backup'] ) ) { 
				$body_font_bkup = ','.$theme_options['theme-typography-body']['font-backup'];   
			}
			
			if( isset($theme_options['theme-typography-body']['word-spacing']) && $theme_options['theme-typography-body']['word-spacing'] != '' ) {
				$word_spacing = 'word-spacing:'.esc_attr($theme_options['theme-typography-body']['word-spacing']);
			}
			
		echo 'table.wc-block-cart-items .wc-block-components-product-metadata__description p, #learn-press-course-curriculum.course-curriculum ul.curriculum-sections .section-content .course-item .item-icon, .lp-pmpro-membership-list h2.lp-title, .lp-single-course .course-quick-info ul li span.label, body { color: '.esc_attr($theme_options['theme-typography-body']['color']).'; font-family:"'.esc_attr(((isset($theme_options['custom-body-font']) && $theme_options['custom-body-font'] != '' )?$theme_options['custom-body-font']:$theme_options['theme-typography-body']['font-family'])).'"'.$body_font_bkup.'!important;font-size: '.esc_attr($theme_options['theme-typography-body']['font-size']). ($theme_options['theme-typography-body']['font-size'] == '15'?'px':'') .';line-height: '. preg_replace( '/px/', '', esc_attr($body_lineheight) ).';letter-spacing: '.esc_attr($theme_options['theme-typography-body']['letter-spacing']).($theme_options['theme-typography-body']['letter-spacing']=='0.3'?'px':'').'; font-weight: '.esc_attr((isset($theme_options['theme-typography-body']['font-weight']) && $theme_options['theme-typography-body']['font-weight'] != "")?$theme_options['theme-typography-body']['font-weight']:'400').';'.$word_spacing.' }';
		}
		
		// H1
		if( $theme_options['theme-h1-typography']['font-family'] != '' ) { 
			if( isset($theme_options['theme-h1-typography']['font-weight']) && 
				$theme_options['theme-h1-typography']['font-weight'] != ''  ) {
				$h1_weight = esc_attr($theme_options['theme-h1-typography']['font-weight']);	
			} else {
				$h1_weight = esc_attr($theme_options['theme-h1-typography']['font-style']);
			}
			
			$h1_font_bkup = $word_spacing = '';
			if ( !empty( $theme_options['theme-h1-typography']['font-family'] ) && !empty( $theme_options['theme-h1-typography']['font-backup'] ) ) { 
				$h1_font_bkup = ','.$theme_options['theme-h1-typography']['font-backup'];   
			}
			
			if( isset($theme_options['theme-h1-typography']['word-spacing']) && $theme_options['theme-h1-typography']['word-spacing'] != '' ) {
				$word_spacing = 'word-spacing:'.esc_attr($theme_options['theme-h1-typography']['word-spacing']);
			}
			
			echo '.counter-number, body.course-item-popup #learn-press-content-item .course-item-title, h1 {  font-family: "'.esc_attr(((isset($theme_options['custom-h1-font']) && $theme_options['custom-h1-font'] != "")?$theme_options['custom-h1-font']:$theme_options['theme-h1-typography']['font-family'])).'"'.$h1_font_bkup.'; font-weight:'.esc_attr($h1_weight).'; font-size:'.esc_attr($theme_options['theme-h1-typography']['font-size']).( ($theme_options['theme-h1-typography']['font-size'] == '40')?'px':'' ).'; line-height: '.esc_attr($theme_options['theme-h1-typography']['line-height']).( ($theme_options['theme-h1-typography']['line-height'] == '20' || $theme_options['theme-h1-typography']['line-height'] == '45')?'px':'' ).'; text-transform:'.esc_attr($theme_options['theme-h1-typography']['text-transform']).'; letter-spacing: '.esc_attr($theme_options['theme-h1-typography']['letter-spacing']).( ($theme_options['theme-h1-typography']['letter-spacing'] == '-0.7')?'px':'' ).'; color: '.esc_attr($theme_options['theme-h1-typography']['color']).'; '.$word_spacing.' }';				
		}
		
		// H2
		if( $theme_options['theme-h2-typography']['font-family'] != '' ) {
			if( isset($theme_options['theme-h2-typography']['font-weight']) && 
				$theme_options['theme-h2-typography']['font-weight'] != ''  ) {
				$h2_weight = esc_attr($theme_options['theme-h2-typography']['font-weight']);	
			} else {
				$h2_weight = esc_attr($theme_options['theme-h2-typography']['font-style']);
			}
			
			$h2_font_bkup = $word_spacing = '';
			if ( !empty( $theme_options['theme-h2-typography']['font-family'] ) && !empty( $theme_options['theme-h2-typography']['font-backup'] ) ) { 
				$h2_font_bkup = ','.$theme_options['theme-h2-typography']['font-backup'];   
			}
			
			if( isset($theme_options['theme-h2-typography']['word-spacing']) && $theme_options['theme-h2-typography']['word-spacing'] != '' ) {
				$word_spacing = 'word-spacing:'.esc_attr($theme_options['theme-h2-typography']['word-spacing']);
			}
			
			echo '.lp-pmpro-membership-list .lp-price, h2 {  font-family: "'.esc_attr(((isset($theme_options['custom-h2-font']) && $theme_options['custom-h2-font'] != '')?$theme_options['custom-h2-font']:$theme_options['theme-h2-typography']['font-family'])).'"'.$h2_font_bkup.'; font-weight:'.esc_attr($h2_weight).'; font-size:'.esc_attr($theme_options['theme-h2-typography']['font-size']).( ($theme_options['theme-h2-typography']['font-size'] == '34')?'px':'' ).'; line-height: '.esc_attr($theme_options['theme-h2-typography']['line-height']).(($theme_options['theme-h2-typography']['line-height'] == '30' || $theme_options['theme-h2-typography']['line-height'] == '40')?'px':'' ).'; text-transform:'.esc_attr($theme_options['theme-h2-typography']['text-transform']).'; letter-spacing: '.esc_attr($theme_options['theme-h2-typography']['letter-spacing']).( ($theme_options['theme-h2-typography']['letter-spacing'] == '-0.4')?'px':'' ).'; color: '.esc_attr($theme_options['theme-h2-typography']['color']).'; '.$word_spacing.' }';	
			echo '.service_table_holder .price{ font-family: "'.esc_attr(((isset($theme_options['custom-h2-font']) && $theme_options['custom-h2-font'] != '')?$theme_options['custom-h2-font']:$theme_options['theme-h2-typography']['font-family'])).'"'.$h2_font_bkup.'; }';			
		}
		
		// H3
		if( $theme_options['theme-h3-typography']['font-family'] != '' ) {
			if( isset($theme_options['theme-h3-typography']['font-weight']) && 
				$theme_options['theme-h3-typography']['font-weight'] != ''  ) {
				$h3_weight = esc_attr($theme_options['theme-h3-typography']['font-weight']);	
			} else {
				$h3_weight = esc_attr($theme_options['theme-h3-typography']['font-style']);
			}
			
			$h3_font_bkup = $word_spacing = '';
			if ( !empty( $theme_options['theme-h3-typography']['font-family'] ) && !empty( $theme_options['theme-h3-typography']['font-backup'] ) ) { 
				$h3_font_bkup = ','.$theme_options['theme-h3-typography']['font-backup'];   
			}
			
			if( isset($theme_options['theme-h3-typography']['word-spacing']) && $theme_options['theme-h3-typography']['word-spacing'] != '' ) {
				$word_spacing = 'word-spacing:'.esc_attr($theme_options['theme-h3-typography']['word-spacing']);
			}
			
			echo 'h3 {  font-family: "'.esc_attr(((isset($theme_options['custom-h3-font']) && $theme_options['custom-h3-font'] != '')?$theme_options['custom-h3-font']:$theme_options['theme-h3-typography']['font-family'])).'"'.$h3_font_bkup.'; font-weight:'.esc_attr($h3_weight).'; font-size:'.esc_attr($theme_options['theme-h3-typography']['font-size']).( ($theme_options['theme-h3-typography']['font-size'] == '30')?'px':'' ).'; line-height: '.esc_attr($theme_options['theme-h3-typography']['line-height']).(($theme_options['theme-h3-typography']['line-height'] == '20' || $theme_options['theme-h3-typography']['line-height'] == '34')?'px':'' ).'; text-transform:'.esc_attr($theme_options['theme-h3-typography']['text-transform']).'; letter-spacing: '.esc_attr($theme_options['theme-h3-typography']['letter-spacing']).( ($theme_options['theme-h3-typography']['letter-spacing'] == '0')?'px':'' ).'; color: '.esc_attr($theme_options['theme-h3-typography']['color']).'; '.$word_spacing.' }';
		}
		
		// H4
		if( $theme_options['theme-h4-typography']['font-family'] != '' ) {
			if( isset($theme_options['theme-h4-typography']['font-weight']) && 
				$theme_options['theme-h4-typography']['font-weight'] != ''  ) {
				$h4_weight = esc_attr($theme_options['theme-h4-typography']['font-weight']);	
			} else {
				$h4_weight = esc_attr($theme_options['theme-h4-typography']['font-style']);
			}
			
			$h4_font_bkup = $word_spacing = '';
			if ( !empty( $theme_options['theme-h4-typography']['font-family'] ) && !empty( $theme_options['theme-h4-typography']['font-backup'] ) ) { 
				$h4_font_bkup = ','.$theme_options['theme-h4-typography']['font-backup'];   
			}
			
			if( isset($theme_options['theme-h4-typography']['word-spacing']) && $theme_options['theme-h4-typography']['word-spacing'] != '' ) {
				$word_spacing = 'word-spacing:'.esc_attr($theme_options['theme-h4-typography']['word-spacing']);
			}
			
			echo '.review-form h4, .review-form h3, .course-rating h3, .single-lp_course .lp-single-course .course-author .author-name, #lp-single-course .related_course .related-title, .manual-course-wrapper .course-box .course-info .course-price.h4, h4 {  font-family: "'.esc_attr(((isset($theme_options['custom-h4-font']) && $theme_options['custom-h4-font'] != '')?$theme_options['custom-h4-font']:$theme_options['theme-h4-typography']['font-family'])).'"'.$h4_font_bkup.'; font-weight:'.esc_attr($h4_weight).'; font-size:'.esc_attr($theme_options['theme-h4-typography']['font-size']).( ($theme_options['theme-h4-typography']['font-size'] == '24')?'px':'' ).'; line-height: '.esc_attr($theme_options['theme-h4-typography']['line-height']).(($theme_options['theme-h4-typography']['line-height'] == '20' || $theme_options['theme-h4-typography']['line-height'] == '30')?'px':'' ).'; text-transform:'.esc_attr($theme_options['theme-h4-typography']['text-transform']).'; letter-spacing: '.esc_attr($theme_options['theme-h4-typography']['letter-spacing']).( ($theme_options['theme-h4-typography']['letter-spacing'] == '0')?'px':'' ).'; color: '.esc_attr($theme_options['theme-h4-typography']['color']).'; '.$word_spacing.' }';
		}
		
		// H5
		if( $theme_options['theme-h5-typography']['font-family'] != '' ) {
			if( isset($theme_options['theme-h5-typography']['font-weight']) && 
				$theme_options['theme-h5-typography']['font-weight'] != ''  ) {
				$h5_weight = esc_attr($theme_options['theme-h5-typography']['font-weight']);	
			} else {
				$h5_weight = esc_attr($theme_options['theme-h5-typography']['font-style']);
			}
			
			$h5_font_bkup = $word_spacing = '';
			if ( !empty( $theme_options['theme-h5-typography']['font-family'] ) && !empty( $theme_options['theme-h5-typography']['font-backup'] ) ) { 
				$h5_font_bkup = ','.$theme_options['theme-h5-typography']['font-backup'];   
			}
			
			if( isset($theme_options['theme-h5-typography']['word-spacing']) && $theme_options['theme-h5-typography']['word-spacing'] != '' ) {
				$word_spacing = 'word-spacing:'.esc_attr($theme_options['theme-h5-typography']['word-spacing']);
			}
			
			echo '.lp-user-profile #profile-content-wishlist .learn-press-wishlist-courses li .course-title h3, .lp-single-instructor span.course-title, .lp-single-instructor span.instructor-display-name, .lp-list-instructors .ul-list-instructors li.item-instructor .instructor-display-name, .learn-press-courses[data-layout=grid] .course-content .course-title, #popup-sidebar .section-header .section-title, .wp-block-woocommerce-cart .wp-block-woocommerce-cart-cross-sells-block .cross-sells-product div .wc-block-components-product-name, table.wc-block-cart-items .wc-block-components-product-name, ul.learn-press-wishlist-courses h3, .lp-profile-content .course-box .course-info h3.course-title, #course-item-content-header .course-title, .course-curriculum ul.curriculum-sections .section-header .section-title, .manual-course-wrapper .course-box .course-info .course-price, .manual-course-wrapper .course-box .course-info .course-price.h5, .sidebar-widget h1, .sidebar-widget h2, .sidebar-widget h3, h5 {  font-family: "'.esc_attr(((isset($theme_options['custom-h5-font']) && $theme_options['custom-h5-font'] != '')?$theme_options['custom-h5-font']:$theme_options['theme-h5-typography']['font-family'])).'"'.$h5_font_bkup.'; font-weight:'.esc_attr($h5_weight).'; font-size:'.esc_attr($theme_options['theme-h5-typography']['font-size']).( ($theme_options['theme-h5-typography']['font-size'] == '19')?'px':'' ).'; line-height: '.esc_attr($theme_options['theme-h5-typography']['line-height']).(($theme_options['theme-h5-typography']['line-height'] == '23')?'px':'' ).'; text-transform:'.esc_attr($theme_options['theme-h5-typography']['text-transform']).'; letter-spacing: '.esc_attr($theme_options['theme-h5-typography']['letter-spacing']).( ($theme_options['theme-h5-typography']['letter-spacing'] == '0')?'px':'' ).'; color: '.esc_attr($theme_options['theme-h5-typography']['color']).'; '.$word_spacing.' }';
		}
		
		// H6
		if( $theme_options['theme-h6-typography']['font-family'] != '' ) {
			if( isset($theme_options['theme-h6-typography']['font-weight']) && 
				$theme_options['theme-h6-typography']['font-weight'] != ''  ) {
				$h6_weight = esc_attr($theme_options['theme-h6-typography']['font-weight']);	
			} else {
				$h6_weight = esc_attr($theme_options['theme-h6-typography']['font-style']);
			}
			
			$h6_font_bkup = $word_spacing = '';
			if ( !empty( $theme_options['theme-h6-typography']['font-family'] ) && !empty( $theme_options['theme-h6-typography']['font-backup'] ) ) { 
				$h6_font_bkup = ','.$theme_options['theme-h6-typography']['font-backup'];   
			}
			
			if( isset($theme_options['theme-h6-typography']['word-spacing']) && $theme_options['theme-h6-typography']['word-spacing'] != '' ) {
				$word_spacing = 'word-spacing:'.esc_attr($theme_options['theme-h6-typography']['word-spacing']);
			}
			
			echo '.learn-press-tabs .learn-press-tabs__tab>label a, .statistic-box .statistic-box__text, .lp-single-instructor .ul-instructor-courses .price-categories .course-item-price .price, .lp-single-instructor .ul-instructor-courses .price-categories .course-item-price .free, .lp-archive-courses .course-content .course-info .course-price .free, .lp-archive-courses .course-content .course-info .course-price .price, .archive-course-widget-outer .course-title, ul.learn-press-courses .course-box .course-info .course-price.h6, .manual-course-wrapper .course-box .course-info .course-price.h6, h6 {  font-family: "'.esc_attr(((isset($theme_options['custom-h6-font']) && $theme_options['custom-h6-font'] != '')?$theme_options['custom-h6-font']:$theme_options['theme-h6-typography']['font-family'])).'"'.$h6_font_bkup.'; font-weight:'.esc_attr($h6_weight).'; font-size:'.esc_attr($theme_options['theme-h6-typography']['font-size']).( ($theme_options['theme-h6-typography']['font-size'] == '16')?'px':'' ).'; line-height: '.esc_attr($theme_options['theme-h6-typography']['line-height']).(($theme_options['theme-h6-typography']['line-height'] == '20')?'px':'' ).'; text-transform:'.esc_attr($theme_options['theme-h6-typography']['text-transform']).'; letter-spacing: '.esc_attr($theme_options['theme-h6-typography']['letter-spacing']).( ($theme_options['theme-h6-typography']['letter-spacing'] == '0')?'px':'' ).'; color: '.esc_attr($theme_options['theme-h6-typography']['color']).'; '.$word_spacing.' }';
		}
		
	}
}
?>