<?php
defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'Redux_Metaboxes' ) ) {
	return;
}
$opt_name = 'redux_demo';
Redux_Metaboxes::set_box(
	$opt_name,
	array(
		'id'         => 'page-meta-configuration',
		'title'      => esc_html__( 'Meta Options', 'manual' ),
		'post_types' => array( 'page', 'manual_portfolio' ),
		'position'   => 'normal', // normal, advanced, side.
		'priority'   => 'high', // high, core, default, low.
		'sections'   => array(
			
			// header menu
			array(
				'title'  => esc_html__( 'Header Menu', 'manual' ),
				'id'     => '__manual_page_meta_header_bar',
				'icon'   => '',
				'fields' => array(
				
					array(
						'id'       => '__manual_page_header_menu_style',
						'type'     => 'image_select',
						'title'    => esc_html__( 'Menu style', 'manual' ),
						'subtitle' => esc_html__( 'Choose a header navigation style: either transparent, white, or the theme default.', 'manual' ),
						'options'  => array(
							'1' => array( 'img' => trailingslashit(get_template_directory_uri()) .'framework/ReduxCore/manual/1.jpg' ),
							'2' => array( 'img' => trailingslashit(get_template_directory_uri()) .'framework/ReduxCore/manual/2.jpg' ),
							'3' => array( 'img' => trailingslashit(get_template_directory_uri()) .'framework/ReduxCore/manual/3.jpg' ),
						),
						'default'  => '3',
					),
					// Customization header menu
					array(
						'id'       => '__manual_page_header_menu_status',
						'type'     => 'switch',
						'title'    => esc_html__( 'Customize the header menu', 'manual' ),
						'subtitle' => esc_html__('Modify the main header, including the logo and menu colors, if needed.', 'manual'),
						'default'  => false,
						'on' => esc_html__( 'Customize', 'manual' ),
						'off' => esc_html__( 'Theme Default', 'manual' ),
					),
					array(
						'id'       => '__manual_page_header_background_colorbg',
						'type'     => 'color_rgba',
						'title'    => esc_html__( 'Background color', 'manual' ),
						'subtitle'    => esc_html__( 'Set the header background.', 'manual' ),
						'desc'    => __( '<span style="color: #D01B0B">If you\'ve chosen a <strong>transparent menu style at the top</strong> and applied a background color under \'Theme Options > Header Menu > Main Header\' for the \'Background color\' <strong>option globally</strong>, then please <strong>make sure the background is set to</strong> rgba(0, 0, 0, 0) or rgba(0, 0, 0, 0.29) <strong>over here<\strong>, depending on your preference for the transparent navigation background.</span>', 'manual' ),
						'required' => array('__manual_page_header_menu_status','equals','1'),
					),
					array(
						'id'       => '__manual_page_header_first_level_menu_text_color',
						'type'     => 'link_color',
						'title'    => esc_html__( 'Menu link color', 'manual' ),
						'subtitle' => esc_html__('Text color for the first level of the navigation menu.', 'manual'),
						'active'    => false, 
						'visited'   => false,
						'required' => array('__manual_page_header_menu_status','equals','1'),
					),
					array(
						'id'       => '__manual_page_header_first_level_menu_text_active_color',
						'type'     => 'link_color',
						'title'    => esc_html__( 'Highlight current page', 'manual' ),
						'subtitle' => esc_html__('Select color to highlight current page menu item.', 'manual'),
						'active'    => false, 
						'visited'   => false, 
						'hover'   => false, 
						'required' => array('__manual_page_header_menu_status','equals','1'),
					),
					array(
						'id'       => '__manual_page_header_flip_logo',
						'type'     => 'switch',
						'title'    => esc_html__( 'Flip logo', 'manual' ),
						'subtitle' => esc_html__('Switch from the \'primary logo\' to the \'secondary logo,\' if necessary.', 'manual'),
						'default'  => false,
						'required' => array('__manual_page_header_menu_status','equals','1'),
					),
					array(
						'id'       => '__manual_page_header_shadow',
						'type'     => 'switch',
						'title'    => esc_html__('Header shadow', 'manual' ),
						'desc' => esc_html__('Please note that this function is effective only when the header shadow is enabled in the \'Header Menu > Main Header\' settings.', 'manual'),
						'subtitle' => esc_html__('Turn the default header shadow on or off.', 'manual'),
						'default'  => false,
						'required' => array('__manual_page_header_menu_status','equals','1'),
					),
					array(
						'id'       => '__manual_page_header_menu_border_btm',
						'type'     => 'border',
						'title'    => esc_html__( 'Header border bottom', 'manual' ),
						'subtitle' => esc_html__('Re-adjust header border bottom', 'manual'),
						'color_alpha'  => true,
						'left'  => false,
						'right'  => false,
						'top'  => false,
						'required' => array('__manual_page_header_menu_status','equals','1'),
					),
					array(
						'id'       => '__manual_page_header_menu_border_top',
						'type'     => 'border',
						'title'    => esc_html__( 'Header border top', 'manual' ),
						'subtitle' => esc_html__('Re-adjust header border top', 'manual'),
						'desc' => esc_html__('If \'Menu position\' is set to \'Logo on Top\' and \'Menu Below Logo\' in \'Theme > Options > Header Menu > Main Header\', then this feature will work properly.', 'manual'),
						'color_alpha'  => true,
						'left'  => false,
						'right'  => false,
						'bottom'  => false,
						'required' => array('__manual_page_header_menu_status','equals','1'),
					),
					array(
						'id'       => '__manual_page_header_hamburger_search_box',
						'type'     => 'switch',
						'title'    => esc_html__( 'Hide the search box in the Hamburger menu.', 'manual' ),
						'desc' => esc_html__('This feature will only function if enabled \'Search Box in Hamburger Menu\' in the \'Theme Options\' under \'Header Menu\' in the \'Main Header\' section.', 'manual'),
						'default'  => false,
						'required' => array('__manual_page_header_menu_status','equals','1'),
						'on' => esc_html__( 'Hide', 'manual' ),
						'off' => esc_html__( 'Theme Default', 'manual' ),
					),
	
				),
			),	
					
			// -- inner 2
			array(
				'title'  => esc_html__( 'Page Title Bar', 'manual' ),
				'icon'   => '',
				'id'     => '__manual_page_meta_title_bar',
				'fields' => array(
				
					array(
						'id'       => '__manual_page_title_bar',
						'type'     => 'switch',
						'title'    => esc_html__('Page title bar', 'manual' ),
						'subtitle' => __('Enable/Disable page title bar', 'manual'),
						'desc' => __('Note: Disabling the page title bar will change the menu style to the default setting, meaning that no transparent menu style will be used.', 'manual'),
						'default'  => true,
						'on'       => esc_html__( 'Enable', 'manual' ),
						'off'      => esc_html__( 'Disable', 'manual' ),
					),
					array(
						'id'       => '__manual_page_title_bar_padding',
						'type'     => 'text',
						'title'    => esc_html__( 'Page title bar :: padding', 'manual' ),
						'subtitle' => esc_html__( 'Re-adjust the space above and below the \'Page Title Bar\' on this page.', 'manual' ),
						'desc'     => __( 'Example: 120px 0px 120px 0px (top, right, bottom, left)<br><br><strong style="color:#e6614b;">IMPORTANT: Make sure the value of RIGHT, LEFT is always 0px</strong>', 'manual' ), 
						'default'  => '',
						'required' => array('__manual_page_title_bar','equals','1'),
					),
					array(
						'id'       => '__manual_page_title_bar_responsive_padding',
						'type'     => 'text',
						'title'    => esc_html__( 'Page title bar :: Responsive padding', 'manual' ),
						'subtitle' => esc_html__( 'Re-adjust the top/bottom spacing for page title bar', 'manual' ),
						'desc'     => __( 'Example: 100px 0px 100px 0px (top, right, bottom, left)<br><br><strong style="color:#e6614b;">IMPORTANT: Make sure the value of RIGHT, LEFT is always 0px</strong>', 'manual' ), 
						'default'  => '',
						'required' => array('__manual_page_title_bar','equals','1'),
					),
					// - Background
					array(
						'id'       => '__manual_page_title_background_wrap',
						'type'     => 'section',
						'title'    => esc_html__( 'Background Settings', 'manual' ),
						'indent'   => true, 
						'required' => array('__manual_page_title_bar','equals','1'),
					),
					array(
						'id'       => '__manual_slider_rev_shortcode',
						'type'     => 'text',
						'title'    => esc_html__( 'Slider revolution shortcode', 'manual' ),
						'desc' => esc_html__( 'copy and paste your shortcode from \'Slider Revolution -> Slider Revolution -> Embed Slider\' to replace either the header image or background color.', 'manual' ),
						'default'  => '',
						'required' => array('__manual_page_title_bar','equals','1'),
					),
					array(
						'id'       => '__manual__pagetitlebar_background',
						'type' => 'background',
						'title'    => esc_html__( 'Background', 'manual' ),
						'subtitle' => esc_html__( 'Create the background for your page.', 'manual' ),
						'required' => array('__manual_page_title_bar','equals','1'), 
					),
					array(
						'id'       => '_manual_header_plx_effect',
						'type'     => 'switch',
						'title'    => esc_html__('Parallax image effects', 'manual' ),
						'subtitle' => __('Make the uploaded image move differently from the rest of the content when scrolling.', 'manual'),
						'default'  => false,
						'on'       => esc_html__( 'Enable', 'manual' ),
						'off'      => esc_html__( 'Disable', 'manual' ),
					),
					array(
						'id'       => '__manual__pagetitlebar_image_overlay',
						'type'     => 'color_rgba',
						'title'    => esc_html__( 'Background overlay', 'manual' ),
						'subtitle'    => esc_html__( 'Select the background overlay for your page title bar.', 'manual' ),
						'required' => array('__manual_page_title_bar','equals','1'),
					),
					// - title
					array(
						'id'       => '__manual_page_title_bar_text_wrap',
						'type'     => 'section',
						'title'    => esc_html__( 'Textual Settings', 'manual' ),
						'indent'   => true, 
						'required' => array('__manual_page_title_bar','equals','1'),
					), 
					array(
						'id'       => '__manual_page_title_bar_text_align',
						'type'     => 'image_select',
						'title'    => esc_html__( 'Text align', 'manual' ),
						'subtitle'    => esc_html__( 'Adjust the alignment of the text on the \'page title bar\'.', 'manual' ),
						'options'  => array(
							'left' => array( 'img' => trailingslashit(get_template_directory_uri()) .'framework/ReduxCore/manual/title-bar-left.png' ),
							'center' => array( 'img' => trailingslashit(get_template_directory_uri()) .'framework/ReduxCore/manual/title-bar-center.png' ),
							'right' => array( 'img' => trailingslashit(get_template_directory_uri()) .'framework/ReduxCore/manual/title-bar-right.png' ),
							'inherit' => array( 'img' => trailingslashit(get_template_directory_uri()) .'framework/ReduxCore/manual/3.jpg' ),
						),
						'default'  => 'inherit',
						'required' => array('__manual_page_title_bar','equals','1'),
					),
					array(
						'id'       => '_manual_header_no_title',
						'type'     => 'switch',
						'title'    => esc_html__('Page title', 'manual' ),
						'subtitle' => __('Choose to display or hide the page title in the specified \'page title bar\' area.', 'manual'),
						'default'  => true,
						'on'       => esc_html__( 'Enable', 'manual' ),
						'off'      => esc_html__( 'Disable', 'manual' ),
						'required' => array('__manual_page_title_bar','equals','1'),
					),
					array(
						'id'       => '_manual_page_tagline',
						'type'     => 'text',
						'title'    => esc_html__( 'Custom title', 'manual' ),
						'subtitle'    => esc_html__( 'Special heading for the page.', 'manual' ),
						'required' => array(
										array('_manual_header_no_title','equals','1'),
										array('__manual_page_title_bar','equals','1'),
										),
					),
					array(
						'id'       => '__manual_page_title_bar_title_typography',
						'type'        => 'typography',
						'title'    => esc_html__( 'Title typography', 'manual' ),
						'subtitle' => esc_html__( 'Customize title text.', 'manual' ),
						'google'      => true,
						'font-backup' => false,
						'text-align' => false,
						'text-transform' => true,
						'subsets'       => false, 
						'letter-spacing'=> true,  
						'all_styles'  => true,
						'font-backup' => true,
						'word-spacing' => true,
						'margin-top' => true,
						'margin-bottom' => true,
						'units'       => 'px',
						'required' => array(
										array('_manual_header_no_title','equals','1'),
										array('__manual_page_title_bar','equals','1'),
										),
					),
					array(
						'id'          => '__manual_page_title_bar_title_typography_resp_h1',
						'type'        => 'typography',
						'title'       => esc_html__( 'Responsive title', 'manual' ),
						'subtitle'    => esc_html__( 'Set responsive title', 'manual' ),
						'google'      => false,
						'font-weight' => false,
						'font-style' => false,
						'font-family' => false,
						'font-backup' => false,
						'text-align'  => false,
						'text-transform' => true,
						'subsets'        => false, 
						'color'          => false, 
						'text-transform'  => false, 
						'letter-spacing' => true,  
						'all_styles'  => false,
						'word-spacing' => true,
						'units'        => 'px',
						'required' => array(
											array('_manual_header_no_title','equals','1'),
											array('__manual_page_title_bar','equals','1'),
											),
					),
					// - sub-title
					array(
						'id'       => '_manual_page_desc',
						'type'     => 'text',
						'title'    => esc_html__( 'Sub-title text', 'manual' ),
						'subtitle' => esc_html__( 'Display the custom sub-title in the specified \'page title bar\' area.', 'manual' ),
						'required' => array('__manual_page_title_bar','equals','1'),
					),
					array(
						'id'       => '__manual_page_title_bar_subtitle_typography',
						'type'        => 'typography',
						'title'    => esc_html__( 'Sub-title typography', 'manual' ),
						'subtitle' => esc_html__( 'Customize sub-title text.', 'manual' ),
						'google'      => true,
						'font-backup' => false,
						'text-align' => false,
						'text-transform' => true,
						'subsets'       => false, 
						'letter-spacing'=> true,  
						'all_styles'  => true,
						'font-backup' => true,
						'word-spacing' => true,
						'margin-top' => true,
						'margin-bottom' => true,
						'units'       => 'px',
						'required' => array('__manual_page_title_bar','equals','1'),
					),
					// - search box
					array(
						'id'       => '__manual_page_title_bar_search_wrap',
						'type'     => 'section',
						'title'    => esc_html__( 'Search Box', 'manual' ),
						'indent'   => true, 
						'required' => array('__manual_page_title_bar','equals','1'),
					),
					array(
						'id'       => '__manual_page_title_bar_search_status',
						'type'     => 'switch',
						'title'    => esc_html__( 'Search box', 'manual' ),
						'subtitle' => esc_html__( 'Choose to show or hide the search box in the specified \'page title bar\' area.', 'manual' ),
						'default'  => false,
						'on' => esc_html__( 'Enable', 'manual' ),
						'off' => esc_html__( 'Disable', 'manual' ),
						'required' => array('__manual_page_title_bar','equals','1'),
					),
					array(
						'id'       => '_manual_search_box_display_grid',
						'type'     => 'select',
						'title'    => esc_html__( 'Search box position', 'manual' ),
						'subtitle'    => esc_html__( 'Choose where to place the search box on the \'page title bar\'.', 'manual' ),
						'options'  => array(
							'center' => esc_html__('Exact Center','manual' ),
							'6' => esc_html__('50% Width','manual' ),
							'7' => esc_html__('58% Width','manual' ),
							'8' => esc_html__('66% Width','manual' ),
							'9' => esc_html__('75% Width','manual' ),
							'10' => esc_html__('83% Width','manual' ),
							'11' => esc_html__('91% Width','manual' ),
							'12' => esc_html__('100% Width','manual' ),
						),
						'default'  => 'center',
						'required' => array(
											array('__manual_page_title_bar_search_status','equals','1'),
											array('__manual_page_title_bar','equals','1'),
											),
					), 
					array(
						'id'       => '__manual_page_title_bar_searchbox_treanding_search_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Title text color', 'manual' ),
						'subtitle'    => esc_html__( 'Trending search text title color', 'manual' ),
						'required' => array(
											array('__manual_page_title_bar_search_status','equals','1'),
											array('__manual_page_title_bar','equals','1'),
											),
					),
					array(
						'id'       => '__manual_page_title_bar_searchbox_treanding_search_link_color',
						'type'     => 'link_color',
						'title'    => esc_html__( 'Link color', 'manual' ),
						'subtitle'    => esc_html__( 'The trending keyword link color', 'manual' ),
						'active'    => false, 
						'visited'   => false,
						'required' => array(
											array('__manual_page_title_bar_search_status','equals','1'),
											array('__manual_page_title_bar','equals','1'),
											),
					),
					// - breadcrumb
					array(
						'id'       => '__manual_page_title_bar_breadcrumb_wrap',
						'type'     => 'section',
						'indent'   => true, 
						'title'    => esc_html__( 'Breadcrumb', 'manual' ),
						'required' => array('__manual_page_title_bar','equals','1'),
					),
					array(
						'id'       => '_manual_header_breadcrumb_status',
						'type'     => 'switch',
						'title'    => esc_html__( 'Breadcrumb', 'manual' ),
						'subtitle' => esc_html__( 'Choose to show or hide the breadcrumb in the specified \'page title bar\' area.', 'manual' ),
						'default'  => false,
						'on' => esc_html__( 'Enable', 'manual' ),
						'off' => esc_html__( 'Disable', 'manual' ),
						'required' => array('__manual_page_title_bar','equals','1'),
					),
					array(
						'id'       => '__manual_page_title_bar_breadcrumb_regular_text_color',
						'type'     => 'color_rgba',
						'title'    => esc_html__( 'Regular text color', 'manual' ),
						'subtitle' => esc_html__('Breadcrumb regular text color.', 'manual'),
						'required' => array(
											array('_manual_header_breadcrumb_status','equals','1'),
											array('__manual_page_title_bar','equals','1'),
											),
					),
					array(
						'id'       => '__manual_page_title_bar_breadcrumb_link_color',
						'type'     => 'link_color',
						'title'    => esc_html__( 'Link color', 'manual' ),
						'subtitle' => esc_html__('Adjust the color of breadcrumb links if needed.', 'manual'),
						'active'  => false,
						'required' => array(
											array('_manual_header_breadcrumb_status','equals','1'),
											array('__manual_page_title_bar','equals','1'),
											),
					),
					array(
						'id'       => '__manual_page_title_bar_breadcrumb_link_seprator_color',
						'type'     => 'color_rgba',
						'title'    => esc_html__( 'Link seprator color', 'manual' ),
						'subtitle' => esc_html__('Adjust the color of breadcrumb link seprators if needed.', 'manual'),
						'required' => array(
											array('_manual_header_breadcrumb_status','equals','1'),
											array('__manual_page_title_bar','equals','1'),
											),
					),
					
				),
			),
			
			// -- inner 3
			array(
				'title'  => esc_html__( 'Footer', 'manual' ),
				'icon'   => '',
				'id'     => '__manual_page_meta_footer',
				'fields' => array(
					array(
						'id'       => '_manual_show_hide_footer_area_pg',
						'type'     => 'switch',
						'title'    => esc_html__( 'Footer', 'manual' ),
						'default'  => true,
						'subtitle' => esc_html__( 'Enable / disable footer on this page', 'manual' ),
						'desc' => esc_html__( 'If the footer is globally disabled using \'Theme Options > Footer,\' this feature will not function.', 'manual' ),
						'on' => esc_html__( 'Enable', 'manual' ),
						'off' => esc_html__( 'Disable', 'manual' ),
					),
				),
			),
			
		),
	)
);
?>