<?php
    if ( ! class_exists( 'Redux' ) ) {
        return;
    }

    $opt_name = "redux_demo";    // ==== IMPORTANT

    $theme = wp_get_theme(); // For use with some settings. Not necessary.

    $args = array(
        'opt_name'             => $opt_name,
        'display_name'         => $theme->get( 'Name' ),
        'display_version'      => $theme->get( 'Version' ),
        'menu_type'            => 'submenu', // menu, submenu
        'allow_sub_menu'       => true,
        'menu_title'           => __( 'Theme Options', 'manual' ),
        'page_title'           => __( 'Theme Options', 'manual' ),
        'google_api_key'       => '',
        'google_update_weekly' => false,
        'async_typography'     => true,
        'admin_bar'            => false,
        'admin_bar_icon'       => 'dashicons-portfolio',
        'admin_bar_priority'   => 50,
        'global_variable'      => 'theme_options',
        'dev_mode'             => false,
		'forced_dev_mode_off'  => true,
		'use_cdn'              => false,
        'update_notice'        => true,
        'customizer'           => true,
        'page_priority'        => null,
        'page_parent'          => 'manual-admin',
        'page_permissions'     => 'manage_options',
        'menu_icon'            => '',
        'last_tab'             => '',
        'page_icon'            => 'icon-themes',
        'page_slug'            => '',
        'save_defaults'        => true,
        'default_show'         => false,
        'default_mark'         => '',
        'show_import_export'   => true,
        'transient_time'       => 60 * MINUTE_IN_SECONDS,
        'output'               => true,
        'output_tag'           => true,
        'database'             => '',
        'use_cdn'              => true,
		'show_options_object'  => false,
    );

    // Panel Intro text -> before the form
    if ( ! isset( $args['global_variable'] ) || $args['global_variable'] !== false ) {
        if ( ! empty( $args['global_variable'] ) ) {
            $v = $args['global_variable'];
        } else {
            $v = str_replace( '-', '_', $args['opt_name'] );
        }
    } else {
    }


    Redux::setArgs( $opt_name, $args );


/*************************************
*  All text fields updated for each 
   change on the front end. *
*************************************/	 
	 
	Redux::setSection( $opt_name, array(
        'title'            => esc_html__( 'Text', 'manual' ),
        'id'               => 'theme_global_used_text_section',
        'customizer_width' => '450px',
		'icon'             => 'el el-globe-alt',
        'fields'           => array(
			
			array (
				'subtitle' => esc_html__('Change the original "Home" attribute in a breadcrumb to: "Start / Doc /..."', 'manual'),
				'id' => 'custom-record-breadcrumb-home-text',
				'type' => 'text',
				'title' => esc_html__('Breadcrumb makeover: Renaming \'Home\'', 'manual'),
				'default' => 'Home',
			),
			array(
				'id'       => 'date-modified-text',
				'type'     => 'text',
				'title'    => esc_html__( 'Text before modified date', 'manual' ),
				'default'  => 'Updated on',
				'desc'     => esc_html__( 'Displayed as: Updated on October 10, 2022', 'manual' ),
				'subtitle' => esc_html__('Text before the modified article\'s date.', 'manual'),
			),
			/****** STANDARD CONFIGURATION FOR KB AND DOC *****/
			array(
				'id'       => 'theme-text-control-both-knowledgebase-and-documentation',
				'type'     => 'section',
				'title'    => esc_html__( 'Standard Setup', 'manual' ),
				'indent'   => true, 
			),
			array (
				'desc' => esc_html__('Text appears under the post title, showing as: 4567 views', 'manual'),
				'id' => 'custom-record-post-view-text',
				'type' => 'text',
				'title' => esc_html__('Views text', 'manual'),
				'default' => esc_html__('views', 'manual'),
				'subtitle' => esc_html__('[Basic]', 'manual'),
			),
			array(
				'id'       => 'theme-text-control-both-knowledgebase-and-documentation-divide-one',
				'type' => 'divide',
			),
			array (
				'desc' => esc_html__('Will serve as the TOC title.', 'manual'),
				'id' => 'toc-on-this-page',
				'type' => 'text',
				'title' => esc_html__('TOC title', 'manual'),
				'default' => esc_html__('On This Page:', 'manual'),
				'subtitle' => esc_html__('[TOC]', 'manual'),
			),
			array (
				'desc' => esc_html__('Show/Hide text near TOC title', 'manual'),
				'id' => 'toc-hide-text',
				'type' => 'text',
				'title' => esc_html__('Hide text', 'manual'),
				'default' => esc_html__('hide', 'manual'),
				'subtitle' => esc_html__('[TOC]', 'manual'),
			),
			array (
				'desc' => esc_html__('Show/Hide text near TOC title', 'manual'),
				'id' => 'toc-show-text',
				'type' => 'text',
				'title' => esc_html__('Show text', 'manual'),
				'default' => esc_html__('show', 'manual'),
				'subtitle' => esc_html__('[TOC]', 'manual'),
			),
			array(
				'id'   => 'theme-text-control-both-knowledgebase-and-documentation-divide-two',
				'type' => 'divide',
			),
			array (
				'id' => 'post-contact-us-didnt-find-any-answer-message',
				'type' => 'text',
				'title' => esc_html__('Message', 'manual'),
				'default' => esc_html__('No luck finding what you need?', 'manual'),
				'desc' => esc_html__('The message will show up following Related Articles in the knowledgebase and documentation section. Displayed as: \'Didn\'t find your answer? @ Contact Us.', 'manual'),
				'subtitle' => esc_html__('[Contact Us]', 'manual'),
			),
			array (
				'id' => 'post-contact-us-contact-us-message',
				'type' => 'text',
				'title' => esc_html__('Link text', 'manual'),
				'default' => esc_html__('Contact Us', 'manual'),
				'desc' => esc_html__('The message will show up following Related Articles in the knowledgebase and documentation section. Displayed as: \'Didn\'t find your answer? @ Contact Us.', 'manual'),
				'subtitle' => esc_html__('[Contact Us]', 'manual'),
			),
			array (
				'id' => 'post-contact-us-link-url',
				'type' => 'text',
				'title' => esc_html__('Link URL', 'manual'),
				'default' => esc_html__('#', 'manual'),
				'desc' => esc_html__('A link that takes you to the page when you click on the \'Contact Us\' text.', 'manual'),
				'subtitle' => esc_html__('[Contact Us]', 'manual'),
			),
			array(
				'id'   => 'theme-text-control-both-knowledgebase-and-documentation-divide-three',
				'type' => 'divide',
			),
			array (
				'desc' => esc_html__('Message above Yes/No button in the knowledgebase and documentation section.', 'manual'),
				'id' => 'yes-no-above-message',
				'type' => 'text',
				'title' => esc_html__('Message', 'manual'),
				'default' => esc_html__('Was this helpful?', 'manual'),
				'subtitle' => esc_html__('[Like/Dislike]', 'manual'),
			),
			array (
				'id' => 'yes-user-input-text',
				'type' => 'text',
				'title' => esc_html__('Like text', 'manual'),
				'desc' => esc_html__('Text for the like button', 'manual'),
				'default' => 'Yes',
				'subtitle' => esc_html__('[Like/Dislike]', 'manual'),
			),
			array (
				'id' => 'no-user-input-text',
				'type' => 'text',
				'title' => esc_html__('Dislike text', 'manual'),
				'desc' => esc_html__('Text for the unlike button', 'manual'),
				'default' => 'No',
				'subtitle' => esc_html__('[Like/Dislike]', 'manual'),
			),
			array (
				'id' => 'already-voted',
				'type' => 'text',
				'title' => esc_html__('Already voted notification', 'manual'),
				'desc' => esc_html__('Notification if user has already voted', 'manual'),
				'default' => 'already voted',
				'subtitle' => esc_html__('[Like/Dislike]', 'manual'),
			),
			array (
				'id' => 'reset-user-input-text',
				'type' => 'text',
				'title' => esc_html__('Reset text', 'manual'),
				'desc' => esc_html__('Text for the reset button', 'manual'),
				'default' => 'Reset',
				'subtitle' => esc_html__('[Like/Dislike]', 'manual'),
			),
			array(
				'id'   => 'theme-text-control-both-knowledgebase-and-documentation-divide-four',
				'type' => 'divide',
			),
			array (
				'desc' => esc_html__('Table header title', 'manual'),
				'id' => 'attached-file-title',
				'type' => 'text',
				'title' => esc_html__('Title', 'manual'),
				'default' => esc_html__('Attached Files', 'manual'),
				'subtitle' => esc_html__('[File Attached]', 'manual'),
			),
			array (
				'desc' => esc_html__('Title for the First Column in the table, responsible for displaying results of attached file types.', 'manual'),
				'id' => 'attached-file-type',
				'type' => 'text',
				'title' => esc_html__('First column title', 'manual'),
				'default' => 'File Type',
				'subtitle' => esc_html__('[File Attached]', 'manual'),
			),
			array (
				'desc' => esc_html__('Title for the Second Column in the table, responsible for displaying results of attached file sizes', 'manual'),
				'id' => 'attached-file-size',
				'type' => 'text',
				'title' => esc_html__('Second column title', 'manual'),
				'default' => 'File Size',
				'subtitle' => esc_html__('[File Attached]', 'manual'),
			),
			array (
				'desc' => esc_html__('Title for the Third Column in the table, displaying links for downloading attachments.', 'manual'),
				'id' => 'attached-file-download',
				'type' => 'text',
				'title' => esc_html__('Third column title', 'manual'),
				'default' => 'Download',
				'subtitle' => esc_html__('[File Attached]', 'manual'),
			),
		)
    ) );
	
	
/***************************
*** Website layout setup ***
****************************/

    Redux::setSection( $opt_name, array(
        'title'  => esc_html__( 'Layout', 'manual' ),
        'id'     => 'manualtheme-layout',
        'icon'   => 'el el-website',
        'fields' => array(
					
					array(
						'id'       => 'website_box_layout',
						'type'     => 'switch',
						'title'    => esc_html__('Layout', 'manual' ),
						'subtitle' => esc_html__('Controls the site layout.', 'manual'),
						'default'  => false,
						'on' => esc_html__( 'Boxed', 'manual' ),
						'off' => esc_html__( 'Wide', 'manual' ),
					),
					array(
						'id'       => 'website_width_container_1200',
						'type'     => 'text',
						'title'    => esc_html__( 'Container width (min: 1200px)', 'manual' ),
						'subtitle'  => esc_html__( 'Manages the width of the container when the browser window is at a minimum of 1200px', 'manual' ),
						'default'  => '1170px',
						'desc'     => esc_html__( 'Default: 1170px', 'manual' ),
					),
					array(
						'id'    => 'theme-layout-extra-settings',
						'type'  => 'tabbed',
						'title' =>  esc_html__( 'Additional control', 'manual' ),
						'tabs'  => array(
							array(
								'title'  => esc_html__( 'Layout', 'manual' ),
								'fields' => array(
									// Wide
									array(
										'id'       => 'website_nav_container_global_full_width',
										'type'     => 'switch',
										'title'    => esc_html__( 'Header', 'manual' ),
										'desc' => esc_html__('Adjust the menu and logo area to span the full width in the header', 'manual'),
										'default'  => false,
										'required' => array('website_box_layout','equals','0'),
										'on' => esc_html__( 'Enable', 'manual' ),
										'off' => esc_html__( 'Disable', 'manual' ),
									),
									array(
										'id'       => 'website_footer_container_global_full_width',
										'type'     => 'switch',
										'title'    => esc_html__( 'Footer', 'manual' ),
										'desc' => esc_html__('Adjust the footer area to span the full width', 'manual'),
										'default'  => false,
										'required' => array('website_box_layout','equals','0'),
										'on' => esc_html__( 'Enable', 'manual' ),
										'off' => esc_html__( 'Disable', 'manual' ),
									),
									// Boxed
									array(
										'id'       => 'website_boxlayout_max_width',
										'type'     => 'text',
										'title'    => esc_html__( 'Boxed width', 'manual' ),
										'desc'  => esc_html__( 'Controls the width of the boxed layout. (Default: 1230px)', 'manual' ),
										'default'  => '1230px',
										'required' => array('website_box_layout','equals','1'),
									),
								),
							),
							array(
								'title'  => esc_html__( 'High-resolution Screens', 'manual' ),
								'fields' => array(
									array(
										'id'       => 'website_highscreen_container',
										'type'     => 'switch',
										'title'    => esc_html__('Custom width', 'manual' ),
										'desc' => esc_html__('Manage container width on high-res screens.', 'manual'),
										'default'  => false,
										'on' => esc_html__( 'Enable', 'manual' ),
										'off' => esc_html__( 'Disable', 'manual' ),
									),
									array(
										'id'       => 'website_width_container_1400_and_1600',
										'type'     => 'text',
										'title'    => esc_html__( 'Width (1400-1600)px', 'manual' ),
										'desc'  => esc_html__( 'Manages container width for browser windows with a minimum width of 1400px and 1600px. (Default:1370px)', 'manual' ),
										'default'  => '1370px',
										'required' => array(
											array('website_highscreen_container','equals','1'),
											array('website_box_layout','equals','0'),
										  ),
									),
									array(
										'id'       => 'website_width_container_1900',
										'type'     => 'text',
										'title'    => esc_html__( 'Width 1900px and above', 'manual' ),
										'desc'  => esc_html__( 'Manages container width for browser windows with a minimum width of 1900px. (Default:1570px)', 'manual' ),
										'default'  => '1570px',
										'required' => array(
											array('website_highscreen_container','equals','1'),
											array('website_box_layout','equals','0'),
										  ),
									),
									array(
										'id'       => 'website_boxlayout_max_width_1400_and_1600',
										'type'     => 'text',
										'title'    => esc_html__( 'Boxed width (1400-1600)px', 'manual' ),
										'desc'  => esc_html__( 'Manages the width of the box layout for screen sizes with a minimum of 1400px and 1600px. (Default:1450px)', 'manual' ),
										'default'  => '1450px',
										'required' => array(
											array('website_highscreen_container','equals','1'),
											array('website_box_layout','equals','1'),
										  ),
									),
									array(
										'id'       => 'website_boxlayout_max_width_1900',
										'type'     => 'text',
										'title'    => esc_html__( 'Boxed width 1900px and above', 'manual' ),
										'desc'  => esc_html__( 'Manages the width of the box layout for screen sizes starting from a minimum of 1900px and above. (Default:1650px)', 'manual' ),							
										'default'  => '1650px',
										'required' => array(
											array('website_highscreen_container','equals','1'),
											array('website_box_layout','equals','1'),
										  ),
									),
								),
							),
						),
					),
					array(         
						'id'       => 'website_box_layout_background',
						'type'     => 'background',
						'title' => esc_html__('Background', 'manual'),
						'subtitle' => esc_html__('Select the background for your boxed layout.', 'manual'),
						'output'   => array('body.boxed_layout'),
						'required' => array('website_box_layout','equals','1'),
					),
					array(
						'id'             => 'website_box_layout_outer_margin',
						'type'           => 'spacing',
						'mode'           => 'margin',
						'units'          => 'px',
						'left'           => false,
						'right'           => false,
						'title'          => esc_html__('Top/Bottom offset', 'manual'),
						'desc'       => esc_html__('Adjusts the vertical displacement of the boxed background\'s top and bottom. Input values in any valid CSS unit, such as 0px, 0px.', 'manual'),
						'default'            => array(
							'margin-top'     => '25px ', 
							'margin-bottom'    => '0px',
						),
						'required' => array('website_box_layout','equals','1'),
						'output'   => array('body.boxed_layout .theme_box_wrapper'),
					),
					array(
						'id'       => 'website_box_layout_shadow',
						'type'     => 'box_shadow',
						'inset-shadow'     => false,
						'title'    => esc_html__( 'Box Shadow', 'manual' ),
						'subtitle' => esc_html__( 'Customize the box shadow to suit your needs', 'manual' ),
						'output'   => array('body.boxed_layout .theme_box_wrapper'),
						'required' => array('website_box_layout','equals','1'),
						'default'  => array( 'drop-shadow' => array('horizontal' => '0', 'vertical' => '-2', 'blur'  => '18', 'spread' => '4',), ), 
					),
	  )
    ) );
	
	
/*************************************
*  Website global color *
*************************************/	 


    Redux::setSection( $opt_name, array(
        'title'  => esc_html__( 'Colors', 'manual' ),
		'desc'   => esc_html__( 'global effect', 'manual' ),
        'id'     => 'manual-theme-global-color',
        'icon'   => 'el el-brush',
        'fields' => array(
						  
					// Website colour
					array(
						'id'       => 'website_colour',
						'type'     => 'link_color',
						'title'    => esc_html__( 'Website color', 'manual' ),
						'subtitle'  => esc_html__('Overall impact throughout the site', 'manual'),
						'hover'    => false, 
						'active'    => false, 
						'visited'   => false, 
						'default'  => array(
							'regular'   => '#47C494',
						)
					),
					array(
						'id'       => 'manual-global-link-color',
						'type'     => 'link_color',
						'title'    => esc_html__( 'Standard anchor tag', 'manual' ),
						'subtitle'  => esc_html__('Color of the standard "a" tag.', 'manual'),
						'active'    => false, 
						'visited'   => false, 
						'default'  => array(
							'regular' => '#333333',
							'hover'   => '#46b289',
						),
					),
					array(
						'id'       => 'standard_a_tag_link_color_inside_post',
						'type'     => 'link_color',
						'title'    => esc_html__( 'Standard anchor tag (inside post)', 'manual' ),
						'subtitle'  => esc_html__('Color of the standard "a" tag inside post', 'manual'),
						'active'    => false, 
						'visited'   => false, 
						'default'  => array(   
							'regular'   => '#1e73be',
							'hover'   => '#46b289',
						)
					),
					array(
						'id'       => 'text_link_color',
						'type'     => 'link_color',
						'title'    => esc_html__( 'Custom anchor tag', 'manual' ),
						'subtitle'  => esc_html__('Color of the custom standard "a" tag', 'manual'),
						'active'    => false, 
						'visited'   => false, 
						'default'  => array(
							'regular' => '#46b289',
							'hover'   => '#001040',
						)
					),
					// Button Settings
					array(
						'id'       => 'global-color-button-settings',
						'type'     => 'section',
						'title'    => esc_html__( 'Botton Settings', 'manual' ),
						'indent'   => true, 
					),
					array(
						'id'       => 'botton_text_color',
						'type'     => 'link_color',
						'title'    => esc_html__( 'Text color', 'manual' ),
						'subtitle'  => esc_html__('Button text color', 'manual'),
						'active'    => false, 
						'visited'   => false, 
						'default'  => array(
							'regular' => '#ffffff',
							'hover' => '#ffffff',
						)
					),
					array(
						'id'       => 'botton_color',
						'type'     => 'link_color',
						'title'    => esc_html__( 'Background color', 'manual' ),
						'subtitle'  => esc_html__('Botton background color', 'manual'),
						'active'    => false, 
						'visited'   => false, 
						'default'  => array(
							'regular' => '#46b289',
							'hover'   => '#001040',
						)
					),
					// Other Settings
					array(
						'id'       => 'global-color-other-settings',
						'type'     => 'section',
						'title'    => esc_html__( 'Other Settings', 'manual' ),
						'indent'   => true, 
					),
					array(
						'id'       => 'blog-meta-icon-color',
						'type'     => 'link_color',
						'title'    => esc_html__( 'Meta icon color', 'manual' ),
						'subtitle'  => esc_html__('Symbols appearing before the text and below the article title.', 'manual'),
						'hover'    => false, 
						'active'    => false, 
						'visited'   => false, 
						'default'  => array(
							'regular' => '#46b289',
						)
					),
					array(
						'id'       => 'blog-meta-icon-text-color',
						'type'     => 'link_color',
						'title'    => esc_html__( 'Meta text color', 'manual' ),
						'subtitle'  => esc_html__('Text appearing after the icon symbols and beneath the article title.', 'manual'),
						'hover'    => false, 
						'active'    => false, 
						'visited'   => false, 
						'default'  => array(
							'regular' => '#727272',
						)
					),
					array(
						'id'       => 'blog-meta-icon-text-link-color',
						'type'     => 'link_color',
						'title'    => esc_html__( 'Meta link color', 'manual' ),
						'subtitle'  => esc_html__('Link text appearing after the icon symbols and beneath the article title.', 'manual'),
						'active'    => false, 
						'visited'   => false, 
						'default'  => array(
							'regular' => '#A9A9A9',
							'hover' => '#46b289',
						)
					),
					array(
						'id'       => 'global-article-icon-color',
						'type'     => 'link_color',
						'title'    => esc_html__( 'Title icon color', 'manual' ),
						'subtitle'  => esc_html__('Icon appearing before the article title.', 'manual'),
						'hover'    => false, 
						'active'    => false, 
						'visited'   => false, 
						'default'  => array(
							'regular' => '#888B8A',
						),
					),
        )
    ) );
	


/***************************************
*******  THEME OPTIONS  - LOGO     *****
****************************************/

	 Redux::setSection( $opt_name, array(
        'title'  => esc_html__( 'Logo', 'manual' ),
        'id'     => 'theme-header-logo-settings',
		'icon'   => 'el el-magic',
        'fields' => array(
						  
			array(
				'id'       => 'hide-header-logo-status',
				'type'     => 'switch',
				'title'    => esc_html__( 'Website logo', 'manual' ),
				'default'  => false,
				'subtitle' => esc_html__( 'Turn your website logo on/off for branding purposes.', 'manual' ),
				'on' => esc_html__( 'Disable', 'manual' ),
				'off' => esc_html__( 'Enable', 'manual' ),
			),
			array(
				'id'       => 'theme-custom-site-url',
				'type'     => 'text',
				'title'    => esc_html__('Custom logo URL', 'manual'),
				'subtitle' => esc_html__('Enter a URL to customize the site logo link. If you leave it blank, the logo will link to the homepage.', 'manual'),
				'required' => array('hide-header-logo-status','equals','0'),
			),			  
			array (
				'id' => 'manual-favicon',
				'type' => 'media',
				'title' => esc_html__('Favicon', 'manual'),
				'url' => false,
				'subtitle' => esc_html__('Set the icon for browser tab and home screen. Recommended size: 196px x 196 px.', 'manual'),
			),
            array(
                'id'       => 'theme-header-logo',
                'type'     => 'media',
                'title'    => esc_html__( 'Primary logo', 'manual' ),
				'url' => false,
				'subtitle' => esc_html__('Set the default logo.', 'manual'),
				'desc' => esc_html__( 'Standard logo size: 479px x 105px', 'manual' ),
				'required' => array('hide-header-logo-status','equals','0'),
            ),
		    array(
                'id'       => 'theme-nav-homepg-logo-when-img-bg',
                'type'     => 'media',
				'url' => false,
                'title'    => esc_html__( 'Secondary logo', 'manual' ),
				'subtitle' => esc_html__( 'Set logo for transparent headers.', 'manual' ),
				'desc' => esc_html__( 'Standard logo size: 479px x 105px', 'manual' ),
				'required' => array('hide-header-logo-status','equals','0'),
            ),
			array(
				'id'       => 'theme-logo-alt-text',
				'type'     => 'text',
				'title'    => esc_html__('Logo backup description', 'manual'),
				'subtitle' => esc_html__('The "alt" attribute provides a backup description for an image in case it can\'t be shown', 'manual'),
				'required' => array('hide-header-logo-status','equals','0'),
			),
			// Logo Customization
			array(
                'id'       => 'readjust-logo-start',
                'type'     => 'section',
                'title'    => esc_html__( 'Logo Customization', 'manual' ),
                'indent'   => true,
				'required' => array('hide-header-logo-status','equals','0'), 
            ),
			array(
				'id'       => 'theme-logo-readjust-height',
				'type'     => 'dimensions',
				'units'    => array('px'),
				'title'    => esc_html__('Resize the logo height', 'manual'),
				'desc'     => esc_html__('Default: 35px', 'manual'),
				'subtitle' => esc_html__( 'Modify logo size', 'manual' ),
				'width'     => false,
				'default'  => array(
					'Height'  => '35'
					)
			),
			array(
				'id'       => 'theme-logo-readjust-margin-top',
				'type'     => 'dimensions',
				'units'    => array('px'),
				'title'    => esc_html__('Margin top', 'manual'),
				'subtitle' => esc_html__( 'Modify top margin for the logo', 'manual' ),
				'desc'     => esc_html__('Default: -6px', 'manual'),
				'width'     => false,
				'default'  => array(
					'Height'  => '-6'
					)
			),
			array(
                'id'       => 'logo-responsive-start',
                'type'     => 'section',
                'title'    => esc_html__( 'Responsive Logo Customization', 'manual' ),
                'indent'   => true, 
				'required' => array('hide-header-logo-status','equals','0'), 
            ),
			array(
				'id'       => 'theme-logo-readjust-height-responsive',
				'type'     => 'dimensions',
				'units'    => array('px'),
				'title'    => esc_html__('Responsive logo resizing', 'manual'),
				'subtitle' => esc_html__( 'Logo size adjustment for responsive design', 'manual' ),
				'desc'     => esc_html__('Default: 35px', 'manual'),
				'width'     => false,
				'default'  => array(
					'Height'  => '35'
					)
			),
			array(
				'id'       => 'theme-logo-readjust-margin-top-responsive',
				'type'     => 'dimensions',
				'units'    => array('px'),
				'title'    => esc_html__('Responsive margin top', 'manual'),
				'subtitle' => esc_html__( 'Modify top margin for the logo', 'manual' ),
				'desc'     => esc_html__('Default: -6px', 'manual'),
				'width'     => false,
				'default'  => array(
					'Height'  => '-6'
					)
			),
			
        )
    ) );
	 

/*-----------------------------------------------------------------------------------*/
/*	TYPOGRAPHY
/*-----------------------------------------------------------------------------------*/

    Redux::setSection( $opt_name, array(
        'title'  => esc_html__( 'Typography', 'manual' ),
        'id'     => 'typography',
        'icon'   => 'el el-font',
        'fields' => array(
			// Custom Font - Global Effect
			array(
				'id'       => 'theme-typography-custom-fonts',
				'type'     => 'custom_fonts',
				'title'    => esc_html__( 'Add custom fonts', 'manual' ),
				'subtitle' => __('<strong>Use your own fonts that are not already listed on Font Family.</strong> <br><span style="color:red;">After uploading a custom font, it will be visible in the \'Font Family\' within the \'Custom Fonts\' section.</span>', 'manual' ),
			),
			
			// Body
            array(
                'id'       => 'theme-typography-body',
                'type'     => 'typography',
                'title'    => esc_html__( 'Body', 'manual' ),
                'subtitle' => esc_html__('Set the body font properties.', 'manual' ),
                'google'   => true,
				'text-align' => false,
				'font-style' => false,
				'letter-spacing' => true,
				'subsets' => false,
				'font-backup' => true,
				'units'  => 'px',
				'word-spacing' => true,
                'default'  => array(
                    'color'       => '#333333',
                    'font-size'   => '15',
                    'font-family' => 'PT Sans',
					'line-height' => '1.6',
					'letter-spacing' => '0.3',
					'google'      => true,
					'font-weight' => '400',
                ),
            ),
			array (
				'subtitle' => esc_html__('The \'Custom Font Name\' already added to the site through third-party plugins or custom coding.', 'manual'),
				'desc' => esc_html__('Adding a name changes the body font to a custom font.', 'manual'),
				'id' => 'custom-body-font',
				'type' => 'text',
				'title' => esc_html__('Font family name', 'manual'),
			),
			
			// H1
			array(
                'id'          => 'theme-h1-typography',
                'type'        => 'typography',
                'title'       => esc_html__( 'H1', 'manual' ),
				'subtitle'    => esc_html__( 'Set Heading 1 options', 'manual' ),
                'google'      => true,
                'font-backup' => false,
				'text-align' => false,
				'text-transform' => true,
                'subsets'       => false, 
                'letter-spacing'=> true,  
                'all_styles'  => true,
				'font-backup' => true,
				'word-spacing' => true,
                'units'       => 'px',
                'default'     => array(
                    'font-style'  => '700',
                    'font-family' => 'Dosis',
                    'google'      => true,
                    'font-size'   => '40',
                    'line-height' => '45',
					'text-transform' => 'none',
					'letter-spacing' => '-0.7',
					'color' => '#222222',
                ),
            ),
			array (
				'subtitle' => esc_html__('The \'Custom Font Name\' already added to the site through third-party plugins or custom coding.', 'manual'),
				'desc' => esc_html__('Adding a name changes the H1 font to a custom font.', 'manual'),
				'id' => 'custom-h1-font',
				'type' => 'text',
				'title' => esc_html__('Font family name', 'manual'),
			),
			
			// H2
			array(
                'id'          => 'theme-h2-typography',
                'type'        => 'typography',
                'title'       => esc_html__( 'H2', 'manual' ),
				'subtitle'    => esc_html__( 'Set Heading 2 options', 'manual' ),
                'google'      => true,
                'font-backup' => false,
				'text-align' => false,
				'text-transform' => true,
                'subsets'       => false, 
                'letter-spacing'=> true,  
                'all_styles'  => true,
				'font-backup' => true,
				'word-spacing' => true,
                'units'       => 'px',
                'default'     => array(
                    'font-style'  => '700',
                    'font-family' => 'Dosis',
                    'google'      => true,
                    'font-size'   => '34',
                    'line-height' => '40',
					'text-transform' => 'none',
					'letter-spacing' => '-0.4',
					'color' => '#222222',
                ),
            ),
			array (
				'subtitle' => esc_html__('The \'Custom Font Name\' already added to the site through third-party plugins or custom coding.', 'manual'),
				'desc' => esc_html__('Adding a name changes the H2 font to a custom font.', 'manual'),
				'id' => 'custom-h2-font',
				'type' => 'text',
				'title' => esc_html__('Font family name', 'manual'),
			),
			
			// H3
			array(
                'id'          => 'theme-h3-typography',
                'type'        => 'typography',
                'title'       => esc_html__( 'H3', 'manual' ),
				'subtitle'    => esc_html__( 'Set Heading 3 options', 'manual' ),
                'google'      => true,
                'font-backup' => false,
				'text-align' => false,
				'text-transform' => true,
                'subsets'       => false, 
                'letter-spacing'=> true,  
                'all_styles'  => true,
				'font-backup' => true,
				'word-spacing' => true,
                'units'       => 'px',
                'default'     => array(
                    'font-style'  => '700',
                    'font-family' => 'Dosis',
                    'google'      => true,
                    'font-size'   => '30',
                    'line-height' => '34',
					'text-transform' => 'none',
					'letter-spacing' => '0',
					'color' => '#222222',
                ),
            ),
			array (
				'subtitle' => esc_html__('The \'Custom Font Name\' already added to the site through third-party plugins or custom coding.', 'manual'),
				'desc' => esc_html__('Adding a name changes the H3 font to a custom font.', 'manual'),
				'id' => 'custom-h3-font',
				'type' => 'text',
				'title' => esc_html__('Font family name', 'manual'),
			),
			
			// H4
			array(
                'id'          => 'theme-h4-typography',
                'type'        => 'typography',
                'title'       => esc_html__( 'H4', 'manual' ),
				'subtitle'    => esc_html__( 'Set Heading 4 options', 'manual' ),
                'google'      => true,
                'font-backup' => false,
				'text-align' => false,
				'text-transform' => true,
                'subsets'       => false, 
                'letter-spacing'=> true,  
                'all_styles'  => true,
				'font-backup' => true,
				'word-spacing' => true,
                'units'       => 'px',
                'default'     => array(
                    'font-style'  => '700',
                    'font-family' => 'Dosis',
                    'google'      => true,
                    'font-size'   => '24',
                    'line-height' => '30',
					'text-transform' => 'none',
					'letter-spacing' => '0',
					'color' => '#222222',
                ),
            ),
			array (
				'subtitle' => esc_html__('The \'Custom Font Name\' already added to the site through third-party plugins or custom coding.', 'manual'),
				'desc' => esc_html__('Adding a name changes the H4 font to a custom font.', 'manual'),
				'id' => 'custom-h4-font',
				'type' => 'text',
				'title' => esc_html__('Font family name', 'manual'),
			),
			
			// H5
			array(
                'id'          => 'theme-h5-typography',
                'type'        => 'typography',
                'title'       => esc_html__( 'H5', 'manual' ),
				'subtitle'    => esc_html__( 'Set Heading 5 options', 'manual' ),
                'google'      => true,
                'font-backup' => false,
				'text-align' => false,
				'text-transform' => true,
                'subsets'       => false, 
                'letter-spacing'=> true,  
                'all_styles'  => true,
				'font-backup' => true,
				'word-spacing' => true,
                'units'       => 'px',
                'default'     => array(
                    'font-style'  => '700',
                    'font-family' => 'Dosis',
                    'google'      => true,
                    'font-size'   => '19',
                    'line-height' => '23',
					'text-transform' => 'none',
					'letter-spacing' => '0',
					'color' => '#222222',
                ),
            ),
			array (
				'subtitle' => esc_html__('The \'Custom Font Name\' already added to the site through third-party plugins or custom coding.', 'manual'),
				'desc' => esc_html__('Adding a name changes the H5 font to a custom font.', 'manual'),
				'id' => 'custom-h5-font',
				'type' => 'text',
				'title' => esc_html__('Font family name', 'manual'),
			),
			
			// H6
			array(
                'id'          => 'theme-h6-typography',
                'type'        => 'typography',
                'title'       => esc_html__( 'H6', 'manual' ),
				'subtitle'    => esc_html__( 'Set Heading 6 options', 'manual' ),
                'google'      => true,
                'font-backup' => false,
				'text-align' => false,
				'text-transform' => true,
                'subsets'       => false, 
                'letter-spacing'=> true,  
                'all_styles'  => true,
				'font-backup' => true,
				'word-spacing' => true,
                'units'       => 'px',
                'default'     => array(
                    'font-style'  => '700',
                    'font-family' => 'Dosis',
                    'google'      => true,
                    'font-size'   => '16',
                    'line-height' => '20',
					'text-transform' => 'none',
					'letter-spacing' => '0',
					'color' => '#222222',
                ),
            ),
			array (
				'subtitle' => esc_html__('The \'Custom Font Name\' already added to the site through third-party plugins or custom coding.', 'manual'),
				'desc' => esc_html__('Adding a name changes the H6 font to a custom font.', 'manual'),
				'id' => 'custom-h6-font',
				'type' => 'text',
				'title' => esc_html__('Font family name', 'manual'),
			),
			
        )
    ) );

		
		
		
/***************************
*******  THEME WIDGET  *****
****************************/
		
		Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Theme - Widget', 'manual' ),
		'id'     => 'manual-theme-widget-style',
		'icon'   => 'el el-website',
		'fields' => array(
			array(
				'id'       => 'theme_widget_sticky_sidebar',
				'type'     => 'switch',
				'title'    => esc_html__( 'Sticky sidebar', 'manual' ),
				'default'  => false,
				'subtitle' => esc_html__( 'Keep your sidebar sticky in one place.', 'manual' ),
				'on' => esc_html__( 'Enable', 'manual' ),
				'off' => esc_html__( 'Disable', 'manual' ),
			),
			array(
				'id'       => 'theme_widget_display_style_global',
				'type'     => 'select',
				'title'    => esc_html__( 'Sidebar style', 'manual' ),
				'subtitle' => esc_html__( 'Choose the appearance for your sidebar design.', 'manual' ),
				'options'  => array(
					'1' => esc_html__('Style 1', 'manual' ),
					'2' => esc_html__('Style 2', 'manual' ),
				),
				'default'  => '1'
			),	
			array(
				'id'       => 'theme_widget_width_size_global',
				'type'     => 'select',
				'title'    => esc_html__( 'Sidebar width', 'manual' ),
				'subtitle' => esc_html__( 'Change the width of the sidebar.', 'manual' ),
				'desc'     => __( 'The sidebar width settings do not apply to the shop, course, and documentation pages. You can manage the sidebar width for the documentation section in the "Theme Options > Documentation > Single/Category Page" settings.', 'manual' ),
				'options'  => array(
					'1' => esc_html__('25%','manual' ),
					'2' => esc_html__('33.3%','manual' ),
				),
				'default'  => '2'
			),	
			array(
				'id'       => 'theme_widget_title_tag',
				'type'     => 'select',
				'title'    => esc_html__( 'Tag', 'manual' ),
				'subtitle'    => esc_html__( 'Title tag for the sidebar.', 'manual' ),
				'options'  => array(
					'h4' => esc_html__('h4', 'manual' ),
					'h5' => esc_html__('h5', 'manual' ),
					'h6' => esc_html__('h6', 'manual' ),
				),
				'default'  => 'h5', 
			),
		)
		) );

/*******************************
*******  ARCHIVE PAGE    *******
********************************/
Redux::setSection( $opt_name, array(
        'title'            => esc_html__( 'Theme - Archive', 'manual' ),
        'id'               => 'archive-page-settings',
        'customizer_width' => '450px',
		'icon'             => 'el el-edit',
        'fields'           => array(
			// Archive Page Settings
			array(
				'id'       => 'archive-page-title',
				'type'     => 'switch',
				'title'    => esc_html__( 'Title and description', 'manual' ),
				'subtitle'    => esc_html__( 'Show/Hide the title and description that show up below the page title but above the content', 'manual' ),
				'default'  => false,
				'on' => esc_html__( 'Show', 'manual' ),
				'off' => esc_html__( 'Hide', 'manual' ),
			),
			// EOF - Archive Page Settings
		)
) );
	
/*******************************************
*******  THEME OPTIONS  - CUSTOM STYLE *****
********************************************/

		Redux::setSection( $opt_name, array(
			'title'            => esc_html__( 'Header Menu', 'manual' ),
			'id'               => 'manual-theme-menu-custom-style',
			'customizer_width' => '400px',
			'icon'             => 'el el-lines'
		) );
		
		// HEADER MENU TYPE STYLE
		Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Main Header', 'manual' ),
		'id'     => 'manual-theme-navigation-style',
		'subsection'  => true,
		'fields' => array(
						  
				array(
					'id'       => 'theme-nav-type',
					'type'     => 'image_select',
					'title'    => esc_html__( 'Menu style', 'manual' ),
					'subtitle' => esc_html__( 'Choose a header navigation style in either transparent or white', 'manual' ),
					'options'  => array(
						'1' => array( 'img' => trailingslashit(get_template_directory_uri()) .'framework/ReduxCore/manual/1.jpg' ),
						'2' => array( 'img' => trailingslashit(get_template_directory_uri()) .'framework/ReduxCore/manual/2.jpg' ),
					),
					'default'  => '1',
				),
				array(
					'id'       => 'theme-global-menu-type',
					'type'     => 'image_select',
					'title'    => esc_html__( 'Menu position', 'manual' ),
					'subtitle' => esc_html__( 'Choose the position for displaying the menu.', 'manual' ),
					'desc' => __( ' <strong style="color:#e6614b;">IMPORTANT:</strong> If you choose "Main Menu - Position no 4," which centers the logo and menu, the "Header - Main Menu Section" Widget in the Appearance > Widget section will not function on the header.', 'manual' ),
					'options'  => array(
						'1' => array( 'img' => trailingslashit(get_template_directory_uri()) .'framework/ReduxCore/manual/menu1.png' ),
						'2' => array( 'img' => trailingslashit(get_template_directory_uri()) .'framework/ReduxCore/manual/menu2.png' ),
						'3' => array( 'img' => trailingslashit(get_template_directory_uri()) .'framework/ReduxCore/manual/menu3.png' ),
						'4' => array( 'img' => trailingslashit(get_template_directory_uri()) .'framework/ReduxCore/manual/menu4.png' ),
					),
					'default'  => '1',
				),
				// hamburger menu - start {show/hidden controls}
				array(
					'id'       => 'activate-hamburger-menu',
					'type'     => 'switch',
					'title'    => esc_html__( 'Hamburger menu', 'manual' ),
					'default'  => false,
					'subtitle' => esc_html__('If you turn it on, the regular menu will be replaced by the hamburger menu.', 'manual' ),
					'on' => esc_html__( 'Enable', 'manual' ),
					'off' => esc_html__( 'Disable', 'manual' ),
					'required' => array('theme-global-menu-type','!=','4'), 
				),
				array(
					'id'    => 'hamburger-menu-extra-settings',
					'type'  => 'tabbed',
					'required' => array(
									array('theme-global-menu-type','!=','4'), 
									array('activate-hamburger-menu','equals',true),
									),
					'tabs'  => array(
								array(
								'title'  => esc_html__( 'Hamburger Menu Settings', 'manual' ),
									'fields' => array(
										array(
											'id'            => 'first-level-hamburger-menu-top-margin',
											'type'          => 'slider',
											'title'         => esc_html__( 'Top margin', 'manual' ),
											'default'       => 32,
											'min'           => 1,
											'step'          => 1,
											'max'           => 90,
											'display_value' => 'label',
											'subtitle' => esc_html__('Default: 32','manual' ),
											'display_value' => 'text',
											'desc'         => __( '<strong style="color:#e6614b;">If required,</strong> re-adjust \'top margin\' based on the seleted <strong>\'main menu height\'</strong> (manual options > main menu - style).', 'manual' ),
										),
									
									),
								),
								array(
									'title'  => esc_html__( 'Search Box On Hamburger Menu', 'manual' ),
									'fields' => array(
										array(
											'id'       => 'activate-search-box-on-menu-bar',
											'type'     => 'switch',
											'title'    => esc_html__( 'Search bar', 'manual' ),
											'default'  => false,
											'required' => array('activate-hamburger-menu','equals',true),
											'desc' => esc_html__('If enable, the live search bar will appear on the main menu bar.','manual' ),
											'on' => esc_html__( 'Enable', 'manual' ),
											'off' => esc_html__( 'Disable', 'manual' ),
										),
										array(
											'id'       => 'replace-search-design-with-modern-bar',
											'type'     => 'switch',
											'title'    => esc_html__( 'Standard search', 'manual' ),
											'default'  => false,
											'required' => array('activate-search-box-on-menu-bar','equals',true),
											'desc' => esc_html__('If activated, the live search will be disabled.','manual' ),
										),
										// Design control
										array(
											'id'            => 'main-menubar-searchbox-font-size',
											'type'          => 'slider',
											'title'         => esc_html__( 'Font size', 'manual' ),
											'default'       => 14,
											'min'           => 1,
											'step'          => 1,
											'max'           => 30,
											'display_value' => 'label',
											'subtitle' => esc_html__('Default: 14','manual' ),
											'display_value' => 'text',
											'required' => array('activate-search-box-on-menu-bar','equals',true),
										),
										array(
											'id'            => 'main-menubar-searchbox-top-margin',
											'type'          => 'slider',
											'title'         => esc_html__( 'Top margin', 'manual' ),
											'default'       => 7,
											'min'           => 1,
											'step'          => 1,
											'max'           => 20,
											'display_value' => 'label',
											'subtitle' => esc_html__('Default: 7','manual' ),
											'display_value' => 'text',
											'desc'      => __( '<strong style="color:#e6614b;">If required,</strong> re-adjust \'top margin\'', 'manual' ),
											'required' => array('activate-search-box-on-menu-bar','equals',true),
										),
										array(
											'id'       => 'main-menubar-searchbox-design-bgcolor',
											'type'     => 'color_rgba',
											'title'    => esc_html__( 'Background color', 'manual' ),
											'default'  => array(
												'color' => '#ffffff',
												'alpha' => 0.9,
											),
											'mode'     => 'background',
											'required' => array('activate-search-box-on-menu-bar','equals',true),
											'desc' => esc_html__('Search bar background color','manual' ),
										),
										array(
											'id'       => 'main-menubar-searchbox-placeholder-text-color',
											'type'     => 'color',
											'transparent'  => false,
											'title'    => esc_html__( 'Text color', 'manual' ),
											'desc'    => esc_html__( 'Color of the placeholder text in the search box.', 'manual' ),
											'default'  => '#888888',
											'required' => array('activate-search-box-on-menu-bar','equals',true),
										),
										array(
											'id'       => 'main-menubar-searchbox-border-color',
											'type' => 'border',
											'title'    => esc_html__( 'Border color', 'manual' ),
											'required' => array('activate-search-box-on-menu-bar','equals',true),
											'desc'    => esc_html__( 'Apply a border to the search box.', 'manual' ),
											'color_alpha'  => true,
										),
									),
								),
					),
				),
				array(
					'id'            => 'theme-nav-type-style-all-height',
					'type'          => 'slider',
					'title'         => esc_html__( 'Header height', 'manual' ),
					'default'       => 92,
					'min'           => 1,
					'step'          => 1,
					'max'           => 150,
					'display_value' => 'label',
					'desc' => esc_html__('Default: 92px', 'manual' ),
					'display_value' => 'text',
					'subtitle'         => __( 'Height of the navigation menu.', 'manual' ),
					'required' => array( array('theme-global-menu-type','!=','3'), array('theme-global-menu-type','!=','4') ),
				),
				array(
					'id'       => 'apply-nav-background-colorbg',
					'type'     => 'color_rgba',
					'title'    => esc_html__( 'Background color', 'manual' ),
					'subtitle'    => esc_html__( 'Set the header background.', 'manual' ),
					'default'  => array(
									'color' => '#ffffff',
									'alpha' => '0'
								),
				),
				array(
					'id'       => 'theme-global-menu-type-border-top-color',
					'type' => 'border',
					'title'    => esc_html__( 'Border top color', 'manual' ),
					'required' => array( array('theme-global-menu-type','!=','1'), array('theme-global-menu-type','!=','2') ),
					'subtitle'    => esc_html__( 'Apply a top border to the selected \'Menu position\'.', 'manual' ),
					'color_alpha'  => true,
					'left'  => false,
					'right'  => false,
					'bottom'  => false,
					'output'   => array( '.navbar-collapse.collapse' ),
				),
				array(
					'id'       => 'main-nav-border-btm',
					'type'     => 'border',
					'title'    => esc_html__( 'Header border bottom', 'manual' ),
					'subtitle' => esc_html__('Apply header border bottom', 'manual'),
					'color_alpha'  => true,
					'left'  => false,
					'right'  => false,
					'top'  => false,
					'output'   => array( '.navbar' ),
				),
				array(
					'id'       => 'header-navbar-box-shadow-status',
					'type'     => 'switch',
					'title'    => esc_html__( 'Header shadow', 'manual' ),
					'subtitle' => esc_html__('A shadow will be displayed beneath the navigation bar', 'manual'),
					'default'  => true,
					'on' => esc_html__( 'Enable', 'manual' ),
					'off' => esc_html__( 'Disable', 'manual' ),
				),
				array(
					'id'       => 'header-bar-bottom-box-shadow',
					'type'     => 'box_shadow',
					'checked'  => false,
					'output'   => array( '.navbar' ),
					'title'    => esc_html__( 'Header bar shadow', 'manual' ),
					'required' => array('header-navbar-box-shadow-status','equals',true),
					'default'  => array(
						'drop-shadow' => array(
							'horizontal' => 0,
							'vertical' => 2,
							'blur' => 9,
							'spread' => -1,
							'color' => '#f2f2f2',
						),
					),
					
				),
				// Menu First Level Settings
				array(
					'id'       => 'menu-first-level-settings',
					'type'     => 'section',
					'title'    => esc_html__( 'Menu (First Level) Settings', 'manual' ),
					'indent'   => true, 
				),
				array(
					'id'       => 'first-level-menu-icon',
					'type'     => 'switch',
					'title'    => esc_html__( 'Navigation Arrow', 'manual' ),
					'default'  => true,
					'subtitle' => esc_html__( 'If a submenu is found, a down arrow icon will be displayed', 'manual' ),
					'on' => esc_html__( 'Enable', 'manual' ),
					'off' => esc_html__( 'Disable', 'manual' ),
				),
				array(
					'id'       => 'theme-typography-nav',
					'type'     => 'typography',
					'title'    => esc_html__( 'Menu typography', 'manual' ),
					'subtitle' => esc_html__('Set menu text options.', 'manual' ),
					'google'      => true,
					'font-backup' => true,
					'text-align' => false,
					'text-transform' => true,
					'subsets'       => false, 
					'letter-spacing'=> true,
					'word-spacing' => true,  
					'all_styles'  => true,
					'color' => false,
					'line-height' => false,
					'units'  => 'px',
					'default'  => array(
						'font-family' => 'Raleway',
						'google'      => true,
						'font-size' => '13px',
						'letter-spacing' => '0.9px',
						'text-transform' => 'uppercase',
						'font-weight'  => '600',
					),
					'output'   => array( '.navbar-inverse .navbar-nav>li>a' ),
				),
				array(
					'id'       => 'first-level-menu-text-color',
					'type'     => 'link_color',
					'title'    => esc_html__( 'Link color', 'manual' ),
					'subtitle' => esc_html__('Text color for the first level of the navigation menu.', 'manual'),
					'active'    => false, 
					'visited'   => false, 
					'default'  => array(
						'regular' => '#181818',
						'hover'   => '#5e5e5e',
						'active'  => '#ccc',
					),
				),
				array(
					'id'       => 'first-level-menu-active-text-color',
					'type'     => 'link_color',
					'title'    => esc_html__( 'Highlight current page', 'manual' ),
					'subtitle' => esc_html__('Select color to highlight current page menu item.', 'manual'),
					'active'    => false, 
					'visited'   => false, 
					'hover'   => false, 
				),
				/*** 
				*** - Menu Inner Level  *****
				***/
				array(
					'id'       => 'menu-inner-level',
					'type'     => 'section',
					'title'    => esc_html__( 'Menu (Inner Levels) Settings', 'manual' ),
					'indent'   => true, 
				),
				array(
					'id'       => 'menu-inner-level-background-color',
					'type'     => 'color',
					'title'    => esc_html__( 'Dropdown background color', 'manual' ),
					'subtitle' => esc_html__('Set the dropdown menu background color.', 'manual'),
					'default'  => '#262626',
				),
				array(
					'id'       => 'menu-inner-level-text-color',
					'type'     => 'link_color',
					'title'    => esc_html__( 'Link color', 'manual' ),
					'subtitle' => esc_html__('Text color for the inner level of the navigation menu.', 'manual'),
					'active'    => false, 
					'visited'   => false, 
					'default'  => array(
						'regular' => '#9d9d9d',
						'hover'   => '#FFFFFF',
						'active'  => '#ccc',
					),
				),
				array(
					'id'       => 'menu-inner-level-active-text-color',
					'type'     => 'link_color',
					'title'    => esc_html__( 'Highlight current page', 'manual' ),
					'subtitle' => esc_html__('Select color to highlight current page menu item.', 'manual'),
					'active'    => false, 
					'visited'   => false, 
					'hover'   => false, 
					'default'  => array(
						'regular' => '#FFFFFF',
					),
				),
				array(
					'id'       => 'menu-inner-level-border-radius',
					'type'     => 'text',
					'title'    => esc_html__( 'Border radius', 'manual' ),
					'subtitle' => esc_html__( 'The border radius of the inner level', 'manual' ),
					'desc' => __('Example: 0px 0px 0px 0px (top, right, bottom, left)', 'manual' ),
					'default'  => '0px 0px 0px 0px',
				),
				array(
					'id'       => 'theme-inner-level-typography-nav',
					'type'     => 'typography',
					'title'    => esc_html__( 'Dropdown menu typography', 'manual' ),
					'subtitle' => esc_html__('Set the dropdown menu text options', 'manual' ),
					'google'      => true,
					'font-backup' => true,
					'text-align' => false,
					'text-transform' => true,
					'subsets'       => false, 
					'letter-spacing'=> true,
					'word-spacing' => true,  
					'all_styles'  => true,
					'color' => false,
					'units'  => 'px',
					'default'  => array(
						'font-family' => 'Raleway',
						'google'      => true,
						'font-size' => '11px',
						'letter-spacing' => '0.9px',
						'text-transform' => 'uppercase',
						'font-weight'  => '600',
						'line-height' => '16px',
					),
					'output'   => array( '#navbar ul li > ul li a' ),
				),
			)
		) );

		// RESPONSIVE MENU
		Redux::setSection( $opt_name, array(
        'title'  => esc_html__( 'Responsive Main Header', 'manual' ),
        'id'     => 'manual-theme-responsive-layout-settings',
		'subsection'  => true,
        'fields' => array(
		
			array(
				'id'       => 'theme-responsive-bar-icon-replacement',
				'type'     => 'switch',
				'subtitle'    => esc_html__( 'Change the hamburger icon with text, such as \'Menu,\' for the responsive layout.', 'manual' ),
				'default'  => false,
				'title' => esc_html__( 'Hamburger icon to \'text\'', 'manual' ),
			),
			array (
				'id' => 'theme-responsive-bar-icon-replacement-text',
				'type' => 'text',
				'title' => esc_html__('Text', 'manual'),
				'default' => 'Menu',
				'subtitle'    => esc_html__( 'The words will be used instead of the hamburger menu icon.', 'manual' ),
				'required' => array('theme-responsive-bar-icon-replacement','equals','1'),
				'class' => 'theme-option-text-align-right',
			),
			array(
				'id'       => 'responsive-bar-icon-replacement-text-typography',
				'type'     => 'typography',
				'title'    => esc_html__( 'Text typography', 'manual' ),
				'subtitle' => esc_html__('Set the typography for the words', 'manual' ),
				'google'      => true,
				'font-backup' => true,
				'text-align' => false,
				'text-transform' => true,
				'subsets'       => false, 
				'letter-spacing'=> true,
				'word-spacing' => true,  
				'all_styles'  => true,
				'units'  => 'px',
				'default'  => array(
					'font-family' => 'Raleway',
					'google'      => true,
					'font-size' => '12px',
					'letter-spacing' => '0.9px',
					'text-transform' => 'uppercase',
					'font-weight'  => '600',
					'line-height' => '16px',
					'color' => '#ffffff',
				),
				'output'   => array( '.navbar-inverse i.navbar-toggle' ),
				'required' => array('theme-responsive-bar-icon-replacement','equals','1'),
				'class' => 'theme-option-text-align-right',
			),
			array(
				'id'       => 'responsive-bar-icon-replacement-text-botton-bg-color',
				'type'     => 'link_color',
				'title'    => esc_html__( 'Botton color', 'manual' ),
				'subtitle'  => esc_html__('Botton background color', 'manual'),
				'active'    => false, 
				'visited'   => false, 
				'default'  => array(
							'regular' => '#333333',
							'hover'   => '#001040',
						),
				'required' => array('theme-responsive-bar-icon-replacement','equals','1'),
				'class' => 'theme-option-text-align-right',
			),
			array(
				'id'   => 'responsive-bar-icon-replacement-text-botton-padding',
				'type' => 'spacing',
				'mode' => 'padding',
				'units_extended' => 'false',
				'title' => esc_html__( 'Padding', 'manual' ),
				'subtitle' => esc_html__('Adjust button padding', 'manual'),
				'required' => array('theme-responsive-bar-icon-replacement','equals','1'),
				'output'   => array( '.navbar-inverse i.navbar-toggle' ),
				'class' => 'theme-option-text-align-right',
				'default'            => array(
					'padding-top'     => '10px', 
					'padding-right'   => '10px', 
					'padding-bottom'  => '10px', 
					'padding-left'    => '10px',
				),
			),
			array(
				'id'            => 'mobile-menu-height',
				'type'          => 'slider',
				'title'         => esc_html__( 'Header height', 'manual' ),
				'default'       => 92,
				'min'           => 1,
				'step'          => 1,
				'max'           => 150,
				'display_value' => 'label',
				'desc'          => esc_html__('Default: 92px', 'manual' ),
				'display_value' => 'text',
				'subtitle'      => __( 'Height of the mobile navigation menu <span style="color:red;">(Works only on mobile devices)</span>', 'manual' ),
			),
			array(
				'id'            => 'first-level-responsive-hamburger-menu-top-margin',
				'type'          => 'slider',
				'title'         => esc_html__( 'Icon top margin', 'manual' ),
				'default'       => 18,
				'min'           => 1,
				'step'          => 1,
				'max'           => 30,
				'display_value' => 'label',
				'subtitle'      => esc_html__('Modify the hamburger icon position according to the chosen header height.', 'manual' ),
				'display_value' => 'text',
				'desc'          => __( 'Default: 18px', 'manual' ),
			),
			array(
				'id'       => 'mobile-bgackground-holder',
				'type'     => 'section',
				'title'    => esc_html__( 'Controls', 'manual' ),
				'indent'   => true, 
			),
			array(
				'id'       => 'mobile-mainheader-flip-logo',
				'type'     => 'switch',
				'title'    => esc_html__( 'Flip logo', 'manual' ),
				'subtitle' => esc_html__('Switch from the \'primary logo\' to the \'secondary logo,\' if necessary.', 'manual'),
				'default'  => false,
			),
			array(
				'id'       => 'mobile-bgackground-holder-headerbackground-color',
				'type'     => 'color',
				'transparent' => false,
				'title'    => esc_html__( 'Menu bar background', 'manual' ),
				'subtitle' => esc_html__( 'Set the mobile menu bar background', 'manual' ),
				'default'  => '#FFFFFF',
			),
			array(
				'id'       => 'mobile-bar-hamburgur-icon-bg',
				'type'     => 'link_color',
				'title'    => esc_html__( 'Botton color', 'manual' ),
				'subtitle'  => esc_html__('Background color of the hamburger button', 'manual'),
				'visited'   => false, 
				'default'  => array(
							'regular' => '#47C494',
							'hover'   => '#333333',
							'active'   => '#ffffff',
						),
			),
			array(
				'id'       => 'mobile-bgackground-holder-background-color',
				'type'     => 'color',
				'transparent' => false,
				'title'    => esc_html__( 'Dropdown background', 'manual' ),
				'subtitle'    => esc_html__( 'Change the background color of the dropdown menu', 'manual' ),
				'default'  => '#F9F9F9',
			),
			
			array(
				'id'       => 'mobile-menu-border-btm-li-color',
				'type'     => 'color_rgba',
				'title'    => esc_html__( 'Menu separator color', 'manual' ),
				'subtitle'    => esc_html__( 'Modify the color of the menu separator in the dropdown menu.', 'manual' ),
				'default'  => array(
								'color' => '#f1f1f1',
								'alpha' => '0.9'
							),
			),
			// Responsive - First level
			array(
				'id'       => 'mobile-menu-first-level',
				'type'     => 'section',
				'title'    => esc_html__( 'Responsive Menu (First Level) Settings', 'manual' ),
				'indent'   => true, 
			),
			array(
				'id'       => 'mobile-menu-first-level-typography',
				'type'     => 'typography',
				'title'    => esc_html__( 'Menu typography', 'manual' ),
				'subtitle' => esc_html__('Set menu text options.', 'manual' ),
				'google'      => true,
				'font-backup' => true,
				'text-align' => false,
				'text-transform' => true,
				'subsets'       => false, 
				'letter-spacing'=> true,
				'word-spacing' => true,  
				'all_styles'  => true,
				'color' => false,
				'line-height' => true,
				'units'  => 'px',
				'default'  => array(
					'font-family' => 'Raleway',
					'google'      => true,
					'font-size' => '12px',
					'letter-spacing' => '0.9px',
					'text-transform' => 'uppercase',
					'font-weight'  => '700',
					'line-height' => '22px',
				),
				'output'   => array( '.mobile-menu-holder li a' ),
			),
			array(
				'id'       => 'mobile-first-level-menu-text-color',
				'type'     => 'link_color',
				'title'    => esc_html__( 'Link color', 'manual' ),
				'active'    => false, 
				'visited'   => false, 
				'default'  => array(
					'regular' => '#5B5B5B',
					'hover'   => '#47c494',
				),
				'subtitle' => esc_html__('Text color for the first level of the navigation menu.', 'manual' ),
			), 
			// Responsive - Inner level
			array(
				'id'       => 'mobile-menu-inner-level',
				'type'     => 'section',
				'title'    => esc_html__( 'Responsive Menu (Inner Levels) Settings', 'manual' ),
				'indent'   => true, 
			),
			array(
				'id'       => 'mobile-menu-inner-level-text-typography',
				'type'     => 'typography',
				'title'    => esc_html__( 'Inner menu typography', 'manual' ),
				'subtitle' => esc_html__('Set the inner dropdown menu text options', 'manual' ),
				'google'      => true,
				'font-backup' => true,
				'text-align' => false,
				'text-transform' => true,
				'subsets'       => false, 
				'letter-spacing'=> true,
				'word-spacing' => true,  
				'all_styles'  => true,
				'color' => false,
				'units'  => 'px',
				'default'  => array(
					'font-family' => 'Raleway',
					'google'      => true,
					'font-size' => '11px',
					'letter-spacing' => '0.9px',
					'text-transform' => 'uppercase',
					'font-weight'  => '600',
					'line-height' => '22px',
				),
				'output'   => array( '.mobile-menu-holder li > ul li a' ),
			),
			array(
				'id'       => 'mobile-menu-inner-level-text-color',
				'type'     => 'link_color',
				'title'    => esc_html__( 'Link color', 'manual' ),
				'active'    => false, 
				'visited'   => false, 
				'default'  => array(
					'regular' => '#656464',
					'hover'   => '#47c494',
				),
				'subtitle' => esc_html__('Text color for the inner level of the navigation menu.', 'manual' ),
			),
		)
		) );
		
		// STICKY MENU
		Redux::setSection( $opt_name, array(
			'title'            => esc_html__( 'Sticky Header', 'manual' ),
			'id'               => 'theme_sticky_menu_settings',
			'subsection'       => true,
			'customizer_width' => '450px',
			'fields'           => array(
										
					// Sticky Menu
					array(
						'id'       => 'theme-sticky-menu',
						'type'     => 'switch',
						'title'    => esc_html__( 'Sticky header', 'manual' ),
						'default'  => false,
						'subtitle' => esc_html__( 'Set the header to fixed on top after scroll', 'manual' ),
						'on' => esc_html__( 'Enable', 'manual' ),
						'off' => esc_html__( 'Disable', 'manual' ),
					),
					array(
						'id'       => 'theme-logo-readjust-sticky-height',
						'type'     => 'dimensions',
						'units'    => array('px'),
						'title'    => esc_html__('Logo height', 'manual'),
						'subtitle' => esc_html__( 'Set the header logo height', 'manual' ),
						'desc'     => esc_html__('Default: 27px', 'manual'),
						'width'     => false,
						'required' => array('theme-sticky-menu','equals',true),
						'class' => 'theme-option-text-align-right',
						'default'  => array(
							'Height'  => '27'
							)
					),
					array(
						'id'       => 'theme-logo-readjust-sticky-margin-top',
						'type'     => 'dimensions',
						'class' => 'theme-option-text-align-right',
						'units'    => array('px'),
						'title'    => esc_html__('Logo top margin', 'manual'),
						'subtitle' => esc_html__( 'Top margin of the logo', 'manual' ),
						'desc'     => esc_html__('Default: -18px', 'manual'),
						'width'     => false,
						'required' => array('theme-sticky-menu','equals',true),
						'default'  => array(
							'Height'  => '-18px'
							)
					),
					array(
						'id'            => 'theme-logo-readjust-sticky-hamburger-menu-top-margin',
						'type'          => 'slider',
						'title'         => esc_html__( 'Hamburger menu top margin', 'manual' ),
						'class' => 'theme-option-text-align-right',
						'default'       => 26,
						'min'           => 1,
						'step'          => 1,
						'max'           => 90,
						'display_value' => 'label',
						'desc' => esc_html__('Default: 26px','manual' ),
						'display_value' => 'text',
						'subtitle'      => esc_html__( 'Adjust the margin of the hamburger menu for the sticky menu bar.', 'manual' ),
						'required' => array('theme-sticky-menu','equals',true),
					),
					
					array(
						'id'        => 'theme_sticky_menu_background',
						'type'      => 'color_rgba',
						'title'    => esc_html__( 'Menu background color', 'manual' ),
						'class' => 'theme-option-text-align-right',
						'subtitle'      => esc_html__( 'Set the sticky menu bar background', 'manual' ),
						'required' => array('theme-sticky-menu','equals',true),
						'default'   => array(
							'color'     => '#fefefe',
							'alpha'     => 0.9
						),
						'options'       => array(
							'choose_text'               => esc_html__('Choose','manual' ),
							'cancel_text'               => esc_html__('Cancel', 'manual' ),
							'palette'                   => null,  // show default
							'input_text'                => esc_html__('Select Color', 'manual' ),
						),                        
					),
					array(
						'id'       => 'theme_sticky_menu_text_color',
						'type'     => 'link_color',
						'title'    => esc_html__( 'Link color', 'manual' ),
						'class' => 'theme-option-text-align-right',
						'subtitle' => esc_html__( 'Text color for the sticky menu menu.', 'manual' ),
						'active'    => false, 
						'visited'   => false, 
						'required' => array('theme-sticky-menu','equals',true),
						'default'  => array(
							'regular' => '#181818',
							'hover'   => '#47c494',
						),
					),
					array(
						'id'       => 'theme_sticky_white_logo',
						'type'     => 'switch',
						'title'    => esc_html__( 'Secondary logo', 'manual' ),
						'class' => 'theme-option-text-align-right',
						'default'  => false,
						'required' => array('theme-sticky-menu','equals',true),
						'subtitle' => esc_html__( 'Swap the primary logo with the secondary logo.', 'manual' ),
						'desc' => __( 'Please, ensure the secondary logo is not blank in \'Theme Options > Logo\'.', 'manual' ),
					),
					array(
						'id'       => 'theme_sticky_spacing_padding',
						'type' => 'spacing',
						'title'    => esc_html__( 'Sticky bar padding', 'manual' ),
						'class' => 'theme-option-text-align-right',
						'required' => array('theme-sticky-menu','equals',true),
						'subtitle' => esc_html__( 'Adjust the top and bottom padding of the sticky bar.', 'manual' ),
						'output'    => array('body.home nav.navbar.after-scroll-wrap, body nav.navbar.after-scroll-wrap'),
						'units'   => array('px'),
						'mode'    => 'padding',
						'left'    => false,
						'right'    => false,
					),
			
			)
		) );
		
		
/***************************************
*******  POST TYPE - CUSTOM HEADER *****
****************************************/

		// DEFAULT THEME HEADER
		Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Page Title Bar (Default)', 'manual' ),
		'id'     => 'manual-theme-default-theme-header',
		'icon'             => 'el el-adjust-alt',
		'fields' => array(
		
				array(
					'id'       => 'default-header-text-align',
					'type'     => 'image_select',
					'title'    => esc_html__( 'Title text align', 'manual' ),
					'subtitle' => esc_html__( 'Select the alignment of the text on the \'page title bar\'.', 'manual' ),
					'options'  => array(
						
						'left' => array(
							'alt' => 'Page Title Bar Style 1',
							'img' => trailingslashit(get_template_directory_uri()) .'framework/ReduxCore/manual/title-bar-left.png'
						),
						
						'center' => array(
							'alt' => 'Page Title Bar Style 2',
							'img' => trailingslashit(get_template_directory_uri())  . 'framework/ReduxCore/manual/title-bar-center.png'
						),
						
						'right' => array(
							'alt' => 'Page Title Bar Style 3',
							'img' => trailingslashit(get_template_directory_uri())  . 'framework/ReduxCore/manual/title-bar-right.png'
						),
						
					),
					'default'  => 'center',
				), 
				array(
					'id'       => 'default-header-sytle-height',
					'type'     => 'text',
					'title'    => esc_html__( 'Padding', 'manual' ),
					'subtitle' => esc_html__( 'Set the top/bottom spacing for page title', 'manual' ),
					'desc' => __('Example: 120px 0px 120px 0px (top, right, bottom, left) <br><br><strong style="color:#e6614b;">IMPORTANT: Make sure the value of RIGHT, LEFT is always 0px</strong>', 'manual' ),
					'default'  => '120px 0px 120px 0px',
				),
				array(
					'id'       => 'default-header-sytle-responsive-height',
					'type'     => 'text',
					'title'    => esc_html__( 'Responsive padding', 'manual' ),
					'subtitle'    => esc_html__( 'Set the top/bottom spacing for page title', 'manual' ),
					'desc' => __('Example: 100px 0px 100px 0px (top, right, bottom, left) <br><br><strong style="color:#e6614b;">IMPORTANT: Make sure the value of RIGHT, LEFT is always 0px</strong>', 'manual' ),
					'default'  => '100px 0px 100px 0px',
				),
				array(
					'id'       => 'default-header-border-radius',
					'type'     => 'text',
					'title'    => esc_html__( 'Border radius', 'manual' ),
					'subtitle' => esc_html__( 'Page title bar border radius', 'manual' ),
					'default'  => '0px 0px 0px 0px',
				),
				array(         
					'id'       => 'theme_header_page_title_bar_background',
					'type'     => 'background',
					'title'    => esc_html__( 'Background', 'manual' ),
					'subtitle' => esc_html__( 'Set the page title bar background', 'manual' ),
					'default'  => array(
									'background-color' => '#F7F7F7',
								  ),
				),
				array(
					'id'       => 'header-pagetitlebar-opacity-color',
					'type'     => 'color_rgba',
					'title'    => esc_html__( 'Background overlay', 'manual' ),
					'mode'     => 'background',
				),
				
				// Header Title
				array(
					'id'       => 'theme_header_title_customization',
					'type'     => 'section',
					'title'    => esc_html__( 'Title Font Style', 'manual' ),
					'indent'   => true, 
				),
				array(
					'id'          => 'page_title_h1_typography',
					'type'        => 'typography',
					'title'       => esc_html__( 'Title style', 'manual' ),
					'subtitle'       => esc_html__( 'Set title options', 'manual' ),
					'google'      => true,
					'font-backup' => true,
					'text-align' => false,
					'text-transform' => true,
					'subsets'       => false, 
					'letter-spacing'=> true,  
					'all_styles'  => true,
					'word-spacing' => true,
					'font-style' => false,
					'font-weight' => true,
					'margin-top' => true,
					'margin-bottom' => true,
					'units'       => 'px',
					'default'     => array(
						'font-family' => 'Dosis',
						'google'      => true,
						'font-size'   => '40px',
						'line-height' => '55px',
						'text-transform' => 'none',
						'letter-spacing' => '-1',
						'color' => '#000000',
						'word-spacing' => '0',
						'font-weight' => '700',
					),
				),
				array(
					'id'          => 'page_title_responsive_h1_typography',
					'type'        => 'typography',
					'title'       => esc_html__( 'Responsive title', 'manual' ),
					'subtitle'    => esc_html__( 'Set responsive title', 'manual' ),
					'google'      => false,
					'font-weight' => false,
					'font-style' => false,
					'font-family' => false,
					'font-backup' => false,
					'text-align'  => false,
					'text-transform' => true,
					'subsets'        => false, 
					'color'          => false, 
					'text-transform'  => false, 
					'letter-spacing' => true,  
					'all_styles'  => false,
					'word-spacing' => true,
					'units'        => 'px',
					'default'      => array(
						'font-style'  => '700',
						'google'      => false,
						'font-size'   => '28px',
						'line-height' => '28px',
						'letter-spacing' => '-1',
					),
				),
				// Sub-title
				array(
					'id'       => 'page_sub_title_typography_p_start',
					'type'     => 'section',
					'title'    => esc_html__( 'Sub Title Font Style', 'manual' ),
					'indent'   => true, 
				),
				array(
					'id'          => 'page_sub_title_div_typography',
					'type'        => 'typography',
					'title'       => esc_html__( 'Sub title style', 'manual' ),
					'subtitle'    => esc_html__( 'Set sub title options', 'manual' ),
					'output'      => array('p.inner-header-color'),
					'google'      => true,
					'font-backup' => true,
					'text-align' => false,
					'text-transform' => true,
					'subsets'       => false, 
					'letter-spacing'=> true,  
					'all_styles'  => false,
					'word-spacing' => true,
					'font-style' => true,
					'font-weight' => true,
					'margin-top' => true,
					'margin-bottom' => true,
					'units'       => 'px',
					'default'     => array(
						'font-family' => 'PT Sans',
						'google'      => true,
						'font-size'   => '19px',
						'line-height' => '20px',
						'text-transform' => 'none',
						'letter-spacing' => '',
						'color' => '#666970',
						'word-spacing' => '0',
						'font-weight'  => '500',
					),
				),
				// Breadcurmb
				array(
					'id'       => 'theme_header_breadcrumb_customization',
					'type'     => 'section',
					'title'    => esc_html__( 'Breadcrumb', 'manual' ),
					'indent'   => true, 
				),
				array(
					'id'          => 'page_title_breadcrumb_typography',
					'type'        => 'typography',
					'title'       => esc_html__( 'Breadcrumbs style', 'manual' ),
					'subtitle'    => esc_html__( 'Set breadcrumbs style', 'manual' ),
					'output'      => array('#breadcrumbs'),
					'google'      => true,
					'font-backup' => true,
					'text-align' => false,
					'text-transform' => true,
					'subsets'       => false, 
					'letter-spacing'=> true,  
					'all_styles'  => false,
					'word-spacing' => true,
					'font-style' => true,
					'font-weight' => true,
					'margin-top' => true,
					'margin-bottom' => true,
					'units'       => 'px',
					'default'     => array(
						'font-family' => 'PT Sans',
						'google'      => true,
						'font-size'   => '14px',
						'line-height' => '20px',
						'text-transform' => 'Capitalize',
						'letter-spacing' => '0px',
						'color' => '#919191',
						'word-spacing' => '0',
						'font-weight'  => '400',
					),
				),
				array(
					'id'       => 'default-top-header-breadcrumb-link-color',
					'type'     => 'link_color',
					'title'    => esc_html__( 'Linked text color', 'manual' ),
					'subtitle'    => esc_html__( 'Color of the linked text', 'manual' ),
					'active'    => false, 
					'visited'   => false, 
					'default'  => array(
						'regular' => '#919191',
						'hover'   => '#636363',
						'active'  => '#ccc',
					),
				),	
				array(
					'id'       => 'default-top-header-breadcrumb-link-seprator-color',
					'type'     => 'color_rgba',
					'title'    => esc_html__( 'Link seprator color', 'manual' ),
					'subtitle' => esc_html__('Adjust the color of breadcrumb link seprators if needed.', 'manual'),
					'default'   => array(
						'color'     => '#919191',
						'alpha'     => 1
					),
				),
				// Treanding Search
				array(
					'id'       => 'theme_header_treanding_search_customization',
					'type'     => 'section',
					'title'    => esc_html__( 'Search Bar', 'manual' ),
					'indent'   => true, 
				),
				array(
					'id'       => 'activate-search-bar-on-the-header',
					'type'     => 'switch',
					'title'    => esc_html__( 'Targeted - Search bar', 'manual' ),
					'default'  => false,
					'subtitle' => esc_html__('When activated, the search box will be visible on the specified \'post type\' within the \'page title bar.\'', 'manual' ),
					'desc'  => __('<span style="color:red;">IMPORTANT NOTE: If you want to show the search bar on the page title bar for any custom post type, except the one defined by the theme, use this option.</span>', 'manual'),
				), 
				array(
					'id'       => 'target-search-bar-display-on-the-header',
					'type'     => 'select',
					'data'     => 'post_type',
					'multi'    => true,
					'sortable' => true,
					'title'    => esc_html__( 'Target display', 'manual' ),
					'subtitle' => esc_html__( 'Choose the post type where you want the search box to appear.', 'manual' ),
					'default'  => '',
					'required' => array('activate-search-bar-on-the-header','equals',true),
					'class'  => 'theme-option-text-align-right',
				),	
				array(
					'id'       => 'theme_header_treanding_search_color',
					'type'     => 'color',
					'title'    => esc_html__( 'Title text color', 'manual' ),
					'subtitle'    => esc_html__( 'Trending search text title color', 'manual' ),
					'default'  => '#444444',
				),
				array(
					'id'       => 'theme_header_treanding_search_link_color',
					'type'     => 'link_color',
					'title'    => esc_html__( 'Link color', 'manual' ),
					'subtitle'    => esc_html__( 'The trending keyword link color', 'manual' ),
					'active'    => false, 
					'visited'   => false, 
					'default'  => array(
						'regular' => '#666666',
						'hover'   => '#47C494',
					),
				),	
		
		)
		) );
		
		
		
/*************************************
*******  START - FOOTER SECTION  *****
**************************************/

    Redux::setSection( $opt_name, array(
        'title'            => esc_html__( 'Footer', 'manual' ),
        'id'               => 'theme-footer',
        'customizer_width' => '400px',
        'icon'             => 'el el-arrow-down'
    ) );
	
	// Footer Style
    Redux::setSection( $opt_name, array(
        'title'            => esc_html__( 'Footer', 'manual' ),
        'id'               => 'footer-design-type-settings',
        'subsection'       => true,
        'customizer_width' => '450px',
        'fields'           => array(
				
				
				array(
					'id'       => 'onoff-footer-section-globally',
					'type'     => 'switch',
					'title'    => esc_html__('Footer section', 'manual' ),
					'subtitle' => __('Enable/Disable footer', 'manual'),
					'default'  => true,
					'on'       => esc_html__( 'Enable', 'manual' ),
					'off'      => esc_html__( 'Disable', 'manual' ),
				),
				array(
					'id'       => 'footer-copyright',
					'type'     => 'text',
					'title'    => esc_html__( 'Copyright', 'manual' ),
					'default'  => 'Copyright [manual-year]Y[/manual-year] SmartWpThemes.com. All Rights Reserved.',
					'subtitle' => esc_html__('Text protected by copyright', 'manual'),
					'desc'             => __('Make the year change automatically by using the shortcode given below. <div style="border:1px solid red; border-radius:5px;padding: 5px;font-weight:bold;margin-top:5px;">[manual-year]Y[/manual-year]</div>.', 'manual'),
					'required' => array('onoff-footer-section-globally','equals','1'),
				),
				array(
					'id'       => 'theme-footer-type',
					'type'     => 'image_select',
					'title'    => esc_html__( 'Footer style', 'manual' ),
					'subtitle'    => esc_html__( 'Design style for footer', 'manual' ),
					'options'  => array(
						'1' => array( 'img' => trailingslashit(get_template_directory_uri()) .'framework/ReduxCore/manual/footer1.jpg' ),
						'2' => array( 'img' => trailingslashit(get_template_directory_uri()) .'framework/ReduxCore/manual/footer2.jpg' ),
					),
					'default'  => '2',
					'class' => 'theme-option-text-align-right',
					'required' => array('onoff-footer-section-globally','equals','1'),
				),
				// widget
				array(
					'id'       => 'footer-widget-status',
					'type'     => 'switch',
					'title'    => esc_html__( 'Widget area', 'manual' ),
					'subtitle' => esc_html__( 'Enable/disable footer widget area', 'manual' ),
					'default'  => false,
					'on' => esc_html__( 'Disable', 'manual' ),
					'off' => esc_html__( 'Enable', 'manual' ),
					'class' => 'theme-option-text-align-right',
					'required' => array( 
									array('theme-footer-type','equals','2'),
									array('onoff-footer-section-globally','equals','1'),
							   ),
				),
				array(
					'id'            => 'theme_footer_noof_section_widget_area',
					'type'          => 'slider',
					'title'         => esc_html__( 'Footer layout', 'manual' ),
					'subtitle'      => esc_html__( 'Set the footer column layout', 'manual' ),
					'default'       => 4,
					'min'           => 1,
					'step'          => 1,
					'max'           => 4,
					'display_value' => 'label',
					'class' => 'theme-option-text-align-right',
					'display_value' => 'text',
					'desc'  => __('IMPORTANT! It\'s important to adjust the \'Column\' below based on the \'Footer layout\' size selected. <br><br><span style="color:red;"><b>HOW TO ADJUST COLUMN LAYOUT?</b><br><br> Example: When setting the \'Footer layout\' to 4 and arranging all columns in a single row, the combined total of the number of columns with one, two, three, and four columns selected below should equal 12</span>', 'manual' ),
					'required' => array( 
									array('theme-footer-type','equals','2'),
									array('onoff-footer-section-globally','equals','1'),
									array('footer-widget-status','equals',false),
							   ),
				),
				array(
					'id'            => 'footer_one_widget_column',
					'type'          => 'slider',
					'title'         => esc_html__( 'One column', 'manual' ),
					'subtitle'      => esc_html__( 'Widget column one', 'manual' ),
					'default'       => 3,
					'min'           => 0,
					'step'          => 1,
					'max'           => 12,
					'display_value' => 'label',
					'display_value' => 'text',
					'class' => 'theme-option-text-align-right',
					'required' => array('theme_footer_noof_section_widget_area','greater_equal','1'),
				),
				array(
					'id'            => 'footer_two_widget_column',
					'type'          => 'slider',
					'title'         => esc_html__( 'Two column', 'manual' ),
					'subtitle'      => esc_html__( 'Widget column two', 'manual' ),
					'default'       => 3,
					'min'           => 0,
					'step'          => 1,
					'max'           => 12,
					'display_value' => 'label',
					'display_value' => 'text',
					'class' => 'theme-option-text-align-right',
					'required' => array('theme_footer_noof_section_widget_area','greater_equal','2'),
				),
				array(
					'id'            => 'footer_three_widget_column',
					'type'          => 'slider',
					'title'         => esc_html__( 'Three column', 'manual' ),
					'subtitle'      => esc_html__( 'Widget column three', 'manual' ),
					'default'       => 3,
					'min'           => 0,
					'step'          => 1,
					'max'           => 12,
					'display_value' => 'label',
					'display_value' => 'text',
					'class' => 'theme-option-text-align-right',
					'required' => array('theme_footer_noof_section_widget_area','greater_equal','3'),
				),
				array(
					'id'            => 'footer_four_widget_column',
					'type'          => 'slider',
					'title'         => esc_html__( 'Four column', 'manual' ),
					'subtitle'      => esc_html__( 'Widget column four', 'manual' ),
					'default'       => 3,
					'min'           => 0,
					'step'          => 1,
					'max'           => 12,
					'display_value' => 'label',
					'display_value' => 'text',
					'class' => 'theme-option-text-align-right',
					'required' => array('theme_footer_noof_section_widget_area','greater_equal','4'),
				),
				// eof- widget
				array(
					'id'       => 'footer-disable-social-icons',
					'type'     => 'switch',
					'title'    => esc_html__( 'Social icons', 'manual' ),
					'subtitle' => esc_html__( 'Enable/Disable copyright section social icons', 'manual' ),
					'class' => 'theme-option-text-align-right',
					'default'  => true,
					'required' => array( 
									array('theme-footer-type','equals','2'),
									array('onoff-footer-section-globally','equals','1'),
							   ),
					'on' => esc_html__( 'Disable', 'manual' ),
					'off' => esc_html__( 'Enable', 'manual' ),
				),
				array(
					'id'       => 'footer-disable-copyright-section',
					'type'     => 'switch',
					'title'    => esc_html__( 'Navigation menu and copyright text', 'manual' ),
					'subtitle'    => esc_html__( 'Enable/Disable copyright section link and text', 'manual' ),
					'default'  => false,
					'required' => array( 
									array('theme-footer-type','equals','2'),
									array('onoff-footer-section-globally','equals','1'),
							   ),
					'class' => 'theme-option-text-align-right',
					'on' => esc_html__( 'Disable', 'manual' ),
					'off' => esc_html__( 'Enable', 'manual' ),
				),
				// Widget Section - Design Control
				array(
					'id'       => 'theme_footer_widget_section_start',
					'type'     => 'section',
					'title'    => esc_html__( 'Widget Section', 'manual' ),
					'indent'   => true, 
					'required' => array( 
									array('theme-footer-type','equals','2'),
									array('onoff-footer-section-globally','equals','1'),
									array('footer-widget-status','equals',false),
							   ),
				),
				array(
					'id'             => 'theme_footer_typetwo_widget_area_padding',
					'type'           => 'spacing',
					'output'      => array('.footer-section .footer-layer-2'),
					'mode'           => 'padding',
					'units'          => array('px'),
					'units_extended' => 'false',
					'left' => false,
					'right' => false,
					'title'    => esc_html__( 'Padding', 'manual' ),
					'subtitle' => __( 'Set the footer widget top/bottom spacing', 'manual' ),
					'default'   => array(
						'padding-top'     => '60px',
						'padding-bottom'     => '20px',
					),		   
				),
				array(
					'id'       => 'theme_footer_title_tag',
					'type'     => 'select',
					'title'    => esc_html__( 'Title tag', 'manual' ),
					'subtitle'    => esc_html__( 'Title tag for widget', 'manual' ),
					'options'  => array(
						'h4' => esc_html__('h4','manual' ),
						'h5' => esc_html__('h5','manual' ),
						'h6' => esc_html__('h6','manual' ),
					),
					'default'  => 'h5', 
				),
				array(
					'id'       => 'theme_footer_widget_tag_color',
					'type'     => 'color',
					'title'    => esc_html__( 'Title color', 'manual' ),
					'subtitle'    => esc_html__( 'Color of widget title', 'manual' ),
					'default'  => '#DDDDDD',
					'transparent' => false,
					'output'    => array('.footer-widget h6, .footer-widget h5, .footer-widget h4'),
				),
				array(
					'id'       => 'theme_footer_widget_standard_color',
					'type'     => 'color',
					'title'    => esc_html__( 'Text color', 'manual' ),
					'subtitle'    => esc_html__( 'Assign a color to the text', 'manual' ),
					'default'  => '#919191',
					'transparent'  => false,
					'output'    => array('.footer-widget .textwidget, .footer-widget .textwidget p, .footer-bg .theme-social-icons li a, span.post-date'),
				),
				array(
					'id'       => 'theme_footer_widget_text_link_color',
					'type'     => 'link_color',
					'title'    => esc_html__( 'Link color', 'manual' ),
					'subtitle'    => esc_html__( 'Color of the standard "a" tag', 'manual' ),
					'active'    => false, 
					'visited'   => false, 
					'default'  => array(
						'regular' => '#919191',
						'hover'   => '#BEBCBC',
						'active'  => '#ccc',
					),
					'output'    => array('.footer-widget a'),
				),
				// Copyright Section - Design Control
				array(
					'id'       => 'theme_footer_copyright_section_start',
					'type'     => 'section',
					'title'    => esc_html__( 'Copyright Section', 'manual' ),
					'indent'   => true, 
					'required' => array('onoff-footer-section-globally','equals','1'),
				),
				array(
					'id'       => 'theme_footer_socialbg_color',
					'type'     => 'color_rgba',
					'title'    => esc_html__( 'Background color', 'manual' ),
					'subtitle' => __( 'Background color of the copyright section', 'manual' ),
					'default'   => array(
						'color'     => '#080808',
						'alpha'     => 1
					),
					'output'         => array('background' => '.footer_social_copyright, .footer-bg.footer-type-one'),
					'transparent' => false,
					'options'       => array(
						'choose_text'               => 'Choose',
						'cancel_text'               => 'Cancel',
						'palette'                   => null,  
						'input_text'                => 'Select Color'
					), 
					'required' => array( 
									array('theme-footer-type','equals','2'),
									array('onoff-footer-section-globally','equals','1'),
							   ),
				),
				array(
					'id'             => 'theme_footer_typetwo_copyright_section_padding',
					'type'           => 'spacing',
					'output'      => array('.footer-section .footer_social_copyright'),
					'mode'           => 'padding',
					'units'          => array('px'),
					'units_extended' => 'false',
					'left' => false,
					'right' => false,
					'title'    => esc_html__( 'Padding', 'manual' ),
					'subtitle' => __( 'Set the top/bottom spacing', 'manual' ),
					'required' => array( 
									array('theme-footer-type','equals','2'),
									array('onoff-footer-section-globally','equals','1'),
							   ),
				),
				array(
					'id'       => 'theme_footer_social_text_color',
					'type'     => 'color',
					'title'    => esc_html__( 'Text color', 'manual' ),
					'transparent' => false,
					'subtitle' => __( 'Assign a color to the text', 'manual' ),
					'required' => array('onoff-footer-section-globally','equals','1'),
					 'default'  => '#828282',
				),
				array(
					'id'       => 'theme_footer_social_icon_link_color',
					'type'     => 'link_color',
					'title'    => esc_html__( 'Social icon link color', 'manual' ),
					'subtitle' => __( 'Add social icons link color', 'manual' ),
					'active'    => false, 
					'visited'   => false, 
					'required' => array('onoff-footer-section-globally','equals','1'),
					'default'  => array(
						'regular' => '#7E7E7E',
						'hover'   => '#FFFFFF',
						'active'  => '#ccc',
					),
				),
				array(
					'id'       => 'theme_footer_social_link_color',
					'type'     => 'link_color',
					'title'    => esc_html__( 'Link color', 'manual' ),
					'subtitle' => __( 'Color of the standard "a" tag', 'manual' ),
					'active'    => false, 
					'visited'   => false,  
					'default'  => array(
						'regular' => '#9E9D9D',
						'hover'   => '#C4C4C4',
						'active'  => '#ccc',
					),
					'required' => array( 
									array('theme-footer-type','equals','2'),
									array('onoff-footer-section-globally','equals','1'),
							   ),
				),
				// - Footer Design Control
				array(
					'id'       => 'theme_footer_design_start',
					'type'     => 'section',
					'title'    => esc_html__( 'Footer Design Control', 'manual' ),
					'indent'   => true, 
					'required' => array('onoff-footer-section-globally','equals','1'),
				),
				array(
					'id'             => 'theme_footer_section_padding',
					'type'           => 'spacing',
					'output'      => array('.footer-section .footer-layer-1 .overlay, .footer-section .footer_type_two_wrap .overlay'),
					'mode'           => 'padding',
					'units'          => array('px'),
					'units_extended' => 'false',
					'left' => false,
					'right' => false,
					'title'    => esc_html__( 'Padding', 'manual' ),
					'subtitle' => esc_html__( 'Set the footer top/bottom spacing', 'manual' ),
				),
				array(         
					'id'       => 'theme_footer_section_background',
					'type'     => 'background',
					'title'    => esc_html__( 'Background', 'manual' ),
					'subtitle' => esc_html__( 'Set the footer background.', 'manual' ),
					'default'  => array(
						'background-color' => '#101010',
					),
					'output'         => array('.footer-section .footer-layer-1, .footer-section .footer_type_two_wrap'),
				),
				array(
					'id'       => 'theme_footer_section_color_overlay',
					'type'     => 'color_rgba',
					'title'    => esc_html__( 'Background overlay', 'manual' ),
					'subtitle'    => esc_html__( 'Select the background overlay.', 'manual' ),
					'default'   => array(
						'color'     => '#000000',
						'alpha'     => 0.0
					),
					'output'         => array('background' => '.footer-section .footer-layer-1 .overlay, .footer-section .footer_type_two_wrap .overlay'),
					'transparent' => false,
					'options'       => array(
						'choose_text'               => 'Choose',
						'cancel_text'               => 'Cancel',
						'palette'                   => null,  
						'input_text'                => 'Select Color'
					), 
				),
				// - eof design controls
	  )
    ) );
	
	// Social Icons
    Redux::setSection( $opt_name, array(
        'title'            => esc_html__( 'Social Icons', 'manual' ),
        'id'               => 'footer-copyright-social-bar',
        'subsection'       => true,
        'customizer_width' => '450px',
        'fields'           => array(
		
			array(
                'id'       => 'footer-social-facebook',
                'type'     => 'text',
                'title'    => esc_html__( 'Facebook URL', 'manual' ),
            ),
			
			array(
                'id'       => 'footer-social-twitter',
                'type'     => 'text',
                'title'    => esc_html__( 'Twitter URL', 'manual' ),
            ),
			
			array(
                'id'       => 'footer-social-youtube',
                'type'     => 'text',
                'title'    => esc_html__( 'Youtube URL', 'manual' ),
            ),
			
			array(
                'id'       => 'footer-social-google',
                'type'     => 'text',
                'title'    => esc_html__( 'Google URL', 'manual' ),
            ),
			
			array(
                'id'       => 'footer-social-instagram',
                'type'     => 'text',
                'title'    => esc_html__( 'Instagram URL', 'manual' ),
            ),
			
			array(
                'id'       => 'footer-social-linkedin',
                'type'     => 'text',
                'title'    => esc_html__( 'Linkedin URL', 'manual' ),
            ),
			
			array(
                'id'       => 'footer-social-pinterest',
                'type'     => 'text',
                'title'    => esc_html__( 'Pinterest URL', 'manual' ),
            ),
			
			array(
                'id'       => 'footer-social-vimo',
                'type'     => 'text',
                'title'    => esc_html__( 'vimo URL', 'manual' ),
            ),
			
			array(
                'id'       => 'footer-social-tumblr',
                'type'     => 'text',
                'title'    => esc_html__( 'Tumblr URL', 'manual' ),
            ),
			
			array(
                'id'       => 'footer-social-whatsapp',
                'type'     => 'text',
                'title'    => esc_html__( 'WhatsApp URL', 'manual' ),
            ),
			
        )
    ) );




/**********************************************
*******  START  SEARCH       *****
***********************************************/

	Redux::setSection( $opt_name, array(
        'title'            => esc_html__( 'Search', 'manual' ),
        'id'               => 'theme_search_section',
        'customizer_width' => '400px',
        'icon'             => 'el el-search-alt'
    ) );

	// SEARCH BOX STYLE
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Search Box Design', 'manual' ),
		'id'     => 'theme-search-box-style',
		'subsection'  => true,
		'fields' => array(
						  
						  
				array(
					'id'       => 'manual-live-search-design-style',
					'type'     => 'image_select',
					'title'    => esc_html__( 'Search box style', 'manual' ),
					'subtitle' => esc_html__( 'The style of the live search box design', 'manual' ),
					'subtitle' => esc_html__( 'The search box will be visible on the page title bar, with the ability to turn it on or off for specific types when setting up the \'Page Title Bar\' configuration.', 'manual' ),
					'options'  => array(
								'1' => array( 'img' => trailingslashit(get_template_directory_uri()) .'framework/ReduxCore/manual/search-box-style-one.jpg' ),
								'2' => array( 'img' => trailingslashit(get_template_directory_uri()) .'framework/ReduxCore/manual/search-box-style-two.jpg' ),
							),
					'default'  => '1'
				),
				array(
					'id'       => 'theme_search_box_search_bottom',
					'type'     => 'switch',
					'title'    => esc_html__( 'Submit buttom', 'manual' ),
					'default'  => false,
					'on' => esc_html__( 'Disable', 'manual' ),
					'off' => esc_html__( 'Enable', 'manual' ),
					'subtitle' => esc_html__('Choose whether you want to show/hide the submit button.', 'manual'),
				),
				array(
					'id'       => 'global-search-text-paceholder',
					'type'     => 'text',
					'title'    => esc_html__( 'Search box placeholder text', 'manual' ),
					'subtitle'    => esc_html__( 'Text that appears in the search box before typing', 'manual' ),
					'default'  => 'Have a question? Ask or enter a search term.',
				),
				array(
					'id'       => 'global-flip-search-text-paceholder',
					'type'     => 'text',
					'title'    => esc_html__( 'Flip search placeholder text', 'manual' ),
					'subtitle'    => esc_html__( 'Change the placeholder text when clicking the search box.', 'manual' ),
					'default'  => 'Please Let Us Know Your Problem',
				),
				array(
					'id'       => 'global-buttom-search-text-paceholder',
					'type'     => 'text',
					'title'    => esc_html__( 'Search button text', 'manual' ),
					'subtitle'    => esc_html__( 'Text on the search button', 'manual' ),
					'default'  => 'Search',
				),
				array(
					'id'       => 'manual-live-search-design-otherdesign-settings',
					'type'     => 'section',
					'title'    => esc_html__( 'Search Box Settings', 'manual' ),
					'indent'   => true, 
				),
				array(
					'id'       => 'manual-live-search-icon-bouncein',
					'type'     => 'switch',
					'title'    => esc_html__( 'Animated search icon: BounceIn effect', 'manual' ),
					'subtitle' => esc_html__('Bouncing effect to the search icon.', 'manual'),
					'default'  => false,
					'on' => esc_html__( 'Enable', 'manual' ),
					'off' => esc_html__( 'Disable', 'manual' ),
				),
				array(
					'id'            => 'theme_search_box_radius',
					'type'          => 'slider',
					'title'         => esc_html__( 'Search box radius', 'manual' ),
					'subtitle'         => esc_html__( 'Change the roundness of the search box corners.', 'manual' ),
					'default'       => 4,
					'min'           => 1,
					'step'          => 1,
					'max'           => 45,
					'display_value' => 'label',
					'display_value' => 'text',
				),
				array(
					'id'       => 'theme_search_box_border_color',
					'type'     => 'color_rgba',
					'title'    => esc_html__( 'Box border color', 'manual' ),
					'subtitle' => esc_html__( 'Change the color of the search box border.', 'manual' ),
					'default'  => array(
						'color' => '#E9E9E9',
						'alpha' => '0.9'
					),
					'mode'     => 'background',
				),
				array(
					'id'       => 'theme_search_box_icon_color',
					'type'     => 'color',
					'title'    => esc_html__( 'Search icon color', 'manual' ),
					'subtitle' => esc_html__( 'Customize the color of the search icon within the search box.', 'manual' ),
					'default'  => '#47c494',
					'transparent' => false,
				),
				array(
					'id'       => 'theme_search_box_placeholder_text_color',
					'type'     => 'color',
					'title'    => esc_html__( 'Placeholder text color', 'manual' ),
					'subtitle' => esc_html__( 'Customize the color of the placeholder text in the search box.', 'manual' ),
					'default'  => '#888888',
					'transparent' => false,
				), 
				array(
					'id'       => 'manual-live-search-box-shadow-input-box',
					'type'     => 'switch',
					'title'    => esc_html__( 'Box shadow', 'manual' ),
					'subtitle' => esc_html__('Shadow effect to the search box.', 'manual'),
					'default'  => false,
					'on' => esc_html__( 'Enable', 'manual' ),
					'off' => esc_html__( 'Disable', 'manual' ),
				),
				array(
					'id'       => 'manual-live-search-transparent-input-box',
					'type'     => 'switch',
					'title'    => esc_html__( 'Transparent search box design', 'manual' ),
					'subtitle' => esc_html__('Set the search box to be transparent.', 'manual'),
					'default'  => false,
					'on' => esc_html__( 'Enable', 'manual' ),
					'off' => esc_html__( 'Disable', 'manual' ),
				),
				array(
					'id'       => 'manual-live-search-transparent-bg-color',
					'type'     => 'color_rgba',
					'title'    => esc_html__( 'Background color', 'manual' ),
					'subtitle'    => esc_html__( 'Customize the color of the transparent background.', 'manual' ),
					'default'  => array(
						'color' => '#ffffff',
						'alpha' => '0.18'
					),
					'mode'     => 'background',
					'required' => array('manual-live-search-transparent-input-box','equals','1'),
					'class' => 'theme-option-text-align-right',	
				),
				array(
					'id'       => 'manual-live-search-transparent-input-box-textcolor',
					'type'     => 'color',
					'title'    => esc_html__( 'Changing text color as you type', 'manual' ),
					'subtitle'    => esc_html__( 'Adjust the color of the text in the search box as soon as the user begins typing.', 'manual' ),
					'default'  => '#888888',
					'transparent' => false, 
					'required' => array('manual-live-search-transparent-input-box','equals','1'),
					'class' => 'theme-option-text-align-right',	
				),
				array(
					'id'       => 'manual-live-search-design-text-settings',
					'type'     => 'section',
					'title'    => esc_html__( 'Search Box Text Settings', 'manual' ),
					'indent'   => true, 
				),
				array(
					'id'       => 'search_box_buttom_text_typography',
					'type'        => 'typography',
					'title'    => esc_html__( 'Search button typography', 'manual' ),
					'subtitle' => esc_html__( 'Customize search button text.', 'manual' ),
					'output'    => array('.jumbotron_new .searchform .button-custom, .elementor-widget-container .elementor_themeoption_search .searchform .button-custom, .page404_content .button-custom, .icon-page-popup.page-search-popup .button-custom'),
					'google'      => true,
					'font-backup' => false,
					'text-align' => false,
					'text-transform' => true,
					'subsets'       => false, 
					'letter-spacing'=> true,  
					'all_styles'  => true,
					'font-backup' => true,
					'word-spacing' => true,
					'margin-top' => false,
					'margin-bottom' => false,
					'color' => false,
					'units'       => 'px',
					'default'     => array(
						'font-size'   => '14px', 
						'text-transform'  => 'uppercase', 
						'line-height' => '23px',
					),
					'required' => array('theme_search_box_search_bottom','equals','false'), 
				),
				array(
					'id'       => 'search_box_bar_text_typography',
					'type'        => 'typography',
					'title'    => esc_html__( 'Search box text typography', 'manual' ),
					'subtitle' => esc_html__( 'Customize search box text typography.', 'manual' ),
					'output'    => array('.form-control.header-search, .theme-top-header-searchbox .form-group .search-button-custom'),
					'google'      => true,
					'font-backup' => false,
					'text-align' => false,
					'text-transform' => true,
					'subsets'       => false, 
					'letter-spacing'=> true,  
					'all_styles'  => true,
					'font-backup' => true,
					'word-spacing' => true,
					'margin-top' => false,
					'margin-bottom' => false,
					'color' => false,
					'units'       => 'px',
					'default'     => array(
						'font-size'   => '17px', 
					),
				),
		)
		) );
		
	// LIVE SEARCH
	Redux::setSection( $opt_name, array(
        'title'        => esc_html__( 'Live Search', 'manual' ),
        'id'           => 'theme_live_search_section',
		'subsection'   => true,
        'fields' => array(
						  
				array(
					'id'       => 'manual-live-search-status',
					'type'     => 'switch',
					'title'    => esc_html__( 'Live search', 'manual' ),
					'subtitle' => esc_html__('Globally enable/disable live search', 'manual'),
					'default'  => true,
					'on' => esc_html__( 'Enable', 'manual' ),
					'off' => esc_html__( 'Disable', 'manual' ),
				),
				array(
					'id'       => 'manual-live-search-post-excerpt',
					'type'     => 'switch',
					'title'    => esc_html__( 'Live search results with post excerpts', 'manual' ),
					'subtitle'    => esc_html__( 'Show post excerpts in live search results', 'manual' ),
					'default'  => false,
					'on' => esc_html__( 'Enable', 'manual' ),
					'off' => esc_html__( 'Disable', 'manual' ),
					'required' => array('manual-live-search-status','equals','1'),
					'class' => 'theme-option-text-align-right',
				),
				array(
					'id'       => 'manual-live-search-post-navigation-status',
					'type'     => 'switch',
					'title'    => esc_html__( 'Post breadcrumb in live search results', 'manual' ),
					'subtitle' => __('Live search will show post navigation for Posts, FAQs, Documentation, and Knowledge Base.', 'manual' ),
					'default'  => true,
					'on' => esc_html__( 'Enable', 'manual' ),
					'off' => esc_html__( 'Disable', 'manual' ),
					'required' => array('manual-live-search-status','equals','1'),
					'class' => 'theme-option-text-align-right',
				),
				array(
					'id'       => 'manual-live-search-post-type-private-records',
					'type'     => 'switch',
					'title'    => esc_html__( 'Private Records', 'manual' ),
					'subtitle' => __('<span style="color:#e6614b">Allow all private information show up in the live search.</span>', 'manual' ),
					'default'  => false,
					'on' => esc_html__( 'Enable', 'manual' ),
					'off' => esc_html__( 'Disable', 'manual' ),
					'required' => array('manual-live-search-status','equals','1'),
					'class' => 'theme-option-text-align-right',
				),
				array(
					'id'       => 'global-showall-search-text-paceholder',
					'type'     => 'text',
					'title'    => esc_html__( 'Show all search results', 'manual' ),
					'subtitle'    => esc_html__( 'Display all results text', 'manual' ),
					'default'  => 'Show All Results',
					'required' => array('manual-live-search-status','equals','1'),
					'class' => 'theme-option-text-align-right',
				),
				array(
					'id'       => 'global-noresult-search-text-paceholder',
					'type'     => 'text',
					'title'    => esc_html__( 'Empty search results message', 'manual' ),
					'subtitle'    => esc_html__( 'Display text for no results', 'manual' ),
					'default'  => 'No Results',
					'required' => array('manual-live-search-status','equals','1'),
					'class' => 'theme-option-text-align-right',
				),
				
		 )
    ) );
	
	// TRENDING SEARCH
	Redux::setSection( $opt_name, array(
        'title'        => esc_html__( 'Trending Search', 'manual' ),
        'id'           => 'theme_trending_search_section',
		'subsection'   => true,
        'fields' => array(
				
				array(
					'id'       => 'manual-trending-live-search-status',
					'type'     => 'switch',
					'title'    => esc_html__( 'Trending search', 'manual' ),
					'subtitle' => esc_html__('Globally enable/disable trending search ', 'manual'),
					'default'  => false,
					'on' => esc_html__( 'Enable', 'manual' ),
					'off' => esc_html__( 'Disable', 'manual' ),
				),
				array(
					'id'       => 'manual-trending-text',
					'type'     => 'text',
					'title'    => esc_html__( 'Pre-Trending search text title', 'manual' ),
					'subtitle' => esc_html__( 'Text title displayed before trending search keywords', 'manual'),
					'desc'     => esc_html__( 'Default: Popular Search', 'manual' ),
					'default'  => 'Popular Search:',
					'required' => array('manual-trending-live-search-status','equals','1'),
					'class' => 'theme-option-text-align-right',
				),
				array(
					'id'       => 'manual-three-trending-search-text',
					'type'     => 'sortable',
					'title'    => esc_html__( 'Trending Search keyword', 'manual' ),
					'subtitle' => esc_html__( 'List three trending search terms: Installation, Demo Data, etc.', 'manual' ),
					'label'    => true,
					'required' => array('manual-trending-live-search-status','equals','1'),
					'class' => 'theme-option-text-align-right',
					'options'  => array(
						'Search keyword 1'  => '',
						'Search keyword 2'  => '',
						'Search keyword 3'  => '',
					)
				),
				
		 )
    ) );
	
	// TARGET POST TYPE SEARCH
	Redux::setSection( $opt_name, array(
        'title'        => esc_html__( 'Target Post Type Search', 'manual' ),
        'id'           => 'theme_target_post_type_search_section',
		'subsection'   => true,
        'fields' => array(
				
				array(
					'id'       => 'manual-trending-post-type-search-status',
					'type'     => 'switch',
					'title'    => esc_html__( 'Dropdown Target Search', 'manual' ),
					'subtitle' => esc_html__('Globally enable/disable target search', 'manual'),
					'default'  => true,
					'on' => esc_html__( 'Enable', 'manual' ),
					'off' => esc_html__( 'Disable', 'manual' ),
				),
				array(
					'id'       => 'manual-dropdown-target-search-margin-right',
					'type'     => 'text',
					'title'    => esc_html__( 'Right margin of dropdown target search box', 'manual' ),
					'subtitle' => esc_html__( 'Adjust dropdown box design if it creates any space.', 'manual' ),
					'desc' => esc_html__( 'Example: 0px, -10px, 20px', 'manual' ),
					'default'  => '0px',
					'required' => array('manual-trending-post-type-search-status','equals','1'),
				),
				array(
					'id'       => 'manual-trending-post-type-search-status-on-forum-pages',
					'type'     => 'switch',
					'subtitle'    => esc_html__( 'Turn on dropdown target search for the Forum (bbPress) section', 'manual' ),
					'title' => esc_html__('Dropdown target search for bbPress forum', 'manual'),
					'default'  => false,
					'on' => esc_html__( 'Enable', 'manual' ),
					'off' => esc_html__( 'Disable', 'manual' ),
					'required' => array('manual-trending-post-type-search-status','equals','1'),
				),
				array(
					'id'       => 'manual-search-post-type-multi-select',
					'type'     => 'select',
					'data'     => 'post_type',
					'multi'    => true,
					'sortable' => true,
					'title'    => esc_html__( 'Target Search (Dropdown list)', 'manual' ),
					'subtitle' => esc_html__('When selecting a post type during a search, the live/normal search results will only show items from the chosen post type.', 'manual' ),
					'desc'     => __( '<strong style="color:red;">NOTE: Post Type: "Courses, Lession & Quizzes" will not function</strong> properly and will not be listed in the targeted search results, even if selected above.. <br><br> <strong>NOTE 2:</strong> Post Types \'Replies\' and \'Topics\' will not be listed in the targeted search results, even if selected from the list above.', 'manual' ),
					'default'  => array('post','manual_kb','manual_documentation'),
					'required' => array (
								  array('manual-trending-post-type-search-status','equals','1'),
								  array('manual-search-post-type-by-category','equals',false),
								  ),
				),
				array(
					'id'       => 'manual-search-post-type-by-category',
					'type'     => 'switch',
					'title'    => __( '<strong style="color:red;">Targeted category search</strong>', 'manual' ),
					'subtitle' => esc_html__('Search based on the selected category.', 'manual'),
					'default'  => false,
					'on' => esc_html__( 'Enable', 'manual' ),
					'off' => esc_html__( 'Disable', 'manual' ),
					'required' => array('manual-trending-post-type-search-status','equals','1'),
				),
				array(
					'id'       => 'manual-search-post-type-name-for-category-search',
					'type'     => 'select',
					'title'    => esc_html__( 'Choose post type for category search', 'manual' ),
					'subtitle' => esc_html__( 'All categories will be listed in the dropdown menu.', 'manual' ),
					'options'  => array(
						'manual_kb' => esc_html__( 'Knowledge Base','manual' ),
						'manual_documentation' => esc_html__( 'Documentation','manual' ),
					),
					'default'  => 'manual_kb',
					'class' => 'theme-option-text-align-right',
					'required' => array (
								  array('manual-trending-post-type-search-status','equals','1'),
								  array('manual-search-post-type-by-category','equals',true),
								  ),
				),
				array(
					'id'       => 'manual-search-kb-category-search-list',
					'type'     => 'select',
					'multi'    => true,
					'sortable' => true,
					'data'  => 'terms',
					'args' => array( 'taxonomies' => array( 'manualknowledgebasecat' ), ),
					'title'    => esc_html__( 'Dropdown list of knowledgebase categories', 'manual' ),
					'subtitle' => __('When selecting a category during a search, the live/normal search results will only include items from the chosen category.', 'manual' ),
					'class' => 'theme-option-text-align-right',
					'required' => array (
								  array('manual-trending-post-type-search-status','equals','1'),
								  array('manual-search-post-type-by-category','equals',true),
								  array('manual-search-post-type-name-for-category-search','equals','manual_kb'),
								  ),
					'desc' => 	esc_html__( 'Leave empty to display all category', 'manual' ),		  
				),
				array(
					'id'       => 'manual-search-doc-category-search-list',
					'type'     => 'select',
					'multi'    => true,
					'sortable' => true,
					'data'  => 'terms',
					'args' => array( 'taxonomies' => array( 'manualdocumentationcategory' ), ),
					'title'    => esc_html__( 'Dropdown list of documentation categories', 'manual' ),
					'subtitle' => __('When selecting a category during a search, the live/normal search results will only include items from the chosen category.', 'manual' ),
					'class' => 'theme-option-text-align-right',
					'required' => array (
								  array('manual-trending-post-type-search-status','equals','1'),
								  array('manual-search-post-type-by-category','equals',true),
								  array('manual-search-post-type-name-for-category-search','equals','manual_documentation'),
								  ),
					'desc' => 	esc_html__( 'Leave empty to display all category', 'manual' ),		  
				),
				
				array(
					'id'       => 'manual-search-kb-category-include-children',
					'type'     => 'switch',
					'title'    => __( 'Category-based search limitations', 'manual' ),
					'subtitle' => esc_html__('Limit search to selected category or include all child sub-categories in the search.', 'manual'),
					'default'  => true,
					'on' => esc_html__( 'Enable', 'manual' ),
					'off' => esc_html__( 'Disable', 'manual' ),
					'class' => 'theme-option-text-align-right',
					'required' => array (
								  array('manual-trending-post-type-search-status','equals','1'),
								  array('manual-search-post-type-by-category','equals',true),
								  ),
				),
				array(
					'id'       => 'manual_dropdown_value_section',
					'type'     => 'section',
					'title'    => esc_html__( 'Target Search Dropdown Text', 'manual' ),
					'indent'   => true,
					'subtitle' => esc_html__('If the selected post type keyword matches any in the \'Target Search\' dropdown list above, it will be replaced by the text below.','manual' ),
					'required' => array('manual-trending-post-type-search-status','equals','1'),
				),
				array(
					'id'       => 'manual-post-type-search-text-all-categories',
					'type'     => 'text',
					'title'    => esc_html__( 'All Categories', 'manual' ),
					'subtitle' => esc_html__( 'Default display text', 'manual' ),
					'default'  => 'All Categories',
					'required' => array (
								  array('manual-trending-post-type-search-status','equals','1'),
								  array('manual-search-post-type-by-category','equals',true),
								  ),
				),
				array(
					'id'       => 'manual-post-type-search-text-inital',
					'type'     => 'text',
					'title'    => esc_html__( 'Default', 'manual' ),
					'subtitle' => esc_html__( 'Default display text', 'manual' ),
					'default'  => 'All Site',
				),
				array(
					'id'       => 'manual-post-type-search-dropdown-kb',
					'type'     => 'text',
					'title'    => esc_html__( 'Knowledge Base', 'manual' ),
					'subtitle' => esc_html__( 'Dropdown Knowledge Base Text', 'manual' ),
					'default'  => 'Knowledge Base',
				),
				array(
					'id'       => 'manual-post-type-search-dropdown-documentation',
					'type'     => 'text',
					'title'    => esc_html__( 'Documentation', 'manual' ),
					'subtitle' => esc_html__( 'Dropdown Documentation Text', 'manual' ),
					'default'  => 'Documentation',
				),
				array(
					'id'       => 'manual-post-type-search-dropdown-portfolio',
					'type'     => 'text',
					'title'    => esc_html__( 'Portfolio', 'manual' ),
					'subtitle' => esc_html__( 'Dropdown Portfolio Text', 'manual' ),
					'default'  => 'Portfolio',
				),
				array(
					'id'       => 'manual-post-type-search-dropdown-faq',
					'type'     => 'text',
					'title'    => esc_html__( 'FAQs', 'manual' ),
					'subtitle' => esc_html__( 'Dropdown FAQs Text', 'manual' ),
					'default'  => 'FAQs',
				),
				array(
					'id'       => 'manual-post-type-search-dropdown-forums',
					'type'     => 'text',
					'title'    => esc_html__( 'Forums', 'manual' ),
					'subtitle' => esc_html__( 'Dropdown Forums Text', 'manual' ),
					'default'  => 'Forums',
				),
				array(
					'id'       => 'manual-post-type-search-dropdown-media',
					'type'     => 'text',
					'title'    => esc_html__( 'Media', 'manual' ),
					'subtitle' => esc_html__( 'Dropdown Media Text', 'manual' ),
					'default'  => 'Media',
				),
				array(
					'id'       => 'manual-post-type-search-dropdown-page',
					'type'     => 'text',
					'title'    => esc_html__( 'Page', 'manual' ),
					'subtitle' => esc_html__( 'Dropdown Page Text', 'manual' ),
					'default'  => 'Page',
				),
				array(
					'id'       => 'manual-post-type-search-dropdown-post',
					'type'     => 'text',
					'title'    => esc_html__( 'Post', 'manual' ),
					'subtitle' => esc_html__( 'Dropdown Post Text', 'manual' ),
					'default'  => 'Post',
				),
		 )
    ) );
	
	// SEARCH PAGE
	Redux::setSection( $opt_name, array(
	'title'        => esc_html__( 'Search Page', 'manual' ),
	'id'           => 'theme_target_post_type_search_page_section',
	'subsection'   => true,
	'fields' => array(
					  
					array(
						'id'       => 'searchpage_header_menu',
						'type'     => 'switch',
						'title'    => esc_html__( 'Customize the header menu', 'manual' ),
						'subtitle' => esc_html__('Modify the main header, including the logo and menu colors, if needed.', 'manual'),
						'default'  => false,
					),
					array(
						'id'       => 'searchpage_header_background_colorbg',
						'type'     => 'color_rgba',
						'title'    => esc_html__( 'Background color', 'manual' ),
						'subtitle'    => esc_html__( 'Set the header background.', 'manual' ),
						'output'    => array('background' => '.navbar-inverse.searchpage'),
						'required' => array('searchpage_header_menu','equals','1'),
						'class' => 'theme-option-text-align-right',			
					),
					array(
						'id'       => 'searchpage_header_first_level_menu_text_color',
						'type'     => 'link_color',
						'title'    => esc_html__( 'Menu link color', 'manual' ),
						'subtitle' => esc_html__('Text color for the first level of the navigation menu.', 'manual'),
						'active'    => false, 
						'visited'   => false,
						'output'    => array('.navbar-inverse.searchpage .navbar-nav>li>a'), 
						'required' => array('searchpage_header_menu','equals','1'),
						'class' => 'theme-option-text-align-right',
					),
					array(
						'id'       => 'searchpage_header_flip_logo',
						'type'     => 'switch',
						'title'    => esc_html__( 'Flip logo', 'manual' ),
						'subtitle' => esc_html__('Switch from the \'primary logo\' to the \'secondary logo,\' if necessary.', 'manual'),
						'default'  => false,
						'class' => 'theme-option-text-align-right',
						'required' => array('searchpage_header_menu','equals','1'),
					),
					array(
						'id'       => 'searchpage_header_shadow',
						'type'     => 'switch',
						'title'    => esc_html__('Header shadow', 'manual' ),
						'desc' => esc_html__('Please note that this function is effective only when the header shadow is enabled in the \'Header Menu > Main Header\' settings.', 'manual'),
						'subtitle' => esc_html__('Turn the default header shadow on or off.', 'manual'),
						'default'  => false,
						'class' => 'theme-option-text-align-right',
						'required' => array('searchpage_header_menu','equals','1'),
					),
					array(
						'id'       => 'searchpage_header_menu_border_btm',
						'type'     => 'border',
						'title'    => esc_html__( 'Header border bottom', 'manual' ),
						'subtitle' => esc_html__('Re-adjust header border bottom', 'manual'),
						'color_alpha'  => true,
						'left'  => false,
						'right'  => false,
						'top'  => false,
						'class' => 'theme-option-text-align-right',
						'required' => array('searchpage_header_menu','equals','1'),
						'output'    => array('.navbar.searchpage'),
					),
					array(
						'id'       => 'searchpage_header_menu_border_top',
						'type'     => 'border',
						'title'    => esc_html__( 'Header border top', 'manual' ),
						'subtitle' => esc_html__('Re-adjust header border top', 'manual'),
						'desc' => esc_html__('If \'Menu position\' is set to \'Logo on Top\' and \'Menu Below Logo\' in \'Theme > Options > Header Menu > Main Header\', then this feature will work properly.', 'manual'),
						'color_alpha'  => true,
						'left'  => false,
						'right'  => false,
						'bottom'  => false,
						'required' => array('searchpage_header_menu','equals','1'),
						'class' => 'theme-option-text-align-right',
						'output'    => array('.navbar.searchpage .navbar-collapse.collapse'),
					),
					array(
						'id'       => 'search_header_menu_hamburger_search_box',
						'type'     => 'switch',
						'title'    => esc_html__( 'Hide the search box in the Hamburger menu.', 'manual' ),
						'desc' => esc_html__('This feature will only function if enabled \'Search Box in Hamburger Menu\' in the \'Theme Options\' under \'Header Menu\' in the \'Main Header\' section.', 'manual'),
						'default'  => false,
						'required' => array('searchpage_header_menu','equals','1'),
						'on' => esc_html__( 'Hide', 'manual' ),
						'off' => esc_html__( 'Theme Default', 'manual' ),
						'class' => 'theme-option-text-align-right',
					),
					array(
						'id'       => 'onoff-search-page-title-bar',
						'type'     => 'switch',
						'title'    => esc_html__('Page title bar', 'manual' ),
						'subtitle' => __('Enable/Disable page title bar', 'manual'),
						'desc' => __('Note: Disabling the page title bar will change the menu style to the default setting, meaning that no transparent menu style will be used.', 'manual'),
						'default'  => true,
						'on'       => esc_html__( 'Enable', 'manual' ),
						'off'      => esc_html__( 'Disable', 'manual' ),
					),
					array(
						'id'       => 'searchpage_title_bar_settings',
						'type'     => 'section',
						'title'    => esc_html__( 'Page Title Bar', 'manual' ),
						'indent'   => true, 
						'required' => array('onoff-search-page-title-bar','equals','1'),
					),
					array(
						'id'       => 'search-header-height',
						'type'     => 'text',
						'title'    => esc_html__( 'Page title bar :: padding', 'manual' ),
						'subtitle' => esc_html__( 'Re-adjust the space above and below the \'Page Title Bar\' on your search page.', 'manual' ),
						'desc'     => __( 'Example: 120px 0px 120px 0px (top, right, bottom, left)<br><br><strong style="color:#e6614b;">IMPORTANT: Make sure the value of RIGHT, LEFT is always 0px</strong>', 'manual' ), 
						'default'  => '',
					),
					array(
						'id'       => 'search-responsive-header-height',
						'type'     => 'text',
						'title'    => esc_html__( 'Page title bar :: Responsive padding', 'manual' ),
						'subtitle' => esc_html__( 'Re-adjust the top/bottom spacing for page title bar', 'manual' ),
						'desc'     => __( 'Example: 100px 0px 100px 0px (top, right, bottom, left)<br><br><strong style="color:#e6614b;">IMPORTANT: Make sure the value of RIGHT, LEFT is always 0px</strong>', 'manual' ), 
						'default'  => '',
					),
					array(
						'id'       => 'search-page-header-title',
						'type'     => 'text',
						'title'    => esc_html__( 'Custom title', 'manual' ),
						'subtitle' => esc_html__( 'Special heading for the search page.', 'manual' ),
						'default'  => 'Search Results',
					),
					array(
						'id'       => 'search-pagetitlebar_text_typography',
						'type'        => 'typography',
						'title'    => esc_html__( 'Title typography', 'manual' ),
						'subtitle' => esc_html__( 'Customize title text.', 'manual' ),
						'output'    => array('.noise-break.searchpage h1.custom_h1_head'),
						'google'      => true,
						'font-backup' => false,
						'text-align' => false,
						'text-transform' => true,
						'subsets'       => false, 
						'letter-spacing'=> true,  
						'all_styles'  => true,
						'font-backup' => true,
						'word-spacing' => true,
						'margin-top' => true,
						'margin-bottom' => true,
						'units'       => 'px',
						'class' => 'theme-option-text-align-right',
					),
					array(
						'id'       => 'search-page-header-sub-title',
						'type'     => 'text',
						'title'    => esc_html__( 'Sub title', 'manual' ),
						'subtitle' => esc_html__( 'Sub title text', 'manual' ),
						'default'  => 'your search of',
					),
					array(
						'id'       => 'search-pagetitlebar_subtext_typography',
						'type'        => 'typography',
						'title'    => esc_html__( 'Sub-title typography', 'manual' ),
						'subtitle' => esc_html__( 'Customize sub-title title text.', 'manual' ),
						'output'    => array('.noise-break.searchpage p.inner-header-color'),
						'google'      => true,
						'font-backup' => false,
						'text-align' => false,
						'text-transform' => true,
						'subsets'       => false, 
						'letter-spacing'=> true,  
						'all_styles'  => true,
						'font-backup' => true,
						'word-spacing' => true,
						'margin-top' => true,
						'margin-bottom' => true,
						'units'       => 'px',
						'class' => 'theme-option-text-align-right',
					),
					array(
						'id'       => 'search-header-text-align',
						'type'     => 'select',
						'title'    => esc_html__( 'Text align', 'manual' ),
						'subtitle'    => esc_html__( 'Adjust the alignment of the text on the \'page title bar\'.', 'manual' ),
						'options'  => array(
							'left'   => esc_html__('Left','manual' ),
							'center' => esc_html__('Center','manual' ),
							'right'  => esc_html__('Right','manual' ),
						),
						'default'  => 'center'
					),
					array(
						'id'       => 'search-page-header-search-bar-status',
						'type'     => 'switch',
						'title'    => esc_html__( 'Search Box', 'manual' ),
						'default'  => true,
						'subtitle' => esc_html__('Choose to show or hide the search box in the specified \'page title bar\' area.', 'manual'),
						'on'       => esc_html__( 'Enable', 'manual' ),
						'off'      => esc_html__( 'Disable', 'manual' ),
					),
					array(
						'id'       => 'search-page-searchbox-display-position',
						'type'     => 'select',
						'title'    => esc_html__( 'Search box position', 'manual' ),
						'subtitle' => esc_html__('Choose where to place the search box on the \'page title bar\'.', 'manual'),
						'options'  => array(
							'center' => esc_html__('Exact Center','manual' ),
							'6'  => esc_html__('50% Width','manual' ),
							'7'  => esc_html__('58% Width','manual' ),
							'8'  => esc_html__('66% Width','manual' ),
							'9'  => esc_html__('75% Width','manual' ),
							'10' => esc_html__('83% Width','manual' ),
							'11' => esc_html__( '91% Width','manual' ),
							'12' => esc_html__('100% Width','manual' ),
						),
						'default'  => 'center',
						'required' => array('search-page-header-search-bar-status','equals','1'),
						'class' => 'theme-option-text-align-right',
					), 
					array(
						'id'       => 'searchpage-header-treanding-search-color',
						'type'     => 'color',
						'title'    => esc_html__( 'Title text color', 'manual' ),
						'subtitle'    => esc_html__( 'Trending search text title color', 'manual' ),
						'required' => array('search-page-header-search-bar-status','equals','1'),
						'output'    => array('.noise-break.searchpage .trending-search span.popular-keyword-title'),
						'class' => 'theme-option-text-align-right',
					),
					array(
						'id'       => 'searchpage-header-treanding-search-link-color',
						'type'     => 'link_color',
						'title'    => esc_html__( 'Link color', 'manual' ),
						'required' => array('search-page-header-search-bar-status','equals','1'),
						'subtitle'    => esc_html__( 'The trending keyword link color', 'manual' ),
						'active'    => false, 
						'visited'   => false,
						'output'    => array('.noise-break.searchpage .trending-search a.trending-search-popular-keyword'),  
						'class' => 'theme-option-text-align-right',
					),
					array(
						'id'       => 'searchpage-header-title-bar-background-setup',
						'type' => 'background',
						'title'    => esc_html__( 'Background', 'manual' ),
						'subtitle' => esc_html__( 'Create the background for your search page.', 'manual' ),
					),
					array(
						'id'       => 'searchpage-header-title-bar-image-overlay',
						'type'     => 'color_rgba',
						'title'    => esc_html__( 'Background overlay', 'manual' ),
						'subtitle'    => esc_html__( 'Select the background overlay for your search page title bar.', 'manual' ),
						'output'    => array('background' => '.noise-break.searchpage .page_opacity.header_custom_height_new'),
						'class' => 'theme-option-text-align-right',
					),	
					array(
						'id'       => 'searchpage_other_settings',
						'type'     => 'section',
						'title'    => esc_html__( 'Search Result Configuration', 'manual' ),
						'indent'   => true, 
					),
					array(
						'id'       => 'manual_searchpg_no_result_text_message',
						'type'     => 'text',
						'title'    => esc_html__( 'Notification of zero results', 'manual' ),
						'subtitle' => esc_html__( 'Show text when no search results are found.', 'manual' ),
						'default'  => 'Sorry!! nothing found related to your search topic, please try search again.',
					),  
					array(
						'id'       => 'searchpg-post-type-private-records',
						'type'     => 'switch',
						'title'    => esc_html__( 'Private records', 'manual' ),
						'subtitle' => __('<span style="color:#e6614b">Enable the display of all private records on the search page.</span>', 'manual' ),
						'default'  => false,
						'on' => esc_html__( 'Enable', 'manual' ),
						'off' => esc_html__( 'Disable', 'manual' ),
					), 
					array(
						'id'       => 'searchpg-result-display-order',
						'type'     => 'select',
						'title'    => esc_html__( 'Display order', 'manual' ),
						'subtitle' => esc_html__( 'Order of display for search records', 'manual' ),
						'options'  => array(
							'ASC' => esc_html__( 'Ascending Order (ASC)','manual' ),
							'DESC' => esc_html__( 'Descending Order (DESC)','manual' ),
						),
						'default'  => 'DESC'
					),
					array(
						'id'       => 'searchpg-result-display-orderby',
						'type'     => 'select',
						'title'    => esc_html__( 'Display order by', 'manual' ),
						'subtitle' => esc_html__( 'Order of display by for search records', 'manual' ),
						'options'  => array(
							'ID' => esc_html__('Order by post id','manual' ),
							'title' => esc_html__('Order by title','manual' ),
							'date' => esc_html__('Order by date','manual' ),
							'modified' => esc_html__('Order by last modified date','manual' ),
							'rand' => esc_html__('Order by Random','manual' ),
							'comment_count' => esc_html__('Order by number of comment','manual' ),
							'relevance' => esc_html__('Order by relevance','manual' ),
							'none' => esc_html__('None','manual' ),
						),
						'default'  => 'relevance'
					),
					
					
					array(
						'id'       => 'searchpg-display-post-content',
						'type'     => 'switch',
						'title'    => esc_html__( 'Post excerpt', 'manual' ),
						'default'  => true,
						'subtitle' => esc_html__('Turn on/off the brief description under the post title in the search results.', 'manual' ),
						'on' => esc_html__( 'Enable', 'manual' ),
						'off' => esc_html__( 'Disable', 'manual' ),
					),
					array(
						'id'       => 'searchpg-display-post-content-on-post-type',
						'type'     => 'select',
						'data'     => 'post_type',
						'multi'    => true,
						'sortable' => true,
						'title'    => esc_html__( 'Targeted post excerpts display', 'manual' ),
						'subtitle' => esc_html__('Specify the post type for which you want to show post excerpts. Only display post excerpts for the selected post type.','manual' ),
						'desc'     => __( '<strong>NOTE:</strong> If no post type is selected, only the title will be displayed.', 'manual' ),
						'default'  => array('manual_kb','manual_documentation'),
						'required' => array('searchpg-display-post-content','equals','1'),
						'class' => 'theme-option-text-align-right',
					),
					array(
						'id'       => 'searchpg-display-post-content-character',
						'type'     => 'text',
						'title'    => esc_html__( 'Length of post excerpts', 'manual' ),
						'subtitle' => esc_html__( 'Manage the length of post excerpts.', 'manual' ),
						'desc' => esc_html__( 'Default: 200 characters', 'manual' ),
						'required' => array('searchpg-display-post-content','equals','1'),
						'default'  => '200',
						'class' => 'theme-option-text-align-right',
					),
					array(
						'id'            => 'searchpg-records-per-page',
						'type'          => 'slider',
						'title'         => esc_html__( 'Search records', 'manual' ),
						'subtitle'      => esc_html__( 'Number of records per page for search', 'manual' ),
						'default'       => 10,
						'min'           => 5,
						'step'          => 1,
						'max'           => 20,
						'display_value' => 'label',
						'desc' => esc_html__( 'Default: 10 records per page', 'manual' ),
						'display_value' => 'text',
					),
					array(
						'id'       => 'searchpg-page-configuration',
						'type'     => 'section',
						'title'    => esc_html__( 'Page Configuration', 'manual' ),
						'indent'   => true,
					),
					array(
						'id'       => 'searchpg-sidebar',
						'type'     => 'switch',
						'title'    => esc_html__( 'Sidebar', 'manual' ),
						'subtitle' => esc_html__( 'Show or hide the sidebar on the search page.', 'manual' ),
						'default'  => true,
						'on' => esc_html__( 'Enable', 'manual' ),
						'off' => esc_html__( 'Disable', 'manual' ),
					),
					array(
						'id'       => 'searchpg-records-post-type-tag',
						'type'     => 'switch',
						'title'    => esc_html__( 'Post type name', 'manual' ),
						'default'  => true,
						'subtitle' => esc_html__( 'Show or hide the post type name below the post title.', 'manual' ),
						'on' => esc_html__( 'Enable', 'manual' ),
						'off' => esc_html__( 'Disable', 'manual' ),
					),
	
					array(
						'id'       => 'searchpg-records-publish-date',
						'type'     => 'switch',
						'title'    => esc_html__( 'Date', 'manual' ),
						'default'  => true,
						'subtitle' => esc_html__( 'Enable or disable the display of the post\'s published date below the post title.', 'manual' ),
						'on' => esc_html__( 'Enable', 'manual' ),
						'off' => esc_html__( 'Disable', 'manual' ),
					),
					array(
						'id'       => 'searchpg-records-author-name',
						'type'     => 'switch',
						'title'    => esc_html__( 'Author name', 'manual' ),
						'default'  => true,
						'subtitle' => esc_html__('Enable or disable showing the author name below the post title.', 'manual' ),
						'on' => esc_html__( 'Enable', 'manual' ),
						'off' => esc_html__( 'Disable', 'manual' ),
					),
					array(
						'id'       => 'searchpg-records-post-user-name',
						'type'     => 'select',
						'title'    => esc_html__( 'Customize author name display options', 'manual' ),
						'subtitle' => esc_html__( 'Choose the way you want the author\'s name to be shown.', 'manual' ),
						'options'  => array(
							'user_login' => esc_html__('User Login','manual' ),
							'user_nicename' => esc_html__('User Nicename','manual' ),
							'user_registered' => esc_html__('User Registered','manual' ),
							'display_name' => esc_html__('Display Name','manual' ),
							'first_name' => esc_html__('First Name','manual' ),
							'user_firstname' => esc_html__('User Firstname','manual' ),
						),
						'default'  => 'user_nicename',
						'required' => array('searchpg-records-author-name','equals','1'),
						'class' => 'theme-option-text-align-right',
					),
			 )
    ) );
	
	
	
	
	
	
	// ADVANCE SEARCH
	Redux::setSection( $opt_name, array(
        'title'        => esc_html__( 'Advance Search', 'manual' ),
        'id'           => 'advance_search_option',
		'subsection'   => true,
        'fields' => array(
						  
						  
						  array(
								'id'       => 'manual-default-search-type-multi-select',
								'type'     => 'select',
								'data'     => 'post_type',
								'multi'    => true,
								'sortable' => true,
								'title'    => esc_html__( 'Post Types Target Search', 'manual' ),
								'subtitle' => __('Search will <strong style="color:orange;">only display results</strong> from the selected post types while performing live/normal search. <br>','manual' ),
								'desc'     => __( '<strong>NOTE:</strong> If <strong style="color:orange;">no any post type selected</strong> above, search will <strong>display results from all the available post type</strong>.', 'manual' ),
						 ),
						  
						  
						  array(
								'id'       => 'general_livesearch_settings',
								'type'     => 'checkbox',
								'title'    => esc_html__('General Search Settings', 'manual'), 
								'options'  => array(
									'1' => esc_html__('Search in Title (DEFAULT, will always active)','manual'),
									'2' => esc_html__('Search in Content','manual'),
									'3' => esc_html__('Search in Excerpt','manual'),
								),
								'default' => array(
									'1' => '1', 
								)
							),
						  
						    array(
								'id'       => 'multi_texonomies_livesearch_settings',
								'type'     => 'select',
								'data'     => 'taxonomies',
								'title'    => esc_html__('Search in Taxonomies', 'manual'),
								'multi'    => true,
								'args'  => array( 'public' => true, 'show_ui' => true, ), 
							),
						   
						    array(
								'id'       => 'advance-livesearch-in-authors',
								'type'     => 'switch',
								'title'    => esc_html__('Authors', 'manual' ),
								'subtitle' => esc_html__('Search author display name and display the posts created by that author', 'manual'),
								'default'  => false,
								'on' => esc_html__( 'Enable', 'manual' ),
								'off' => esc_html__( 'Disable', 'manual' ),
							),
						   
						   array(
								'id'       => 'advance-search-misc-section',
								'type'     => 'section',
								'title'    => esc_html__( 'Miscellaneous Settings', 'manual' ),
								'indent'   => true,
						   ),
						   
						   array(
								'id'          => 'advance-search-exclude-older-result',
								'type'        => 'date',
								'title'       => esc_html__('Exclude Older Search Results', 'manual'), 
								'subtitle'    => esc_html__('Will not appear in search results older than selected date', 'manual'),
								'placeholder' => esc_html__('Select Date', 'manual'),
								'desc'    => esc_html__('Leave empty to disable', 'manual'),
						   ),
						   
						   array(
								'id'       => 'adv-search-terms-relation-type',
								'type'     => 'select',
								'title'    => esc_html__( 'Terms Relation Type', 'manual' ),
								'subtitle' => esc_html__( 'Type of query relation between search terms.', 'manual' ),
								'desc' => esc_html__( 'e.g. if someone searches for "getting started" then define the relation between "getting" and "started". The default value is AND.', 'manual' ),
								'options'  => array(
									'AND' => esc_html__('AND','manual' ),
									'OR' => esc_html__('OR','manual' ),
								),
								'default'  => 'AND'
						  ),
						   
						  array(
								'id'       => 'adv-search-match-exact-type',
								'type'     => 'select',
								'title'    => esc_html__( 'Match the Search Term Exactly', 'manual' ),
								'subtitle' => esc_html__( 'Whether to match search term exactly or partially.', 'manual' ),
								'desc' => esc_html__( 'e.g. If someone search "Word" it will display items matching "WordPress" or "Word" but if you select Yes then it will display items only matching "Word". The default value is No.', 'manual' ),
								'options'  => array(
									'yes' => esc_html__('YES', 'manual' ),
									'no' => esc_html__('NO', 'manual' ),
								),
								'default'  => 'no'
						  ),
						  
						   
					)
    ) );

/**********************************************
*******  START  KNOWLEDGEBASE       *****
***********************************************/

	Redux::setSection( $opt_name, array(
        'title'            => esc_html__( 'Knowledgebase', 'manual' ),
        'id'               => 'theme_knowledgebase_section',
        'customizer_width' => '400px',
        'icon'             => 'el el-file-edit'
    ) );
	
	// CUSTOM SLUG NAME
	Redux::setSection( $opt_name, array(
        'title'            => esc_html__( 'Global Settings', 'manual' ),
        'id'               => 'knowledgebase_slug_section',
        'subsection'       => true,
        'customizer_width' => '450px',
        'fields'           => array(
		
				array(
					'id'       => 'hide-private-kb-articles-globally',
					'type'     => 'switch',
					'title'    => esc_html__( 'Private articles', 'manual' ),  
					'default'  => false,
					'desc' => __( '<span style="color: #D01B0B;">This <strong>doesn\'t function with page-builder KB shortcodes and search</strong>. However, all shortcodes and the search function have their own privacy settings.</span>', 'manual' ),
					'subtitle' => esc_html__( 'If turned on, only logged-in users or those with the right permissions can see private articles','manual' ),
					'off' => esc_html__( 'Disable', 'manual' ),
					'on' => esc_html__( 'Enable', 'manual' ),
				),
				array(
					'id'       => 'kb-post-type-has-archive',
					'type'     => 'switch',
					'title'    => esc_html__( 'Has archive', 'manual' ),
					'subtitle' => esc_html__( 'If not specified, the archive slug will automatically match the post type slug.', 'manual' ),
					'desc'     => __( '(default: false) Indicates whether the post type will have a URL for post type archives', 'manual' ),
					'on' => esc_html__( 'True', 'manual' ),
					'off' => esc_html__( 'False', 'manual' ),
					'default'  => false,
				),
				array(
					'id'       => 'kb-slug-name',
					'type'     => 'text',
					'title'    => esc_html__( 'Post slug name', 'manual' ),
					'subtitle' => esc_html__( 'Slug name for knowledgebase single post.', 'manual' ),
					'desc'     => __( '<strong>Will be displayed as: </strong> http://domain.com/<strong>knowledgebase</strong>/creating-new-kb-post/ <br><br> <div style="color: #D01B0B;"><strong>CAUTION:</strong> Knowledgebase link name should not match the page name, or it may result in a 404 error. </div>', 'manual' ),
					'default'  => 'knowledgebase',
				),
			    array(
					'id'       => 'kb-cat-slug-name',
					'type'     => 'text',
					'title'    => esc_html__( 'Category slug name', 'manual' ),
					'subtitle' => esc_html__( 'Slug name for knowledgebase category page.', 'manual' ),
					'desc'     => __( '<strong>Will be displayed as: </strong> http://domain.com/<strong>kb</strong>/customization/ <br><br> <div style="color: #D01B0B;"><strong>CAUTION:</strong> The category slug name should be different from the knowledgebase post and page names. If they match, you\'ll see a 404 error. Also, try not to change the category slug often, as it can cause broken links and affect search results. </div>', 'manual' ),
					'default'  => 'kb',
				),
				array(
					'id'       => 'kb-cat-page-access-control-message',
					'type'     => 'text',
					'title'    => esc_html__( 'Category page access message', 'manual' ),
					'default'  => 'You do not have sufficient permissions to access this Knowledge-base Category.',
					'desc' => esc_html__('Displayed when user lacks sufficient permission to access the chosen category.', 'manual' ),
					'subtitle' => esc_html__('[Access Control]', 'manual' ),
				),
				array(
					'id'       => 'kb-single-page-access-control-message',
					'type'     => 'text',
					'title'    => esc_html__( 'Articles page access message', 'manual' ),
					'default'  => 'You do not have sufficient permissions to access this Knowledge-base Article.',
					'desc' => esc_html__('Displayed when user lacks sufficient permission to access the selected article.', 'manual' ),
					'subtitle' => esc_html__('[Access Control]', 'manual' ),
				),
				array(
					'id'       => 'kb-tag-slug-name',
					'type'     => 'text',
					'title'    => esc_html__( 'Tag slug name', 'manual' ),
					'subtitle' => esc_html__( 'Slug name for knowledgebase tag page.', 'manual' ),
					'desc'     => __( '<strong>Will be displayed as: </strong> http://domain.com/<strong>kb-tag</strong>/kb-post-slug-name/', 'manual' ),
					'default'  => 'kb-tag',
				),
				array(
					'id'       => 'kb-post-type-support-custom-fields',
					'type'     => 'switch',
					'title'    => esc_html__( 'Custom field box', 'manual' ),
					'subtitle' => esc_html__( 'Custom fields in WordPress are a more advanced feature that allows you to include additional information in specific posts.', 'manual' ),
					'on' => esc_html__( 'Enable', 'manual' ),
					'off' => esc_html__( 'Disable', 'manual' ),
					'default'  => false,
				),
				array(
					'id'       => 'kb-gutenberg-editor-onoff',
					'type'     => 'switch',
					'title'    => esc_html__( 'Gutenberg editor', 'manual' ),
					'subtitle' => esc_html__( 'Switch the post type knowledgebase from the classic editor to the Gutenberg editor', 'manual' ),
					'default'  => true,
					'on' => esc_html__( 'Enable', 'manual' ),
					'off' => esc_html__( 'Disable', 'manual' ),
				),
			    array(
					'id'       => 'kb-breadcrumb-name',
					'type'     => 'text',
					'title'    => esc_html__( 'Breadcrumb', 'manual' ),
					'subtitle' => esc_html__( 'Personalized breadcrumb label', 'manual' ),
					'desc'     => __( '<strong>Will be displayed as:</strong>  Home / <strong>Knowledge Base</strong> / Customization /', 'manual' ),
					'default'  => 'Knowledge Base',
				),
				array(
					'id'       => 'kb-breadcrumb-custom-home-url',
					'type'     => 'text',
					'title'    => esc_html__( 'Breadcrumb URL', 'manual' ),
					'subtitle' => esc_html__( 'Custom home page URL for your knowledgebase', 'manual' ),
					'desc'     => __( '<strong>Will be displayed as:</strong>  Home / <a href="">Knowledge Base</a> / Customization /', 'manual' ),
					'default'  => '',
					'class'  => 'theme-option-text-align-right',
				),
				array(
					'id'       => 'kb-hide-notification-bar',
					'type'     => 'switch',
					'title'    => esc_html__( 'Notification bar', 'manual' ),
					'default'  => true,
					'subtitle' => esc_html__( 'A notification bar will be displayed for the \'knowledge base\' post type (applies to both category and single pages).', 'manual' ),
					'on' => esc_html__( 'Disable', 'manual' ),
					'off' => esc_html__( 'Enable', 'manual' ),
				),
	
		)
    ) );
	
	
	// CATEGORY SETTINGS
	Redux::setSection( $opt_name, array(
        'title'            => esc_html__( 'Category Page', 'manual' ),
        'id'               => 'knowledgebase_records_order_section',
        'subsection'       => true,
        'customizer_width' => '450px',
        'fields'           => array(
		
		
						array(
							'id'       => 'kb-cat-sidebar-status',
							'type'     => 'switch',
							'title'    => esc_html__( 'Sidebar', 'manual' ),
							'default'  => false,
							'subtitle' => esc_html__( 'Decide if you want the sidebar to show or hide.', 'manual' ),
							'on' => esc_html__( 'Hide', 'manual' ),
							'off' => esc_html__( 'Show', 'manual' ),
						),
						array(
							'id'       => 'kb-cat-sidebar-position',
							'type'     => 'select',
							'title'    => esc_html__( 'Position', 'manual' ),
							'subtitle'    => esc_html__( 'Select where you want the sidebar to appear.', 'manual' ),
							'options'  => array(
								'left' => esc_html__('Left', 'manual' ),
								'right' => esc_html__('Right', 'manual' ),
							),
							'default'  => 'right',
							'required' => array('kb-cat-sidebar-status','equals','0'),
							'class'  => 'theme-option-text-align-right',
						),
						array(
							'id'       => 'kb-cat-content-center',
							'type'     => 'switch',
							'title'    => esc_html__( 'Column layout', 'manual' ),
							'default'  => false,
							'subtitle' => esc_html__( 'Choose how you\'d like the category records to be shown.', 'manual' ),
							'on' => esc_html__( 'Exact Center', 'manual' ),
							'off' => esc_html__( 'Standard', 'manual' ),
							'required' => array('kb-cat-sidebar-status','equals','1'),
							'class'  => 'theme-option-text-align-right',
						),
						array(
							'id'       => 'all-child-cat-post-in-root-category',
							'type'     => 'switch',
							'title'    => esc_html__( 'Show all child category records within parent', 'manual' ),
							'default'  => false,
							'subtitle' => esc_html__( 'Show all child category records within the parent category without displaying separate sub-categories, i.e all root and child category records will be listed together.', 'manual' ),
						),
						array(
							'id'       => 'kb-cat-view-all',
							'type'     => 'text',
							'title'    => esc_html__( 'View all text', 'manual' ),
							'default'  => 'View All',
							'subtitle' => esc_html__('Appears on the sub-category records: \'View All\' text for more records. (Displayed as: View All (2) &rarr;)','manual' ),
							'required' => array('all-child-cat-post-in-root-category','equals','0'),
							'class'  => 'theme-option-text-align-right',
						),
						array(
							'id'       => 'kb-noof-subcat-records-percat',
							'type'     => 'text',
							'title'    => esc_html__( 'Sub-category records', 'manual' ),
							'subtitle' => esc_html__( 'Select the number of records to show under each sub-category.', 'manual' ),
							'default'  => '5',
							'desc' => esc_html__( 'A value of "-1" will show all results.', 'manual' ),
							'required' => array('all-child-cat-post-in-root-category','equals','0'),
							'class'  => 'theme-option-text-align-right',
						),					
						array(
							'id'       => 'kb-noof-records-catper-page',
							'type'     => 'text',
							'title'    => esc_html__( 'Root category records per page', 'manual' ),
							'subtitle'    => esc_html__( 'Select the number of records to display under the root category.', 'manual' ),
							'default'  => '-1',
							'desc' => esc_html__( 'A value of "-1" will display all the results without pagination.', 'manual' ),
						),
						array(
							'id'       => 'kb-cat-display-order',
							'type'     => 'select',
							'title'    => esc_html__( 'Display order', 'manual' ),
							'subtitle' => esc_html__( 'Order of display for knowledgebase category records', 'manual' ),
							'options'  => array(
								'ASC' => esc_html__('Ascending Order (ASC)','manual' ),
								'DESC' => esc_html__('Descending Order (DESC)','manual' ),
							),
							'default'  => 'ASC'
						),
						array(
							'id'       => 'kb-cat-display-order-by',
							'type'     => 'select',
							'title'    => esc_html__( 'Display order by', 'manual' ),
							'subtitle' => esc_html__( 'Order of display by for knowledgebase category records', 'manual' ),
							'options'  => array(
								'ID' => esc_html__('Order by post id','manual' ),
								'title' => esc_html__('Order by title','manual' ),
								'name' => esc_html__('Order by post name','manual' ),
								'date' => esc_html__('Order by date','manual' ),
								'modified' => esc_html__('Order by last modified date','manual' ),
								'rand' => esc_html__('Order by Random','manual' ),
								'comment_count' => esc_html__('Order by number of comment','manual' ),
								'menu_order' => esc_html__('Page Order','manual' ),
								'none' => esc_html__('None','manual' ),
							),
							'default'  => 'date'
						),
						// DESIGN SETTINGS
						array(
							'id'       => 'kb-other-category-settings',
							'type'     => 'section',
							'title'    => esc_html__( 'Design Settings', 'manual' ),
							'indent'   => true, 
						),
						array(
							'id'       => 'kb-catpg-display-style',
							'type'     => 'image_select',
							'title'    => esc_html__( 'Title style', 'manual' ),
							'subtitle' => esc_html__( 'Choose the title style for the knowledgebase article.', 'manual' ),
							'options'  => array(
								'1' => array( 'img' => trailingslashit(get_template_directory_uri()) .'framework/ReduxCore/manual/doc-post-style-one.jpg' ),
								'2' => array( 'img' => trailingslashit(get_template_directory_uri()) .'framework/ReduxCore/manual/doc-post-style-two.jpg' ),
							),
							'default'  => '1'
						),
						array(
							'id'       => 'kb-catpg-display-style-one-col-layout',
							'type'     => 'select',
							'title'    => esc_html__( 'Choose sub-category layout', 'manual' ),
							'subtitle' => esc_html__( 'Choose the column layout for your sub-category records', 'manual' ),
							'options'  => array(
								'1' => esc_html__('1 Column','manual' ),
								'2' => esc_html__('2 Columns','manual' ),
							),
							'default'  => '2',
							'required' => array (
												array('kb-catpg-display-style','equals','1'),
												array('all-child-cat-post-in-root-category','equals','0'),
												),
						),
						array(
							'id'       => 'kb-catpg-display-style-one-col-layout-li-applyborder',
							'type'     => 'switch',
							'title'    => esc_html__('Border', 'manual' ),
							'subtitle' => esc_html__('Apply border to each sub-category records', 'manual'),
							'default'  => false,
							'required' => array('kb-catpg-display-style-one-col-layout','equals','1'),
							'class'  => 'theme-option-text-align-right',
						),
						array(
							'id'       => 'kb-catpg-display-style-one-col-layout-grid-style',
							'type'     => 'switch',
							'title'    => esc_html__('Grid style', 'manual' ),
							'subtitle' => esc_html__('Show sub-category records in grid style', 'manual'),
							'default'  => false,
							'required' => array('kb-catpg-display-style-one-col-layout','equals','1'),
							'class'  => 'theme-option-text-align-right',
						),
						array(
							'id'       => 'knowledgebase-cat-quick-stats-under-title-appear-right',
							'type'     => 'switch',
							'title'    => esc_html__( 'Meta field display position', 'manual' ),
							'subtitle' => esc_html__('Select meta field (post views and post published date) display position for root category', 'manual'),
							'default'  => false,
							'on' => esc_html__( 'Right Align', 'manual' ),
							'off' => esc_html__( 'Normal', 'manual' ),
							'required' => array('kb-catpg-display-style','equals','1'),
						),
						array(
							'id'       => 'kb-cat-design2-aitc-text',
							'type'     => 'text',
							'title'    => esc_html__('Record count text', 'manual'),
							'subtitle'    => esc_html__('Text displayed after the total count of records for the sub-category.', 'manual'),
							'default'  => 'articles in this collection',
							'required' => array('kb-catpg-display-style','equals','2'),
						),
						array(
							'id'       => 'kb-cat-design2-wby-text',
							'type'     => 'text',
							'title'    => esc_html__('Pre-Author text', 'manual'),
							'subtitle'    => esc_html__('The words shown before the author\'s name.', 'manual'),
							'default'  => 'Written by',
							'required' => array('kb-catpg-display-style','equals','2'),
						),
						array(
							'id'       => 'kb-cat-design2-icon-color',
							'type'     => 'color_rgba',
							'title'    => esc_html__( 'Icon color', 'manual' ),
							'subtitle'    => esc_html__( 'Pick a color for the icon that appear before the category title.', 'manual' ),
							'default'  => array(
											'color' => '#46b289',
										),
						),
						array(
							'id'       => 'knowledgebase-remove-subcategory-description',
							'type'     => 'switch',
							'title'    => esc_html__( 'Description for sub-category', 'manual' ),
							'subtitle' => esc_html__('Show or hide descriptions under category names.', 'manual'),
							'default'  => false,
							'on' => esc_html__( 'Hide', 'manual' ),
							'off' => esc_html__( 'Show', 'manual' ),
						),
						array(
							'id'       => 'knowledgebase-remove-subcategory-readmore',
							'type'     => 'switch',
							'title'    => esc_html__( 'Read more text', 'manual' ),
							'subtitle' => esc_html__('Show or hide link text that appears below sub-category records.', 'manual'),
							'default'  => false,
							'on' => esc_html__( 'Hide', 'manual' ),
							'off' => esc_html__( 'Show', 'manual' ),
							'required' => array('kb-catpg-display-style','equals','1'),
							'class'  => 'theme-option-text-align-right',
						),
						array(
							'id'       => 'knowledgebase-cat-quick-stats-under-title',
							'type'     => 'switch',
							'title'    => esc_html__( 'Post views and date', 'manual' ),
							'subtitle' => esc_html__('Enable/Disable meta fields below article title', 'manual'),
							'default'  => false,
							'on' => esc_html__( 'Hide', 'manual' ),
							'off' => esc_html__( 'Show', 'manual' ),
							'required' => array('kb-catpg-display-style','equals','1'),
						),
						array(
							'id'       => 'knowledgebase-cat-style1-post-excerpt',
							'type'     => 'switch',
							'title'    => esc_html__( 'Post excerpt', 'manual' ),
							'subtitle' => esc_html__('Enable/Disable post excerpt that apper below post title', 'manual'),
							'default'  => false,
							'on' => esc_html__( 'Enable', 'manual' ),
							'off' => esc_html__( 'Disable', 'manual' ),
						),
						array(
							'id'       => 'kb-cat-design2-articles-excerpt-trim',
							'type'     => 'text',
							'title'    => esc_html__('Excerpt length', 'manual'),
							'subtitle' => esc_html__( 'By default, the excerpt length is set to 25 words. Utilize this excerpt length filter to adjust it to X words.', 'manual' ),
							'default'  => '25',
							'required' =>  array('knowledgebase-cat-style1-post-excerpt','equals','1'),
							'class'  => 'theme-option-text-align-right',
						),
						array(
							'id'       => 'kb-cat-design2-articles-excerpt-color',
							'type'     => 'color_rgba',
							'title'    => esc_html__( 'Excerpt text color', 'manual' ),
							'subtitle'    => esc_html__( 'Adjust the excerpt text color as required.', 'manual' ),
							'default'  => array(
											'color' => '#777777',
											'alpha' => '.9'
										),
							'required' =>  array('knowledgebase-cat-style1-post-excerpt','equals','1'),
							'class'  => 'theme-option-text-align-right',
						),
						// GROUP - 2
						array(
							'id'       => 'kb-cat-design2-articleboxbg-color',
							'type'     => 'color_rgba',
							'title'    => esc_html__( 'Background color', 'manual' ),
							'subtitle' => esc_html__( 'Define background color for root category article box.', 'manual' ),
							'default'  => array(
											'color' => '#f9f9f9',
											'alpha' => '.6'
										),
							'required' => array('kb-catpg-display-style','equals','2'),
						),
						array(
							'id'       => 'kb-cat-design2-metabox-color',
							'type'     => 'color_rgba',
							'title'    => esc_html__( 'Meta color', 'manual' ),
							'subtitle' => esc_html__( 'Select meta color (author and date) as needed.', 'manual' ),
							'default'  => array(
											'color' => '#808080',
											'alpha' => '.9'
										),
							'required' => array('kb-catpg-display-style','equals','2'),
						),
	
		)
    ) );
	
	
	// SINGLE PAGE SETTINGS
	Redux::setSection( $opt_name, array(
        'title'            => esc_html__( 'Single Page', 'manual' ),
        'id'               => 'kb_single_records_on_off_section',
        'subsection'       => true,
        'customizer_width' => '450px',
        'fields'           => array(
				
				array(
					'id'       => 'kb-singlepg-title-tag',
					'type'     => 'select',
					'title'    => esc_html__( 'Title tag', 'manual' ),
					'subtitle'    => esc_html__( 'Choose the post title tag.', 'manual' ),
					'options'  => array(
						'h2' => esc_html__('h2','manual' ),
						'h1' => esc_html__('h1','manual' ),
					),
					'default'  => 'h1', 
				),
				array(
					'id'       => 'kb-cat-sidebar-singlepg-status',
					'type'     => 'switch',
					'title'    => esc_html__( 'Sidebar', 'manual' ),
					'default'  => false,
					'subtitle' => esc_html__( 'Decide if you want the sidebar to show or hide.', 'manual' ),
					'on' => esc_html__( 'Hide', 'manual' ),
					'off' => esc_html__( 'Show', 'manual' ),
				),
				array(
					'id'       => 'kb-single-page-content-center',
					'type'     => 'switch',
					'title'    => esc_html__( 'Column layout', 'manual' ),
					'default'  => false,
					'subtitle' => esc_html__( 'Choose how you\'d like the page to be shown.', 'manual' ),
					'on' => esc_html__( 'Exact Center', 'manual' ),
					'off' => esc_html__( 'Standard', 'manual' ),
					'required' => array('kb-cat-sidebar-singlepg-status','equals','1'),
					'class'  => 'theme-option-text-align-right',
				),
				array(
					'id'       => 'kb-single-page-sidebar-position',
					'type'     => 'select',
					'title'    => esc_html__( 'Position', 'manual' ),
					'subtitle' => esc_html__( 'Select where you want the sidebar to appear.', 'manual' ),
					'options'  => array(
						'left' => esc_html__('Left','manual' ),
						'right' => esc_html__('Right','manual' ),
					),
					'default'  => 'right',
					'required' => array('kb-cat-sidebar-singlepg-status','equals','0'),
					'class'  => 'theme-option-text-align-right',
				),
				array(
					'id'       => 'kb-toc-inside-post',
					'type'     => 'switch',
					'title'    => __('Table of content (TOC)','manual'),
					'subtitle' => esc_html__('Show the table of contents (TOC) within the knowledgebase article.', 'manual'),
					'desc' => __('<span style="color:#D01B0B;">Make sure the TOC widget is off in the knowledgebase sidebar to avoid errors. Also, note that TOC won\'t work in posts created with wpBakery or Elementor.</span>', 'manual'),
					'default'  => false,
					'on' => esc_html__( 'Enable', 'manual' ),
					'off' => esc_html__( 'Disable', 'manual' ),
				),
				array(
					'id'       => 'kb-comment-status',
					'type'     => 'switch',
					'title'    => esc_html__( 'Comments', 'manual' ),
					'subtitle' => esc_html__( 'Enable comments on each article.', 'manual' ),
					'default'  => false,
					'on' => esc_html__( 'On', 'manual' ),
					'off' => esc_html__( 'Off', 'manual' ),
				),
				array(
					'id'       => 'kb-comment-box-on-thumbsdown',
					'type'     => 'switch',
					'title'    => __('Conditional display of comment box','manual' ),
					'subtitle' => esc_html__( 'Show comment box only when user clicks on the thumbs down feedback button.', 'manual' ),
					'default'  => false,
					'required' => array('kb-comment-status','equals','1'),
					'class'  => 'theme-option-text-align-right',
				),
				array(
					'id'       => 'kb-post-contact-us-link',
					'type'     => 'switch',
					'title'    => __('Contact us link','manual'),
					'subtitle' => esc_html__('The "[Didn\'t find your answer? @ Contact Us]" link will be displayed below the related posts and above the comment box.', 'manual'),
					'desc' => __('<span style="color:#0273ff;"><strong>INFORMATION:</strong></span> To modify the text ("Didn\'t find your answer? @ Contact Us") and link, please navigate to the "Theme Option > Text" section.', 'manual'),
					'default'  => true,
					'on' => esc_html__( 'Enable', 'manual' ),
					'off' => esc_html__( 'Disable', 'manual' ),
				),
				array(
					'id'       => 'knowledgebase-social-share-status',
					'type'     => 'switch',
					'title'    => esc_html__( 'Social share', 'manual' ),
					'subtitle' => esc_html__('Turn on or off the option to share articles on different social networks.', 'manual'),
					'default'  => false,
					'on' => esc_html__( 'Disable', 'manual' ),
					'off' => esc_html__( 'Enable', 'manual' ),
				),
				array(
					'id'       => 'knowledgebase-voting-buttons-status',
					'type'     => 'switch',
					'title'    => esc_html__('Post voting', 'manual' ),
					'subtitle' => esc_html__('Boost your content quality by letting readers vote on articles.', 'manual'),
					'default'  => false,
					'on' => esc_html__( 'Disable', 'manual' ),
					'off' => esc_html__( 'Enable', 'manual' ),
				),
				array(
					'id'       => 'knowledgebase-voting-login-users',
					'type'     => 'switch',
					'title'    => __('Access control','manual'),
					'subtitle' => esc_html__('Only users who are logged in can vote on articles.', 'manual'),
					'default'  => false,
					'on' => esc_html__( 'Enable', 'manual' ),
					'off' => esc_html__( 'Disable', 'manual' ),
					'required' => array('knowledgebase-voting-buttons-status','equals','0'),
					'class'  => 'theme-option-text-align-right',
				),
				array(
					'id'       => 'kb-related-post-status',
					'type'     => 'switch',
					'title'    => esc_html__( 'Related Posts', 'manual' ),
					'subtitle' => esc_html__( 'Introducing your readers to other relevant content.', 'manual' ),
					'default'  => true,
					'on' => esc_html__( 'Enable', 'manual' ),
					'off' => esc_html__( 'Disable', 'manual' ),
				),
				array(
					'id'       => 'kb-related-post-per-page',
					'type'     => 'text',
					'title'    => esc_html__( 'Related posts', 'manual' ),
					'subtitle' => esc_html__( 'Manage how many related posts are shown.', 'manual' ),
					'default'  => '6',
					'required' => array('kb-related-post-status','equals','1'),
					'class'  => 'theme-option-text-align-right',
				),
				array(
					'id'       => 'kb-related-post-title',
					'type'     => 'text',
					'title'    => esc_html__( 'Related title', 'manual' ),
					'default'  => 'Related Articles',
					'subtitle' => esc_html__('Topic/Title showcasing a list of related records based on the current post.', 'manual' ),
					'required' => array('kb-related-post-status','equals','1'),
					'class'  => 'theme-option-text-align-right',
				),
				array(
					'id'       => 'kb-next-previous-post',
					'type'     => 'switch',
					'title'    => __('Next Previous link','manual'),
					'subtitle' => esc_html__('Links to the next and previous articles will appear at the bottom of the knowledgebase article.', 'manual'),
					'default'  => true,
					'on' => esc_html__( 'Enable', 'manual' ),
					'off' => esc_html__( 'Disable', 'manual' ),
				),
				array(
					'id'       => 'kb-next-previous-post-bg-color',
					'type'     => 'color_rgba',
					'title'    => esc_html__( 'Background color', 'manual' ),
					'subtitle' => esc_html__( 'Background color for Next/Previous section.', 'manual' ),
					'default'  => array(
									'color' => '#f7f7f7',
									'alpha' => '1'
								),
					'required' => array('kb-next-previous-post','equals',true),
					'desc' => esc_html__('(Default:#f7f7f7)','manual' ),
					'class'  => 'theme-option-text-align-right',
				),
				// DESIGN KB SINGLE PAGE
				array(
					'id'       => 'kb-singlepage-design-settings',
					'type'     => 'section',
					'title'    => esc_html__( 'Design Settings', 'manual' ),
					'indent'   => true, 
				),
				array(
					'id'       => 'kb-singlepg-display-style',
					'type'     => 'image_select',
					'title'    => esc_html__( 'Title style', 'manual' ),
					'subtitle' => esc_html__( 'Choose the title style for the knowledgebase article.', 'manual' ),
					'options'  => array(
						'1' => array( 'img' => trailingslashit(get_template_directory_uri()) .'framework/ReduxCore/manual/doc-post-style-one.jpg' ),
						'2' => array( 'img' => trailingslashit(get_template_directory_uri()) .'framework/ReduxCore/manual/doc-post-style-two.jpg' ),
					),
					'default'  => '1'
				),
				array(
					'id'       => 'kb-singlepg-design2-wby-text',
					'type'     => 'text',
					'title'    => esc_html__('Pre-Author text', 'manual'),
					'subtitle'    => esc_html__('The words shown before the author\'s name.', 'manual'),
					'default'  => 'Written by',
					'required' => array('kb-singlepg-display-style','equals','2'),
				),
				array(
					'id'       => 'kb-singlepg-design2-metabox-color',
					'type'     => 'color_rgba',
					'title'    => esc_html__( 'Color', 'manual' ),
					'subtitle' => esc_html__( 'Article meta Color (Author & Date)', 'manual' ),
					'default'  => array(
									'color' => '#808080',
									'alpha' => '.9'
								),
					'required' => array('kb-singlepg-display-style','equals','2'),
				),
				array(
					'id'       => 'kb-remove-article-title-icon',
					'type'     => 'switch',
					'title'    => esc_html__( 'Pre-title icon', 'manual' ),
					'subtitle'    => esc_html__( 'Icon that shows up before the title of the post.', 'manual' ),
					'default'  => true,
					'on' => esc_html__( 'Enable', 'manual' ),
					'off' => esc_html__( 'Disable', 'manual' ),
					'required' => array('kb-singlepg-display-style','equals','1'),
				),
				array(
					'id'       => 'kb-single-pg-print-status',
					'type'     => 'switch',
					'title'    => esc_html__( 'Print', 'manual' ),
					'default'  => true,
					'subtitle' => esc_html__( 'Switch the ability to print the article on or off below the post title.', 'manual' ),
					'on' => esc_html__( 'Enable', 'manual' ),
					'off' => esc_html__( 'Disable', 'manual' ),
				),
				array(
					'id'       => 'knowledgebase-quick-stats-under-title',
					'type'     => 'switch',
					'title'    => esc_html__( 'Views & Likes Metadata', 'manual' ),
					'subtitle' => esc_html__('Activate/deactivate the article\'s view count and positive feedback, such as the number of likes, displayed below the post title.', 'manual'),
					'default'  => false,
					'on' => esc_html__( 'Disable', 'manual' ),
					'off' => esc_html__( 'Enable', 'manual' ),
				),
				array(
					'id'       => 'kb-singlepg-publish-date-status',
					'type'     => 'switch',
					'title'    => esc_html__( 'Post publish date', 'manual' ),
					'default'  => true,
					'subtitle' => esc_html__( 'Enable/disable the display of the post publish date below the post title.', 'manual' ),
					'on' => esc_html__( 'Enable', 'manual' ),
					'off' => esc_html__( 'Disable', 'manual' ),
					'required' => array('kb-singlepg-display-style','equals','1'),
				),
				array(
					'id'       => 'kb-singlepg-modified-date-status',
					'type'     => 'switch',
					'title'    => esc_html__( 'Post modified date', 'manual' ),
					'default'  => true,
					'subtitle' => esc_html__( 'Enable/disable the display of the post modified date below the post title.', 'manual' ),
					'on' => esc_html__( 'Enable', 'manual' ),
					'off' => esc_html__( 'Disable', 'manual' ),
					'required' => array('kb-singlepg-display-style','equals','1'),
				),
				array(
					'id'       => 'kb-disable-doc-author-name',
					'type'     => 'switch',
					'title'    => esc_html__( 'Author name', 'manual' ),
					'default'  => true,
					'subtitle' => esc_html__('Enable or disable showing the author name below the post title.', 'manual' ),
					'on' => esc_html__( 'Enable', 'manual' ),
					'off' => esc_html__( 'Disable', 'manual' ),
					'required' => array('kb-singlepg-display-style','equals','1'),
				),
				array(
					'id'       => 'kb-single-post-user-name',
					'type'     => 'select',
					'title'    => esc_html__( 'Customize author name display options', 'manual' ),
					'subtitle' => esc_html__( 'Choose the way you want the author\'s name to be shown.', 'manual' ),
					'options'  => array(
						'user_login' => esc_html__('User Login','manual' ),
						'user_nicename' => esc_html__('User Nicename','manual' ),
						'user_registered' => esc_html__('User Registered','manual' ),
						'display_name' => esc_html__('Display Name','manual' ),
						'first_name' => esc_html__('First Name','manual' ),
						'user_firstname' => esc_html__('User Firstname','manual' ),
					),
					'default'  => 'user_nicename',
					'required' => array('kb-disable-doc-author-name','equals','1'),
					'class'  => 'theme-option-text-align-right',
				),
				
		)
    ) );
	
	// KNOWLEDGEBASE CUSTOM SINGLE PAGE HEADER
	Redux::setSection( $opt_name, array(
	'title'            => __( 'Custom \'Page Title Bar\' - Single Page', 'manual' ),
	'id'               => 'kb_custom_singlepg_header',
	'subsection'       => true,
	'customizer_width' => '450px',
	'fields'           => array(

				array(
					'id'       => 'knowledgebase_pagetitlebar_header_menu',
					'type'     => 'switch',
					'title'    => esc_html__( 'Customize the header menu', 'manual' ),
					'subtitle' => esc_html__('Modify the main header, including the logo and menu colors, if needed.', 'manual'),
					'default'  => false,
				),
				array(
					'id'       => 'knowledgebase_pagetitlebar_header_background_colorbg',
					'type'     => 'color_rgba',
					'title'    => esc_html__( 'Background color', 'manual' ),
					'subtitle'    => esc_html__( 'Set the header background.', 'manual' ),
					'output'    => array('background' => '.navbar-inverse.theme-single-kb-page'),
					'required' => array('knowledgebase_pagetitlebar_header_menu','equals','1'),
					'class' => 'theme-option-text-align-right',			
				),
				array(
					'id'       => 'knowledgebase_pagetitlebar_header_first_level_menu_text_color',
					'type'     => 'link_color',
					'title'    => esc_html__( 'Menu link color', 'manual' ),
					'subtitle' => esc_html__('Text color for the first level of the navigation menu.', 'manual'),
					'active'    => false, 
					'visited'   => false,
					'output'    => array('.navbar-inverse.theme-single-kb-page .navbar-nav>li>a'), 
					'required' => array('knowledgebase_pagetitlebar_header_menu','equals','1'),
					'class' => 'theme-option-text-align-right',
				),
				array(
					'id'       => 'knowledgebase_pagetitlebar_header_flip_logo',
					'type'     => 'switch',
					'title'    => esc_html__( 'Flip logo', 'manual' ),
					'subtitle' => esc_html__('Switch from the \'primary logo\' to the \'secondary logo,\' if necessary.', 'manual'),
					'default'  => false,
					'class' => 'theme-option-text-align-right',
					'required' => array('knowledgebase_pagetitlebar_header_menu','equals','1'),
				),
				array(
					'id'       => 'knowledgebase_pagetitlebar_header_shadow',
					'type'     => 'switch',
					'title'    => esc_html__('Header shadow', 'manual' ),
					'desc' => esc_html__('Please note that this function is effective only when the header shadow is enabled in the \'Header Menu > Main Header\' settings.', 'manual'),
					'subtitle' => esc_html__('Turn the default header shadow on or off.', 'manual'),
					'default'  => false,
					'class' => 'theme-option-text-align-right',
					'required' => array('knowledgebase_pagetitlebar_header_menu','equals','1'),
				),
				array(
					'id'       => 'knowledgebase_pagetitlebar_header_menu_border_btm',
					'type'     => 'border',
					'title'    => esc_html__( 'Header border bottom', 'manual' ),
					'subtitle' => esc_html__('Re-adjust header border bottom', 'manual'),
					'color_alpha'  => true,
					'left'  => false,
					'right'  => false,
					'top'  => false,
					'class' => 'theme-option-text-align-right',
					'required' => array('knowledgebase_pagetitlebar_header_menu','equals','1'),
					'output'    => array('.navbar.theme-single-kb-page'),
				),
				array(
					'id'       => 'knowledgebase_pagetitlebar_header_menu_border_top',
					'type'     => 'border',
					'title'    => esc_html__( 'Header border top', 'manual' ),
					'subtitle' => esc_html__('Re-adjust header border top', 'manual'),
					'desc' => esc_html__('If \'Menu position\' is set to \'Logo on Top\' and \'Menu Below Logo\' in \'Theme > Options > Header Menu > Main Header\', then this feature will work properly.', 'manual'),
					'color_alpha'  => true,
					'left'  => false,
					'right'  => false,
					'bottom'  => false,
					'required' => array('knowledgebase_pagetitlebar_header_menu','equals','1'),
					'class' => 'theme-option-text-align-right',
					'output'    => array('.navbar.theme-single-kb-page .navbar-collapse.collapse'),
				),
				array(
					'id'       => 'manualkb_single_headermenu_hamburger_searchbox',
					'type'     => 'switch',
					'title'    => esc_html__( 'Hide the search box in the Hamburger menu.', 'manual' ),
					'desc' => esc_html__('This feature will only function if enabled \'Search Box in Hamburger Menu\' in the \'Theme Options\' under \'Header Menu\' in the \'Main Header\' section.', 'manual'),
					'default'  => false,
					'required' => array('knowledgebase_pagetitlebar_header_menu','equals','1'),
					'on' => esc_html__( 'Hide', 'manual' ),
					'off' => esc_html__( 'Theme Default', 'manual' ),
					'class' => 'theme-option-text-align-right',
				),
				array(
					'id'       => 'onoff-knowledgebase-single-page-title-bar',
					'type'     => 'switch',
					'title'    => esc_html__('Page title bar', 'manual' ),
					'subtitle'    => esc_html__('Enable/Disable page title bar', 'manual' ),
					'desc' => __('Note: Disabling the page title bar will change the menu style to the default setting, meaning that no transparent menu style will be used.', 'manual'),
					'default'  => true,
					'on'       => esc_html__( 'Enable', 'manual' ),
					'off'      => esc_html__( 'Disable', 'manual' ),
				),
				// -------------- Page Title Bar Controls --------------
				array(
					'id'       => 'kb-kb-single-page-title-bar-controls',
					'type'     => 'section',
					'title'    => esc_html__( 'Page Title Bar', 'manual' ),
					'indent'   => true, 
					'required' => array('onoff-knowledgebase-single-page-title-bar','equals','1'),  
				),
				array(
					'id'       => 'kbsinglepg-header-height',
					'type'     => 'text',
					'title'    => esc_html__( 'Page title bar :: padding', 'manual' ),
					'subtitle'    => esc_html__( 'Re-adjust the space above and below the \'Page Title Bar\' on your knowledgebase single page.', 'manual' ),
					'desc' => __('Example: 32px 0px 32px 0px (top, right, bottom, left) <br><br><strong style="color:#e6614b;">IMPORTANT: Make sure the value of RIGHT, LEFT is always 0px</strong>', 'manual' ),
					'default'  => '32px 0px 32px 0px',
				),
				array(
					'id'       => 'kbsinglepg-responsive-header-height',
					'type'     => 'text',
					'title'    => esc_html__( 'Page title bar :: Responsive padding', 'manual' ),
					'subtitle' => esc_html__( 'Re-adjust the top/bottom spacing for page title bar', 'manual' ),
					'desc'     => __( 'Example: 100px 0px 100px 0px (top, right, bottom, left) <br><br><strong style="color:#e6614b;">IMPORTANT: Make sure the value of RIGHT, LEFT is always 0px</strong>', 'manual' ), 
					'default'  => '',
				),
				array(
					'id'       => 'kb-single-pg-title-text-status',
					'type'     => 'switch',
					'title'    => esc_html__( 'Category Name', 'manual' ),
					'default'  => true,
					'subtitle' => esc_html__( 'Show post category name in page title bar', 'manual' ),
					'on' => esc_html__( 'Disable', 'manual' ),
					'off' => esc_html__( 'Enable', 'manual' ),
				),
				array(
					'id'       => 'kb-title-on-page-title-bar',
					'type'     => 'switch',
					'title'    => __('Post title','manual'),
					'subtitle' => esc_html__('Replace category name with post title', 'manual'),
					'default'  => false,
					'on' => esc_html__( 'Enable', 'manual' ),
					'off' => esc_html__( 'Disable', 'manual' ),
					'class'  => 'theme-option-text-align-right',
					'required' => array('kb-single-pg-title-text-status','equals','0'),
				),
				array(
					'id'       => 'kb_pagetitlebar-title-color',
					'type'     => 'color',
					'title'    => esc_html__( 'Title color', 'manual' ),
					'subtitle'    => esc_html__( 'Page title bar text color', 'manual' ),
					'class'  => 'theme-option-text-align-right',
					'required' => array('kb-single-pg-title-text-status','equals','0'), 
				),
				array(
					'id'       => 'kb_pagetitlebar_singlepg_text_typography',
					'type'        => 'typography',
					'title'    => esc_html__( 'Title typography', 'manual' ),
					'subtitle' => esc_html__( 'Customize title text.', 'manual' ),
					'output'    => array('.noise-break.theme-single-kb-page h1.custom_h1_head'),
					'required' => array('kb-single-pg-title-text-status','equals','0'), 
					'google'      => true,
					'font-backup' => false,
					'text-align' => false,
					'text-transform' => true,
					'subsets'       => false, 
					'letter-spacing'=> true,  
					'all_styles'  => true,
					'font-backup' => true,
					'word-spacing' => true,
					'margin-top' => true,
					'margin-bottom' => true,
					'color' => false,
					'units' => 'px',
					'class' => 'theme-option-text-align-right',
				),
				array(
					'id'       => 'kb-single-pg-header-description-status',
					'type'     => 'switch',
					'title'    => esc_html__( 'Category description', 'manual' ),
					'default'  => false,
					'subtitle' => esc_html__( 'Display category description in \'Page Title Bar\'', 'manual' ),
					'on' => esc_html__( 'Enable', 'manual' ),
					'off' => esc_html__( 'Disable', 'manual' ),
				),
				array(
					'id'       => 'kb_pagetitlebar-description-color',
					'type'     => 'color',
					'title'    => esc_html__( 'Description color', 'manual' ),
					'subtitle'    => esc_html__( 'Category description color', 'manual' ),
					'class'  => 'theme-option-text-align-right',
					'required' => array('kb-single-pg-header-description-status','equals','1'), 
				),
				array(
					'id'       => 'kb_pagetitlebar_desc_singlepg_typography',
					'type'        => 'typography',
					'title'    => esc_html__( 'Description typography', 'manual' ),
					'subtitle' => esc_html__( 'Customize description text.', 'manual' ),
					'output'    => array('.noise-break.theme-single-kb-page .header-desc p'),
					'required' => array('kb-single-pg-header-description-status','equals','1'),
					'google'      => true,
					'font-backup' => false,
					'text-align' => false,
					'text-transform' => true,
					'subsets'       => false, 
					'letter-spacing'=> true,  
					'all_styles'  => true,
					'font-backup' => true,
					'word-spacing' => true,
					'margin-top' => true,
					'margin-bottom' => true,
					'color' => false,
					'units'       => 'px',
					'class' => 'theme-option-text-align-right',
				),
				array(
					'id'       => 'kbsinglepg-text-align',
					'type'     => 'select',
					'title'    => esc_html__( 'Text align', 'manual' ),
					'subtitle'    => esc_html__( 'Adjust the alignment of the text on the \'page title bar\'', 'manual' ),
					'options'  => array(
						'center' => esc_html__('Center','manual' ),
						'left' => esc_html__('Left','manual' ),
						'right' => esc_html__('Right','manual' ),
					),
					'default'  => 'center',
				),
				array(
					'id'       => 'kb-single-pg-header-search-status',
					'type'     => 'switch',
					'title'    => esc_html__( 'Search box', 'manual' ),
					'default'  => false,
					'subtitle' => esc_html__( 'Choose to show or hide the search box in the specified \'page title bar\' area.', 'manual' ),
					'on' => esc_html__( 'Disable', 'manual' ),
					'off' => esc_html__( 'Enable', 'manual' ),
				),
				array(
					'id'       => 'kbsinglepg-searchbox-display-position',
					'type'     => 'select',
					'title'    => esc_html__( 'Search box position', 'manual' ),
					'subtitle'    => esc_html__( 'Choose where to place the search box on the \'page title bar\'.', 'manual' ),
					'options'  => array(
						'center' => esc_html__('Exact Center', 'manual' ),
						'6' => esc_html__('50% Width', 'manual' ),
						'7' => esc_html__('58% Width', 'manual' ),
						'8' => esc_html__('66% Width', 'manual' ),
						'9' => esc_html__('75% Width', 'manual' ),
						'10' => esc_html__('83% Width', 'manual' ),
						'11' => esc_html__('91% Width', 'manual' ),
						'12' => esc_html__('100% Width', 'manual' ),
					),
					'default'  => 'center',
					'required' => array('kb-single-pg-header-search-status','equals','0'),
					'class'  => 'theme-option-text-align-right',
				),
				array(
					'id'       => 'knowledgebase-pagetitlebar-searchbox-treanding-search-color',
					'type'     => 'color',
					'title'    => esc_html__( 'Title text color', 'manual' ),
					'subtitle'    => esc_html__( 'Trending search text title color', 'manual' ),
					'required' => array('kb-single-pg-header-search-status','equals','0'),
					'output'    => array('.noise-break.theme-single-kb-page .trending-search span.popular-keyword-title'),
					'class' => 'theme-option-text-align-right',
				),
				array(
					'id'       => 'knowledgebase-pagetitlebar-searchbox-treanding-search-link-color',
					'type'     => 'link_color',
					'title'    => esc_html__( 'Link color', 'manual' ),
					'subtitle'    => esc_html__( 'The trending keyword link color', 'manual' ),
					'active'    => false, 
					'visited'   => false,
					'required' => array('kb-single-pg-header-search-status','equals','0'),
					'output'    => array('.noise-break.theme-single-kb-page .trending-search a.trending-search-popular-keyword'),  
					'class' => 'theme-option-text-align-right',
				),
				array(
					'id'       => 'kb-single-pg-header-breadcrumb-status',
					'type'     => 'switch',
					'title'    => esc_html__( 'Breadcrumb', 'manual' ),
					'default'  => false,
					'subtitle' => esc_html__( 'Choose to show or hide the breadcrumb in the specified \'page title bar\' area.', 'manual' ),
					'on' => esc_html__( 'Disable', 'manual' ),
					'off' => esc_html__( 'Enable', 'manual' ),
				),
				array(
					'id'       => 'knowledgebase_pagetitlebar_breadcrumb_regular_text_color',
					'type'     => 'color_rgba',
					'title'    => esc_html__( 'Regular text color', 'manual' ),
					'subtitle' => esc_html__('Breadcrumb regular text color.', 'manual'),
					'required' => array('kb-single-pg-header-breadcrumb-status','equals','0'),
					'class' => 'theme-option-text-align-right',
				),
				array(
					'id'       => 'knowledgebase_pagetitlebar_breadcrumb_link_color',
					'type'     => 'link_color',
					'title'    => esc_html__( 'Link color', 'manual' ),
					'subtitle' => esc_html__('Adjust the color of breadcrumb links if needed.', 'manual'),
					'required' => array('kb-single-pg-header-breadcrumb-status','equals','0'),
					'active'  => false,
					'class' => 'theme-option-text-align-right',
				),
				array(
					'id'       => 'knowledgebase_pagetitlebar_breadcrumb_link_seprator_color',
					'type'     => 'color_rgba',
					'title'    => esc_html__( 'Link seprator color', 'manual' ),
					'subtitle' => esc_html__('Adjust the color of breadcrumb link seprators if needed.', 'manual'),
					'required' => array('kb-single-pg-header-breadcrumb-status','equals','0'),
					'class' => 'theme-option-text-align-right',
				),
				array(
					'id'       => 'knowledgebase-pagetitlebar-background-setup',
					'type' => 'background',
					'title'    => esc_html__( 'Background', 'manual' ),
					'subtitle' => esc_html__( 'Create the background for your knowledgebase single page.', 'manual' ),
					'desc' => __( '<span style="color:red;">IMPORTANT:</span> If a post has a featured image, it will overwrite the image uploaded here and be displayed on the \'page header bar\'. Please note that if you do not want the featured image to overwrite the uploaded image overhere, you can use the  \'Disable Featured images on \'Page Title Bar\'\' option below.', 'manual' ),
				),
				array(
					'id'       => 'knowledgebase-pagetitlebar-image-overlay',
					'type'     => 'color_rgba',
					'title'    => esc_html__( 'Background overlay', 'manual' ),
					'subtitle'    => esc_html__( 'Select the background overlay for your knowledgebase page title bar.', 'manual' ),
					'class' => 'theme-option-text-align-right',
				),
				array(
					'id'       => 'knowledgebase-pagetitlebar-featured-image',
					'type'     => 'switch',
					'title'    => esc_html__( 'Featured image', 'manual' ),
					'default'  => false,
					'subtitle' => esc_html__( 'Globally disable post featured images on the \'page title bar\'.', 'manual' ),
					'on' => esc_html__( 'Disable', 'manual' ),
					'off' => esc_html__( 'Enable', 'manual' ),
				),
				array(
					'id'       => 'knowledgebase-pagetitlebar-featureimg-background-setup',
					'type' => 'background',
					'title'    => esc_html__( 'Background', 'manual' ),
					'subtitle' => esc_html__( 'Setting up the background for the featured image in a knowledgebase post.', 'manual' ),
					'class' => 'theme-option-text-align-right',
					'background-image' => false,
					'background-color' => false,
					'default'  => array(
						'background-repeat' => 'no-repeat',
						'background-attachment' => 'scroll',
						'background-position' => 'center center',
						'background-size' => 'cover',
					),
					'required' => array('knowledgebase-pagetitlebar-featured-image','equals','0'), 
				),
				array(
					'id'       => 'knowledgebase-pagetitlebar-feature-image-overlay',
					'type'     => 'color_rgba',
					'title'    => esc_html__( 'Background overlay', 'manual' ),
					'subtitle'    => esc_html__( 'Select the background overlay for the title bar of your knowledgebase page, featuring a featured image.', 'manual' ),
					'class' => 'theme-option-text-align-right',
					'required' => array('knowledgebase-pagetitlebar-featured-image','equals','0'),
					'default'   => array(
						'color'     => '#000000',
						'alpha'     => '0.4',
					), 
				),
				array(
					'id'       => 'kb_pagetitlebar_feature_title_color',
					'type'     => 'color',
					'title'    => esc_html__( 'Title color', 'manual' ),
					'subtitle'    => esc_html__( 'Page title bar text color', 'manual' ),
					'class'  => 'theme-option-text-align-right',
					'required' => array('knowledgebase-pagetitlebar-featured-image','equals','0'),
					'default'  => '#FFFFFF',
				),
				array(
					'id'       => 'kb_pagetitlebar_feature_title_desc_color',
					'type'     => 'color',
					'title'    => esc_html__( 'Description color', 'manual' ),
					'subtitle'    => esc_html__( 'Page title bar description color', 'manual' ),
					'class'  => 'theme-option-text-align-right',
					'required' => array('knowledgebase-pagetitlebar-featured-image','equals','0'),
					'default'  => '#FFFFFF',
				),
				array(
					'id'       => 'knowledgebase_pagetitlebar_featureimg_breadcrumb_regular_text_color',
					'type'     => 'color_rgba',
					'title'    => esc_html__( 'Breadcrumb regular text color', 'manual' ),
					'subtitle' => esc_html__('Regular text color.', 'manual'),
					'required' => array('knowledgebase-pagetitlebar-featured-image','equals','0'),
					'class' => 'theme-option-text-align-right',
					'default'   => array(
						'color'     => '#ffffff',
						'alpha'     => '1',
					),
				),
				array(
					'id'       => 'knowledgebase_pagetitlebar_featureimg_breadcrumb_link_color',
					'type'     => 'link_color',
					'title'    => esc_html__( 'Breadcrumb link color', 'manual' ),
					'subtitle' => esc_html__('Adjust the color of breadcrumb links if needed.', 'manual'),
					'required' => array('knowledgebase-pagetitlebar-featured-image','equals','0'),
					'active'  => false,
					'visited'  => false,
					'class' => 'theme-option-text-align-right',
					'default'  => array(
						'regular'  => '#ffffff', 
						'hover'    => '#47C494', 
					),
				),
				array(
					'id'       => 'knowledgebase_pagetitlebar_featureimg_breadcrumb_link_seprator_color',
					'type'     => 'color_rgba',
					'title'    => esc_html__( 'Breadcrumb link seprator color', 'manual' ),
					'subtitle' => esc_html__('Adjust the color of breadcrumb link seprators if needed.', 'manual'),
					'required' => array('knowledgebase-pagetitlebar-featured-image','equals','0'),
					'class' => 'theme-option-text-align-right',
					'default'   => array(
						'color'     => '#ffffff',
						'alpha'     => '1',
					), 
				),
			)
	) );
	
	
	// KNOWLEDGEBASE CUSTOM CAT HEADER
	Redux::setSection( $opt_name, array(
        'title'            => esc_html__( 'Custom \'Page Title Bar\' - Category/Tag Page', 'manual' ),
        'id'               => 'kb_custom_header',
        'subsection'       => true,
        'customizer_width' => '450px',
        'fields'           => array(
		
					array(
						'id'       => 'knowledgebase_pagetitlebar_cat_header_menu',
						'type'     => 'switch',
						'title'    => esc_html__( 'Customize the header menu', 'manual' ),
						'subtitle' => esc_html__('Modify the main header, including the logo and menu colors, if needed.', 'manual'),
						'default'  => false,
					),
					array(
						'id'       => 'knowledgebase_pagetitlebar_cat_header_background_colorbg',
						'type'     => 'color_rgba',
						'title'    => esc_html__( 'Background color', 'manual' ),
						'subtitle'    => esc_html__( 'Set the header background.', 'manual' ),
						'output'    => array('background' => '.navbar-inverse.theme-cat-kb-page'),
						'required' => array('knowledgebase_pagetitlebar_cat_header_menu','equals','1'),
						'class' => 'theme-option-text-align-right',			
					),
					array(
						'id'       => 'knowledgebase_pagetitlebar_cat_header_first_level_menu_text_color',
						'type'     => 'link_color',
						'title'    => esc_html__( 'Menu link color', 'manual' ),
						'subtitle' => esc_html__('Text color for the first level of the navigation menu.', 'manual'),
						'active'    => false, 
						'visited'   => false,
						'output'    => array('.navbar-inverse.theme-cat-kb-page .navbar-nav>li>a'), 
						'required' => array('knowledgebase_pagetitlebar_cat_header_menu','equals','1'),
						'class' => 'theme-option-text-align-right',
					),
					array(
						'id'       => 'knowledgebase_pagetitlebar_cat_header_flip_logo',
						'type'     => 'switch',
						'title'    => esc_html__( 'Flip logo', 'manual' ),
						'subtitle' => esc_html__('Switch from the \'primary logo\' to the \'secondary logo,\' if necessary.', 'manual'),
						'default'  => false,
						'class' => 'theme-option-text-align-right',
						'required' => array('knowledgebase_pagetitlebar_cat_header_menu','equals','1'),
					),
					array(
						'id'       => 'knowledgebase_pagetitlebar_cat_header_shadow',
						'type'     => 'switch',
						'title'    => esc_html__('Header shadow', 'manual' ),
						'desc' => esc_html__('Please note that this function is effective only when the header shadow is enabled in the \'Header Menu > Main Header\' settings.', 'manual'),
						'subtitle' => esc_html__('Turn the default header shadow on or off.', 'manual'),
						'default'  => false,
						'class' => 'theme-option-text-align-right',
						'required' => array('knowledgebase_pagetitlebar_cat_header_menu','equals','1'),
					),
					array(
						'id'       => 'knowledgebase_pagetitlebar_cat_header_menu_border_btm',
						'type'     => 'border',
						'title'    => esc_html__( 'Header border bottom', 'manual' ),
						'subtitle' => esc_html__('Re-adjust header border bottom', 'manual'),
						'color_alpha'  => true,
						'left'  => false,
						'right'  => false,
						'top'  => false,
						'class' => 'theme-option-text-align-right',
						'required' => array('knowledgebase_pagetitlebar_cat_header_menu','equals','1'),
						'output'    => array('.navbar.theme-cat-kb-page'),
					),
					array(
						'id'       => 'knowledgebase_pagetitlebar_cat_header_menu_border_top',
						'type'     => 'border',
						'title'    => esc_html__( 'Header border top', 'manual' ),
						'subtitle' => esc_html__('Re-adjust header border top', 'manual'),
						'desc' => esc_html__('If \'Menu position\' is set to \'Logo on Top\' and \'Menu Below Logo\' in \'Theme > Options > Header Menu > Main Header\', then this feature will work properly.', 'manual'),
						'color_alpha'  => true,
						'left'  => false,
						'right'  => false,
						'bottom'  => false,
						'required' => array('knowledgebase_pagetitlebar_cat_header_menu','equals','1'),
						'class' => 'theme-option-text-align-right',
						'output'    => array('.navbar.theme-cat-kb-page .navbar-collapse.collapse'),
					),
					array(
						'id'       => 'manualkb_cat_headermenu_hamburger_searchbox',
						'type'     => 'switch',
						'title'    => esc_html__( 'Hide the search box in the Hamburger menu.', 'manual' ),
						'desc' => esc_html__('This feature will only function if enabled \'Search Box in Hamburger Menu\' in the \'Theme Options\' under \'Header Menu\' in the \'Main Header\' section.', 'manual'),
						'default'  => false,
						'required' => array('knowledgebase_pagetitlebar_cat_header_menu','equals','1'),
						'on' => esc_html__( 'Hide', 'manual' ),
						'off' => esc_html__( 'Theme Default', 'manual' ),
						'class' => 'theme-option-text-align-right',
					),
					array(
						'id'       => 'onoff-knowledgebase-catag-page-title-bar',
						'type'     => 'switch',
						'title'    => esc_html__('Page title bar', 'manual' ),
						'subtitle' => __('Enable/Disable page title bar.', 'manual'),
						'desc' => __('Note: Disabling the page title bar will change the menu style to the default setting, meaning that no transparent menu style will be used.', 'manual'),
						'default'  => true,
						'on'       => esc_html__( 'Enable', 'manual' ),
						'off'      => esc_html__( 'Disable', 'manual' ),
					),
					// -------------- Page Title Bar Controls --------------
					array(
						'id'       => 'kb-cattag-page-title-bar-controls',
						'type'     => 'section',
						'title'    => esc_html__( 'Page Title Bar', 'manual' ),
						'indent'   => true, 
						'required' => array('onoff-knowledgebase-catag-page-title-bar','equals','1'),  
					),
					array(
						'id'       => 'kbcat-header-height',
						'type'     => 'text',
						'title'    => esc_html__( 'Page title bar :: padding', 'manual' ),
						'subtitle'    => esc_html__( 'Re-adjust the space above and below the \'Page Title Bar\' on your knowledgebase category page.', 'manual' ),
						'desc' =>  __('Example: 120px 0px 120px 0px (top, right, bottom, left) <br><br><strong style="color:#e6614b;">IMPORTANT: Make sure the value of RIGHT, LEFT is always 0px</strong>', 'manual' ),
						'default'  => '',
					),
					array(
						'id'       => 'kbcat-responsive-header-height',
						'type'     => 'text',
						'title'    => esc_html__( 'Page title bar :: Responsive padding', 'manual' ),
						'subtitle' => esc_html__( 'Re-adjust the top/bottom spacing for page title bar', 'manual' ),
						'desc'     => __( 'Example: 100px 0px 100px 0px (top, right, bottom, left) <br><br><strong style="color:#e6614b;">IMPORTANT: Make sure the value of RIGHT, LEFT is always 0px</strong>', 'manual' ), 
						'default'  => '',
					),
					array(
						'id'       => 'kbcat_pagetitlebar_cat_title_typography',
						'type'        => 'typography',
						'title'    => esc_html__( 'Title typography', 'manual' ),
						'subtitle' => esc_html__( 'Customize title text.', 'manual' ),
						'output'    => array('.noise-break.theme-cat-kb-page h1.custom_h1_head'),
						'google'      => true,
						'font-backup' => false,
						'text-align' => false,
						'text-transform' => true,
						'subsets'       => false, 
						'letter-spacing'=> true,  
						'all_styles'  => true,
						'font-backup' => true,
						'word-spacing' => true,
						'margin-top' => true,
						'margin-bottom' => true,
						'units'       => 'px',
					),
					array(
						'id'       => 'kb-cat-header-description-status',
						'type'     => 'switch',
						'title'    => esc_html__( 'Category description', 'manual' ),
						'default'  => false,
						'subtitle' => esc_html__( 'Display category description in \'Page Title Bar\'', 'manual' ),
						'on' => esc_html__( 'Enable', 'manual' ),
						'off' => esc_html__( 'Disable', 'manual' ),
					),
					array(
						'id'       => 'kbcat_pagetitlebar_description_typography',
						'type'        => 'typography',
						'title'    => esc_html__( 'Description typography', 'manual' ),
						'subtitle' => esc_html__( 'Customize description text.', 'manual' ),
						'output'    => array('.noise-break.theme-cat-kb-page .header-desc p'),
						'required' => array('kb-cat-header-description-status','equals','1'), 
						'google'      => true,
						'font-backup' => false,
						'text-align' => false,
						'text-transform' => true,
						'subsets'       => false, 
						'letter-spacing'=> true,  
						'all_styles'  => true,
						'font-backup' => true,
						'word-spacing' => true,
						'margin-top' => true,
						'margin-bottom' => true,
						'units'       => 'px',
						'class' => 'theme-option-text-align-right',
					),
					array(
						'id'       => 'kbcat-text-align',
						'type'     => 'select',
						'title'    => esc_html__( 'Text align', 'manual' ),
						'subtitle'    => esc_html__( 'Adjust the alignment of the text on the \'page title bar\'', 'manual' ),
						'options'  => array(
							'center' => esc_html__('Center','manual' ),
							'left' => esc_html__('Left','manual' ),
							'right' => esc_html__('Right','manual' ),
						),
						'default'  => 'center',
					),
					array(
						'id'       => 'kb-cat-header-search-status',
						'type'     => 'switch',
						'title'    => esc_html__( 'Search Box', 'manual' ),
						'default'  => false,
						'subtitle' => esc_html__( 'Choose to show or hide the search box in the specified \'page title bar\' area.', 'manual' ),
						'on' => esc_html__( 'Disable', 'manual' ),
						'off' => esc_html__( 'Enable', 'manual' ),
					),
					array(
						'id'       => 'kbcat-searchbox-display-position',
						'type'     => 'select',
						'title'    => esc_html__( 'Search box position', 'manual' ),
						'subtitle'    => esc_html__( 'Choose where to place the search box on the \'page title bar\'.', 'manual' ),
						'options'  => array(
							'center' => esc_html__('Exact Center','manual' ),
							'6' => esc_html__('50% Width','manual' ),
							'7' => esc_html__('58% Width','manual' ),
							'8' => esc_html__('66% Width','manual' ),
							'9' => esc_html__('75% Width','manual' ),
							'10' => esc_html__('83% Width','manual' ),
							'11' => esc_html__('91% Width','manual' ),
							'12' => esc_html__('100% Width','manual' ),
						),
						'default'  => 'center',
						'required' => array('kb-cat-header-search-status','equals','0'),
						'class'  => 'theme-option-text-align-right',
					),
					array(
						'id'       => 'knowledgebase-pagetitlebar-cat-searchbox-treanding-search-color',
						'type'     => 'color',
						'title'    => esc_html__( 'Title text color', 'manual' ),
						'subtitle'    => esc_html__( 'Trending search text title color', 'manual' ),
						'required' => array('kb-cat-header-search-status','equals','0'),
						'output'    => array('.noise-break.theme-cat-kb-page .trending-search span.popular-keyword-title'),
						'class' => 'theme-option-text-align-right',
					),
					array(
						'id'       => 'knowledgebase-pagetitlebar-cat-searchbox-treanding-search-link-color',
						'type'     => 'link_color',
						'title'    => esc_html__( 'Link color', 'manual' ),
						'subtitle'    => esc_html__( 'The trending keyword link color', 'manual' ),
						'active'    => false, 
						'visited'   => false,
						'required' => array('kb-cat-header-search-status','equals','0'),
						'output'    => array('.noise-break.theme-cat-kb-page .trending-search a.trending-search-popular-keyword'),  
						'class' => 'theme-option-text-align-right',
					),
					array(
						'id'       => 'kb-cat-header-breadcrumb-status',
						'type'     => 'switch',
						'title'    => esc_html__( 'Breadcrumb', 'manual' ),
						'default'  => false,
						'subtitle' => esc_html__( 'Choose to show or hide the breadcrumb in the specified \'page title bar\' area.', 'manual' ),
						'on' => esc_html__( 'Disable', 'manual' ),
						'off' => esc_html__( 'Enable', 'manual' ),
					),
					array(
						'id'       => 'knowledgebase_pagetitlebar_cat_breadcrumb_regular_text_color',
						'type'     => 'color_rgba',
						'title'    => esc_html__( 'Regular text color', 'manual' ),
						'subtitle' => esc_html__('Breadcrumb regular text color.', 'manual'),
						'required' => array('kb-cat-header-breadcrumb-status','equals','0'),
						'output'    => array('.noise-break.theme-cat-kb-page #breadcrumbs'),
						'class' => 'theme-option-text-align-right',
					),
					array(
						'id'       => 'knowledgebase_pagetitlebar_cat_breadcrumb_link_color',
						'type'     => 'link_color',
						'title'    => esc_html__( 'Link color', 'manual' ),
						'subtitle' => esc_html__('Adjust the color of breadcrumb links if needed.', 'manual'),
						'required' => array('kb-cat-header-breadcrumb-status','equals','0'),
						'output'    => array('.noise-break.theme-cat-kb-page #breadcrumbs a'),
						'active'  => false,
						'class' => 'theme-option-text-align-right',
					),
					array(
						'id'       => 'knowledgebase_pagetitlebar_cat_breadcrumb_link_seprator_color',
						'type'     => 'color_rgba',
						'title'    => esc_html__( 'Link seprator color', 'manual' ),
						'subtitle' => esc_html__('Adjust the color of breadcrumb link seprators if needed.', 'manual'),
						'required' => array('kb-cat-header-breadcrumb-status','equals','0'),
						'output'    => array('.noise-break.theme-cat-kb-page #breadcrumbs span'),
						'class' => 'theme-option-text-align-right',
					),
					array(
						'id'       => 'knowledgebase-pagetitlebar-cat-background-setup',
						'type' => 'background',
						'title'    => esc_html__( 'Background', 'manual' ),
						'subtitle' => esc_html__( 'Create the background for your knowledgebase category/tag page.', 'manual' ),
						'desc' => __( '<span style="color:red;">IMPORTANT:</span> 
If you select category-based images for the \'page title bar\', the uploaded image will be overridden by the image uploaded via \'knowledgebase > Category\' specifically for that category. Any images uploaded elsewhere will be disregarded.', 'manual' ),
					),
					array(
						'id'       => 'knowledgebase-pagetitlebar-cat-image-overlay',
						'type'     => 'color_rgba',
						'title'    => esc_html__( 'Background overlay', 'manual' ),
						'subtitle'    => esc_html__( 'Select the background overlay for your knowledgebase page title bar.', 'manual' ),
						'output'    => array('background' => '.noise-break.theme-cat-kb-page .page_opacity.header_custom_height_new'),
						'class' => 'theme-option-text-align-right',
					),
			)
		) );
/**********************************************
*******  // EOF  KNOWLEDGEBASE //   *****
***********************************************/
	
	
	
		
		
/**********************************************
*******  START  DOCUMENTATION       *****
***********************************************/
	Redux::setSection( $opt_name, array(
        'title'            => esc_html__( 'Documentation', 'manual' ),
        'id'               => 'theme_documentation_section',
        'customizer_width' => '400px',
        'icon'             => 'el el-folder-open'
    ) );
	
	// CUSTOM SLUG NAME
	Redux::setSection( $opt_name, array(
        'title'            => esc_html__( 'Global Settings', 'manual' ),
        'id'               => 'documentation_slug_section',
        'subsection'       => true,
        'customizer_width' => '450px',
        'fields'           => array(
		
			    array(
					'id'       => 'doc-slug-name',
					'type'     => 'text',
					'title'    => esc_html__( 'Post slug name', 'manual' ),
					'subtitle'    => esc_html__( 'Slug name for documentation single post.', 'manual' ),
					'desc'     => __( '<strong>Will be displayed as: </strong> http://domain.com/<strong>documentation</strong>/new-doc-post/ <br><br> <span style="color:#D01B0B;"><strong>CAUTION:</strong> Documentation link name should not match the page name, or it may result in a 404 error.</span>', 'manual' ),
					'default'  => 'documentation',
			    ),
			    array(
					'id'       => 'doc-cat-slug-name',
					'type'     => 'text',
					'title'    => esc_html__( 'Category slug name', 'manual' ),
					'subtitle'    => esc_html__( 'Slug name for documentation category page.', 'manual' ),
					'desc'     => __( '<strong>Will be displayed as: </strong> http://domain.com/<strong>doc</strong>/product-name/ <br><br> <span style="color:#D01B0B;"><strong>CAUTION:</strong> The category slug name should be different from the documentation post and page names. If they match, you\'ll see a 404 error. Also, try not to change the category slug often, as it can cause broken links and affect search results.</span>', 'manual' ),
					'default'  => 'doc',
			    ),
			    array(
					'id'       => 'doc-tag-slug-name',
					'type'     => 'text',
					'title'    => esc_html__( 'Tag slug name', 'manual' ),
					'subtitle' => esc_html__( 'Slug name for documentation tag page.', 'manual' ),
					'desc'     => __( '<strong>Will be displayed as: </strong> http://domain.com/<strong>doc-tag</strong>/doc-post-slug-name/', 'manual' ),
					'default'  => 'doc-tag',
				),
				array(
					'id'       => 'documentation-root-category-access-control-message',
					'type'     => 'text',
					'title'    => esc_html__( 'Category page access message', 'manual' ),
					'default'  => 'You do not have sufficient permissions to access this documentation',
					'desc' => esc_html__('Displayed when user lacks sufficient permission to access the chosen category.', 'manual' ),
					'subtitle' => esc_html__('[Access Control]', 'manual' ),
				),
				array(
					'id'       => 'documentation-single-page-access-control-message',
					'type'     => 'text',
					'title'    => esc_html__( 'Articles page access message', 'manual' ),
					'default'  => 'You do not have sufficient permissions to access this documentation Article.',
					'desc' => esc_html__('Displayed when user lacks sufficient permission to access the selected article.','manual' ),
					'subtitle' => esc_html__('[Access Control]', 'manual' ),
				),
			    array(
					'id'       => 'doc-post-type-support-custom-fields',
					'type'     => 'switch',
					'title'    => esc_html__( 'Custom field box', 'manual' ),
					'subtitle' => esc_html__( 'Custom fields in WordPress are a more advanced feature that allows you to include additional information in specific posts.', 'manual' ),
					'on' => esc_html__( 'Enable', 'manual' ),
					'off' => esc_html__( 'Disable', 'manual' ),
					'default'  => false,
				),
				array(
					'id'       => 'doc-gutenberg-editor-onoff',
					'type'     => 'switch',
					'title'    => esc_html__( 'Gutenberg editor', 'manual' ),
					'subtitle'    => esc_html__( 'Switch the post type documentation from the classic editor to the Gutenberg editor', 'manual' ),
					'default'  => true,
					'on' => esc_html__( 'Enable', 'manual' ),
					'off' => esc_html__( 'Disable', 'manual' ),
				),
				array(
					'id'       => 'doc-breadcrumb-name',
					'type'     => 'text',
					'title'    => esc_html__( 'Breadcrumb', 'manual' ),
					'subtitle'    => esc_html__( 'Personalized breadcrumb label', 'manual' ),
					'desc'     => __( '<strong>Will be displayed as:</strong>  Home / <strong>Documentation</strong> / product-name /', 'manual' ),
					'default'  => 'Documentation',
				),
				array(
					'id'       => 'doc-breadcrumb-custom-home-url',
					'type'     => 'text',
					'title'    => esc_html__( 'Breadcrumb URL', 'manual' ),
					'desc'     => __( '<strong>Will be displayed as:</strong>  Home / <a href="">Documentation</a> / product-name /', 'manual' ),
					'subtitle' => esc_html__( 'Custom home page URL for your documentation', 'manual' ),
					'default'  => '',
					'class'  => 'theme-option-text-align-right',
				),
		
		)
    ) );
	
	// RECORDS ORDER SECTION
	Redux::setSection( $opt_name, array(
        'title'            => esc_html__( 'Tree Menu', 'manual' ),
        'id'               => 'documentation_records_order_section',
        'subsection'       => true,
        'customizer_width' => '450px',
        'fields'           => array(
									
				array(
					'id'       => 'documentation-tree-menu-display-style',
					'type'     => 'image_select',
					'title'    => esc_html__( 'Menu style', 'manual' ),
					'subtitle' => esc_html__( 'Choose a design style for the documentation tree menu.', 'manual' ),
					'desc' => esc_html__( 'Menu for the documentation post sidebar, appearing on either the left or right.', 'manual' ),
					'options'  => array(
						'1' => array( 'img' => trailingslashit(get_template_directory_uri()) .'framework/ReduxCore/manual/doc-menu-one.jpg' ),
						'2' => array( 'img' => trailingslashit(get_template_directory_uri()) .'framework/ReduxCore/manual/doc-menu-two.jpg' ),
					),
					'default'  => '1'
				),
				array(
					'id'       => 'documentation-private-articles-tree-menu',
					'type'     => 'switch',
					'title'    => esc_html__( 'Private articles', 'manual' ),
					'subtitle' => __( 'Make private articles title visible or invisible in the menu. <br><br> (If switched to invisible, the titles of private articles will only be visible to logged-in users or to users with specific roles.)', 'manual' ),
					'desc' => __( '<span style="color:#e6614b"><strong>IMPORTANT: The feature does not work for tree menus that have a (+)/(-) sign.</strong></span>', 'manual' ),
					'default'  => true,
					'on' => esc_html__( 'Visible', 'manual' ),
					'off' => esc_html__( 'Invisible', 'manual' ),
				),
				array(
					'id'       => 'documentation-private-articles-tree-menu-display-to-logged-in-user',
					'type'     => 'switch',
					'title'    => esc_html__( 'Conditional access', 'manual' ),
					'subtitle' => __( 'Make private articles title visible to only logged-in users.<br><br>(If activated, private article titles will be visible exclusively to all logged-in users, while access to the article content will be limited to users with specific roles defined during article creation.)', 'manual' ),
					'default'  => false,
					'required' => array('documentation-private-articles-tree-menu','equals','0'),
					'class'  => 'theme-option-text-align-right',
				),
				array(
					'id'       => 'documentation-responsive-tree-menu',
					'type'     => 'switch',
					'title'    => esc_html__( 'Responsive menu', 'manual' ),
					'subtitle' => __( 'Change the regular menu to the documentation menu when the website switches to a mobile-friendly layout. Remember, this change only affects the page with the documentation menu.', 'manual' ),
					'default'  => true,
					'on' => esc_html__( 'Enable', 'manual' ),
					'off' => esc_html__( 'Disable', 'manual' ),
				),
				array(
					'id'       => 'documentation-tree-menu-expand',
					'type'     => 'switch',
					'title'    => esc_html__( 'Automatic expansion of tree menu', 'manual' ),
					'subtitle' => esc_html__( 'Set the documentation page tree menu to automatically expand by default.', 'manual' ),
					'default'  => false,
					'on' => esc_html__( 'Enable', 'manual' ),
					'off' => esc_html__( 'Disable', 'manual' ),
				),
				array(
					'id'       => 'documentation-tree-menu-expand-collapse-text-on-off',
					'type'     => 'switch',
					'title'    => esc_html__( 'Expand/Collapse Text', 'manual' ),
					'subtitle' => esc_html__( 'Display collapsing/expanding text above the tree menu. This feature enables users to expand/collapse the entire tree menu at once.', 'manual' ),
					'default'  => false,
					'on' => esc_html__( 'Hide', 'manual' ),
					'off' => esc_html__( 'Show', 'manual' ),
				),
				array(
					'id'       => 'documentation-expand-text',
					'type'     => 'text',
					'title'    => esc_html__( 'Expand text', 'manual' ),
					'default'  => 'Expand All',
					'subtitle' => esc_html__('Text displayed above the tree menu.', 'manual' ),
					'class'  => 'theme-option-text-align-right',
					'required' => array('documentation-tree-menu-expand-collapse-text-on-off','equals','0'),
				),
				array(
					'id'       => 'documentation-collapse-text',
					'type'     => 'text',
					'title'    => esc_html__( 'Collapse text', 'manual' ),
					'default'  => 'Collapse All',
					'subtitle' => esc_html__('Text displayed above the tree menu.', 'manual' ),
					'class'  => 'theme-option-text-align-right',
					'required' => array('documentation-tree-menu-expand-collapse-text-on-off','equals','0'),
				),
				array(
					'id'       => 'documentation-menu-scroller-status',
					'type'     => 'switch',
					'title'    => esc_html__('Menu scroller', 'manual' ),
					'subtitle' => esc_html__('Activate to show a scrollbar after reaching a specific height in the tree menu.', 'manual'),
					'default'  => false,
					'on' => esc_html__( 'Enable', 'manual' ),
					'off' => esc_html__( 'Disable', 'manual' ),
				),
				array(
					'id'            => 'documentation-scroll-after-menu-height-new',
					'type'          => 'slider',
					'title'         => esc_html__( 'Menu height', 'manual' ),
					'subtitle'      => esc_html__( 'A scroll bar will appear when the specified height of the tree menu is exceeded.', 'manual' ),
					'default'       => 401,
					'min'           => 1,
					'step'          => 1,
					'max'           => 1200,
					'display_value' => 'label',
					'display_value' => 'text',
					'required' => array('documentation-menu-scroller-status','equals','1'),
					'class'  => 'theme-option-text-align-right',
				),
				array(
					'id'       => 'documentation-menu-scroller-design',
					'type'     => 'select',
					'title'    => esc_html__( 'Scrollbar design', 'manual' ),
					'subtitle'    => esc_html__( 'Choose the appearance of the scrollbar design.', 'manual' ),
					'options'  => array(
						'default' => esc_html__('Default','manual' ),
						'dark' => esc_html__('Dark','manual' ),
						'light-3' => esc_html__('Light 3','manual' ),
						'dark-3' => esc_html__('Dark 3','manual' ),
						'dark-thick' => esc_html__('Dark Thick','manual' ),
						'dark-thin' => esc_html__('Dark Thin','manual' ),
						'inset' => esc_html__('Inset','manual' ),
						'inset-dark' => esc_html__('Inset Dark','manual' ),
						'inset-2-dark' => esc_html__('Inset 2 Dark','manual' ),
						'inset-3' => esc_html__('Inset 3','manual' ),
						'inset-3-dark' => esc_html__('Inset 3 Dark','manual' ),
						'rounded-dark' => esc_html__('Rounded Dark','manual' ),
						'rounded-dots-dark' => esc_html__('Rounded Dots Dark','manual' ),
						'3d' => esc_html__('3D','manual' ),
						'3d-dark' => esc_html__('3D Dark','manual' ),
						'3d-thick' => esc_html__('3D Thick','manual' ),
						'3d-thick-dark' => esc_html__('3D Thick Dark','manual' ),
					),
					'default'  => 'default',
					'required' => array('documentation-menu-scroller-status','equals','1'),
					'class'  => 'theme-option-text-align-right',
				),
				array(
					'id'       => 'documentation-record-display-order',
					'type'     => 'select',
					'title'    => esc_html__( 'Display order', 'manual' ),
					'subtitle' => esc_html__( 'Order of display for tree menu records', 'manual' ),
					'options'  => array(
						'ASC' => esc_html__('Ascending Order (ASC)','manual' ),
						'DESC' => esc_html__('Descending Order (DESC)','manual' ),
					),
					'default'  => 'ASC'
				),
				array(
					'id'       => 'documentation-record-display-order-by',
					'type'     => 'select',
					'title'    => esc_html__( 'Display order by', 'manual' ),
					'subtitle' => esc_html__( 'Order of display by for tree menu records.', 'manual' ),
					'desc'     => __( 'Find how orderby works <a href="https://codex.wordpress.org/Template_Tags/get_posts" target="_blank">https://codex.wordpress.org/Template_Tags/get_posts</a>', 'manual' ),
					'options'  => array(
						'title' => esc_html__('Order by Title','manual' ),
						'rand' => esc_html__('Order by Random','manual' ),
						'menu_order' => esc_html__('Page Order','manual' ),
						'date' => esc_html__('Order By Date','manual' ),
						'modified' => esc_html__('Order By Last Modified Date','manual' ),
						'none' => esc_html__('None','manual' ),
					),
					'default'  => 'menu_order'
				),
		)
    ) );
	
	Redux::setSection( $opt_name, array(
        'title'            => esc_html__( 'Custom \'Page Title Bar\' - Category/Single Page', 'manual' ),
        'id'               => 'documentation_custom_header',
        'subsection'       => true,
        'customizer_width' => '450px',
        'fields'           => array(
		
					array(
						'id'       => 'documentation_pagetitlebar_header_menu',
						'type'     => 'switch',
						'title'    => esc_html__( 'Customize the header menu', 'manual' ),
						'subtitle' => esc_html__('Modify the main header, including the logo and menu colors, if needed.', 'manual'),
						'default'  => false,
					),
					array(
						'id'       => 'documentation_pagetitlebar_header_background_colorbg',
						'type'     => 'color_rgba',
						'title'    => esc_html__( 'Background color', 'manual' ),
						'subtitle'    => esc_html__( 'Set the header background.', 'manual' ),
						'output'    => array('background' => '.navbar-inverse.theme-documentation-pages'),
						'required' => array('documentation_pagetitlebar_header_menu','equals','1'),
						'class' => 'theme-option-text-align-right',			
					),
					array(
						'id'       => 'documentation_pagetitlebar_header_first_level_menu_text_color',
						'type'     => 'link_color',
						'title'    => esc_html__( 'Menu link color', 'manual' ),
						'subtitle' => esc_html__('Text color for the first level of the navigation menu.', 'manual'),
						'active'    => false, 
						'visited'   => false,
						'output'    => array('.navbar-inverse.theme-documentation-pages .navbar-nav>li>a'), 
						'required' => array('documentation_pagetitlebar_header_menu','equals','1'),
						'class' => 'theme-option-text-align-right',
					),
					array(
						'id'       => 'documentation_pagetitlebar_header_flip_logo',
						'type'     => 'switch',
						'title'    => esc_html__( 'Flip logo', 'manual' ),
						'subtitle' => esc_html__('Switch from the \'primary logo\' to the \'secondary logo,\' if necessary.', 'manual'),
						'default'  => false,
						'class' => 'theme-option-text-align-right',
						'required' => array('documentation_pagetitlebar_header_menu','equals','1'),
					),
					array(
						'id'       => 'documentation_pagetitlebar_header_shadow',
						'type'     => 'switch',
						'title'    => esc_html__('Header shadow', 'manual' ),
						'desc' => esc_html__('Please note that this function is effective only when the header shadow is enabled in the \'Header Menu > Main Header\' settings.', 'manual'),
						'subtitle' => esc_html__('Turn the default header shadow on or off.', 'manual'),
						'default'  => false,
						'class' => 'theme-option-text-align-right',
						'required' => array('documentation_pagetitlebar_header_menu','equals','1'),
					),
					array(
						'id'       => 'documentation_pagetitlebar_header_menu_border_btm',
						'type'     => 'border',
						'title'    => esc_html__( 'Header border bottom', 'manual' ),
						'subtitle' => esc_html__('Re-adjust header border bottom', 'manual'),
						'color_alpha'  => true,
						'left'  => false,
						'right'  => false,
						'top'  => false,
						'class' => 'theme-option-text-align-right',
						'required' => array('documentation_pagetitlebar_header_menu','equals','1'),
						'output'    => array('.navbar.theme-documentation-pages'),
					),
					array(
						'id'       => 'documentation_pagetitlebar_header_menu_border_top',
						'type'     => 'border',
						'title'    => esc_html__( 'Header border top', 'manual' ),
						'subtitle' => esc_html__('Re-adjust header border top', 'manual'),
						'desc' => esc_html__('If \'Menu position\' is set to \'Logo on Top\' and \'Menu Below Logo\' in \'Theme > Options > Header Menu > Main Header\', then this feature will work properly.', 'manual'),
						'color_alpha'  => true,
						'left'  => false,
						'right'  => false,
						'bottom'  => false,
						'required' => array('documentation_pagetitlebar_header_menu','equals','1'),
						'class' => 'theme-option-text-align-right',
						'output'    => array('.navbar.theme-documentation-pages .navbar-collapse.collapse'),
					),
					array(
						'id'       => 'documentation_header_menu_hamburger_search_box',
						'type'     => 'switch',
						'title'    => esc_html__( 'Hide the search box in the Hamburger menu.', 'manual' ),
						'desc' => esc_html__('This feature will only function if enabled \'Search Box in Hamburger Menu\' in the \'Theme Options\' under \'Header Menu\' in the \'Main Header\' section.', 'manual'),
						'default'  => false,
						'required' => array('documentation_pagetitlebar_header_menu','equals','1'),
						'on' => esc_html__( 'Hide', 'manual' ),
						'off' => esc_html__( 'Theme Default', 'manual' ),
						'class' => 'theme-option-text-align-right',
					),
					array(
						'id'       => 'onoff-documentation-catag-single-page-title-bar',
						'type'     => 'switch',
						'title'    => esc_html__('Page title bar', 'manual' ),
						'subtitle' => __('Enable/Disable page title bar', 'manual'),
						'desc' => __('Note: Disabling the page title bar will change the menu style to the default setting, meaning that no transparent menu style will be used.', 'manual'),
						'default'  => true,
						'on'       => esc_html__( 'Enable', 'manual' ),
						'off'      => esc_html__( 'Disable', 'manual' ),
					),
					// -------------- Page Title Bar Controls --------------
					array(
						'id'       => 'doc-page-title-bar-controls',
						'type'     => 'section',
						'title'    => esc_html__( 'Page Title Bar', 'manual' ),
						'indent'   => true, 
						'required' => array('onoff-documentation-catag-single-page-title-bar','equals','1'),  
					),
					array(
						'id'       => 'documentation-header-height-category-page',
						'type'     => 'text',
						'title'    => esc_html__( 'Page title bar :: padding', 'manual' ),
						'subtitle'    => esc_html__( 'Re-adjust the space above and below the \'Page Title Bar\' on your documentation page.', 'manual' ),
						'desc' => __('Example: 120px 0px 120px 0px (top, right, bottom, left) <br><br><strong style="color:#e6614b;">IMPORTANT: Make sure the value of RIGHT, LEFT is always 0px</strong>', 'manual' ),
						'default'  => '',
					),
					array(
						'id'       => 'documentation-responsive-header-height-category-page',
						'type'     => 'text',
						'title'    => esc_html__( 'Page title bar :: Responsive padding', 'manual' ),
						'subtitle' => esc_html__( 'Re-adjust the top/bottom spacing for page title bar', 'manual' ),
						'desc'     => __( 'Example: 100px 0px 100px 0px (top, right, bottom, left) <br><br><strong style="color:#e6614b;">IMPORTANT: Make sure the value of RIGHT, LEFT is always 0px</strong>', 'manual' ), 
						'default'  => '',
					),
					array(
						'id'       => 'doc-cat-single-pg-title-text-status',
						'type'     => 'switch',
						'title'    => esc_html__( 'Title text', 'manual' ),
						'default'  => false,
						'subtitle' => esc_html__( 'Show/Hide visibility of category name in the page title bar.', 'manual' ),
						'on' => esc_html__( 'Disable', 'manual' ),
						'off' => esc_html__( 'Enable', 'manual' ),
					),
					array(
						'id'       => 'documentation_pagetitlebar_text_typography',
						'type'        => 'typography',
						'title'    => esc_html__( 'Title typography', 'manual' ),
						'subtitle' => esc_html__( 'Customize title text.', 'manual' ),
						'output'    => array('.noise-break.theme-documentation-pages h1.custom_h1_head'),
						'required' => array('doc-cat-single-pg-title-text-status','equals','0'),  
						'google'      => true,
						'font-backup' => false,
						'text-align' => false,
						'text-transform' => true,
						'subsets'       => false, 
						'letter-spacing'=> true,  
						'all_styles'  => true,
						'font-backup' => true,
						'word-spacing' => true,
						'margin-top' => true,
						'margin-bottom' => true,
						'units'       => 'px',
						'class' => 'theme-option-text-align-right',
					),
					array(
						'id'       => 'doc-header-text-align',
						'type'     => 'select',
						'title'    => esc_html__( 'Text align', 'manual' ),
						'subtitle'    => esc_html__( 'Adjust the alignment of the text on the \'page title bar\'', 'manual' ),
						'options'  => array(
							'left' => esc_html__('Left', 'manual' ),
							'center' => esc_html__('Center', 'manual' ),
							'right' => esc_html__('Right', 'manual' ),
						),
						'default'  => 'center'
					),
					array(
						'id'       => 'documentation-disable-search-category-page',
						'type'     => 'switch',
						'title'    => esc_html__( 'Search box', 'manual' ),
						'default'  => false,
						'subtitle' => esc_html__('Choose to show or hide the search box in the specified \'page title bar\' area.', 'manual'),
						'on' => esc_html__( 'Disable', 'manual' ),
						'off' => esc_html__( 'Enable', 'manual' ),
					),
					array(
						'id'       => 'documentation-searchbox-display-position',
						'type'     => 'select',
						'title'    => esc_html__( 'Search box position', 'manual' ),
						'subtitle'    => esc_html__( 'Choose where to place the search box on the \'page title bar\'.', 'manual' ),
						'options'  => array(
							'center' => esc_html__('Exact Center','manual' ),
							'6' => esc_html__('50% Width','manual' ),
							'7' => esc_html__('58% Width','manual' ),
							'8' => esc_html__('66% Width','manual' ),
							'9' => esc_html__('75% Width','manual' ),
							'10' => esc_html__('83% Width','manual' ),
							'11' => esc_html__('91% Width','manual' ),
							'12' => esc_html__('100% Width','manual' ),
						),
						'default'  => 'center',
						'required' => array('documentation-disable-search-category-page','equals','0'),
						'class'  => 'theme-option-text-align-right',
					), 
					array(
						'id'       => 'documentation-pagetitlebar-searchbox-treanding-search-color',
						'type'     => 'color',
						'title'    => esc_html__( 'Title text color', 'manual' ),
						'subtitle'    => esc_html__( 'Trending search text title color', 'manual' ),
						'required' => array('documentation-disable-search-category-page','equals','0'),
						'output'    => array('.noise-break.theme-documentation-pages .trending-search span.popular-keyword-title'),
						'class' => 'theme-option-text-align-right',
					),
					array(
						'id'       => 'documentation-pagetitlebar-searchbox-treanding-search-link-color',
						'type'     => 'link_color',
						'title'    => esc_html__( 'Link color', 'manual' ),
						'subtitle'    => esc_html__( 'The trending keyword link color', 'manual' ),
						'active'    => false, 
						'visited'   => false,
						'required' => array('documentation-disable-search-category-page','equals','0'),
						'output'    => array('.noise-break.theme-documentation-pages .trending-search a.trending-search-popular-keyword'),  
						'class' => 'theme-option-text-align-right',
					),
					array(
						'id'       => 'documentation-disable-breadcrumb-category-page',
						'type'     => 'switch',
						'title'    => esc_html__( 'Breadcrumb', 'manual' ),
						'default'  => false,
						'subtitle' => esc_html__( 'Choose to show or hide the breadcrumb in the specified \'page title bar\' area.','manual' ),
						'on' => esc_html__( 'Disable', 'manual' ),
						'off' => esc_html__( 'Enable', 'manual' ),
					),
					array(
						'id'       => 'documentation_pagetitlebar_breadcrumb_text_color',
						'type'     => 'color_rgba',
						'title'    => esc_html__( 'Regular text color', 'manual' ),
						'subtitle' => esc_html__('Breadcrumb regular text color.', 'manual'),
						'required' => array('documentation-disable-breadcrumb-category-page','equals','0'),
						'class' => 'theme-option-text-align-right',
						'output'    => array('.noise-break.theme-documentation-pages #breadcrumbs'),
					),
					array(
						'id'       => 'documentation_pagetitlebar_breadcrumb_link_color',
						'type'     => 'link_color',
						'title'    => esc_html__( 'Link color', 'manual' ),
						'subtitle' => esc_html__('Adjust the color of breadcrumb links if needed.', 'manual'),
						'required' => array('documentation-disable-breadcrumb-category-page','equals','0'),
						'output'    => array('.noise-break.theme-documentation-pages #breadcrumbs a'),
						'active'  => false,
						'class' => 'theme-option-text-align-right',
					),
					array(
						'id'       => 'documentation_pagetitlebar_breadcrumb_link_seprator_color',
						'type'     => 'color_rgba',
						'title'    => esc_html__( 'Link seprator color', 'manual' ),
						'subtitle' => esc_html__('Adjust the color of breadcrumb link seprators if needed.', 'manual'),
						'required' => array('documentation-disable-breadcrumb-category-page','equals','0'),
						'output'    => array('.noise-break.theme-documentation-pages #breadcrumbs span'),
						'class' => 'theme-option-text-align-right',
					),
					array(
						'id'       => 'documentation-pagetitlebar-background-setup',
						'type' => 'background',
						'title'    => esc_html__( 'Background', 'manual' ),
						'subtitle' => esc_html__( 'Create the background for your documentation page.', 'manual' ),
						'desc' => __( '<span style="color:red;">IMPORTANT:</span> If you select category-based images for the \'page title bar\', the uploaded image will be overridden by the image uploaded via \'Documentation > Category\' specifically for that category. Any images uploaded elsewhere will be disregarded.', 'manual' ),
					),
					array(
						'id'       => 'documentation-pagetitlebar-image-overlay',
						'type'     => 'color_rgba',
						'title'    => esc_html__( 'Background overlay', 'manual' ),
						'subtitle'    => esc_html__( 'Select the background overlay for your documentation page title bar.', 'manual' ),
						'output'    => array('background' => '.noise-break.theme-documentation-pages .page_opacity.header_custom_height_new'),
						'class' => 'theme-option-text-align-right',
					),
				)
		) );
	
	// SINGLE POST ON/OFF
	Redux::setSection( $opt_name, array(
        'title'            => esc_html__( 'Single/Category Page', 'manual' ),
        'id'               => 'documentation_single_records_on_off_section',
        'subsection'       => true,
        'customizer_width' => '450px',
        'fields'           => array(
									
				array(
					'id'       => 'documentation-row-layout',
					'type'     => 'image_select',
					'title'    => esc_html__( 'Page layout', 'manual' ),
					'subtitle' => esc_html__( 'Choose the page layout for your documentation page.', 'manual' ),
					'options'  => array(
						'1' => array( 'img' => trailingslashit(get_template_directory_uri()) .'framework/ReduxCore/manual/doc-sidebar-nine.png' ),
						'2' => array( 'img' => trailingslashit(get_template_directory_uri()) .'framework/ReduxCore/manual/doc-sidebar-eight.png' ),
						'3' => array( 'img' => trailingslashit(get_template_directory_uri()) .'framework/ReduxCore/manual/doc-sidebar-content-sidebar.png' ),
						'4' => array( 'img' => trailingslashit(get_template_directory_uri()) .'framework/ReduxCore/manual/doc-sidebar-content-sidebar-two.png' ),
					),
					'default'  => '2'
				),
				array(
					'id'       => 'documentation-singlepg-title-tag',
					'type'     => 'select',
					'title'    => esc_html__( 'Title tag', 'manual' ),
					'subtitle'    => esc_html__( 'Choose the post title tag.', 'manual' ),
					'options'  => array(
						'h1' => esc_html__('h1', 'manual' ),
						'h2' => esc_html__('h2', 'manual' ),
					),
					'default'  => 'h2', 
				),
				array(
					'id'       => 'documentation-sidebar-position',
					'type'     => 'select',
					'title'    => esc_html__( 'Sidebar', 'manual' ),
					'subtitle' => esc_html__( 'Select the location to display the tree menu sidebar on your documentation page.', 'manual' ),
					'options'  => array(
						'left' => esc_html__('Left','manual' ),
						'right' => esc_html__('Right','manual' ),
					),
					'default'  => 'left'
				),
				array(
					'id'       => 'documentation-toc-inside-post',
					'type'     => 'switch',
					'title'    => esc_html__('Table of content (TOC)','manual'),
					'subtitle' => esc_html__('Show the table of contents (TOC) within the documentation article.', 'manual'),
					'desc' => __('<span style="color:#D01B0B;">Make sure the TOC widget is off in the documentation sidebar to avoid errors. Also, note that TOC won\'t work in posts created with wpBakery or Elementor.</span>', 'manual'),
					'default'  => false,
					'on' => esc_html__( 'Enable', 'manual' ),
					'off' => esc_html__( 'Disable', 'manual' ),
				),
				array(
					'id'       => 'documentation-social-share-status',
					'type'     => 'switch',
					'title'    => esc_html__( 'Social share', 'manual' ),
					'subtitle'     => esc_html__('Turn on or off the option to share articles on different social networks.', 'manual'),
					'default'  => false,
					'on' => esc_html__( 'Disable', 'manual' ),
					'off' => esc_html__( 'Enable', 'manual' ),
				),
				array(
					'id'       => 'documentation-voting-buttons-status',
					'type'     => 'switch',
					'title'    => esc_html__( 'Post voting', 'manual' ),
					'subtitle' => esc_html__('Boost your content quality by letting readers vote on articles.', 'manual'),
					'default'  => false,
					'on' => esc_html__( 'Disable', 'manual' ),
					'off' => esc_html__( 'Enable', 'manual' ),
				),
				array(
					'id'       => 'documentation-voting-login-users',
					'type'     => 'switch',
					'title'    => esc_html__('Access control','manual'),
					'subtitle' => esc_html__('Only users who are logged in can vote on articles.', 'manual'),
					'default'  => false,
					'on' => esc_html__( 'Enable', 'manual' ),
					'off' => esc_html__( 'Disable', 'manual' ),
					'required' => array('documentation-voting-buttons-status','equals','0'),
					'class'  => 'theme-option-text-align-right',
				),
				array(
					'id'       => 'documentation-comment-status',
					'type'     => 'switch',
					'title'    => esc_html__( 'Comments', 'manual' ),
					'subtitle' => esc_html__( 'Enable comments on each article.', 'manual' ),
					'default'  => false,
					'description' => __('<span style="color:red">This only functions if the option to load articles using Ajax is turned off.</span>','manual' ),
				),
				array(
					'id'       => 'doc-post-contact-us-link',
					'type'     => 'switch',
					'title'    => __('Contact us link','manual'),
					'subtitle' => esc_html__('The "[Didn\'t find your answer? @ Contact Us]" link will be displayed below the related posts and above the Next/Previous links.', 'manual'),
					'desc' => __('<span style="color:#0273ff;"><strong>INFORMATION:</strong></span> To modify the text ("Didn\'t find your answer? @ Contact Us") and link, please navigate to the "Theme Option > Text" section.', 'manual'),
					'default'  => true,
					'on' => esc_html__( 'Enable', 'manual' ),
					'off' => esc_html__( 'Disable', 'manual' ),
				),
				array(
					'id'       => 'documentation-related-post-status',
					'type'     => 'switch',
					'title'    => esc_html__( 'Related posts', 'manual' ),
					'subtitle' => esc_html__('Introducing your readers to other relevant content', 'manual'),
					'default'  => true,
					'on' => esc_html__( 'Enable', 'manual' ),
					'off' => esc_html__( 'Disable', 'manual' ),
				),
				array(
					'id'       => 'documentation-related-post-per-page',
					'type'     => 'text',
					'title'    => esc_html__( 'Related posts', 'manual' ),
					'subtitle' => esc_html__('Manage how many related posts are shown.', 'manual'),
					'default'  => '6',
					'required' => array('documentation-related-post-status','equals','1'),
					'class'  => 'theme-option-text-align-right',
				),
				array(
					'id'       => 'documentation-related-post-title',
					'type'     => 'text',
					'title'    => esc_html__( 'Related title', 'manual' ),
					'default'  => 'Related Articles',
					'subtitle' => esc_html__('Topic/Title showcasing a list of related records based on the current post.','manual' ),
					'required' => array('documentation-related-post-status','equals','1'),
					'class'  => 'theme-option-text-align-right',
				),
				array(
					'id'       => 'documentation-next-previous-post',
					'type'     => 'switch',
					'title'    => __('Next Previous link','manual'),
					'subtitle' => esc_html__('Links to the next and previous articles will appear at the bottom of the documentation article.', 'manual'),
					'default'  => true,
					'on' => esc_html__( 'Enable', 'manual' ),
					'off' => esc_html__( 'Disable', 'manual' ),
				),
				array(
					'id'       => 'documentation-next-previous-post-text-previously',
					'type'     => 'text',
					'title'    => esc_html__( 'Text from before', 'manual' ),
					'subtitle' => esc_html__( 'Subtitle text', 'manual' ),
					'desc'     => __( '', 'manual' ),
					'default'  => 'Previously',
					'required' => array('documentation-next-previous-post','equals','1'),
					'class'  => 'theme-option-text-align-right',
				),
				array(
					'id'       => 'documentation-next-previous-post-text-up-next',
					'type'     => 'text',
					'title'    => esc_html__( 'Text for what\'s coming next.', 'manual' ),
					'subtitle' => esc_html__( 'Subtitle text', 'manual' ),
					'desc'     => __( '', 'manual' ),
					'default'  => 'Up Next',
					'required' => array('documentation-next-previous-post','equals','1'),
					'class'  => 'theme-option-text-align-right',
				),
				array(
					'id'       => 'documentation-notification-bar-global',
					'type'     => 'switch',
					'title'    => esc_html__( 'Notification bar', 'manual' ),
					'default'  => true,
					'subtitle' => esc_html__( 'Turn on or off the notification bar that shows up above the theme footer.', 'manual' ),
					'desc' => __( '<span style="color:#0273ff;"><strong>INFORMATION:</strong></span> To set up the notification bar, please go to "Theme Options > Extra - Settings > Notification Bar"', 'manual' ),
					'on' => esc_html__( 'Disable', 'manual' ),
					'off' => esc_html__( 'Enable', 'manual' ),
				),
				// Content Block Configuration
				array(
					'id'       => 'doc-feature-onoff-settings',
					'type'     => 'section',
					'title'    => esc_html__( 'Content Block Configuration', 'manual' ),
					'indent'   => true, 
				),
				array(
					'id'       => 'doc-global-arcile-display-style',
					'type'     => 'image_select',
					'title'    => esc_html__( 'Title style', 'manual' ),
					'subtitle' => esc_html__( 'Choose the title style for the documentation article.', 'manual' ),
					'options'  => array(
						'1' => array( 'img' => trailingslashit(get_template_directory_uri()) .'framework/ReduxCore/manual/doc-post-style-one.jpg' ),
						'2' => array( 'img' => trailingslashit(get_template_directory_uri()) .'framework/ReduxCore/manual/doc-post-style-two.jpg' ),
					),
					'default'  => '1'
				),
				array( 
					'id'       => 'documentation-pg-title-icon',
					'type'     => 'switch',
					'title'    => esc_html__( 'Pre-title icon', 'manual' ),
					'subtitle' => esc_html__( 'Icon that shows up before the title of the post.', 'manual' ),
					'default'  => true,
					'on' => esc_html__( 'Enable', 'manual' ),
					'off' => esc_html__( 'Disable', 'manual' ),
					'required' => array('doc-global-arcile-display-style','equals','1'),
				),
				array( 
					'id'       => 'doc-global-design2-author',
					'type'     => 'switch',
					'title'    => esc_html__( 'Author and date display', 'manual' ),
					'subtitle' => esc_html__( 'Enable/disable the display of the author image, author name, and article post date below the post title.', 'manual' ),
					'default'  => true,
					'on' => esc_html__( 'Enable', 'manual' ),
					'off' => esc_html__( 'Disable', 'manual' ),
					'required' => array('doc-global-arcile-display-style','equals','2'),
				),
				array(
					'id'       => 'doc-global-design2-wby-text',
					'type'     => 'text',
					'title'    => esc_html__('Pre-Author text', 'manual'),
					'subtitle'    => esc_html__('The words shown before the author\'s name.', 'manual'),
					'default'  => 'Written by',
					'class'  => 'theme-option-text-align-right',
					'required' => array(
								  array('doc-global-arcile-display-style','equals','2'),
								  array('doc-global-design2-author','equals',true),
								  ),
				),
				array(
					'id'       => 'doc-global-design2-metabox-color',
					'type'     => 'color_rgba',
					'title'    => esc_html__( 'Color', 'manual' ),
					'subtitle' => esc_html__( 'Article meta Color (Author & Date)', 'manual' ),
					'default'  => array(
									'color' => '#808080',
									'alpha' => '.9'
								),
					'required' => array(
								  array('doc-global-arcile-display-style','equals','2'),
								  array('doc-global-design2-author','equals',true),
								  ),
					'class'  => 'theme-option-text-align-right',			  
				),
				array( 
					'id'       => 'documentation-pg-content-box-shadow',
					'type'     => 'switch',
					'title'    => esc_html__( 'Content white background', 'manual' ),
					'subtitle' => esc_html__( 'A white background will be applied to the content area.', 'manual' ),
					'default'  => false,
					'on' => esc_html__( 'Enable', 'manual' ),
					'off' => esc_html__( 'Disable', 'manual' ),
					'required' => array('doc-global-arcile-display-style','equals','2'),
				),
				array(
					'id'       => 'documentation-pg-content-box-height',
					'type'     => 'text',
					'title'    => esc_html__( 'Content area height', 'manual' ),
					'subtitle' => esc_html__( 'Adjust content area height', 'manual' ),
					'default'  => '',
					'required' => array( array('doc-global-arcile-display-style','equals','2'),
										 array('documentation-pg-content-box-shadow','equals',true)
										),
					'desc'  => esc_html__('Example: 1000px','manual' ),
					'class'  => 'theme-option-text-align-right',
				),
				array(
					'id'       => 'doc-global-page-bg-color',
					'type'     => 'color',
					'title'    => esc_html__( 'Page background color', 'manual' ),
					'subtitle' => esc_html__( 'Choose the background color as per your preference.', 'manual' ),
					'default'  => '#f1f1f1',
					'transparent' => false,
					'required' => array( array('doc-global-arcile-display-style','equals','2'),
										 array('documentation-pg-content-box-shadow','equals',true)
										),
					'desc'  => esc_html__('Default: #f1f1f1','manual' ),
					'class'  => 'theme-option-text-align-right',
				),
				array(
					'id'       => 'doc-global-design2-content-box-margin-zero',
					'type'     => 'switch',
					'title'    => esc_html__( 'Zero margin for container row', 'manual' ),
					'default'  => false,
					'subtitle' => esc_html__( 'Set the top and bottom margins of the container row to zero.', 'manual' ),
					'on' => esc_html__( 'Enable', 'manual' ),
					'off' => esc_html__( 'Disable', 'manual' ),
					'required' => array( array('doc-global-arcile-display-style','equals','2'),
										 array('documentation-pg-content-box-shadow','equals',true)
										),
					'class'  => 'theme-option-text-align-right',					
				),
				array(
					'id'       => 'documentation-single-pg-print-status',
					'type'     => 'switch',
					'title'    => esc_html__( 'Print', 'manual' ),
					'default'  => true,
					'subtitle' => esc_html__( 'Switch the ability to print the article on or off below the post title.', 'manual' ),
					'on' => esc_html__( 'Enable', 'manual' ),
					'off' => esc_html__( 'Disable', 'manual' ),
				),
				array(
					'id'       => 'documentation-quick-stats-under-title',
					'type'     => 'switch',
					'title'    => esc_html__( 'Views & Likes Metadata', 'manual' ),
					'subtitle'     => esc_html__('Activate/deactivate the article\'s view count and positive feedback, such as the number of likes, displayed below the post title.', 'manual'),
					'default'  => false,
					'on' => esc_html__( 'Disable', 'manual' ),
					'off' => esc_html__( 'Enable', 'manual' ),
				),
				array(
					'id'       => 'documentation-singlepg-publish-date-status',
					'type'     => 'switch',
					'title'    => esc_html__( 'Post publish date', 'manual' ),
					'default'  => true,
					'subtitle' => esc_html__( 'Enable/disable the display of the post publish date below the post title.', 'manual' ),
					'on' => esc_html__( 'Enable', 'manual' ),
					'off' => esc_html__( 'Disable', 'manual' ),
					'required' => array('doc-global-arcile-display-style','equals','1'),
				),
				array(
					'id'       => 'documentation-singlepg-modified-date-status',
					'type'     => 'switch',
					'title'    => esc_html__( 'Post modified date', 'manual' ),
					'default'  => true,
					'subtitle' => esc_html__( 'Enable/disable the display of the post modified date below the post title.', 'manual' ),
					'on' => esc_html__( 'Enable', 'manual' ),
					'off' => esc_html__( 'Disable', 'manual' ),
					'required' => array('doc-global-arcile-display-style','equals','1'),
				),
				array(
					'id'       => 'documentation-disable-doc-author-name',
					'type'     => 'switch',
					'title'    => esc_html__( 'Author name', 'manual' ),
					'default'  => true,
					'subtitle' => esc_html__( 'Enable or disable showing the author name below the post title.','manual' ),
					'on' => esc_html__( 'Enable', 'manual' ),
					'off' => esc_html__( 'Disable', 'manual' ),
					'required' => array('doc-global-arcile-display-style','equals','1'),
				),
				array(
					'id'       => 'documentation-single-post-user-name',
					'type'     => 'select',
					'title'    => esc_html__( 'Customize author name display options', 'manual' ),
					'subtitle' => esc_html__( 'Choose the way you want the author\'s name to be shown.', 'manual' ),
					'options'  => array(
						'user_login' => esc_html__('User Login','manual' ),
						'user_nicename' => esc_html__('User Nicename','manual' ),
						'user_registered' => esc_html__('User Registered','manual' ),
						'display_name' => esc_html__('Display Name','manual' ),
						'first_name' => esc_html__('First Name','manual' ),
						'user_firstname' => esc_html__('User Firstname','manual' ),
					),
					'default'  => 'user_nicename',
					'required' => array('documentation-disable-doc-author-name','equals','1'),
					'class'  => 'theme-option-text-align-right',
				),
		)
    ) );
	
	
	// SEARCH HANDLER 
	Redux::setSection( $opt_name, array(
        'title'            => esc_html__( 'Page Loading Configuration', 'manual' ),
        'id'               => 'documentation_ajaxload_settings_section',
        'subsection'       => true,
        'customizer_width' => '450px',
        'fields'           => array(
									
				array(
					'id'       => 'documentation-disable-ajaxload-content',
					'type'     => 'switch',
					'title'    => esc_html__('AJAX content loading', 'manual' ),
					'subtitle' => esc_html__('When activated, the documentation article will load its content using AJAX loading; if deactivated, the page will load the content normally.', 'manual'),
					'default'  => false,
					'on' => esc_html__( 'Disable', 'manual' ),
					'off' => esc_html__( 'Enable', 'manual' ),
				),
				array(
					'id'       => 'documentation-disable-autoscroll-content-article-title',
					'type'     => 'switch',
					'title'    => esc_html__('Auto-Scroll to title', 'manual' ),
					'subtitle' => esc_html__('When this feature is enabled, the webpage will automatically scroll to the documentation title while the article is being loaded using AJAX.', 'manual'),
					'default'  => false,
					'on' => esc_html__( 'Disable', 'manual' ),
					'off' => esc_html__( 'Enable', 'manual' ),
					'class'  => 'theme-option-text-align-right',
					'required' => array('documentation-disable-ajaxload-content','equals','0'),
				),
				array(
					'id'       => 'activate_js_call_after_ajax_page_load',
					'type'     => 'switch',
					'title'    => esc_html__( 'JavaScript execution on AJAX load', 'manual' ),
					'subtitle' => esc_html__('Run JavaScript code when the documentation article loads using AJAX.', 'manual'),
					'default'  => false,
					'on' => esc_html__( 'Enable', 'manual' ),
					'off' => esc_html__( 'Disable', 'manual' ),
					'class'  => 'theme-option-text-align-right',
					'required' => array('documentation-disable-ajaxload-content','equals','0'),
				),
				array(
					'id'       => 'js_code_call_after_ajax_page_load',
					'type'     => 'ace_editor',
					'title'    => esc_html__( 'JavaScript code', 'manual' ),
					'subtitle' => esc_html__( 'Place your JavaScript code after \'// YOUR JS CODE OVER HERE.\' in the editor box.', 'manual' ),
					'required' =>  array(
									array('documentation-disable-ajaxload-content','equals','0'),
									array('activate_js_call_after_ajax_page_load','equals','1'),
									),
					'mode'     => 'javascript',
					'theme'    => 'chrome',
					'class'  => 'theme-option-text-align-right',
					'default'  => '
jQuery( document ).on("executeJSCodeOnAjaxCallDocPost", function(event, data){
		  
	// Unique Documentation Post ID
	postID = data.post_id;
	
	"use strict";
	
	// YOUR JS CODE OVER HERE.
		  
}); '
				),
				array(
					'id'       => 'fix_documentation_busted_msg',
					'type'     => 'switch',
					'title'    => esc_html__('Fix the "Busted!" message','manual' ),
					'subtitle' => esc_html__('
If you encounter a situation where you\'re trying to access a specific documentation article and see the text message "Busted!", try these options:','manual' ),
					'default'  => false,
					'on' => esc_html__( 'Enable', 'manual' ),
					'off' => esc_html__( 'Disable', 'manual' ),
					'class'  => 'theme-option-text-align-right',
					'required' => array('documentation-disable-ajaxload-content','equals','0'),
				),
				array(
					'id'       => 'activate-vc-inside-ajax-load-page-doc',
					'type'     => 'switch',
					'title'    => esc_html__( 'Visual Composer on AJAX Docs', 'manual' ),
					'subtitle' => esc_html__( 'Allow Visual Composer on AJAX-loaded documentation pages.', 'manual' ),
					'desc' =>  __( '<strong style="color:red">WARNING:</strong> Documentation records use AJAX requests, which could prevent Visual Composer shortcodes from working properly if they rely on jQuery or JavaScript functions. <br><br> <strong style="color:green">SOLUTION:</strong> Execute ANY JavaScript or jQuery function on AJAX page load by utilizing the "JavaScript execution on AJAX load" option mentioned above.', 'manual' ),
					'default'  => false,
					'on' => esc_html__( 'Enable', 'manual' ),
					'off' => esc_html__( 'Disable', 'manual' ),
					'class'  => 'theme-option-text-align-right',
					'required' => array('documentation-disable-ajaxload-content','equals','0'),
				),
		)
    ) );		
	
	
	// Page Template - "Documenation - Home" Settings
	Redux::setSection( $opt_name, array(
        'title'            => esc_html__( 'Page Template - "Documenation - Home" Settings', 'manual' ),
        'id'               => 'documentation_pagetemplate_dochome_section',
        'subsection'       => true,
        'customizer_width' => '450px',
        'fields'           => array(
									
							array(
								'id'       => 'documentation-category-record-display-order',
								'type'     => 'select',
								'title'    => esc_html__( 'Display order', 'manual' ),
								'subtitle' => esc_html__( 'Order of display for documentation category records.', 'manual' ),
								'options'  => array(
									'ASC' => esc_html__('Ascending Order (ASC)','manual' ),
									'DESC' => esc_html__('Descending Order (DESC)','manual' ),
								),
								'default'  => 'ASC'
							),
							array(
								'id'       => 'documentation-category-record-display-order-by',
								'type'     => 'select',
								'title'    => esc_html__( 'Display order by', 'manual' ),
								'subtitle' => esc_html__( 'Order of display by for documentation category records.', 'manual' ),
								'options'  => array(
									'id' => esc_html__('Order By ID','manual' ),
									'count' => esc_html__('Order By Count','manual' ),
									'name' => esc_html__('Order By Name ','manual' ),
									'slug' => esc_html__('Order By Slug ','manual' ),
									'none' => esc_html__('None','manual' ),
								),
								'default'  => 'name'
							),		
									
		)
    ) );
		

/**********************************************
*******  START  FAQ       *****
***********************************************/


	Redux::setSection( $opt_name, array(
        'title'            => esc_html__( 'FAQ', 'manual' ),
        'id'               => 'theme_faq',
        'customizer_width' => '400px',
        'icon'             => 'el el-question-sign'
    ) );
	
	Redux::setSection( $opt_name, array(
        'title'            => esc_html__( 'Global Settings', 'manual' ),
        'id'               => 'faq_slug_section',
        'subsection'       => true,
        'customizer_width' => '450px',
        'fields'           => array(
		
				
						array(
							'id'       => 'faq-slug-name',
							'type'     => 'text',
							'title'    => esc_html__( 'Post slug name', 'manual' ),
							'subtitle'    => esc_html__( 'Slug name for FAQ single post.', 'manual' ),
							'desc'     => __( '<strong>Will be displayed as: </strong> http://domain.com/<strong>faqs</strong>/creating-new-kb-post/ <br><br> <span style="color: #D01B0B;">CAUTION: FAQ link name should not match the page name, or it may result in a 404 error.</span>', 'manual' ),
							'default'  => 'faqs',
						),
						array(
							'id'       => 'faq-cat-slug-name',
							'type'     => 'text',
							'title'    => esc_html__( 'Category slug name', 'manual' ),
							'subtitle'    => esc_html__( 'Slug name for FAQ category page.', 'manual' ),
							'desc'     => __( '<strong>Will be displayed as: </strong> http://domain.com/<strong>faq</strong>/customization/ <br><br> <div style="color: #D01B0B;"><strong>CAUTION:</strong> The category slug name should be different from the FAQ post and page names. If they match, you\'ll see a 404 error. Also, try not to change the category slug often, as it can cause broken links and affect search results.</div>', 'manual' ),
							'default'  => 'faq',
						),
						array(
							'id'       => 'faq-cat-page-access-control-message',
							'type'     => 'text',
							'title'    => esc_html__( 'Category page access message', 'manual' ),
							'default'  => 'You do not have sufficient permissions to access this FAQ Category.',
							'desc' => esc_html__('Displayed when user lacks sufficient permission to access the chosen category.', 'manual' ),
							'subtitle' => esc_html__('[Access Control]', 'manual' ),
						),
						array(
							'id'       => 'faq-expand-collapse-text',
							'type'     => 'text',
							'title'    => esc_html__( 'Expand / Collapse text', 'manual' ),
							'default'  => 'Expand / Collapse All',
							'desc' => esc_html__('Top-of-page text for FAQ list.', 'manual' ),
							'subtitle' => esc_html__('[Category Page]', 'manual' ),
						),
						array(
							'id'       => 'faq-post-type-support-custom-fields',
							'type'     => 'switch',
							'title'    => esc_html__( 'Custom field box', 'manual' ),
							'subtitle' => esc_html__( 'Custom fields in WordPress are a more advanced feature that allows you to include additional information in specific posts.', 'manual' ),
							'on' => esc_html__( 'Enable', 'manual' ),
							'off' => esc_html__( 'Disable', 'manual' ),
							'default'  => false,
						),
						array(
							'id'       => 'faq-gutenberg-editor-onoff',
							'type'     => 'switch',
							'title'    => esc_html__( 'Gutenberg editor', 'manual' ),
							'subtitle' => esc_html__( 'Switch the post type FAQ from the classic editor to the Gutenberg editor', 'manual' ),
							'default'  => false,
							'on' => esc_html__( 'Enable', 'manual' ),
							'off' => esc_html__( 'Disable', 'manual' ),
						),
						array(
							'id'       => 'faq-hash-search-status',
							'type'     => 'switch',
							'title'    => esc_html__( 'Hash search', 'manual' ),
							'subtitle'    => esc_html__( 'Enable hash search for FAQs, displaying results on the same FAQ page', 'manual' ),
							'desc' => esc_html__('If deactivated, the system will redirect to the individual FAQ page.', 'manual'),
							'default'  => true,
							'on' => esc_html__( 'Enable', 'manual' ),
							'off' => esc_html__( 'Disable', 'manual' ),
						),
					   array(
							'id'       => 'faq-breadcrumb-name',
							'type'     => 'text',
							'title'    => esc_html__( 'Breadcrumb', 'manual' ),
							'subtitle'    => esc_html__( 'Personalized breadcrumb label', 'manual' ),
							'desc'     => __( '<strong>Will be displayed as:</strong>  Home / <strong>FAQ</strong> / Customization /', 'manual' ),
							'default'  => 'FAQ',
						),
						array(
							'id'       => 'faq-breadcrumb-custom-home-url',
							'type'     => 'text',
							'title'    => esc_html__( 'Breadcrumb URL', 'manual' ),
							'subtitle'    => esc_html__( 'Your customized web link for the FAQ breadcrumb label', 'manual' ),
							'desc'     => __( '<strong>Will be displayed as:</strong>  Home / <a href="">FAQ</a> / Customization /', 'manual' ),
							'subtitle' => esc_html__( 'Custom home page URL for your FAQ', 'manual' ),
							'default'  => '',
							'class' => 'theme-option-text-align-right',	
						),
	
		)
    ) );

	Redux::setSection( $opt_name, array(
	'title'            => esc_html__( 'Custom \'Page Title Bar\' - Category/Single Page', 'manual' ),
	'id'               => 'faq_cat_on_off_section',
	'subsection'       => true,
	'customizer_width' => '450px',
	'fields'           => array(
	
						array(
							'id'       => 'faq_pages_header_menu',
							'type'     => 'switch',
							'title'    => esc_html__( 'Customize the header menu', 'manual' ),
							'subtitle' => esc_html__('Modify the main header, including the logo and menu colors, if needed.', 'manual'),
							'default'  => false,
						),
						array(
							'id'       => 'faq_pages_header_background_colorbg',
							'type'     => 'color_rgba',
							'title'    => esc_html__( 'Background color', 'manual' ),
							'subtitle'    => esc_html__( 'Set the header background.', 'manual' ),
							'output'    => array('background' => '.navbar-inverse.theme-faq-pages'),
							'required' => array('faq_pages_header_menu','equals','1'),
							'class' => 'theme-option-text-align-right',			
						),
						array(
							'id'       => 'faq_pages_header_first_level_menu_text_color',
							'type'     => 'link_color',
							'title'    => esc_html__( 'Menu link color', 'manual' ),
							'subtitle' => esc_html__('Text color for the first level of the navigation menu.', 'manual'),
							'active'    => false, 
							'visited'   => false,
							'output'    => array('.navbar-inverse.theme-faq-pages .navbar-nav>li>a'), 
							'required' => array('faq_pages_header_menu','equals','1'),
							'class' => 'theme-option-text-align-right',
						),
						array(
							'id'       => 'faq_pages_header_flip_logo',
							'type'     => 'switch',
							'title'    => esc_html__( 'Flip logo', 'manual' ),
							'subtitle' => esc_html__('Switch from the \'primary logo\' to the \'secondary logo,\' if necessary.', 'manual'),
							'default'  => false,
							'class' => 'theme-option-text-align-right',
							'required' => array('faq_pages_header_menu','equals','1'),
						),
						array(
							'id'       => 'faq_pages_header_shadow',
							'type'     => 'switch',
							'title'    => esc_html__('Header shadow', 'manual' ),
							'desc' => esc_html__('Please note that this function is effective only when the header shadow is enabled in the \'Header Menu > Main Header\' settings.', 'manual'),
							'subtitle' => esc_html__('Turn the default header shadow on or off.', 'manual'),
							'default'  => false,
							'class' => 'theme-option-text-align-right',
							'required' => array('faq_pages_header_menu','equals','1'),
						),
						array(
							'id'       => 'faq_pages_header_menu_border_btm',
							'type'     => 'border',
							'title'    => esc_html__( 'Header border bottom', 'manual' ),
							'subtitle' => esc_html__('Re-adjust header border bottom', 'manual'),
							'color_alpha'  => true,
							'left'  => false,
							'right'  => false,
							'top'  => false,
							'class' => 'theme-option-text-align-right',
							'required' => array('faq_pages_header_menu','equals','1'),
							'output'    => array('.navbar.theme-faq-pages'),
						),
						array(
							'id'       => 'faq_pages_header_menu_border_top',
							'type'     => 'border',
							'title'    => esc_html__( 'Header border top', 'manual' ),
							'subtitle' => esc_html__('Re-adjust header border top', 'manual'),
							'desc' => esc_html__('If \'Menu position\' is set to \'Logo on Top\' and \'Menu Below Logo\' in \'Theme > Options > Header Menu > Main Header\', then this feature will work properly.', 'manual'),
							'color_alpha'  => true,
							'left'  => false,
							'right'  => false,
							'bottom'  => false,
							'required' => array('faq_pages_header_menu','equals','1'),
							'class' => 'theme-option-text-align-right',
							'output'    => array('.navbar.theme-faq-pages .navbar-collapse.collapse'),
						),
						array(
							'id'       => 'faq_header_menu_hamburger_search_box',
							'type'     => 'switch',
							'title'    => esc_html__( 'Hide the search box in the Hamburger menu.', 'manual' ),
							'desc' => esc_html__('This feature will only function if enabled \'Search Box in Hamburger Menu\' in the \'Theme Options\' under \'Header Menu\' in the \'Main Header\' section.', 'manual'),
							'default'  => false,
							'required' => array('faq_pages_header_menu','equals','1'),
							'on' => esc_html__( 'Hide', 'manual' ),
							'off' => esc_html__( 'Theme Default', 'manual' ),
							'class' => 'theme-option-text-align-right',
						),
						array(
							'id'       => 'onoff-faq-catag-single-page-title-bar',
							'type'     => 'switch',
							'title'    => esc_html__('Page title bar', 'manual' ),
							'subtitle' => __('Enable/Disable page title bar', 'manual'),
							'desc' => __('Note: Disabling the page title bar will change the menu style to the default setting, meaning that no transparent menu style will be used.', 'manual'),
							'default'  => true,
							'on'       => esc_html__( 'Enable', 'manual' ),
							'off'      => esc_html__( 'Disable', 'manual' ),
						),
						// -------------- Page Title Bar Controls --------------
						array(
							'id'       => 'faq-page-title-bar-controls',
							'type'     => 'section',
							'title'    => esc_html__( 'Page Title Bar', 'manual' ),
							'indent'   => true, 
							'required' => array('onoff-faq-catag-single-page-title-bar','equals','1'),  
						),
						array(
							'id'       => 'faq-header-height-category-page',
							'type'     => 'text',
							'title'    => esc_html__( 'Page title bar :: padding', 'manual' ),
							'subtitle' => esc_html__( 'Re-adjust the space above and below the \'Page Title Bar\' on your FAQ page.', 'manual' ),
							'desc'     => __('Example: 120px 0px 120px 0px (top, right, bottom, left) <br><br><strong style="color:#e6614b;">IMPORTANT: Make sure the value of RIGHT, LEFT is always 0px</strong>', 'manual' ), 
							'default'  => '',
						),
						array(
							'id'       => 'faq-responsive-header-height-category-page',
							'type'     => 'text',
							'title'    => esc_html__( 'Page title bar :: Responsive padding', 'manual' ),
							'subtitle' => esc_html__( 'Re-adjust the top/bottom spacing for page title bar', 'manual' ),
							'desc'     => __( 'Example: 100px 0px 100px 0px (top, right, bottom, left) <br><br><strong style="color:#e6614b;">IMPORTANT: Make sure the value of RIGHT, LEFT is always 0px</strong>', 'manual' ), 
							'default'  => '',
						),
						array(
							'id'       => 'faq-pagetilebar-title-text-typography',
							'type'        => 'typography',
							'title'    => esc_html__( 'Title typography', 'manual' ),
							'subtitle' => esc_html__( 'Customize title text.', 'manual' ),
							'output'    => array('.noise-break.theme-faq-pages h1.custom_h1_head'),
							'google'      => true,
							'font-backup' => false,
							'text-align' => false,
							'text-transform' => true,
							'subsets'       => false, 
							'letter-spacing'=> true,  
							'all_styles'  => true,
							'font-backup' => true,
							'word-spacing' => true,
							'margin-top' => true,
							'margin-bottom' => true,
							'units'       => 'px',
						),
						array(
							'id'       => 'faq-header-text-align',
							'type'     => 'select',
							'title'    => esc_html__( 'Text align', 'manual' ),
							'subtitle'    => esc_html__( 'Adjust the alignment of the text on the \'page title bar\'.', 'manual' ),
							'options'  => array(
								'left' => esc_html__('Left','manual' ),
								'center' => esc_html__('Center','manual' ),
								'right' => esc_html__('Right','manual' ),
							),
							'default'  => 'center'
						),
						array(
							'id'       => 'faq-cat-header-search-status',
							'type'     => 'switch',
							'title'    => esc_html__( 'Search box', 'manual' ),
							'default'  => false,
							'subtitle' => esc_html__('Choose to show or hide the search box in the specified \'page title bar\' area.', 'manual'),
							'on' => esc_html__( 'Disable', 'manual' ),
							'off' => esc_html__( 'Enable', 'manual' ),
						),
						array(
							'id'       => 'faq-searchbox-display-position',
							'type'     => 'select',
							'title'    => esc_html__( 'Search box position', 'manual' ),
							'subtitle'    => esc_html__( 'Choose where to place the search box on the \'page title bar\'.', 'manual' ),
							'options'  => array(
								'center' => esc_html__('Exact Center', 'manual' ),
								'6' => esc_html__('50% Width', 'manual' ),
								'7' => esc_html__('58% Width', 'manual' ),
								'8' => esc_html__('66% Width', 'manual' ),
								'9' => esc_html__('75% Width', 'manual' ),
								'10' => esc_html__('83% Width', 'manual' ),
								'11' => esc_html__('91% Width', 'manual' ),
								'12' => esc_html__('100% Width', 'manual' ),
							),
							'default'  => 'center',
							'required' => array('faq-cat-header-search-status','equals','0'),
							'class' => 'theme-option-text-align-right',
						),
						array(
							'id'       => 'faq-pagetitlebar-searchbox-treanding-search-color',
							'type'     => 'color',
							'title'    => esc_html__( 'Title text color', 'manual' ),
							'subtitle'    => esc_html__( 'Trending search text title color', 'manual' ),
							'required' => array('faq-cat-header-search-status','equals','0'),
							'output'    => array('.noise-break.theme-faq-pages .trending-search span.popular-keyword-title'),
							'class' => 'theme-option-text-align-right',
						),
						array(
							'id'       => 'faq-pagetitlebar-searchbox-treanding-search-link-color',
							'type'     => 'link_color',
							'title'    => esc_html__( 'Link color', 'manual' ),
							'subtitle'    => esc_html__( 'The trending keyword link color', 'manual' ),
							'active'    => false, 
							'visited'   => false,
							'required' => array('faq-cat-header-search-status','equals','0'),
							'output'    => array('.noise-break.theme-faq-pages .trending-search a.trending-search-popular-keyword'),  
							'class' => 'theme-option-text-align-right',
						),	
						array(
							'id'       => 'faq-cat-header-breadcrumb-status',
							'type'     => 'switch',
							'title'    => esc_html__( 'Breadcrumb', 'manual' ),
							'subtitle'    => esc_html__( 'Choose to show or hide the breadcrumb in the specified \'page title bar\' area.', 'manual' ),
							'default'  => false,
							'on'       => esc_html__( 'Disable', 'manual' ),
							'off'      => esc_html__( 'Enable', 'manual' ),
						),
						array(
							'id'       => 'faq_pagetitlebar_breadcrumb_text_color',
							'type'     => 'color_rgba',
							'title'    => esc_html__( 'Regular text color', 'manual' ),
							'subtitle' => esc_html__('Breadcrumb regular text color.', 'manual'),
							'required' => array('faq-cat-header-breadcrumb-status','equals','0'),
							'class' => 'theme-option-text-align-right',
							'output'    => array('.noise-break.theme-faq-pages #breadcrumbs'),
						),
						array(
							'id'       => 'faq_pagetitlebar_breadcrumb_link_color',
							'type'     => 'link_color',
							'title'    => esc_html__( 'Link color', 'manual' ),
							'subtitle' => esc_html__('Adjust the color of breadcrumb links if needed.', 'manual'),
							'required' => array('faq-cat-header-breadcrumb-status','equals','0'),
							'output'    => array('.noise-break.theme-faq-pages #breadcrumbs a'),
							'active'  => false,
							'class' => 'theme-option-text-align-right',
						),
						array(
							'id'       => 'faq_pagetitlebar_breadcrumb_link_seprator_color',
							'type'     => 'color_rgba',
							'title'    => esc_html__( 'Link seprator color', 'manual' ),
							'subtitle' => esc_html__('Adjust the color of breadcrumb link seprators if needed.', 'manual'),
							'required' => array('faq-cat-header-breadcrumb-status','equals','0'),
							'output'    => array('.noise-break.theme-faq-pages #breadcrumbs span'),
							'class' => 'theme-option-text-align-right',
						),
						array(
							'id'       => 'faq-pagetitlebar-background-setup',
							'type' => 'background',
							'title'    => esc_html__( 'Background', 'manual' ),
							'subtitle' => esc_html__( 'Create the background for your FAQ page.', 'manual' ),
							'desc' => __( '<span style="color:red;">IMPORTANT:</span> If you use category-based images for the \'page title bar\' header, don\'t upload an image here. Uploading an image will replace all category-based images, and only the uploaded image here will show in the entire FAQ section.', 'manual' ),
						),
						array(
							'id'       => 'faq-pagetitlebar-image-overlay',
							'type'     => 'color_rgba',
							'title'    => esc_html__( 'Background overlay', 'manual' ),
							'subtitle'    => esc_html__( 'Select the background overlay for your FAQ page title bar.', 'manual' ),
							'output'    => array('background' => '.noise-break.theme-faq-pages .page_opacity.header_custom_height_new'),
							'class' => 'theme-option-text-align-right',
						),
			
		)
	) );
	
	
    Redux::setSection( $opt_name, array(
        'title'  => esc_html__( 'Category Page', 'manual' ),
        'id'     => 'theme_faq_section',
	    'subsection' => true,
        'fields' => array(
		
			array(
                'id'       => 'faq-display-sidebar-status',
                'type'     => 'switch',
                'title'    => esc_html__( 'Sidebar', 'manual' ),
                'subtitle' => esc_html__( 'Turn on/off the sidebar on your FAQ page', 'manual' ),
                'default'  => false,
				'on' => esc_html__( 'Disable', 'manual' ),
				'off' => esc_html__( 'Enable', 'manual' ),
            ),
			array(
				'id'       => 'faq-sidebar-display-position',
				'type'     => 'select',
				'title'    => esc_html__( 'Position', 'manual' ),
				'subtitle' => esc_html__( 'Choose the display position for the FAQ sidebar.', 'manual' ),
				'options'  => array(
					'left' => esc_html__('Left','manual' ),
					'right' => esc_html__('Right','manual' ),
				),
				'default'  => 'left',
				'class' => 'theme-option-text-align-right',
				'required' => array('faq-display-sidebar-status','equals','0'),
			),
			array(
                'id'       => 'faq-ed-expandcollapse',
                'type'     => 'switch',
                'title'    => esc_html__( '"Expand/Collapse All" link', 'manual' ),
                'subtitle' => esc_html__( 'Enable or disable the option to show the "Expand / Collapse All" text on top of FAQ records. When activated, clicking it opens all FAQ records at once, and another click closes them all.', 'manual' ),
                'default'  => true,
				'on' => esc_html__( 'Enable', 'manual' ),
				'off' => esc_html__( 'Disable', 'manual' ),
            ),
			array(
                'id'       => 'faq-display-social-share',
                'type'     => 'switch',
                'title'    => esc_html__( 'Social share', 'manual' ),
                'subtitle' => esc_html__( 'Show/hide social share icons within the FAQ records.', 'manual' ),
                'default'  => true,
				'on' => esc_html__( 'Enable', 'manual' ),
				'off' => esc_html__( 'Disable', 'manual' ),
            ),
			array(
				'id'       => 'faq-records-settings',
				'type'     => 'section',
				'title'    => esc_html__( 'FAQ Records Configuration', 'manual' ),
				'indent'   => true, 
			),
			array(
					'id'       => 'faq-display-order',
					'type'     => 'select',
					'title'    => esc_html__( 'Display order', 'manual' ),
					'subtitle' => esc_html__( 'Order of display for FAQ records', 'manual' ),
					'options'  => array(
						'1' => esc_html__('Ascending Order (ASC)','manual' ),
						'2' => esc_html__('Descending Order (DESC)','manual' ),
					),
					'default'  => '2'
			),
			array(
				'id'       => 'faq-display-order-by',
				'type'     => 'select',
				'title'    => esc_html__( 'Display order by', 'manual' ),
				'subtitle' => esc_html__( 'Order of display by for FAQ records', 'manual' ),
				'options'  => array(
					'date' => esc_html__('Order By Date','manual' ),
					'modified' => esc_html__('Order By Last Modified Date','manual' ),
					'title' => esc_html__('Order By Title','manual' ),
					'rand' => esc_html__('Order By Random','manual' ),
					'menu_order' => esc_html__('Order By Page Order','manual' ),
					'comment_count' => esc_html__('Order By Number of Comments','manual' ),
					'none' => esc_html__('None','manual' ),
				),
				'default'  => 'date'
			),
			array(
				'id'       => 'faq-noof-records-catper-page',
				'type'     => 'text',
				'title'    => esc_html__( 'FAQ records', 'manual' ),
				'subtitle'    => esc_html__( 'Number of records per page for FAQ records', 'manual' ),
				'default'  => '-1',
				'desc' => esc_html__( 'Setting the value to "-1" will show all results without any pagination', 'manual' ),
			),
			array(
				'id'       => 'faq-other-category-settings',
				'type'     => 'section',
				'title'    => esc_html__( 'FAQ Records Design Settings', 'manual' ),
				'indent'   => true, 
			),
			array(
				'id'       => 'faq-tab-box-background-color',
				'type'     => 'color_rgba',
				'title'    => esc_html__( 'Background color', 'manual' ),
				'subtitle' => esc_html__( 'Background color of the FAQ bar tab', 'manual' ),
				'desc' => __('Default: #FAFAFA', 'manual' ),
				'default'  => array(
								'color' => '#FAFAFA',
								'alpha' => '1'
							),
			),
			array(
				'id'       => 'faq-tab-box-border-radius',
				'type'     => 'text',
				'title'    => esc_html__( 'Border radius', 'manual' ),
				'subtitle' => esc_html__( 'Manages the border radius of the FAQ tab box.', 'manual' ),
				'desc' => __('Example: 0px 0px 0px 0px (top, right, bottom, left)', 'manual' ),
				'default'  => '0px 0px 0px 0px',
			),
			array(
				'id'       => 'faq-tab-box-title-typography',
				'type'        => 'typography',
				'title'    => esc_html__( 'Title typography', 'manual' ),
				'subtitle' => esc_html__( 'Customize tab title text.', 'manual' ),
				'output'    => array('.display-faq-section h5.title-faq-cat'),
				'google'      => true,
				'font-backup' => false,
				'text-align' => false,
				'text-transform' => true,
				'subsets'       => false, 
				'color'       => false, 
				'letter-spacing'=> true,  
				'all_styles'  => true,
				'font-backup' => true,
				'word-spacing' => true,
				'margin-top' => true,
				'margin-bottom' => true,
				'units'       => 'px',
				'default'  => array(
					'font-weight'  => '700', 
					'google'      => true,
					'font-size'   => '20px', 
					'line-height' => '25px'
				),
			),
			array(
				'id'       => 'faq-tab-box-title-link-color',
				'type'     => 'link_color',
				'title'    => esc_html__( 'Link color', 'manual' ),
				'subtitle' => esc_html__('Adjust the color of title.', 'manual'),
				'output'    => array('.display-faq-section h5.title-faq-cat a'),
				'active'  => false,
				'class' => 'theme-option-text-align-right',
			),
		)
    ) );
	
	
/**********************************************
*******  START  PORTFOLIO       *****
***********************************************/

		Redux::setSection( $opt_name, array(
			'title'            => esc_html__( 'Portfolio', 'manual' ),
			'id'               => 'theme_portfolio_section',
			'customizer_width' => '400px',
			'icon'             => 'el el-picture'
		) );
		
		 Redux::setSection( $opt_name, array(
			'title'      => esc_html__( 'Global Settings', 'manual' ),
			'id'         => 'manual-portfolio-settings',
			'subsection' => true,
			'fields'     => array(
			
			   array(
					'id'       => 'portfolio-slug-name',
					'type'     => 'text',
					'title'    => esc_html__( 'Post slug name', 'manual' ),
					'subtitle'    => esc_html__( 'Slug name for portfolio single post.', 'manual' ),
					'desc'     => __( '<strong>Will be displayed as: </strong> http://domain.com/<strong>work</strong>/single-portfolio-record/ <br><br>  <div style="color: #D01B0B;"><strong>CAUTION:</strong> portfolio link name should not match the page name, or it may result in a 404 error.</div>', 'manual' ),
					'default'  => 'work',
			   ),
			   array(
					'id'       => 'portfolio-cat-slug-name',
					'type'     => 'text',
					'title'    => esc_html__( 'Category slug name', 'manual' ),
					'subtitle'    => esc_html__( 'Slug name for portfolio category page.', 'manual' ),
					'desc'     => __( '<strong>Will be displayed as: </strong> http://domain.com/<strong>pfocat</strong>/themes/ <br><br> <div style="color: #D01B0B;"><strong>CAUTION:</strong> The category slug name should be different from the portfolio post and page names. If they match, you\'ll see a 404 error. Also, try not to change the category slug often, as it can cause broken links and affect search results.</div>', 'manual' ),
					'default'  => 'pfocat',
			   ),
			   array(
					'id'       => 'portfolio-post-type-support-custom-fields',
					'type'     => 'switch',
					'title'    => esc_html__( 'Custom field box', 'manual' ),
					'subtitle' => esc_html__( 'Custom fields in WordPress are a more advanced feature that allows you to include additional information in specific posts.', 'manual' ),
					'on' => esc_html__( 'Enable', 'manual' ),
					'off' => esc_html__( 'Disable', 'manual' ),
					'default'  => false,
			   ),
			   array(
					'id'       => 'portfolio-breadcrumb-name',
					'type'     => 'text',
					'title'    => esc_html__( 'Breadcrumb', 'manual' ),
					'subtitle' => esc_html__( 'Personalized breadcrumb label', 'manual' ),
					'desc'     => __( '<strong>Will be displayed as:</strong>  Home / <strong>Portfolio</strong> / Customization /', 'manual' ),
					'default'  => 'Portfolio',
				),
				array(
					'id'       => 'portfolio-breadcrumb-custom-home-url',
					'type'     => 'text',
					'title'    => esc_html__( 'Breadcrumb URL', 'manual' ),
					'subtitle' => esc_html__( 'Custom home page URL for your FAQ', 'manual' ),
					'desc'     => __( '<strong>Will be displayed as:</strong>  Home / <a href="">Portfolio</a> / Customization /', 'manual' ),
					'default'  => '',
					'class'  => 'theme-option-text-align-right',
				),
				array(
					'id'       => 'portfolio-comment-status',
					'type'     => 'switch',
					'title'    => esc_html__( 'Comment box', 'manual' ),
					'subtitle' => esc_html__('Comments on each portfolio article.', 'manual'),
					'default'  => false,
					'on' => esc_html__( 'Enable', 'manual' ),
					'off' => esc_html__( 'Disable', 'manual' ),
				),
				array(
					'id'       => 'portfolio-next-previous-status',
					'type'     => 'switch',
					'title'    => esc_html__('Next/Previous link ', 'manual' ),
					'subtitle' => esc_html__('Turn on/off the next/previous links at the bottom of the individual portfolio page.', 'manual'),
					'default'  => false,
					'on' => esc_html__( 'Enable', 'manual' ),
					'off' => esc_html__( 'Disable', 'manual' ),
				),		
			)
		) );
		
		
		
/**********************************************
*******  START BLOG       *****
***********************************************/

	Redux::setSection( $opt_name, array(
			'title'            => esc_html__( 'Blog', 'manual' ),
			'id'               => 'theme_blog_section',
			'customizer_width' => '400px',
			'icon'             => 'el el-file-edit'
	) );
	
	Redux::setSection( $opt_name, array(
        'title'            => esc_html__( 'Blog Settings', 'manual' ),
        'id'               => 'blog_global_settings',
        'subsection'       => true,
        'customizer_width' => '450px',
        'fields'           => array(
		
				array(
					'id'       => 'remove_blog_breadcrumb_name',
					'type'     => 'switch',
					'title'    => esc_html__( 'Simplify blog breadcrumb', 'manual' ),
					'desc'     => __('<strong>Will appear as:</strong>  Home / Latest News /','manual' ),
					'default'  => false,
					'subtitle' => esc_html__( 'Take out the category and page name from the breadcrumb on the blog page.', 'manual' ),
					'on' => esc_html__( 'Enable', 'manual' ),
					'off' => esc_html__( 'Disable', 'manual' ),
				),
				array(
					'id'       => 'blog-breadcrumb-name',
					'type'     => 'text',
					'title'    => esc_html__( 'Custom name in breadcrumb', 'manual' ),
					'desc'     => __( '<strong>Will show up as:</strong> Home / <strong>{BLOG CUSTOM NAME}</strong> / Category Name / Latest News / <br><br> Choose a special name for a page on your blog. This name will appear in the title bar on the Breadcrumb row after the home page, following "home/". If you have set a specific \'Posts page\' in the \'Settings > Reading\' of your blog, its name will be shown in the Breadcrumb list. But, if you have a custom page name, it will replace the default one.', 'manual' ),
					'default'  => '',
					'subtitle' => esc_html__( 'Customizing breadcrumb', 'manual' ),
					'required' => array('remove_blog_breadcrumb_name','equals','0'),
					'class' => 'theme-option-text-align-right',	
				),
				array(
					'id'       => 'blog_single_page_global_header_settings',
					'type'     => 'switch',
					'title'    => esc_html__( 'Uniform page title bar', 'manual' ),
					'subtitle' => __('Apply the header (page title bar) settings from the \'Front Post Page,\' which is selected in \'Settings > Reading\' as your main posts page, to the entire blog area.', 'manual' ),
					'default'  => false,
					'on' => esc_html__( 'Enable', 'manual' ),
					'off' => esc_html__( 'Disable', 'manual' ),
				),
				array(
					'id'       => 'blog-landing-page',
					'type'     => 'section',
					'title'    => esc_html__( 'Blog Landing Page', 'manual' ),
					'indent'   => true,
				),
				array (
					'subtitle' => esc_html__('Change the \'Continue Reading\' text link that will appear under the post summary on your main landing page, which is set in \'Settings > Reading\' as your selected Posts page. ', 'manual'),
					'id' => 'theme-defult-post-continue-reading-text',
					'type' => 'text',
					'title' => esc_html__('Read more: Text below post summary', 'manual'),
					'default' => esc_html__('Continue Reading', 'manual'),
				),
				array(
					'id'       => 'blog_home_title_tag',
					'type'     => 'select',
					'title'    => esc_html__( 'Title tag', 'manual' ),
					'subtitle' => esc_html__('Choose the title tag for showing blog posts on your main landing page, set in \'Settings > Reading\' as your selected Posts page.','manual' ),
					'options'  => array(
						'h2' => esc_html__('h2', 'manual' ),
						'h3' => esc_html__('h3', 'manual' ),
						'h4' => esc_html__('h4', 'manual' ),
						'h5' => esc_html__('h5', 'manual' ),
						'h6' => esc_html__('h6', 'manual' ),
					),
					'default'  => 'h2', 
				),
				array(
					'id'       => 'blog_home_sidebar',
					'type'     => 'switch',
					'title'    => esc_html__( 'Sidebar', 'manual' ),
					'subtitle' => esc_html__('Turn sidebar on or off for the main landing page, which is set in \'Settings > Reading\' as your chosen Posts page.','manual' ),
					'default'  => true,
					'on' => esc_html__( 'Enable', 'manual' ),
					'off' => esc_html__( 'Disable', 'manual' ),
				),
				
		)
    ) );
	
    Redux::setSection( $opt_name, array(
        'title'  => esc_html__( 'Blog Single', 'manual' ),
        'id'     => 'theme_blog_section_singlepg',
        'subsection' => true,
        'fields' => array(
		
						array(
							'id'       => 'blog_single_pg_header_menu',
							'type'     => 'switch',
							'title'    => esc_html__( 'Customize the header menu', 'manual' ),
							'subtitle' => esc_html__('Modify the main header, including the logo and menu colors, if needed.', 'manual'),
							'default'  => false,
						),
						array(
							'id'       => 'blog_single_pg_header_background_colorbg',
							'type'     => 'color_rgba',
							'title'    => esc_html__( 'Background color', 'manual' ),
							'subtitle'    => esc_html__( 'Set the header background.', 'manual' ),
							'output'    => array('background' => '.navbar-inverse.single-blog-post-pg'),
							'required' => array('blog_single_pg_header_menu','equals','1'),
							'class' => 'theme-option-text-align-right',			
						),
						array(
							'id'       => 'blog_single_pg_header_first_level_menu_text_color',
							'type'     => 'link_color',
							'title'    => esc_html__( 'Menu link color', 'manual' ),
							'subtitle' => esc_html__('Text color for the first level of the navigation menu.', 'manual'),
							'active'    => false, 
							'visited'   => false,
							'output'    => array('.navbar-inverse.single-blog-post-pg .navbar-nav>li>a'), 
							'required' => array('blog_single_pg_header_menu','equals','1'),
							'class' => 'theme-option-text-align-right',
						),
						array(
							'id'       => 'blog_single_pg_header_flip_logo',
							'type'     => 'switch',
							'title'    => esc_html__( 'Flip logo', 'manual' ),
							'subtitle' => esc_html__('Switch from the \'primary logo\' to the \'secondary logo,\' if necessary.', 'manual'),
							'default'  => false,
							'class' => 'theme-option-text-align-right',
							'required' => array('blog_single_pg_header_menu','equals','1'),
						),
						array(
							'id'       => 'blog_single_pg_header_shadow',
							'type'     => 'switch',
							'title'    => esc_html__('Header shadow', 'manual' ),
							'desc' => esc_html__('Please note that this function is effective only when the header shadow is enabled in the \'Header Menu > Main Header\' settings.', 'manual'),
							'subtitle' => esc_html__('Turn the default header shadow on or off.', 'manual'),
							'default'  => false,
							'class' => 'theme-option-text-align-right',
							'required' => array('blog_single_pg_header_menu','equals','1'),
						),
						array(
							'id'       => 'blog_single_pg_header_menu_border_btm',
							'type'     => 'border',
							'title'    => esc_html__( 'Header border bottom', 'manual' ),
							'subtitle' => esc_html__('Re-adjust header border bottom', 'manual'),
							'color_alpha'  => true,
							'left'  => false,
							'right'  => false,
							'top'  => false,
							'class' => 'theme-option-text-align-right',
							'required' => array('blog_single_pg_header_menu','equals','1'),
							'output'    => array('.navbar.single-blog-post-pg'),
						),
						array(
							'id'       => 'blog_single_pg_header_menu_border_top',
							'type'     => 'border',
							'title'    => esc_html__( 'Header border top', 'manual' ),
							'subtitle' => esc_html__('Re-adjust header border top', 'manual'),
							'desc' => esc_html__('If \'Menu position\' is set to \'Logo on Top\' and \'Menu Below Logo\' in \'Theme > Options > Header Menu > Main Header\', then this feature will work properly.', 'manual'),
							'color_alpha'  => true,
							'left'  => false,
							'right'  => false,
							'bottom'  => false,
							'required' => array('blog_single_pg_header_menu','equals','1'),
							'class' => 'theme-option-text-align-right',
							'output'    => array('.navbar.single-blog-post-pg .navbar-collapse.collapse'),
						),
						array(
							'id'       => 'blog_single_header_menu_hamburger_search_box',
							'type'     => 'switch',
							'title'    => esc_html__( 'Hide the search box in the Hamburger menu.', 'manual' ),
							'desc' => esc_html__('This feature will only function if enabled \'Search Box in Hamburger Menu\' in the \'Theme Options\' under \'Header Menu\' in the \'Main Header\' section.', 'manual'),
							'default'  => false,
							'required' => array('blog_single_pg_header_menu','equals','1'),
							'on' => esc_html__( 'Hide', 'manual' ),
							'off' => esc_html__( 'Theme Default', 'manual' ),
							'class' => 'theme-option-text-align-right',
						),
						array(
							'id'       => 'blog_single_pagetitlebar_controls',
							'type'     => 'switch',
							'title'    => esc_html__( 'Page title bar', 'manual' ),
							'subtitle' => esc_html__('Enable/Disable page title bar', 'manual'),
							'desc' => esc_html__('Note: Disabling the page title bar will change the menu style to the default setting, meaning that no transparent menu style will be used.', 'manual'),
							'default'  => true,
							'on' => esc_html__( 'Enable', 'manual' ),
							'off' => esc_html__( 'Disable', 'manual' ),
						),
						// Page Title Bar
						array(
							'id'       => 'blog-singlepage-content-pagetitlebar-settings',
							'type'     => 'section',
							'title'    => esc_html__( 'Page Title Bar', 'manual' ),
							'indent'   => true, 
							'required' => array('blog_single_pagetitlebar_controls','equals','1'),
						),
						array(
							'id'       => 'blog-header-height',
							'type'     => 'text',
							'title'    => esc_html__( 'Page title bar :: padding', 'manual' ),
							'subtitle' => __( 'Re-adjust the space above and below the \'Page Title Bar\' on your blog\'s single page.', 'manual' ),
							'desc'     => __('Example: 135px 0px 135px 0px (top, right, bottom, left) <br><br><strong style="color:#e6614b;">IMPORTANT: Make sure the value of RIGHT, LEFT is always 0px</strong>', 'manual' ),
							'default'  => '',
						),
						array(
							'id'       => 'blog-responsive-header-height',
							'type'     => 'text',
							'title'    => esc_html__( 'Page title bar :: Responsive padding', 'manual' ),
							'subtitle' => esc_html__( 'Re-adjust the top/bottom spacing for page title bar', 'manual' ),
							'desc'     => __( 'Example: 100px 0px 100px 0px (top, right, bottom, left) <br><br><strong style="color:#e6614b;">IMPORTANT: Make sure the value of RIGHT, LEFT is always 0px</strong>', 'manual' ), 
							'default'  => '',
						),
						array(
							'id'       => 'blog_single_title_on_header',
							'type'     => 'switch',
							'title'    => esc_html__( 'Blog title', 'manual' ),
							'subtitle' => esc_html__('Choose to display or hide the Blog Post Title in the specified \'page title bar\' area.', 'manual'),
							'default'  => true,
						),
						array(
							'id'       => 'blog-header-text-typography',
							'type'        => 'typography',
							'title'    => esc_html__( 'Title typography', 'manual' ),
							'subtitle' => esc_html__( 'Customize title text.', 'manual' ),
							'output'    => array('.noise-break.single-blog-post-pg h1.custom_h1_head'),
							'required' => array('blog_single_title_on_header','equals','1'),
							'google'      => true,
							'font-backup' => false,
							'text-align' => false,
							'text-transform' => true,
							'subsets'       => false, 
							'letter-spacing'=> true,  
							'all_styles'  => true,
							'font-backup' => true,
							'word-spacing' => true,
							'margin-top' => true,
							'margin-bottom' => true,
							'units'       => 'px',
							'class' => 'theme-option-text-align-right',
						),
						array(
							'id'         => 'blog-header-typography-spacing',
							'type'       => 'spacing',
							'mode'       => 'padding',
							'title'      => esc_html__( 'Title padding', 'manual' ),
							'subtitle' => esc_html__('Adjust title padding', 'manual'),
							'desc' => esc_html__('Only works on screens that are larger than 992 pixels.', 'manual'),
							'units'   => array('px'),
							'class' => 'theme-option-text-align-right',
							'required' => array('blog_single_title_on_header','equals','1'),
						),
						array(
							'id'          => 'blog_header_typography_responsive_h1',
							'type'        => 'typography',
							'title'       => esc_html__( 'Responsive title', 'manual' ),
							'subtitle'    => esc_html__( 'Set responsive title', 'manual' ),
							'google'      => false,
							'font-weight' => false,
							'font-style' => false,
							'font-family' => false,
							'font-backup' => false,
							'text-align'  => false,
							'text-transform' => true,
							'subsets'        => false, 
							'color'          => false, 
							'text-transform'  => false, 
							'letter-spacing' => true,  
							'all_styles'  => false,
							'word-spacing' => true,
							'units'        => 'px',
							'class' => 'theme-option-text-align-right',
							'required' => array('blog_single_title_on_header','equals','1'),
						),
						array(
							'id'         => 'blog-header-text-align',
							'type'       => 'select',
							'title'      => esc_html__( 'Text align', 'manual' ),
							'subtitle' => esc_html__('Adjust the alignment of the text on the \'page title bar\'.', 'manual'),
							'options'    => array(
								'left'   => esc_html__('Left','manual' ),
								'center' => esc_html__('Center','manual' ),
								'right'  => esc_html__('Right','manual' ),
							),
							'default'    => 'center'
						),
						array(
							'id'       => 'blog_single_post_display_search',
							'type'     => 'switch',
							'title'    => esc_html__('Search Box', 'manual' ),
							'subtitle' => esc_html__('Choose to show or hide the search box in the specified \'page title bar\' area.', 'manual'),
							'default'  => false,
							'on'       => esc_html__( 'Enable', 'manual' ),
							'off'      => esc_html__( 'Disable', 'manual' ),
						),
						array(
							'id'       => 'blog-single-searchbox-display-position',
							'type'     => 'select',
							'title'    => esc_html__( 'Search box position', 'manual' ),
							'subtitle' => esc_html__('Choose where to place the search box on the \'page title bar\'.', 'manual'),
							'options'  => array(
								'center' => esc_html__('Exact Center','manual' ),
								'6'  => esc_html__('50% Width','manual' ),
								'7'  => esc_html__('58% Width','manual' ),
								'8'  => esc_html__('66% Width','manual' ),
								'9'  => esc_html__('75% Width','manual' ),
								'10' => esc_html__('83% Width','manual' ),
								'11' => esc_html__('91% Width','manual' ),
								'12' => esc_html__('100% Width','manual' ),
							),
							'default'  => 'center',
							'required' => array('blog_single_post_display_search','equals','1'),
							'class' => 'theme-option-text-align-right',
						), 
						array(
							'id'       => 'blog-single-searchbox-treanding-search-color',
							'type'     => 'color',
							'title'    => esc_html__( 'Title text color', 'manual' ),
							'subtitle'    => esc_html__( 'Trending search text title color', 'manual' ),
							'required' => array('blog_single_post_display_search','equals','1'),
							'output'    => array('.noise-break.single-blog-post-pg .trending-search span.popular-keyword-title'),
							'class' => 'theme-option-text-align-right',
						),
						array(
							'id'       => 'blog-single-searchbox-treanding-search-link-color',
							'type'     => 'link_color',
							'title'    => esc_html__( 'Link color', 'manual' ),
							'subtitle'    => esc_html__( 'The trending keyword link color', 'manual' ),
							'active'    => false, 
							'visited'   => false,
							'required' => array('blog_single_post_display_search','equals','1'),
							'output'    => array('.noise-break.single-blog-post-pg .trending-search a.trending-search-popular-keyword'),  
							'class' => 'theme-option-text-align-right',
						),	
						array(
							'id'       => 'blog_single_breadcrumb_on_header',
							'type'     => 'switch',
							'title'    => esc_html__( 'Breadcrumb', 'manual' ),
							'subtitle' => esc_html__('Choose to show or hide the breadcrumb in the specified \'page title bar\' area.', 'manual'),
							'default'  => true,
							'on'       => esc_html__( 'Enable', 'manual' ),
							'off'      => esc_html__( 'Disable', 'manual' ),
						),
						array(
							'id'       => 'blog_single_breadcrumb_regular_text_color',
							'type'     => 'color_rgba',
							'title'    => esc_html__( 'Regular text color', 'manual' ),
							'subtitle' => esc_html__('Breadcrumb regular text color.', 'manual'),
							'required' => array('blog_single_breadcrumb_on_header','equals','1'),
							'class' => 'theme-option-text-align-right',
							'output'    => array('.noise-break.single-blog-post-pg #breadcrumbs'),
						),
						array(
							'id'       => 'blog_single_breadcrumb_link_color',
							'type'     => 'link_color',
							'title'    => esc_html__( 'Link color', 'manual' ),
							'subtitle' => esc_html__('Adjust the color of breadcrumb links if needed.', 'manual'),
							'required' => array('blog_single_breadcrumb_on_header','equals','1'),
							'output'    => array('.noise-break.single-blog-post-pg #breadcrumbs a'),
							'active'  => false,
							'class' => 'theme-option-text-align-right',
						),
						array(
							'id'       => 'blog_single_breadcrumb_link_seprator_color',
							'type'     => 'color_rgba',
							'title'    => esc_html__( 'Link seprator color', 'manual' ),
							'subtitle' => esc_html__('Adjust the color of breadcrumb link seprators if needed.', 'manual'),
							'required' => array('blog_single_breadcrumb_on_header','equals','1'),
							'output'    => array('.noise-break.single-blog-post-pg #breadcrumbs span'),
							'class' => 'theme-option-text-align-right',
						),
						array(
							'id'       => 'blog_featured_image_on_the_header',
							'type'     => 'switch',
							'title'    => esc_html__( 'Featured image', 'manual' ),
							'subtitle' => esc_html__('Choose whether to display or hide the \'post feature image\' on the \'page title bar\'.', 'manual'),
							'default'  => false,
							'on'       => esc_html__( 'Enable', 'manual' ),
							'off'      => esc_html__( 'Disable', 'manual' ),
						),
						array(
							'id'       => 'blog_featured_image_bg_adjustment',
							'type'     => 'background',
							'background-color'     => false,
							'background-image'     => false,
							'title'    => esc_html__( 'Background', 'manual' ),
							'subtitle'    => esc_html__( 'Adjust background.', 'manual' ),
							'required' => array('blog_featured_image_on_the_header','equals','1'),
							'class' => 'theme-option-text-align-right',
							'default'  => array(
												'background-repeat' => 'no-repeat',
												'background-position' => 'center center',
												'background-size' => 'cover',
												'background-attachment' => 'scroll',
											),
						),
						array(
							'id'       => 'blog_background_nofeaturedimage',
							'type'     => 'background',
							'title'    => esc_html__( 'Background', 'manual' ),
							'subtitle'    => esc_html__( 'Adjust background.', 'manual' ),
							'required' => array('blog_featured_image_on_the_header','equals','0'),
							'class' => 'theme-option-text-align-right',
						),
						array(
							'id'       => 'blog_featured_image_overlay',
							'type'     => 'color_rgba',
							'title'    => esc_html__( 'Background overlay', 'manual' ),
							'subtitle'    => esc_html__( 'Select the background overlay for your blog single page title bar.', 'manual' ),
							'output'    => array('background' => '.noise-break.single-blog-post-pg .page_opacity.header_custom_height_new'),
							'class' => 'theme-option-text-align-right',
						),
						// Content layout
						array(
							'id'       => 'blog-singlepage-content-layout-settings',
							'type'     => 'section',
							'title'    => esc_html__( 'Content Layout Settings', 'manual' ),
							'indent'   => true, 
						),
						array(
							'id'       => 'blog_single_title_on_content_area',
							'type'     => 'switch',
							'title'    => esc_html__( 'Title', 'manual' ),
							'subtitle' => __('Enable or disable the display of the post title at the top of the blog post content','manual' ),
							'default'  => false,
							'on' => esc_html__( 'Enable', 'manual' ),
							'off' => esc_html__( 'Disable', 'manual' ),
						),
						array(
							'id'       => 'manual_blog_single_page_title_tag',
							'type'     => 'select',
							'title'    => esc_html__( 'Title tag', 'manual' ),
							'subtitle' => esc_html__('Adjust the tag for the post title.','manual' ),
							'options'  => array(
								'h1' => esc_html__('h1', 'manual' ),
								'h2' => esc_html__('h2', 'manual' ),
								'h3' => esc_html__('h3', 'manual' ),
							),
							'default'  => 'h2',
							'required' => array('blog_single_title_on_content_area','equals','1'), 
							'class' => 'theme-option-text-align-right',
						),
						array(
							'id'       => 'blog_single_post_feature_image',
							'type'     => 'switch',
							'title'    => esc_html__( 'Feature image', 'manual' ),
							'subtitle' => esc_html__('Decide if you want to show or hide the \'post feature image\' above the content and below the post title.','manual' ),
							'default'  => true,
							'on' => esc_html__( 'Enable', 'manual' ),
							'off' => esc_html__( 'Disable', 'manual' ),
						),
						array(
							'id'       => 'blog_single_page_icon_format',
							'type'     => 'switch',
							'title'    => esc_html__( 'Post format (icon)', 'manual' ),
							'subtitle' => esc_html__('Activate/deactivate the post format icon visible in the upper-right section of the post. (The use of post formats can affect how the content is displayed on your site)','manual' ),
							'default'  => true,
							'on' => esc_html__( 'Disable', 'manual' ),
							'off' => esc_html__( 'Enable', 'manual' ),
						),
						array(
							'id'       => 'blog_single_meta_fields',
							'type'     => 'switch',
							'title'    => esc_html__('Meta fields', 'manual'),
							'subtitle' => esc_html__('Turn on/off the information below the post title and above the post content.', 'manual'),
							'default'  => true,
							'on' => esc_html__( 'Enable', 'manual' ),
							'off' => esc_html__( 'Disable', 'manual' ),
						),
						array(
							'id'       => 'blog_single_meta_date',
							'type'     => 'switch',
							'title'    => esc_html__('Date', 'manual'),
							'subtitle' => esc_html__('Turn on/off date.', 'manual'),
							'default'  => true,
							'on' => esc_html__( 'Enable', 'manual' ),
							'off' => esc_html__( 'Disable', 'manual' ),
							'class' => 'theme-option-text-align-right',
							'required' => array('blog_single_meta_fields','equals','1'), 
						),
						array(
							'id'       => 'blog_single_meta_author',
							'type'     => 'switch',
							'title'    => esc_html__('Author name', 'manual'),
							'subtitle' => esc_html__('Turn on/off author name.', 'manual'),
							'default'  => true,
							'on' => esc_html__( 'Enable', 'manual' ),
							'off' => esc_html__( 'Disable', 'manual' ),
							'class' => 'theme-option-text-align-right',
							'required' => array('blog_single_meta_fields','equals','1'), 
						),
						array(
							'id'       => 'blog_single_meta_category_name',
							'type'     => 'switch',
							'title'    => esc_html__('Category name', 'manual'),
							'subtitle' => esc_html__('Turn on/off category name.', 'manual'),
							'default'  => true,
							'on' => esc_html__( 'Enable', 'manual' ),
							'off' => esc_html__( 'Disable', 'manual' ),
							'class' => 'theme-option-text-align-right',
							'required' => array('blog_single_meta_fields','equals','1'), 
						),
						array(
							'id'       => 'blog_single_social_share_status',
							'type'     => 'switch',
							'title'    => esc_html__( 'Social share', 'manual' ),
							'subtitle' => esc_html__('Sharing buttons visible under the blog post.', 'manual'),
							'default'  => true,
							'on' => esc_html__( 'Enable', 'manual' ),
							'off' => esc_html__( 'Disable', 'manual' ),
						),
						array(
							'id'       => 'blog_single_sidebar_status',
							'type'     => 'switch',
							'title'    => esc_html__('Sidebar', 'manual'),
							'subtitle' => esc_html__('Turn on/off the sidebar on your blog single page', 'manual'),
							'default'  => true,
							'on' => esc_html__( 'Enable', 'manual' ),
							'off' => esc_html__( 'Disable', 'manual' ),
						),
						array(
							'id'       => 'blog_single_page_sidebar_center_content',
							'type'     => 'switch',
							'title'    => esc_html__('Center content', 'manual'),
							'subtitle' => esc_html__('Apply the content exactly in the middle.', 'manual'),
							'default'  => false,
							'on' => esc_html__( 'Enable', 'manual' ),
							'off' => esc_html__( 'Disable', 'manual' ),
							'required' => array('blog_single_sidebar_status','equals','0'), 
							'class' => 'theme-option-text-align-right',
						),

		)
    ) );	
		
/*************************************
*******  WeDocs  *****
**************************************/
if(class_exists( 'WeDocs' )) {

	Redux::setSection( $opt_name, array(
        'title'            => esc_html__( 'WeDocs', 'manual' ),
        'id'               => 'add_on_wedocs_plugin',
        'customizer_width' => '400px',
        'icon'             => 'el el-folder-open'
    ) );
	
	Redux::setSection( $opt_name, array(
        'title'            => esc_html__( 'Single Page Settings', 'manual' ),
        'id'               => 'WeDocs-pagecontent',
        'customizer_width' => '450px',
		'subsection'       => true,
        'fields'           => array(
		
				array(
					'id'       => 'wedocs-title-on-page',
					'type'     => 'switch',
					'title'    => esc_html__('Title', 'manual'),
					'subtitle'    => esc_html__( 'Show/hide title on the content page', 'manual' ),
					'default'  => true,
					'on' => esc_html__( 'Enable', 'manual' ),
					'off' => esc_html__( 'Disable', 'manual' ),
				),
				array(
					'id'       => 'wedocs-breadcrumbs-on-page',
					'type'     => 'switch',
					'title'    => esc_html__('Breadcrumbs', 'manual'),
					'subtitle'    => esc_html__( 'Show breadcrumbs above the content area on the single article pages', 'manual' ),
					'default'  => true,
					'on' => esc_html__( 'Enable', 'manual' ),
					'off' => esc_html__( 'Disable', 'manual' ),
				),
				array(
					'id'      => 'wedocs_page_content_padding_top',
					'type'    => 'spacing',
					'mode'    => 'padding',
					'bottom'  => false,
					'left'    => false,
					'right'   => false,
					'output'  => array('.wedocs-content-wrap'),
					'title'   => esc_html__( 'Content area top padding', 'manual' ),
					'subtitle'    => esc_html__( 'Adjust top padding for the content area', 'manual' ),
					'desc'     => 'Default: 0px',
					'default'            => array(
						'padding-top'     => '0px', 
					)
				),
				array(
					'id'       => 'wedocs_page_left_right_sidebar_padding_top',
					'type'    => 'spacing',
					'mode'    => 'padding',
					'bottom'  => false,
					'left'    => false,
					'right'   => false,
					'title'    => esc_html__( 'Right/Left sidebar padding top', 'manual' ),
					'subtitle'    => esc_html__( 'Adjust padding top', 'manual' ),
					'desc'     => 'Default: 33px',
					'default'            => array(
						'padding-top'     => '33px', 
					)
				),
				array(
					'id'       => 'wedocs-toc-settings',
					'type'     => 'switch',
					'title'    => esc_html__('TOC (Table of contents)', 'manual'),
					'subtitle'    => esc_html__( 'Show the Table of Contents (TOC) for the post on the right sidebar', 'manual' ),
					'default'  => true,
					'on' => esc_html__( 'Enable', 'manual' ),
					'off' => esc_html__( 'Disable', 'manual' ),
				),
				array(
					'id'       => 'wedocs-sidebar-menu-settings',
					'type'     => 'section',
					'title'    => esc_html__( 'Sidebar Menu', 'manual' ),
					'indent'   => true, 
				),
				array(
					'id'       => 'wedocs-page-sidebar-article-icon-color-replace',
					'type'     => 'switch',
					'title'    => esc_html__('Menu root icon color', 'manual'),
					'subtitle'    => esc_html__( 'Enable/Disable color of the icon for the root article in the menu', 'manual' ),
					'default'  => false,
					'on' => esc_html__( 'Enable', 'manual' ),
					'off' => esc_html__( 'Disable', 'manual' ),
				),
				array(
					'id'       => 'wedocs-page-sidebar-article-icon-color',
					'type'     => 'color',
					'title'    => esc_html__( 'Color', 'manual' ),
					'subtitle'    => esc_html__( 'Color of the icon for the root article in the menu', 'manual' ),
					'transparent' => false,
					'default'  => '',
					'output'    => array('.wedocs-single-wrap .wedocs-sidebar ul.doc-nav-list > li > a:before, .wedocs-single-wrap .wedocs-sidebar ul.doc-nav-list > li.current_page_item > a:before'),
					'required' => array('wedocs-page-sidebar-article-icon-color-replace','equals','1'), 
					'class' => 'theme-option-text-align-right',
				),
				array(
					'id'       => 'wedocs-root-article-name',
					'type'     => 'switch',
					'title'    => esc_html__('Root article name', 'manual'),
					'subtitle'    => esc_html__( 'Show the root article name above the menu sidebar', 'manual' ),
					'default'  => true,
					'on' => esc_html__( 'Enable', 'manual' ),
					'off' => esc_html__( 'Disable', 'manual' ),
				),
				array(
					'id'       => 'wedocs-root-article-name-typography-body',
					'type'     => 'typography',
					'title'    => esc_html__( 'Typography', 'manual' ),
					'subtitle' => esc_html__('Set root article typography', 'manual' ),
					'google'   => true,
					'text-align' => false,
					'font-style' => false,
					'letter-spacing' => true,
					'text-transform' => true,
					'subsets' => false,
					'font-backup' => true,
					'word-spacing' => true,
					'units'  => '',
					'required' => array('wedocs-root-article-name','equals','1'),  
					'output'   => array('.wedocs-sidebar.wedocs-hide-mobile h3.widget-title, .wedocs-siderbar-doc-title'),
					'class' => 'theme-option-text-align-right',
					'default'   => array(
						'color'  => '#1e73be', 
						'font-size'  => '14px', 
						'line-height'  => '14px', 
						'font-family'  => 'Plus Jakarta Sans', 
						'font-weight' => '800', 
						'text-transform' => 'uppercase'
					),
				),
				array(
					'id'          => 'wedocs-page-sidebar-menu',
					'type'        => 'typography',
					'title'       => esc_html__( 'Inner article', 'manual' ),
					'subtitle'    => esc_html__( 'Change the way the text looks in the sidebar menu if needed', 'manual' ),
					'output'      => array('.wedocs-sidebar ul.doc-nav-list'),
					'google'      => false,
					'font-weight' => false,
					'font-style' => false,
					'font-family' => false,
					'font-backup' => false,
					'text-align'  => false,
					'text-transform' => true,
					'subsets'        => false, 
					'color'          => false, 
					'text-transform'  => false, 
					'letter-spacing' => true,  
					'all_styles'  => false,
					'word-spacing' => true,
					'units'        => 'px',
				),
				array(
					'id'       => 'wedocs_page_sidebar_menu_a_tag_link_color',
					'type'     => 'link_color',
					'title'    => esc_html__( 'Anchor tag', 'manual' ),
					'subtitle'  => esc_html__('Color of the anchor "a" tag.', 'manual'),
					'active'    => false, 
					'visited'   => false, 
				),
				array(
					'id'       => 'wedocs-menu-root-article-typography',
					'type'     => 'typography',
					'title'    => esc_html__( 'Menu root article typography', 'manual' ),
					'subtitle' => esc_html__('Adjust root menu article typography if necessary', 'manual' ),
					'google'   => true,
					'text-align' => false,
					'font-style' => false,
					'letter-spacing' => true,
					'text-transform' => true,
					'subsets' => false,
					'font-backup' => true,
					'word-spacing' => true,
					'units'  => '',
					'output'   => array('.wedocs-single-wrap .wedocs-sidebar ul.doc-nav-list > li.page_item_has_children > a'),
					'default'   => array(
						'font-size'  => '14px', 
						'line-height'  => '26px', 
						'font-family'  => 'Plus Jakarta Sans', 
						'font-weight' => '800', 
						'text-transform' => 'uppercase'
					),
				),
		
		)
	) );
	
	Redux::setSection( $opt_name, array(
			'title'            => esc_html__( 'Custom \'Page Title Bar\' - Single Page', 'manual' ),
			'id'               => 'wedocs_custom_singlepg_header',
			'subsection'       => true,
			'customizer_width' => '450px',
			'fields'           => array(
			
								array(
									'id'       => 'wedocs_header_menu',
									'type'     => 'switch',
									'title'    => esc_html__( 'Customize the header menu', 'manual' ),
									'subtitle' => esc_html__('Modify the main header, including the logo and menu colors, if needed.', 'manual'),
									'default'  => false,
								),
								array(
									'id'       => 'wedocs_header_background_colorbg',
									'type'     => 'color_rgba',
									'title'    => esc_html__( 'Background color', 'manual' ),
									'subtitle'    => esc_html__( 'Set the header background.', 'manual' ),
									'output'    => array('background' => '.navbar-inverse.theme-wedocs-singlepg'),
									'required' => array('wedocs_header_menu','equals','1'),
									'class' => 'theme-option-text-align-right',			
								),
								array(
									'id'       => 'wedocs_header_first_level_menu_text_color',
									'type'     => 'link_color',
									'title'    => esc_html__( 'Menu link color', 'manual' ),
									'subtitle' => esc_html__('Text color for the first level of the navigation menu.', 'manual'),
									'active'    => false, 
									'visited'   => false,
									'output'    => array('.navbar-inverse.theme-wedocs-singlepg .navbar-nav>li>a'), 
									'required' => array('wedocs_header_menu','equals','1'),
									'class' => 'theme-option-text-align-right',
								),
								array(
									'id'       => 'wedocs_header_flip_logo',
									'type'     => 'switch',
									'title'    => esc_html__( 'Flip logo', 'manual' ),
									'subtitle' => esc_html__('Switch from the \'primary logo\' to the \'secondary logo,\' if necessary.', 'manual'),
									'default'  => false,
									'class' => 'theme-option-text-align-right',
									'required' => array('wedocs_header_menu','equals','1'),
								),
								array(
									'id'       => 'wedocs_header_shadow',
									'type'     => 'switch',
									'title'    => esc_html__('Header shadow', 'manual' ),
									'desc' => esc_html__('Please note that this function is effective only when the header shadow is enabled in the \'Header Menu > Main Header\' settings.', 'manual'),
									'subtitle' => esc_html__('Turn the default header shadow on or off.', 'manual'),
									'default'  => false,
									'class' => 'theme-option-text-align-right',
									'required' => array('wedocs_header_menu','equals','1'),
								),
								array(
									'id'       => 'wedocs_header_menu_border_btm',
									'type'     => 'border',
									'title'    => esc_html__( 'Header border bottom', 'manual' ),
									'subtitle' => esc_html__('Re-adjust header border bottom', 'manual'),
									'color_alpha'  => true,
									'left'  => false,
									'right'  => false,
									'top'  => false,
									'class' => 'theme-option-text-align-right',
									'required' => array('wedocs_header_menu','equals','1'),
									'output'    => array('.navbar.theme-wedocs-singlepg'),
								),
								array(
									'id'       => 'wedocs_header_menu_border_top',
									'type'     => 'border',
									'title'    => esc_html__( 'Header border top', 'manual' ),
									'subtitle' => esc_html__('Re-adjust header border top', 'manual'),
									'desc' => esc_html__('If \'Menu position\' is set to \'Logo on Top\' and \'Menu Below Logo\' in \'Theme > Options > Header Menu > Main Header\', then this feature will work properly.', 'manual'),
									'color_alpha'  => true,
									'left'  => false,
									'right'  => false,
									'bottom'  => false,
									'required' => array('wedocs_header_menu','equals','1'),
									'class' => 'theme-option-text-align-right',
									'output'    => array('.navbar.theme-wedocs-singlepg .navbar-collapse.collapse'),
								),
								array(
									'id'       => 'docs_headermenu_hamburger_searchbox',
									'type'     => 'switch',
									'title'    => esc_html__( 'Hide the search box in the Hamburger menu.', 'manual' ),
									'desc' => esc_html__('This feature will only function if enabled \'Search Box in Hamburger Menu\' in the \'Theme Options\' under \'Header Menu\' in the \'Main Header\' section.', 'manual'),
									'default'  => false,
									'required' => array('wedocs_header_menu','equals','1'),
									'on' => esc_html__( 'Hide', 'manual' ),
									'off' => esc_html__( 'Theme Default', 'manual' ),
									'class' => 'theme-option-text-align-right',
								),
								array(
									'id'       => 'onoff-wedocs-single-page-title-bar',
									'type'     => 'switch',
									'title'    => esc_html__('Page title bar', 'manual' ),
									'subtitle' => esc_html__('Enable/Disable page title bar', 'manual' ),
									'desc' => __('Note: Disabling the page title bar will change the menu style to the default setting, meaning that no transparent menu style will be used.', 'manual'),
									'default'  => true,
									'on'       => esc_html__( 'Enable', 'manual' ),
									'off'      => esc_html__( 'Disable', 'manual' ),
								),
								// -------------- Page Title Bar Controls --------------
								array(
									'id'       => 'wedocs-single-page-title-bar-controls',
									'type'     => 'section',
									'title'    => esc_html__( 'Page Title Bar', 'manual' ),
									'indent'   => true, 
									'required' => array('onoff-wedocs-single-page-title-bar','equals','1'),  
								),
								array(
									'id'       => 'wedocs-header-height',
									'type'     => 'text',
									'title'    => esc_html__( 'Page title bar :: padding', 'manual' ),
									'subtitle'    => esc_html__( 'Re-adjust the space above and below the \'Page Title Bar\' on your wedocs page.', 'manual' ),
									'desc' => __('Example: 32px 0px 32px 0px (top, right, bottom, left) <br><br><strong style="color:#e6614b;">IMPORTANT: Make sure the value of RIGHT, LEFT is always 0px</strong>', 'manual' ),
									'default'  => '',
								),
								array(
									'id'       => 'wedocs-responsive-header-height',
									'type'     => 'text',
									'title'    => esc_html__( 'Page title bar :: Responsive padding', 'manual' ),
									'subtitle' => esc_html__( 'Re-adjust the top/bottom spacing for page title bar', 'manual' ),
									'desc'     => __( 'Example: 100px 0px 100px 0px (top, right, bottom, left) <br><br><strong style="color:#e6614b;">IMPORTANT: Make sure the value of RIGHT, LEFT is always 0px</strong>', 'manual' ), 
									'default'  => '',
								),
								array(
									'id'       => 'wedocs-single-pg-title-text-status',
									'type'     => 'switch',
									'title'    => esc_html__( 'Title name', 'manual' ),
									'default'  => false,
									'subtitle' => esc_html__( 'Display title name', 'manual' ),
									'on' => esc_html__( 'Disable', 'manual' ),
									'off' => esc_html__( 'Enable', 'manual' ),
								),
								array(
									'id'       => 'wedocs_pagetitlebar_text_typography',
									'type'        => 'typography',
									'title'    => esc_html__( 'Title typography', 'manual' ),
									'subtitle' => esc_html__( 'Customize title text.', 'manual' ),
									'output'    => array('.noise-break.theme-wedocs-singlepg h1.custom_h1_head'),
									'required' => array('wedocs-single-pg-title-text-status','equals','0'),
									'google'      => true,
									'font-backup' => false,
									'text-align' => false,
									'text-transform' => true,
									'subsets'       => false, 
									'letter-spacing'=> true,  
									'all_styles'  => true,
									'font-backup' => true,
									'word-spacing' => true,
									'margin-top' => true,
									'margin-bottom' => true,
									'units'       => 'px',
									'class' => 'theme-option-text-align-right',
								),
								array(
									'id'       => 'wedocs-text-align',
									'type'     => 'select',
									'title'    => esc_html__( 'Text align', 'manual' ),
									'subtitle'    => esc_html__( 'Adjust the alignment of the text on the \'page title bar\'', 'manual' ),
									'options'  => array(
										'center' => esc_html__('Center','manual' ),
										'left' => esc_html__('Left','manual' ),
										'right' => esc_html__('Right','manual' ),
									),
									'default'  => 'center',
								),
								array(
									'id'       => 'wedocs-single-pg-header-search-status',
									'type'     => 'switch',
									'title'    => esc_html__( 'Search box', 'manual' ),
									'default'  => false,
									'subtitle' => esc_html__( 'Choose to show or hide the search box in the specified \'page title bar\' area.', 'manual' ),
									'on' => esc_html__( 'Disable', 'manual' ),
									'off' => esc_html__( 'Enable', 'manual' ),
								),
								array(
									'id'       => 'wedocs-searchbox-display-position',
									'type'     => 'select',
									'title'    => esc_html__( 'Search box position', 'manual' ),
									'subtitle'    => esc_html__( 'Choose where to place the search box on the \'page title bar\'.', 'manual' ),
									'options'  => array(
										'center' => esc_html__('Exact Center', 'manual' ),
										'6' => esc_html__('50% Width', 'manual' ),
										'7' => esc_html__('58% Width', 'manual' ),
										'8' => esc_html__('66% Width', 'manual' ),
										'9' => esc_html__('75% Width', 'manual' ),
										'10' => esc_html__('83% Width', 'manual' ),
										'11' => esc_html__('91% Width', 'manual' ),
										'12' => esc_html__('100% Width', 'manual' ),
									),
									'default'  => 'center',
									'required' => array('wedocs-single-pg-header-search-status','equals','0'),
									'class'  => 'theme-option-text-align-right',
								),
								array(
									'id'       => 'wedocs-page-searchbox-treanding-search-color',
									'type'     => 'color',
									'transparent'   => false,
									'title'    => esc_html__( 'Title text color', 'manual' ),
									'subtitle'    => esc_html__( 'Trending search text title color', 'manual' ),
									'required' => array('wedocs-single-pg-header-search-status','equals','0'),
									'output'    => array('.noise-break.theme-wedocs-singlepg .trending-search span.popular-keyword-title'),
									'class' => 'theme-option-text-align-right',
								),
								array(
									'id'       => 'wedocs-page-searchbox-treanding-search-link-color',
									'type'     => 'link_color',
									'title'    => esc_html__( 'Link color', 'manual' ),
									'subtitle'    => esc_html__( 'The trending keyword link color', 'manual' ),
									'active'    => false, 
									'visited'   => false,
									'required' => array('wedocs-single-pg-header-search-status','equals','0'),
									'output'    => array('.noise-break.theme-wedocs-singlepg .trending-search a.trending-search-popular-keyword'),  
									'class' => 'theme-option-text-align-right',
								),
								array(
									'id'       => 'wedocs-single-pg-header-breadcrumb-status',
									'type'     => 'switch',
									'title'    => esc_html__( 'Breadcrumb', 'manual' ),
									'default'  => false,
									'subtitle' => esc_html__( 'Choose to show or hide the breadcrumb in the specified \'page title bar\' area.', 'manual' ),
									'on' => esc_html__( 'Disable', 'manual' ),
									'off' => esc_html__( 'Enable', 'manual' ),
								),
								array(
									'id'       => 'wedocs_pagetitlebar_breadcrumb_regular_text_color',
									'type'     => 'color_rgba',
									'title'    => esc_html__( 'Regular text color', 'manual' ),
									'subtitle' => esc_html__('Breadcrumb regular text color.', 'manual'),
									'required' => array('wedocs-single-pg-header-breadcrumb-status','equals','0'),
									'output'    => array('.noise-break.theme-wedocs-singlepg ol.wedocs-breadcrumb span.current'),
									'class' => 'theme-option-text-align-right',
								),
								array(
									'id'       => 'wedocs_pagetitlebar_breadcrumb_link_color',
									'type'     => 'link_color',
									'title'    => esc_html__( 'Link color', 'manual' ),
									'subtitle' => esc_html__('Adjust the color of breadcrumb links if needed.', 'manual'),
									'required' => array('wedocs-single-pg-header-breadcrumb-status','equals','0'),
									'output'    => array('.noise-break.theme-wedocs-singlepg ol.wedocs-breadcrumb a'),
									'active'  => false,
									'class' => 'theme-option-text-align-right',
								),
								array(
									'id'       => 'wedocs_pagetitlebar_breadcrumb_link_seprator_color',
									'type'     => 'color_rgba',
									'title'    => esc_html__( 'Link seprator color', 'manual' ),
									'subtitle' => esc_html__('Adjust the color of breadcrumb link seprators if needed.', 'manual'),
									'required' => array('wedocs-single-pg-header-breadcrumb-status','equals','0'),
									'output'    => array('.noise-break.theme-wedocs-singlepg ol.wedocs-breadcrumb i.wedocs-icon:before'),
									'class' => 'theme-option-text-align-right',
								),
								array(
									'id'       => 'wedocs_pagetitlebar_background_setup',
									'type' => 'background',
									'title'    => esc_html__( 'Background', 'manual' ),
									'subtitle' => esc_html__( 'Create the background for your wedocs page.', 'manual' ),
								),
								array(
									'id'       => 'wedocs_pagetitlebar_image_overlay',
									'type'     => 'color_rgba',
									'title'    => esc_html__( 'Background overlay', 'manual' ),
									'subtitle'    => esc_html__( 'Select the background overlay for your forum page title bar.', 'manual' ),
									'output'    => array('background' => '.noise-break.theme-wedocs-singlepg .page_opacity.header_custom_height_new'),
									'class' => 'theme-option-text-align-right',
								),	
			
			)
			) );
}
		
		
/*************************************
*******  404 Page Content  *****
**************************************/
	Redux::setSection( $opt_name, array(
        'title'            => esc_html__( '404 Page', 'manual' ),
        'id'               => '404-pagecontent',
        'customizer_width' => '450px',
		'icon'             => 'el el-error',
        'fields'           => array(
									
					array(
						'id'       => '404page_header_menu',
						'type'     => 'switch',
						'title'    => esc_html__( 'Customize the header menu', 'manual' ),
						'subtitle' => esc_html__('Modify the main header, including the logo and menu colors, if needed.', 'manual'),
						'default'  => false,
					),
					array(
						'id'       => '404page_header_background_colorbg',
						'type'     => 'color_rgba',
						'title'    => esc_html__( 'Background color', 'manual' ),
						'subtitle'    => esc_html__( 'Set the header background.', 'manual' ),
						'output'    => array('background' => '.navbar-inverse.error-fourzero-page'),
						'required' => array('404page_header_menu','equals','1'),
						'class' => 'theme-option-text-align-right',			
					),
					array(
						'id'       => '404page_header_first_level_menu_text_color',
						'type'     => 'link_color',
						'title'    => esc_html__( 'Menu link color', 'manual' ),
						'subtitle' => esc_html__('Text color for the first level of the navigation menu.', 'manual'),
						'active'    => false, 
						'visited'   => false,
						'output'    => array('.navbar-inverse.error-fourzero-page .navbar-nav>li>a'), 
						'required' => array('404page_header_menu','equals','1'),
						'class' => 'theme-option-text-align-right',
					),
					array(
						'id'       => '404page_header_flip_logo',
						'type'     => 'switch',
						'title'    => esc_html__( 'Flip logo', 'manual' ),
						'subtitle' => esc_html__('Switch from the \'primary logo\' to the \'secondary logo,\' if necessary.', 'manual'),
						'default'  => false,
						'class' => 'theme-option-text-align-right',
						'required' => array('404page_header_menu','equals','1'),
					),
					array(
						'id'       => '404page_header_shadow',
						'type'     => 'switch',
						'title'    => esc_html__('Header shadow', 'manual' ),
						'desc' => esc_html__('Please note that this function is effective only when the header shadow is enabled in the \'Header Menu > Main Header\' settings.', 'manual'),
						'subtitle' => esc_html__('Turn the default header shadow on or off.', 'manual'),
						'default'  => false,
						'class' => 'theme-option-text-align-right',
						'required' => array('404page_header_menu','equals','1'),
					),
					array(
						'id'       => '404page_header_menu_border_btm',
						'type'     => 'border',
						'title'    => esc_html__( 'Header border bottom', 'manual' ),
						'subtitle' => esc_html__('Re-adjust header border bottom', 'manual'),
						'color_alpha'  => true,
						'left'  => false,
						'right'  => false,
						'top'  => false,
						'class' => 'theme-option-text-align-right',
						'required' => array('404page_header_menu','equals','1'),
						'output'    => array('.navbar.error-fourzero-page'),
					),
					array(
						'id'       => '404page_header_menu_border_top',
						'type'     => 'border',
						'title'    => esc_html__( 'Header border top', 'manual' ),
						'subtitle' => esc_html__('Re-adjust header border top', 'manual'),
						'desc' => esc_html__('If \'Menu position\' is set to \'Logo on Top\' and \'Menu Below Logo\' in \'Theme > Options > Header Menu > Main Header\', then this feature will work properly.', 'manual'),
						'color_alpha'  => true,
						'left'  => false,
						'right'  => false,
						'bottom'  => false,
						'required' => array('404page_header_menu','equals','1'),
						'class' => 'theme-option-text-align-right',
						'output'    => array('.navbar.error-fourzero-page .navbar-collapse.collapse'),
					),
					array(
						'id'       => '404page_header_menu_hamburger_search_box',
						'type'     => 'switch',
						'title'    => esc_html__( 'Hide the search box in the Hamburger menu.', 'manual' ),
						'desc' => esc_html__('This feature will only function if enabled \'Search Box in Hamburger Menu\' in the \'Theme Options\' under \'Header Menu\' in the \'Main Header\' section.', 'manual'),
						'default'  => false,
						'required' => array('404page_header_menu','equals','1'),
						'on' => esc_html__( 'Hide', 'manual' ),
						'off' => esc_html__( 'Theme Default', 'manual' ),
						'class' => 'theme-option-text-align-right',
					),
					array(
						'id'       => 'onoff-404-page-hrader',
						'type'     => 'switch',
						'title'    => esc_html__( 'Page title bar', 'manual' ),
						'subtitle' => esc_html__('Enable/Disable page title bar', 'manual'),
						'default'  => false,
						'on'       => esc_html__( 'Enable', 'manual' ),
						'off'      => esc_html__( 'Disable', 'manual' ),
						'desc' => __('Note: Disabling the page title bar will change the menu style to the default setting, meaning that no transparent menu style will be used.', 'manual'),
					),
					array(
						'id'       => '404-title-bar-header',
						'type'     => 'section',
						'title'    => esc_html__( 'Page Title Bar', 'manual' ),
						'indent'   => true, 
						'required' => array('onoff-404-page-hrader','equals','1'),
					),
					array(
						'id'       => '404-header-height',
						'type'     => 'text',
						'title'    => esc_html__( 'Page title bar :: padding', 'manual' ),
						'subtitle' => esc_html__( 'Re-adjust the space above and below the \'Page Title Bar\' on your 404 page.', 'manual' ),
						'desc'     => __('Example: 135px 0px 135px 0px (top, right, bottom, left) <br><br><strong style="color:#e6614b;">IMPORTANT: Make sure the value of RIGHT, LEFT is always 0px</strong>', 'manual' ),
						'default'  => '',
					),
					array(
						'id'       => '404-responsive-header-height',
						'type'     => 'text',
						'title'    => esc_html__( 'Page title bar :: Responsive padding', 'manual' ),
						'subtitle' => esc_html__( 'Re-adjust the top/bottom spacing for page title bar', 'manual' ), 
						'desc'     => __('Example: 100px 0px 100px 0px (top, right, bottom, left) <br><br><strong style="color:#e6614b;">IMPORTANT: Make sure the value of RIGHT, LEFT is always 0px</strong>', 'manual' ),
						'default'  => '',
					),
					array(
						'id'       => 'home-404-main-title',
						'type'     => 'text',
						'title'    => esc_html__( 'Custom title', 'manual' ),
						'subtitle' => esc_html__( 'Special heading for the 404 error page.', 'manual' ),
						'default'  => '404 - Page NOT Found',
					),
					array(
						'id'       => '404_pagetitlebar_text_typography',
						'type'     => 'typography',
						'title'    => esc_html__( 'Title typography', 'manual' ),
						'subtitle' => esc_html__( 'Customize title text.', 'manual' ),
						'output'    => array('.noise-break.error-fourzero-page h1.custom_h1_head'),
						'google'      => true,
						'font-backup' => false,
						'text-align' => false,
						'text-transform' => true,
						'subsets'       => false, 
						'letter-spacing'=> true,  
						'all_styles'  => true,
						'font-backup' => true,
						'word-spacing' => true,
						'margin-top' => true,
						'margin-bottom' => true,
						'units'       => 'px',
						'class' => 'theme-option-text-align-right',
					),
					array(
						'id'       => '404-header-text-align',
						'type'     => 'select',
						'title'    => esc_html__( 'Text align', 'manual' ),
						'subtitle'    => esc_html__( 'Adjust the alignment of the text on the \'page title bar\'.', 'manual' ),
						'options'  => array(
										'left' => esc_html__('Left', 'manual' ),
										'center' => esc_html__('Center', 'manual' ),
										'right' => esc_html__('Right', 'manual' ),
						),
						'default'  => 'center'
					),
					array(
						'id'       => 'home-404-search-bar-status',
						'type'     => 'switch',
						'title'    => esc_html__( 'Search box', 'manual' ),
						'subtitle' => esc_html__('Choose to show or hide the search box in the specified \'page title bar\' area.', 'manual'),
						'default'  => true,
						'on'       => esc_html__( 'Disable', 'manual' ),
						'off'      => esc_html__( 'Enable', 'manual' ),
					),
					array(
						'id'       => 'home-404-searchbox-display-position',
						'type'     => 'select',
						'title'    => esc_html__( 'Search box position', 'manual' ),
						'subtitle'    => esc_html__( 'Choose where to place the search box on the \'page title bar\'.', 'manual' ),
						'options'  => array(
							'center' => esc_html__('Exact Center','manual' ),
							'6' => esc_html__('50% Width','manual' ),
							'7' => esc_html__('58% Width','manual' ),
							'8' => esc_html__('66% Width','manual' ),
							'9' => esc_html__('75% Width','manual' ),
							'10' => esc_html__('83% Width','manual' ),
							'11' => esc_html__('91% Width','manual' ),
							'12' => esc_html__('100% Width','manual' ),
						),
						'default'  => 'center',
						'required' => array('home-404-search-bar-status','equals','0'),
						'class' => 'theme-option-text-align-right',
					),
					array(
						'id'       => '404-page-searchbox-treanding-search-color',
						'type'     => 'color',
						'transparent'   => false,
						'title'    => esc_html__( 'Title text color', 'manual' ),
						'subtitle'    => esc_html__( 'Trending search text title color', 'manual' ),
						'required' => array('home-404-search-bar-status','equals','0'),
						'output'    => array('.noise-break.error-fourzero-page .trending-search span.popular-keyword-title'),
						'class' => 'theme-option-text-align-right',
					),
					array(
						'id'       => '404-page-searchbox-treanding-search-link-color',
						'type'     => 'link_color',
						'title'    => esc_html__( 'Link color', 'manual' ),
						'subtitle'    => esc_html__( 'The trending keyword link color', 'manual' ),
						'active'    => false, 
						'visited'   => false,
						'required' => array('home-404-search-bar-status','equals','0'),
						'output'    => array('.noise-break.error-fourzero-page .trending-search a.trending-search-popular-keyword'),  
						'class' => 'theme-option-text-align-right',
					),
					array(
						'id'       => '404page-title-bar-background-setup',
						'type' => 'background',
						'title'    => esc_html__( 'Background', 'manual' ),
						'subtitle' => esc_html__( 'Create the background for your 404 page.', 'manual' ),
					),
					array(
						'id'       => '404page-title-bar-image-overlay',
						'type'     => 'color_rgba',
						'title'    => esc_html__( 'Background overlay', 'manual' ),
						'subtitle'    => esc_html__( 'Select the background overlay for your 404 page title bar.', 'manual' ),
						'output'    => array('background' => '.noise-break.error-fourzero-page .page_opacity.header_custom_height_new'),
						'class' => 'theme-option-text-align-right',
					),
					// Content configuration.
					array(
						'id'       => '404page-content-configuration',
						'type'     => 'section',
						'title'    => esc_html__( 'Content Configuration', 'manual' ),
						'indent'   => true, 
					),
					array(
						'id'       => '404-disable-page-contnet',
						'type'     => 'switch',
						'title'    => esc_html__( '404 content', 'manual' ),
						'subtitle'    => esc_html__( 'Display or hide the 404 content.', 'manual' ),
						'default'  => true,
						'on' => esc_html__( 'Enable', 'manual' ),
						'off' => esc_html__( 'Disable', 'manual' ),
					),
					array(
						'id'       => '404-disable-page-search',
						'type'     => 'switch',
						'title'    => esc_html__( 'Search box', 'manual' ),
						'subtitle'    => esc_html__( 'Show the search box within the page content.', 'manual' ),
						'default'  => true,
						'on' => esc_html__( 'Enable', 'manual' ),
						'off' => esc_html__( 'Disable', 'manual' ),
						'required' => array('404-disable-page-contnet','equals','1'),
						'class' => 'theme-option-text-align-right',	
					),
					array(
						'id'       => '404-pagetitme',
						'type'     => 'text',
						'title'    => esc_html__( 'Title', 'manual' ),
						'subtitle'    => esc_html__( 'Title text for the main content.', 'manual' ),
						'default'  => '404',
						'required' => array('404-disable-page-contnet','equals','1'),
						'class' => 'theme-option-text-align-right',	
					),
					array(
						'id'       => '404-sustitle',
						'type'     => 'text',
						'title'    => esc_html__( 'Sub-title', 'manual' ),
						'subtitle'    => esc_html__( 'The text below the main title.', 'manual' ),
						'default'  => esc_html__('Uh-oh! We couldn\'t find that page.','manual' ),
						'required' => array('404-disable-page-contnet','equals','1'),
						'class' => 'theme-option-text-align-right',	
					),
					array(
						'id'       => '404-contenttext',
						'type'     => 'text',
						'title'    => esc_html__( 'Description', 'manual' ),
						'subtitle'    => esc_html__( 'Brief message.', 'manual' ),
						'default'  => esc_html__('The link is broken, or the page has been removed. Please try searching our site.','manual' ),
						'required' => array('404-disable-page-contnet','equals','1'),
						'class' => 'theme-option-text-align-right',	
					),
					array(
						'id'       => '404page-pagetitle-typography',
						'type'        => 'typography',
						'title'    => esc_html__( 'Title typography', 'manual' ),
						'subtitle' => esc_html__( 'Customize main title text.', 'manual' ),
						'output'    => array('.page404_wrap h1'),
						'required' => array('404-disable-page-contnet','equals','1'),
						'class' => 'theme-option-text-align-right',	
						'google'      => true,
						'font-backup' => false,
						'text-align' => false,
						'text-transform' => true,
						'subsets'       => false, 
						'letter-spacing'=> true,  
						'all_styles'  => true,
						'font-backup' => true,
						'word-spacing' => true,
						'margin-top' => true,
						'margin-bottom' => true,
						'units'       => 'px',
						'default'  => array(
							'color'       => '#002e5b', 
							'font-weight'  => '700', 
							'font-family' => 'Dosis', 
							'google'      => true,
							'font-size'   => '180px', 
							'line-height' => '170px'
						),
					),
					array(
						'id'       => '404page-pagesubtitle-typography',
						'type'        => 'typography',
						'title'    => esc_html__( 'Sub-title typography', 'manual' ),
						'subtitle' => esc_html__( 'Customize subtitle text.', 'manual' ),
						'output'    => array('.page404_wrap h3'),
						'required' => array('404-disable-page-contnet','equals','1'),
						'class' => 'theme-option-text-align-right',	
						'google'      => true,
						'font-backup' => false,
						'text-align' => false,
						'text-transform' => true,
						'subsets'       => false, 
						'letter-spacing'=> true,  
						'all_styles'  => true,
						'font-backup' => true,
						'word-spacing' => true,
						'margin-top' => true,
						'margin-bottom' => true,
						'units'       => 'px',
						'default'  => array(
							'color'       => '#363d40', 
						),
					),
					array(
						'id'       => '404page-desc-typography',
						'type'     => 'typography',
						'title'    => esc_html__( 'Description typography', 'manual' ),
						'subtitle' => esc_html__( 'Customize description text.', 'manual' ),
						'output'    => array('.page404_wrap p.desc'),
						'required' => array('404-disable-page-contnet','equals','1'),
						'class' => 'theme-option-text-align-right',	
						'google'      => true,
						'font-backup' => false,
						'text-align' => false,
						'text-transform' => true,
						'subsets'       => false, 
						'letter-spacing'=> true,  
						'all_styles'  => true,
						'font-backup' => true,
						'word-spacing' => true,
						'margin-top' => true,
						'margin-bottom' => true,
						'units'       => 'px',
						'default'  => array(
							'color' => '#002e5b', 
						),
					),
					array(
						'id'       => '404page-background-setup',
						'type' => 'background',
						'title'    => esc_html__( 'Background', 'manual' ),
						'subtitle' => esc_html__( 'Create the background for your 404 page.', 'manual' ),
						'output'   => array('.page404_wrap'), 
						'required' => array('404-disable-page-contnet','equals','1'),
						'class' => 'theme-option-text-align-right',	
						'default'  => array(
										'background-color' => '#f2f2f2',
									)
					),
					array(
						'id'       => '404page-background-overlay-color',
						'type'      => 'color_rgba',
						'title'    => esc_html__( 'Background overlay', 'manual' ),
						'subtitle' => esc_html__( 'Select the background overlay for your 404 page.', 'manual' ),
						'output'    => array('background' => '.page404_wrap .page404_wrap_overlay'),
						'required' => array('404-disable-page-contnet','equals','1'),
						'class' => 'theme-option-text-align-right',	
					),
		)
	) );		
		

/*************************************
*******  Theme Default Login  *****
**************************************/
	Redux::setSection( $opt_name, array(
			'title'            => esc_html__( 'Theme Default Login Form', 'manual' ),
			'id'               => 'theme_login_setup_section',
			'customizer_width' => '400px',
			'icon'             => 'el el-lock',
			 'fields'           => array(
			 							array(
											'id'       => 'login_box_label_username',
											'type'     => 'text',
											'title'    => esc_html__( 'Text label for Username or Email', 'manual' ),
											'default'  => 'Username or Email Address',
											'subtitle' => esc_html__('Text label for entering Username or Email Address', 'manual'),
										),
										array(
											'id'       => 'login_box_label_password',
											'type'     => 'text',
											'title'    => esc_html__( 'Text label for password', 'manual' ),
											'default'  => 'Password',
											'subtitle' => esc_html__('Text label for entering password', 'manual'),
										),
										array(
											'id'       => 'login_box_label_remember',
											'type'     => 'text',
											'title'    => esc_html__( 'Text label for remember', 'manual' ),
											'default'  => 'Remember Me',
											'subtitle' => esc_html__('Text label for remember checkbox', 'manual'),
										),
										array(
											'id'       => 'login_box_label_log_in',
											'type'     => 'text',
											'title'    => esc_html__( 'Text label for Log In', 'manual' ),
											'default'  => 'Log In',
											'subtitle' => esc_html__('Text label for log in button', 'manual'),
										),
										array(
											'id'       => 'login_box_lostpwd_text',
											'type'     => 'text',
											'title'    => esc_html__( 'Text for forgot password Link', 'manual' ),
											'default'  => 'Lost Password',
											'subtitle' => esc_html__('Text that appears on the login box for the forgot password link', 'manual'),
										),
										array(
											'id'       => 'login_box_lostpwd_linkurl',
											'type'     => 'text',
											'subtitle'    => esc_html__( 'Custom password reset link', 'manual' ),
											'default'  => '',
											'title' => esc_html__('Forgotten password recovery custom link URL', 'manual'),
											'class' => 'theme-option-text-align-right',
										),
										array(
											'id'       => 'login_box_register_text',
											'type'     => 'text',
											'title'    => esc_html__( ' Text for forgot \'register now\' Link', 'manual' ),
											'default'  => 'Register now',
											'subtitle' => esc_html__('Text that appears on the login box for the Register now link', 'manual'),
										),
										array(
											'id'       => 'login_box_register_text_before',
											'type'     => 'text',
											'title'    => esc_html__( ' Text that appear before \'register now\' Link', 'manual' ),
											'default'  => 'Not a member yet?',
											'subtitle' => esc_html__('Text that appears on the login box before the Register now link', 'manual'),
											'class' => 'theme-option-text-align-right',
										),
										array(
											'id'       => 'login_box_register_linkurl',
											'type'     => 'text',
											'subtitle'    => esc_html__( 'Custom Register link', 'manual' ),
											'default'  => '',
											'title' => esc_html__('User registration custom link URL', 'manual'),
											'class' => 'theme-option-text-align-right',
										),
										array(
											'id'       => 'login_box_custom_loginlink',
											'type'     => 'text',
											'subtitle'    => esc_html__( 'Custom Login URL link', 'manual' ),
											'default'  => '',
											'title' => esc_html__('Custom login link URL', 'manual'),
											'desc' => __('<span style="color: #D01B0B">This feature only applies to documentation posts. It shows a login box with just the login link if the article is private.</span>', 'manual'),
										),
					),
	) );
		
		
/**********************************************
*******  //  FORUM SECTION  //     *****
***********************************************/
if ( class_exists( 'bbPress' ) ) {

	Redux::setSection( $opt_name, array(
			'title'            => esc_html__( 'Forum', 'manual' ),
			'id'               => 'theme_bbpress_section',
			'customizer_width' => '400px',
			'icon'             => 'el el-comment-alt'
	) );

	 Redux::setSection( $opt_name, array(
			'title'      => esc_html__( 'Global Settings', 'manual' ),
			'id'         => 'theme-forum-settings',
			'subsection'       => true,
			'fields'     => array(					  
			
           array(
                'id'       => 'manual-forum-yes-no-sidebar',
                'type'     => 'image_select',
                'title'    => esc_html__( 'Sidebar layout', 'manual' ),
                'subtitle' => esc_html__( 'Choose whether to enable or disable a sidebar for the entire forum section.', 'manual' ),
                'options'  => array(
                    '1' => array(
                        'alt' => '1 Column',
                        'img' => ReduxFramework::$_url . 'assets/img/1col.png'
                    ),
                    '2' => array(
                        'alt' => '2 Column Right',
                        'img' => ReduxFramework::$_url . 'assets/img/2cr.png'
                    ),
                    
                ),
                'default'  => '2'
            ),
			array(
                'id'      => 'manual-forum-message',
                'type'    => 'editor',
                'title'   => esc_html__( 'Notification message', 'manual' ),
				'subtitle' => esc_html__( 'The message that will be displayed above the forum section on the default homepage of the forum.', 'manual' ),
                'default' => '',
                'args'    => array(
                    'wpautop'       => false,
                    'media_buttons' => false,
                    'textarea_rows' => 5,
                    'teeny'         => false,
                    'quicktags'     => false,
                )
            ),
			array(
				'id'       => 'bbpress-forum-header-settings',
				'type'     => 'section',
				'title'    => esc_html__( 'Forum Table - Design Control', 'manual' ),
				'subtitle'    => esc_html__( 'Uniform design for the forum table, applied across the board.', 'manual' ),
				'indent'   => true, 
			),
			array(
				'id'      => 'bbpress-forum-header-bar-color-gradient',
				'type'    => 'color_gradient',
				'title'  => esc_html__('Header gradient', 'manual'),
				'subtitle'  => esc_html__('Table header gradient color', 'manual'),
				'output'  => '#bbpress-forums .bbp-forum-header',
				'gradient-type'  => true,
				'gradient-reach' => true,
				'gradient-angle' => true,
				'default'        => array(
									'from' => '#EFEFEF',
									'to'   => '#EFEFEF',
										'gradient-reach' => array(
											'to'   => 50,
											'from' => 0,
										),
									),
			),
			array(
				'id'       => 'bbpress-forum-header-bar-top-border',
				'type'     => 'border',
				'title'    => esc_html__( 'Forum header border', 'manual' ),
				'subtitle'  => esc_html__('Add a color to the top border of the table header.', 'manual'),
				'output'  => '#bbpress-forums .bbp-forums .status-category .bbp-forum-header, #bbpress-forums .bbp-forums > .bbp-forum-header',
				'bottom'  => false,
				'left'  => false,
				'right'  => false,
				'default'  => array(
						'border-color'  => '#47C494', 
						'border-style'  => 'solid', 
						'border-top'    => '1px', 
					),
			),
			array(
				'id'       => 'bbpress-forum-header-spacing',
				'type'     => 'spacing',
				'title'    => esc_html__( 'Header padding', 'manual' ),
				'subtitle'  => esc_html__('Adjust padding for the forum header.', 'manual'),
				'mode'    => 'padding',
				'output'    => array('#bbpress-forums .bbp-forum-header'),
				'default' => array(
							'padding-top'     => '8px', 
							'padding-right'   => '13px', 
							'padding-bottom'  => '8px', 
							'padding-left'    => '13px',
							'units'          => 'px', 
						)
			),
			array(
				'id'       => 'bbpress-forum-header-title-typography',
				'type'        => 'typography',
				'title'    => esc_html__( 'Forum header title typography', 'manual' ),
				'subtitle' => esc_html__( 'Customize header title text.', 'manual' ),
				'output'    => array('#bbpress-forums .bbp-forum-header .bbp-forum-title'),
				'google'      => true,
				'font-backup' => false,
				'text-align' => false,
				'text-transform' => true,
				'subsets'       => false, 
				'letter-spacing'=> true,  
				'all_styles'  => true,
				'font-backup' => true,
				'word-spacing' => true,
				'units'       => 'px',
			),
			array(
				'id'       => 'bbpress-forum-header-desc-typography',
				'type'        => 'typography',
				'title'    => esc_html__( 'Forum header description typography', 'manual' ),
				'subtitle' => esc_html__( 'Customize header description text.', 'manual' ),
				'output'    => array('#bbpress-forums .bbp-forum-header .bbp-forum-content'),
				'google'      => true,
				'font-backup' => false,
				'text-align' => false,
				'text-transform' => true,
				'subsets'       => false, 
				'letter-spacing'=> true,  
				'all_styles'  => true,
				'font-backup' => true,
				'word-spacing' => true,
				'margin-top' => true,
				'margin-bottom' => true,
				'units'       => 'px',
			),
			array(
				'id'       => 'theme-text-control-bbpress',
				'type'     => 'section',
				'title'    => esc_html__( 'Table Text', 'manual' ),
				'indent'   => true, 
			),
			array(
				'id'       => 'bbpress-directory-text',
				'type'     => 'text',
				'title'    => esc_html__( '1st column title', 'manual' ),
				'default'  => 'Directory',
				'subtitle' => esc_html__('Lists categories with descriptions.', 'manual' ),
			),
			array(
				'id'       => 'bbpress-topic-text',
				'type'     => 'text',
				'title'    => esc_html__( '2nd column title', 'manual' ),
				'default'  => 'Topics',
				'subtitle' => esc_html__('Shows the number of topics per category.', 'manual' ),
			),
			array(
				'id'       => 'bbpress-posts-text',
				'type'     => 'text',
				'title'    => esc_html__( '3rd column title', 'manual' ),
				'default'  => 'Posts',
				'subtitle' => esc_html__('Shows the number of posts per category.', 'manual' ),
			),
			array(
				'id'       => 'bbpress-lastpost-text',
				'type'     => 'text',
				'title'    => esc_html__( '4th column title', 'manual' ),
				'default'  => 'Last Post',
				'subtitle' => esc_html__('Displays the latest person to reply in the specific category.', 'manual' ),
			),
			array(
				'id'       => 'bbpress-voices-text',
				'type'     => 'text',
				'title'    => esc_html__( 'Voices Text', 'manual' ),
				'default'  => 'Voices',
			),
        )
    ) );
	
			
   // BBPRESS CUSTOM HEADER
   Redux::setSection( $opt_name, array(
        'title'            => esc_html__( 'Custom \'Page Title Bar\' - Applied to all forum sections globally', 'manual' ),
        'id'               => 'bbpres-header-design',
        'subsection'       => true,
        'customizer_width' => '450px',
        'fields'           => array(
		
				array(
					'id'       => 'bbpress_header_menu',
					'type'     => 'switch',
					'title'    => esc_html__( 'Customize the header menu', 'manual' ),
					'subtitle' => esc_html__('Modify the main header, including the logo and menu colors, if needed.', 'manual'),
					'default'  => false,
				),
				array(
					'id'       => 'bbpress_header_background_colorbg',
					'type'     => 'color_rgba',
					'title'    => esc_html__( 'Background color', 'manual' ),
					'subtitle'    => esc_html__( 'Set the header background.', 'manual' ),
					'output'    => array('background' => '.navbar-inverse.theme-forum-bbpress-pages'),
					'required' => array('bbpress_header_menu','equals','1'),
					'class' => 'theme-option-text-align-right',			
				),
				array(
					'id'       => 'bbpress_header_first_level_menu_text_color',
					'type'     => 'link_color',
					'title'    => esc_html__( 'Menu link color', 'manual' ),
					'subtitle' => esc_html__('Text color for the first level of the navigation menu.', 'manual'),
					'active'    => false, 
					'visited'   => false,
					'output'    => array('.navbar-inverse.theme-forum-bbpress-pages .navbar-nav>li>a'), 
					'required' => array('bbpress_header_menu','equals','1'),
					'class' => 'theme-option-text-align-right',
				),
				array(
					'id'       => 'bbpress_header_flip_logo',
					'type'     => 'switch',
					'title'    => esc_html__( 'Flip logo', 'manual' ),
					'subtitle' => esc_html__('Switch from the \'primary logo\' to the \'secondary logo,\' if necessary.', 'manual'),
					'default'  => false,
					'class' => 'theme-option-text-align-right',
					'required' => array('bbpress_header_menu','equals','1'),
				),
				array(
					'id'       => 'bbpress_header_shadow',
					'type'     => 'switch',
					'title'    => esc_html__('Header shadow', 'manual' ),
					'desc' => esc_html__('Please note that this function is effective only when the header shadow is enabled in the \'Header Menu > Main Header\' settings.', 'manual'),
					'subtitle' => esc_html__('Turn the default header shadow on or off.', 'manual'),
					'default'  => false,
					'class' => 'theme-option-text-align-right',
					'required' => array('bbpress_header_menu','equals','1'),
				),
				array(
					'id'       => 'bbpress_header_menu_border_btm',
					'type'     => 'border',
					'title'    => esc_html__( 'Header border bottom', 'manual' ),
					'subtitle' => esc_html__('Re-adjust header border bottom', 'manual'),
					'color_alpha'  => true,
					'left'  => false,
					'right'  => false,
					'top'  => false,
					'class' => 'theme-option-text-align-right',
					'required' => array('bbpress_header_menu','equals','1'),
					'output'    => array('.navbar.theme-forum-bbpress-pages'),
				),
				array(
					'id'       => 'bbpress_header_menu_border_top',
					'type'     => 'border',
					'title'    => esc_html__( 'Header border top', 'manual' ),
					'subtitle' => esc_html__('Re-adjust header border top', 'manual'),
					'desc' => esc_html__('If \'Menu position\' is set to \'Logo on Top\' and \'Menu Below Logo\' in \'Theme > Options > Header Menu > Main Header\', then this feature will work properly.', 'manual'),
					'color_alpha'  => true,
					'left'  => false,
					'right'  => false,
					'bottom'  => false,
					'required' => array('bbpress_header_menu','equals','1'),
					'class' => 'theme-option-text-align-right',
					'output'    => array('.navbar.theme-forum-bbpress-pages .navbar-collapse.collapse'),
				),
				array(
					'id'       => 'bbPress_headermenu_hamburger_searchbox',
					'type'     => 'switch',
					'title'    => esc_html__( 'Hide the search box in the Hamburger menu.', 'manual' ),
					'desc' => esc_html__('This feature will only function if enabled \'Search Box in Hamburger Menu\' in the \'Theme Options\' under \'Header Menu\' in the \'Main Header\' section.', 'manual'),
					'default'  => false,
					'required' => array('bbpress_header_menu','equals','1'),
					'on' => esc_html__( 'Hide', 'manual' ),
					'off' => esc_html__( 'Theme Default', 'manual' ),
					'class' => 'theme-option-text-align-right',
				),
				array(
					'id'       => 'onoff-bbpress-page-title-bar',
					'type'     => 'switch',
					'title'    => esc_html__('Page title bar', 'manual' ),
					'subtitle' => __('Enable/Disable page title bar', 'manual'),
					'desc' => __('Note: Disabling the page title bar will change the menu style to the default setting, meaning that no transparent menu style will be used.', 'manual'),
					'default'  => true,
					'on'       => esc_html__( 'Enable', 'manual' ),
					'off'      => esc_html__( 'Disable', 'manual' ),
				),
				array(
					'id'       => 'bbpress_pagetitlebar_settings',
					'type'     => 'section',
					'title'    => esc_html__( 'Page Title Bar', 'manual' ),
					'indent'   => true, 
					'required' => array('onoff-bbpress-page-title-bar','equals','1'),
				),
				array(
					'id'       => 'bbpress-header-height',
					'type'     => 'text',
					'title'    => esc_html__( 'Page title bar :: padding', 'manual' ),
					'subtitle' => esc_html__( 'Re-adjust the space above and below the \'Page Title Bar\' on your forum page.', 'manual' ),
					'desc'     => __('Example: 120px 0px 120px 0px (top, right, bottom, left) <br><br><strong style="color:#e6614b;">IMPORTANT: Make sure the value of RIGHT, LEFT is always 0px</strong>','manual' ),
					'default'  => '',
				),
				array(
					'id'       => 'bbpress-responsive-header-height',
					'type'     => 'text',
					'title'    => esc_html__( 'Page title bar :: Responsive padding', 'manual' ),
					'subtitle' => esc_html__( 'Re-adjust the top/bottom spacing for page title bar', 'manual' ),
					'desc'     => __( 'Example: 100px 0px 100px 0px (top, right, bottom, left) <br><br><strong style="color:#e6614b;">IMPORTANT: Make sure the value of RIGHT, LEFT is always 0px</strong>', 'manual' ), 
					'default'  => '',
				),
				array(
					'id'       => 'manual-forum-title',
					'type'     => 'text',
					'title'    => esc_html__( 'Forum title', 'manual' ),
					'subtitle'    => esc_html__( 'Display the custom forum title in the specified \'page title bar\' area.', 'manual' ),
					'default'  => 'Community Forum',
				),
				array(
					'id'       => 'bbpress-pagetitlebar-text-typography',
					'type'        => 'typography',
					'title'    => esc_html__( 'Title typography', 'manual' ),
					'subtitle' => esc_html__( 'Customize title text.', 'manual' ),
					'output'    => array('.noise-break.theme-forum-bbpress-pages h1.custom_h1_head'),
					'google'      => true,
					'font-backup' => false,
					'text-align' => false,
					'text-transform' => true,
					'subsets'       => false, 
					'letter-spacing'=> true,  
					'all_styles'  => true,
					'font-backup' => true,
					'word-spacing' => true,
					'margin-top' => true,
					'margin-bottom' => true,
					'units'       => 'px',
					'class' => 'theme-option-text-align-right',
				),
				array(
					'id'          => 'bbpress_pgtitlebar_typ_responsive_h1',
					'type'        => 'typography',
					'title'       => esc_html__( 'Responsive title', 'manual' ),
					'subtitle'    => esc_html__( 'Set responsive title', 'manual' ),
					'google'      => false,
					'font-weight' => false,
					'font-style' => false,
					'font-family' => false,
					'font-backup' => false,
					'text-align'  => false,
					'text-transform' => true,
					'subsets'        => false, 
					'color'          => false, 
					'text-transform'  => false, 
					'letter-spacing' => true,  
					'all_styles'  => false,
					'word-spacing' => true,
					'units'        => 'px',
					'class' => 'theme-option-text-align-right',
				),
				array(
					'id'       => 'manual-forum-subtitle',
					'type'     => 'text',
					'title'    => esc_html__( 'Sub-title text', 'manual' ),
					'subtitle' => esc_html__( 'Display the custom forum sub-title in the specified \'page title bar\' area.', 'manual' ),
					'default'  => 'receive professional support and assistance with any issues',
				),
				array(
					'id'       => 'bbpress-pagetitlebar-subtitle-typography',
					'type'        => 'typography',
					'title'    => esc_html__( 'Sub-title typography', 'manual' ),
					'subtitle' => esc_html__( 'Customize sub-title text.', 'manual' ),
					'output'    => array('.noise-break.theme-forum-bbpress-pages p.inner-header-color'),
					'google'      => true,
					'font-backup' => false,
					'text-align' => false,
					'text-transform' => true,
					'subsets'       => false, 
					'letter-spacing'=> true,  
					'all_styles'  => true,
					'font-backup' => true,
					'word-spacing' => true,
					'margin-top' => true,
					'margin-bottom' => true,
					'units'       => 'px',
					'class' => 'theme-option-text-align-right',
				),
				array(
					'id'       => 'bbpress-header-text-align',
					'type'     => 'select',
					'title'    => esc_html__( 'Text align', 'manual' ),
					'subtitle'    => esc_html__( 'Adjust the alignment of the text on the \'page title bar\'.', 'manual' ),
					'options'  => array(
						'left'   => esc_html__('Left', 'manual' ),
						'center' => esc_html__('Center', 'manual' ),
						'right'  => esc_html__('Right', 'manual' ),
					),
					'default'  => 'center'
				),
				array(
					'id'       => 'bbpress_search_status',
					'type'     => 'switch',
					'title'    => esc_html__( 'Search box', 'manual' ),
					'subtitle' => esc_html__( 'Choose to show or hide the search box in the specified \'page title bar\' area.', 'manual' ),
					'default'  => true,
					'on' => esc_html__( 'Enable', 'manual' ),
					'off' => esc_html__( 'Disable', 'manual' ),
				),
				array(
					'id'       => 'bbpress-searchbox-display-position',
					'type'     => 'select',
					'title'    => esc_html__( 'Search box position', 'manual' ),
					'subtitle'    => esc_html__( 'Choose where to place the search box on the \'page title bar\'.', 'manual' ),
					'options'  => array(
						'center' => esc_html__('Exact Center','manual' ),
						'6' => esc_html__('50% Width','manual' ),
						'7' => esc_html__('58% Width','manual' ),
						'8' => esc_html__('66% Width','manual' ),
						'9' => esc_html__('75% Width','manual' ),
						'10' => esc_html__('83% Width','manual' ),
						'11' => esc_html__('91% Width','manual' ),
						'12' => esc_html__('100% Width','manual' ),
					),
					'default'  => 'center',
					'required' => array('bbpress_search_status','equals','1'),
					'class'  => 'theme-option-text-align-right',
				), 
				array(
					'id'       => 'bbpress-searchbox-treanding-search-color',
					'type'     => 'color',
					'title'    => esc_html__( 'Title text color', 'manual' ),
					'subtitle'    => esc_html__( 'Trending search text title color', 'manual' ),
					'required' => array('bbpress_search_status','equals','1'),
					'output'    => array('.noise-break.theme-forum-bbpress-pages .trending-search span.popular-keyword-title'),
					'class' => 'theme-option-text-align-right',
				),
				array(
					'id'       => 'bbpress-searchbox-treanding-search-link-color',
					'type'     => 'link_color',
					'title'    => esc_html__( 'Link color', 'manual' ),
					'required' => array('bbpress_search_status','equals','1'),
					'subtitle'    => esc_html__( 'The trending keyword link color', 'manual' ),
					'active'    => false, 
					'visited'   => false,
					'output'    => array('.noise-break.theme-forum-bbpress-pages .trending-search a.trending-search-popular-keyword'),  
					'class' => 'theme-option-text-align-right',
				),
				array(
					'id'       => 'bbpress_breadcrumb_status',
					'type'     => 'switch',
					'title'    => esc_html__( 'Breadcrumb', 'manual' ),
					'subtitle' => esc_html__( 'Choose to show or hide the breadcrumb in the specified \'page title bar\' area.', 'manual' ),
					'default'  => true,
					'on' => esc_html__( 'Enable', 'manual' ),
					'off' => esc_html__( 'Disable', 'manual' ),
				),
				array(
					'id'       => 'bbpress_breadcrumb',
					'type'     => 'switch',
					'title'    => esc_html__( 'Forum root in breadcrumbs', 'manual' ),
					'subtitle'    => esc_html__( 'Add the "Forum Root" slug name to the breadcrumb', 'manual' ),
					'default'  => false,
					'on' => esc_html__( 'Enable', 'manual' ),
					'off' => esc_html__( 'Disable', 'manual' ),
					'class' => 'theme-option-text-align-right',
					'required' => array('bbpress_breadcrumb_status','equals','1'),
				),
				array(
					'id'       => 'bbpress_pagetitlebar_breadcrumb_regular_text_color',
					'type'     => 'color_rgba',
					'title'    => esc_html__( 'Regular text color', 'manual' ),
					'subtitle' => esc_html__('Breadcrumb regular text color.', 'manual'),
					'required' => array('bbpress_breadcrumb_status','equals','1'),
					'output'    => array('.noise-break.theme-forum-bbpress-pages #breadcrumbs'),
					'class' => 'theme-option-text-align-right',
				),
				array(
					'id'       => 'bbpress_pagetitlebar_breadcrumb_link_color',
					'type'     => 'link_color',
					'title'    => esc_html__( 'Link color', 'manual' ),
					'subtitle' => esc_html__('Adjust the color of breadcrumb links if needed.', 'manual'),
					'required' => array('bbpress_breadcrumb_status','equals','1'),
					'output'    => array('.noise-break.theme-forum-bbpress-pages #breadcrumbs a'),
					'active'  => false,
					'class' => 'theme-option-text-align-right',
				),
				array(
					'id'       => 'bbpress_pagetitlebar_breadcrumb_link_seprator_color',
					'type'     => 'color_rgba',
					'title'    => esc_html__( 'Link seprator color', 'manual' ),
					'subtitle' => esc_html__('Adjust the color of breadcrumb link seprators if needed.', 'manual'),
					'required' => array('bbpress_breadcrumb_status','equals','1'),
					'output'    => array('.noise-break.theme-forum-bbpress-pages #breadcrumbs span'),
					'class' => 'theme-option-text-align-right',
				),
				array(
					'id'       => 'bbpress_pagetitlebar_background_setup',
					'type' => 'background',
					'title'    => esc_html__( 'Background', 'manual' ),
					'subtitle' => esc_html__( 'Create the background for your forum page.', 'manual' ),
				),
				array(
					'id'       => 'bbpress_pagetitlebar_image_overlay',
					'type'     => 'color_rgba',
					'title'    => esc_html__( 'Background overlay', 'manual' ),
					'subtitle'    => esc_html__( 'Select the background overlay for your forum page title bar.', 'manual' ),
					'output'    => array('background' => '.noise-break.theme-forum-bbpress-pages .page_opacity.header_custom_height_new'),
					'class' => 'theme-option-text-align-right',
				),	

			)
		) );

	 
}

/*************************************
*******  LEARNPRESS - SETTINGS  *****
**************************************/
if(class_exists( 'LearnPress' )) {

	Redux::setSection( $opt_name, array(
		'title'            => esc_html__( 'LearnPress', 'manual' ),
		'id'               => 'learnpress_wrap',
		'customizer_width' => '400px',
		'icon'       => 'el el-star',
	) );	
	
	 Redux::setSection( $opt_name, array(
			'title'      => esc_html__( 'LearnPress', 'manual' ),
			'id'         => 'learnpress_settings',
			'subsection' => true,
			'fields'     => array(
						array(
							'id'       => 'learnpress_display_feature_image',
							'type'     => 'switch',
							'title'    => esc_html__( 'Feature image', 'manual' ),
							'subtitle' => esc_html__( 'Showcase the featured image at the upper section of the individual page content area.', 'manual' ),
							'default'  => false,
						),
						// Archive Page
						array(
							'id'       => 'learnpress_archive_pg_customization',
							'type'     => 'section',
							'title'    => esc_html__( 'Archive Page', 'manual' ),
							'indent'   => true, 
						),
						array(
							'id'       => 'learnpress_archive_pg_course_column',
							'type'     => 'select',
							'title'    => esc_html__( 'Course Columns', 'manual' ),
							'subtitle' => esc_html__( 'Course display column', 'manual' ),
							'options'  => array(
								'6' => esc_html__('2 Columns','manual' ),
								'4' => esc_html__('3 Columns','manual' ),
								'3' => esc_html__('4 Columns','manual' ),
							),
							'default'  => '3'
						),
						array(
							'id'       => 'learnpress_archive_pg_course_titletag',
							'type'     => 'select',
							'title'    => esc_html__( 'Title', 'manual' ),
							'subtitle' => esc_html__( 'Set title tag.', 'manual' ),
							'options'  => array(
								'h3' => esc_html__('h3', 'manual' ),
								'h4' => esc_html__('h4', 'manual' ),
								'h5' => esc_html__('h5', 'manual' ),
								'h6' => esc_html__('h6', 'manual' ),
							),
							'default'  => 'h5', 
						),
						array(
							'id'       => 'learnpress_archive_post_course_price_titletag',
							'type'     => 'select',
							'title'    => esc_html__( 'Price', 'manual' ),
							'subtitle' => esc_html__( 'Set price tag.', 'manual' ),
							'options'  => array(
								'h4' => esc_html__('h4', 'manual' ),
								'h5' => esc_html__('h5', 'manual' ),
								'h6' => esc_html__('h6', 'manual' ),
							),
							'default'  => 'h5', 
						),
						// Related Post
						array(
							'id'       => 'learnpress_related_post_customization',
							'type'     => 'section',
							'title'    => esc_html__( 'Related Course', 'manual' ),
							'indent'   => true, 
						),
						array(
							'id'       => 'learnpress_related_post_course_column',
							'type'     => 'select',
							'title'    => esc_html__( 'Related post columns', 'manual' ),
							'subtitle' => esc_html__( 'Related post course column', 'manual' ),
							'options'  => array(
								'4' => esc_html__('3 Columns','manual' ),
								'3' => esc_html__('4 Columns','manual' ),
							),
							'default'  => '3'
						),
						array(
							'id'       => 'learnpress_related_post_course_titletag',
							'type'     => 'select',
							'title'    => esc_html__( 'Title', 'manual' ),
							'subtitle' => esc_html__( 'Set title tag.', 'manual' ),
							'options'  => array(
								'h3' => esc_html__('h3', 'manual' ),
								'h4' => esc_html__('h4', 'manual' ),
								'h5' => esc_html__('h5', 'manual' ),
								'h6' => esc_html__('h6', 'manual' ),
							),
							'default'  => 'h5', 
						),
						array(
							'id'       => 'learnpress_related_post_course_price_titletag',
							'type'     => 'select',
							'title'    => esc_html__( 'Price', 'manual' ),
							'subtitle' => esc_html__( 'Set price tag.', 'manual' ),
							'options'  => array(
								'h4' => esc_html__('h4', 'manual' ),
								'h5' => esc_html__('h5', 'manual' ),
								'h6' => esc_html__('h6', 'manual' ),
							),
							'default'  => 'h5', 
						),
			 )
    ) );
	
	Redux::setSection( $opt_name, array(
				'title'            => esc_html__( 'Custom \'Page Title Bar\' - Single Page', 'manual' ),
				'id'               => 'learnpress_custom_singlepg_header',
				'subsection'       => true,
				'customizer_width' => '450px',
				'fields'           => array(
				
						array(
							'id'       => 'learnpress_header_menu',
							'type'     => 'switch',
							'title'    => esc_html__( 'Customize the header menu', 'manual' ),
							'subtitle' => esc_html__('Modify the main header, including the logo and menu colors, if needed.', 'manual'),
							'default'  => false,
						),
						array(
							'id'       => 'learnpress_header_background_colorbg',
							'type'     => 'color_rgba',
							'title'    => esc_html__( 'Background color', 'manual' ),
							'subtitle'    => esc_html__( 'Set the header background.', 'manual' ),
							'output'    => array('background' => '.navbar-inverse.theme-learnpress-singlepg'),
							'required' => array('learnpress_header_menu','equals','1'),
							'class' => 'theme-option-text-align-right',			
						),
						array(
							'id'       => 'learnpress_header_first_level_menu_text_color',
							'type'     => 'link_color',
							'title'    => esc_html__( 'Menu link color', 'manual' ),
							'subtitle' => esc_html__('Text color for the first level of the navigation menu.', 'manual'),
							'active'    => false, 
							'visited'   => false,
							'output'    => array('.navbar-inverse.theme-learnpress-singlepg .navbar-nav>li>a'), 
							'required' => array('learnpress_header_menu','equals','1'),
							'class' => 'theme-option-text-align-right',
						),
						array(
							'id'       => 'learnpress_header_flip_logo',
							'type'     => 'switch',
							'title'    => esc_html__( 'Flip logo', 'manual' ),
							'subtitle' => esc_html__('Switch from the \'primary logo\' to the \'secondary logo,\' if necessary.', 'manual'),
							'default'  => false,
							'class' => 'theme-option-text-align-right',
							'required' => array('learnpress_header_menu','equals','1'),
						),
						array(
							'id'       => 'learnpress_header_shadow',
							'type'     => 'switch',
							'title'    => esc_html__('Header shadow', 'manual' ),
							'desc' => esc_html__('Please note that this function is effective only when the header shadow is enabled in the \'Header Menu > Main Header\' settings.', 'manual'),
							'subtitle' => esc_html__('Turn the default header shadow on or off.', 'manual'),
							'default'  => false,
							'class' => 'theme-option-text-align-right',
							'required' => array('learnpress_header_menu','equals','1'),
						),
						array(
							'id'       => 'learnpress_header_menu_border_btm',
							'type'     => 'border',
							'title'    => esc_html__( 'Header border bottom', 'manual' ),
							'subtitle' => esc_html__('Re-adjust header border bottom', 'manual'),
							'color_alpha'  => true,
							'left'  => false,
							'right'  => false,
							'top'  => false,
							'class' => 'theme-option-text-align-right',
							'required' => array('learnpress_header_menu','equals','1'),
							'output'    => array('.navbar.theme-learnpress-singlepg'),
						),
						array(
							'id'       => 'learnpress_header_menu_border_top',
							'type'     => 'border',
							'title'    => esc_html__( 'Header border top', 'manual' ),
							'subtitle' => esc_html__('Re-adjust header border top', 'manual'),
							'desc' => esc_html__('If \'Menu position\' is set to \'Logo on Top\' and \'Menu Below Logo\' in \'Theme > Options > Header Menu > Main Header\', then this feature will work properly.', 'manual'),
							'color_alpha'  => true,
							'left'  => false,
							'right'  => false,
							'bottom'  => false,
							'required' => array('learnpress_header_menu','equals','1'),
							'class' => 'theme-option-text-align-right',
							'output'    => array('.navbar.theme-learnpress-singlepg .navbar-collapse.collapse'),
						),
						array(
							'id'       => 'learnpress_headermenu_hamburger_searchbox',
							'type'     => 'switch',
							'title'    => esc_html__( 'Hide the search box in the Hamburger menu.', 'manual' ),
							'desc' => esc_html__('This feature will only function if enabled \'Search Box in Hamburger Menu\' in the \'Theme Options\' under \'Header Menu\' in the \'Main Header\' section.', 'manual'),
							'default'  => false,
							'required' => array('learnpress_header_menu','equals','1'),
							'on' => esc_html__( 'Hide', 'manual' ),
							'off' => esc_html__( 'Theme Default', 'manual' ),
							'class' => 'theme-option-text-align-right',
						),
						array(
							'id'       => 'onoff-learnpress-single-page-title-bar',
							'type'     => 'switch',
							'title'    => esc_html__('Page title bar', 'manual' ),
							'subtitle'    => esc_html__('Enable/Disable page title bar', 'manual' ),
							'desc' => __('Note: Disabling the page title bar will change the menu style to the default setting, meaning that no transparent menu style will be used.', 'manual'),
							'default'  => true,
							'on'       => esc_html__( 'Enable', 'manual' ),
							'off'      => esc_html__( 'Disable', 'manual' ),
						),	
						// -------------- Page Title Bar Controls --------------
						array(
							'id'       => 'learnpress-single-page-title-bar-controls',
							'type'     => 'section',
							'title'    => esc_html__( 'Page Title Bar', 'manual' ),
							'indent'   => true, 
							'required' => array('onoff-learnpress-single-page-title-bar','equals','1'),  
						),
						array(
							'id'       => 'learnpress-singlepg-header-height',
							'type'     => 'text',
							'title'    => esc_html__( 'Page title bar :: padding', 'manual' ),
							'subtitle'    => esc_html__( 'Re-adjust the space above and below the \'Page Title Bar\' on your learnpress single page.', 'manual' ),
							'desc' => __('Example: 132px 0px 132px 0px (top, right, bottom, left) <br><br><strong style="color:#e6614b;">IMPORTANT: Make sure the value of RIGHT, LEFT is always 0px</strong>', 'manual' ),
							'default'  => '',
						),
						array(
							'id'       => 'learnpress-responsive-singlepg-header-height',
							'type'     => 'text',
							'title'    => esc_html__( 'Page title bar :: Responsive padding', 'manual' ),
							'subtitle' => esc_html__( 'Re-adjust the top/bottom spacing for page title bar', 'manual' ),
							'desc'     => __( 'Example: 100px 0px 100px 0px (top, right, bottom, left)<br><br><strong style="color:#e6614b;">IMPORTANT: Make sure the value of RIGHT, LEFT is always 0px</strong>', 'manual' ), 
							'default'  => '',
						),
						array(
							'id'       => 'learnpress-single-pg-title-text-status',
							'type'     => 'switch',
							'title'    => esc_html__( 'Header title', 'manual' ),
							'default'  => true,
							'subtitle' => esc_html__( 'Choose to display or hide the Article Title in the specified \'page title bar\' area.', 'manual' ),
							'on' => esc_html__( 'Enable', 'manual' ),
							'off' => esc_html__( 'Disable', 'manual' ),
						),
						array(
							'id'       => 'learnpress_pagetitlebar_text_typography',
							'type'        => 'typography',
							'title'    => esc_html__( 'Title typography', 'manual' ),
							'subtitle' => esc_html__( 'Customize title text.', 'manual' ),
							'output'    => array('.noise-break.theme-learnpress-singlepg h1.custom_h1_head'),
							'required' => array('learnpress-single-pg-title-text-status','equals','1'), 
							'google'      => true,
							'font-backup' => false,
							'text-align' => false,
							'text-transform' => true,
							'subsets'       => false, 
							'letter-spacing'=> true,  
							'all_styles'  => true,
							'font-backup' => true,
							'word-spacing' => true,
							'margin-top' => true,
							'margin-bottom' => true,
							'units'       => 'px',
							'class' => 'theme-option-text-align-right',
						),
						array(
							'id'       => 'learnpress-singlepg-text-align',
							'type'     => 'select',
							'title'    => esc_html__( 'Text align', 'manual' ),
							'subtitle'    => esc_html__( 'Adjust the alignment of the text on the \'page title bar\'.', 'manual' ),
							'options'  => array(
								'center' => esc_html__('Center','manual' ),
								'left' => esc_html__('Left','manual' ),
								'right' => esc_html__('Right','manual' ),
							),
							'default'  => 'left',
						),
						array(
							'id'       => 'learnpress-single-pg-header-search-status',
							'type'     => 'switch',
							'title'    => esc_html__( 'Search box', 'manual' ),
							'default'  => false,
							'subtitle' => esc_html__( 'Choose to show or hide the search box in the specified \'page title bar\' area.', 'manual' ),
							'on' => esc_html__( 'Enable', 'manual' ),
							'off' => esc_html__( 'Disable', 'manual' ),
						),
						array(
							'id'       => 'learnpress-searchbox-display-position',
							'type'     => 'select',
							'title'    => esc_html__( 'Search box position', 'manual' ),
							'subtitle'    => esc_html__( 'Choose where to place the search box on the \'page title bar\'.', 'manual' ),
							'options'  => array(
								'center' => esc_html__('Exact Center', 'manual' ),
								'6' => esc_html__('50% Width', 'manual' ),
								'7' => esc_html__('58% Width', 'manual' ),
								'8' => esc_html__('66% Width', 'manual' ),
								'9' => esc_html__('75% Width', 'manual' ),
								'10' => esc_html__('83% Width', 'manual' ),
								'11' => esc_html__('91% Width', 'manual' ),
								'12' => esc_html__('100% Width', 'manual' ),
							),
							'default'  => 'center',
							'required' => array('learnpress-single-pg-header-search-status','equals','1'),
							'class'  => 'theme-option-text-align-right',
						),
						array(
							'id'       => 'learnpress-pagetitlebar-treanding-search-color',
							'type'     => 'color',
							'title'    => esc_html__( 'Title text color', 'manual' ),
							'subtitle'    => esc_html__( 'Trending search text title color', 'manual' ),
							'required' => array('learnpress-single-pg-header-search-status','equals','1'),
							'output'    => array('.noise-break.theme-learnpress-singlepg .trending-search span.popular-keyword-title'),
							'class' => 'theme-option-text-align-right',
						),
						array(
							'id'       => 'learnpress-pagetitlebar-treanding-search-link-color',
							'type'     => 'link_color',
							'title'    => esc_html__( 'Link color', 'manual' ),
							'required' => array('learnpress-single-pg-header-search-status','equals','1'),
							'subtitle'    => esc_html__( 'The trending keyword link color', 'manual' ),
							'active'    => false, 
							'visited'   => false,
							'output'    => array('.noise-break.theme-learnpress-singlepg .trending-search a.trending-search-popular-keyword'),  
							'class' => 'theme-option-text-align-right',
						),
						array(
							'id'       => 'learnpress-single-pg-header-breadcrumb-status',
							'type'     => 'switch',
							'title'    => esc_html__( 'Breadcrumb', 'manual' ),
							'default'  => true,
							'subtitle' => esc_html__( 'Choose to show or hide the breadcrumb in the specified \'page title bar\' area.', 'manual' ),
							'on' => esc_html__( 'Enable', 'manual' ),
							'off' => esc_html__( 'Disable', 'manual' ),
						),
						array(
							'id'       => 'learnpress_pagetitlebar_breadcrumb_regular_text_color',
							'type'     => 'color_rgba',
							'title'    => esc_html__( 'Regular text color', 'manual' ),
							'subtitle' => esc_html__('Breadcrumb regular text color.', 'manual'),
							'required' => array('learnpress-single-pg-header-breadcrumb-status','equals','1'),
							'output'    => array('.noise-break.theme-learnpress-singlepg #breadcrumbs'),
							'class' => 'theme-option-text-align-right',
						),
						array(
							'id'       => 'learnpress_pagetitlebar_breadcrumb_link_color',
							'type'     => 'link_color',
							'title'    => esc_html__( 'Link color', 'manual' ),
							'subtitle' => esc_html__('Adjust the color of breadcrumb links if needed.', 'manual'),
							'required' => array('learnpress-single-pg-header-breadcrumb-status','equals','1'),
							'output'    => array('.noise-break.theme-learnpress-singlepg #breadcrumbs a'),
							'active'  => false,
							'class' => 'theme-option-text-align-right',
						),
						array(
							'id'       => 'learnpress_pagetitlebar_breadcrumb_link_seprator_color',
							'type'     => 'color_rgba',
							'title'    => esc_html__( 'Link seprator color', 'manual' ),
							'subtitle' => esc_html__('Adjust the color of breadcrumb link seprators if needed.', 'manual'),
							'required' => array('learnpress-single-pg-header-breadcrumb-status','equals','1'),
							'output'    => array('.noise-break.theme-learnpress-singlepg #breadcrumbs span'),
							'class' => 'theme-option-text-align-right',
						),
						array(
							'id'       => 'learnpress_featured_image_on_the_header',
							'type'     => 'switch',
							'title'    => esc_html__( 'Featured image', 'manual' ),
							'subtitle' => esc_html__('Choose whether to display or hide the \'post feature image\' on the \'page title bar\'.', 'manual'),
							'default'  => true,
						),
						array(
							'id'       => 'learnpress_featured_image_bg_adjustment',
							'type'     => 'background',
							'background-color'     => false,
							'background-image'     => false,
							'title'    => esc_html__( 'Background', 'manual' ),
							'subtitle'    => esc_html__( 'Adjust background.', 'manual' ),
							'required' => array('learnpress_featured_image_on_the_header','equals','1'),
							'class' => 'theme-option-text-align-right',
							'default'  => array(
												'background-repeat' => 'no-repeat',
												'background-position' => 'center center',
												'background-size' => 'cover',
												'background-attachment' => 'scroll',
											),
						),
						array(
							'id'       => 'learnpress_background_nofeaturedimage',
							'type'     => 'background',
							'title'    => esc_html__( 'Background', 'manual' ),
							'subtitle'    => esc_html__( 'Adjust background.', 'manual' ),
							'required' => array('learnpress_featured_image_on_the_header','equals','0'),
							'class' => 'theme-option-text-align-right',
						),
						array(
							'id'       => 'learnpress_featured_image_overlay',
							'type'     => 'color_rgba',
							'title'    => esc_html__( 'Background overlay', 'manual' ),
							'subtitle'    => esc_html__( 'Select the background overlay for your blog single page title bar.', 'manual' ),
							'output'    => array('background' => '.noise-break.theme-learnpress-singlepg .page_opacity.header_custom_height_new'),
							'class' => 'theme-option-text-align-right',
						),
					  )
			) );
		
}
	 
/*************************************
*******  WOOCOMMERCE - SETTINGS  *****
**************************************/
	
global $woocommerce;
if ($woocommerce) {

	Redux::setSection( $opt_name, array(
		'title'            => esc_html__( 'WooCommerce', 'manual' ),
		'id'               => 'theme_woocommerce',
		'customizer_width' => '400px',
		'icon'       => 'el el-shopping-cart',
	) );
	
	 Redux::setSection( $opt_name, array(
			'title'      => esc_html__( 'Global Settings', 'manual' ),
			'id'         => 'theme_woocommerce_global',
			'subsection'       => true,
			'customizer_width' => '450px',
			'fields'     => array(
		
				array(
					'id'       => 'woo_column_product_listing',
					'type'     => 'select',
					'title'    => esc_html__( 'Columns', 'manual' ),
					'subtitle' => esc_html__( 'Select the number of columns for the product display on the default WooCommerce shop page.', 'manual' ),
					'options'  => array(
						'3' => esc_html__('3 Columns','manual' ),
						'4' => esc_html__('4 Columns','manual' ),
					),
					'default'  => '3'
				),
				array(
					'id'       => 'woo_display_sidebar_on_product_listing_page',
					'type'     => 'switch',
					'title'    => esc_html__( 'Sidebar', 'manual' ),
					'subtitle' => esc_html__( 'Choose if you want to display or hide the sidebar on the regular WooCommerce shop page.', 'manual' ),
					'default'  => true,
				),
				array(
					'id'       => 'woo_single_product_page',
					'type'     => 'section',
					'title'    => esc_html__( 'Single Product Page', 'manual' ),
					'indent'   => true, 
				),
				array(
					'id'       => 'woo_single_product_page_social_icon',
					'type'     => 'switch',
					'title'    => esc_html__( 'Social icons', 'manual' ),
					'subtitle' => esc_html__( 'Show social icons on the product description page, i.e on the single product page below the product description.', 'manual' ),
					'default'  => true,
				),
				array (
					'id' => 'woo_single_product_page_related_products_text',
					'type' => 'text',
					'title' => esc_html__('Title text for related products', 'manual'),
					'subtitle' => esc_html__( 'Text title that shows above the related products and beneath the single product description, specifically on the single product page.', 'manual' ),
					'default' => esc_html__('Related products', 'manual'),
				),
				array(
					'id'       => 'woo_no_of_related_products',
					'type'     => 'select',
					'title'    => esc_html__( 'Related Products column', 'manual' ),
					'subtitle' => esc_html__( 'Select the number of columns for the product display on the related products area.', 'manual' ),
					'options'  => array(
						'3' => '3 Columns',
						'4' => '4 Columns',
					),
					'default'  => '4'
				),
		 )
    ) );
	
	// - cat/tag
	Redux::setSection( $opt_name, array(
        'title'            => esc_html__( 'Custom \'Page Title Bar\' - Category/Tag Page', 'manual' ),
        'id'               => 'woocommerce_custom_header_cat_tag',
        'subsection'       => true,
        'customizer_width' => '450px',
        'fields'           => array(
		
					array(
						'id'       => 'woocommerce_pagetitlebar_header_menu',
						'type'     => 'switch',
						'title'    => esc_html__( 'Customize the header menu', 'manual' ),
						'subtitle' => esc_html__('Modify the main header, including the logo and menu colors, if needed.', 'manual'),
						'default'  => false,
					),
					array(
						'id'       => 'woocommerce_pagetitlebar_header_background_colorbg',
						'type'     => 'color_rgba',
						'title'    => esc_html__( 'Background color', 'manual' ),
						'subtitle'    => esc_html__( 'Set the header background.', 'manual' ),
						'output'    => array('background' => '.navbar-inverse.theme-woocommerce-cat-tag'),
						'required' => array('woocommerce_pagetitlebar_header_menu','equals','1'),
						'class' => 'theme-option-text-align-right',			
					),
					array(
						'id'       => 'woocommerce_pagetitlebar_header_first_level_menu_text_color',
						'type'     => 'link_color',
						'title'    => esc_html__( 'Menu link color', 'manual' ),
						'subtitle' => esc_html__('Text color for the first level of the navigation menu.', 'manual'),
						'active'    => false, 
						'visited'   => false,
						'output'    => array('.navbar-inverse.theme-woocommerce-cat-tag .navbar-nav>li>a'), 
						'required' => array('woocommerce_pagetitlebar_header_menu','equals','1'),
						'class' => 'theme-option-text-align-right',
					),
					array(
						'id'       => 'woocommerce_pagetitlebar_header_flip_logo',
						'type'     => 'switch',
						'title'    => esc_html__( 'Flip logo', 'manual' ),
						'subtitle' => esc_html__('Switch from the \'primary logo\' to the \'secondary logo,\' if necessary.', 'manual'),
						'default'  => false,
						'class' => 'theme-option-text-align-right',
						'required' => array('woocommerce_pagetitlebar_header_menu','equals','1'),
					),
					array(
						'id'       => 'woocommerce_pagetitlebar_header_shadow',
						'type'     => 'switch',
						'title'    => esc_html__('Header shadow', 'manual' ),
						'desc' => esc_html__('Please note that this function is effective only when the header shadow is enabled in the \'Header Menu > Main Header\' settings.', 'manual'),
						'subtitle' => esc_html__('Turn the default header shadow on or off.', 'manual'),
						'default'  => false,
						'class' => 'theme-option-text-align-right',
						'required' => array('woocommerce_pagetitlebar_header_menu','equals','1'),
					),
					array(
						'id'       => 'woocommerce_pagetitlebar_header_menu_border_btm',
						'type'     => 'border',
						'title'    => esc_html__( 'Header border bottom', 'manual' ),
						'subtitle' => esc_html__('Re-adjust header border bottom', 'manual'),
						'color_alpha'  => true,
						'left'  => false,
						'right'  => false,
						'top'  => false,
						'class' => 'theme-option-text-align-right',
						'required' => array('woocommerce_pagetitlebar_header_menu','equals','1'),
						'output'    => array('.navbar.theme-woocommerce-cat-tag'),
					),
					array(
						'id'       => 'woocommerce_pagetitlebar_header_menu_border_top',
						'type'     => 'border',
						'title'    => esc_html__( 'Header border top', 'manual' ),
						'subtitle' => esc_html__('Re-adjust header border top', 'manual'),
						'desc' => esc_html__('If \'Menu position\' is set to \'Logo on Top\' and \'Menu Below Logo\' in \'Theme > Options > Header Menu > Main Header\', then this feature will work properly.', 'manual'),
						'color_alpha'  => true,
						'left'  => false,
						'right'  => false,
						'bottom'  => false,
						'required' => array('woocommerce_pagetitlebar_header_menu','equals','1'),
						'class' => 'theme-option-text-align-right',
						'output'    => array('.navbar.theme-woocommerce-cat-tag .navbar-collapse.collapse'),
					),
					array(
						'id'       => 'woocat_headermenu_hamburger_searchbox',
						'type'     => 'switch',
						'title'    => esc_html__( 'Hide the search box in the Hamburger menu.', 'manual' ),
						'desc' => esc_html__('This feature will only function if enabled \'Search Box in Hamburger Menu\' in the \'Theme Options\' under \'Header Menu\' in the \'Main Header\' section.', 'manual'),
						'default'  => false,
						'required' => array('woocommerce_pagetitlebar_header_menu','equals','1'),
						'on' => esc_html__( 'Hide', 'manual' ),
						'off' => esc_html__( 'Theme Default', 'manual' ),
						'class' => 'theme-option-text-align-right',
					),
					array(
						'id'       => 'onoff-woocommerce-catag-page-title-bar',
						'type'     => 'switch',
						'title'    => esc_html__('Page title bar', 'manual' ),
						'subtitle' => __('Enable/Disable page title bar', 'manual'),
						'desc' => __('Note: Disabling the page title bar will change the menu style to the default setting, meaning that no transparent menu style will be used.', 'manual'),
						'default'  => true,
						'on'       => esc_html__( 'Enable', 'manual' ),
						'off'      => esc_html__( 'Disable', 'manual' ),
					),
					// -------------- Page Title Bar Controls --------------
					array(
						'id'       => 'woocommerce-page-title-bar-controls',
						'type'     => 'section',
						'title'    => esc_html__( 'Page Title Bar', 'manual' ),
						'indent'   => true, 
						'required' => array('onoff-woocommerce-catag-page-title-bar','equals','1'),  
					),
					array(
						'id'       => 'woocommerce-header-height-category-tag-page',
						'type'     => 'text',
						'title'    => esc_html__( 'Page title bar :: padding', 'manual' ),
						'subtitle'    => esc_html__( 'Re-adjust the space above and below the \'Page Title Bar\' on your WooCommerce category/tag page.', 'manual' ),
						'desc' => __('Example: 120px 0px 120px 0px (top, right, bottom, left) <br><br><strong style="color:#e6614b;">IMPORTANT: Make sure the value of RIGHT, LEFT is always 0px</strong>', 'manual' ),
						'default'  => '',
					),
					array(
						'id'       => 'woocommerce-responsive-header-height-category-tag-page',
						'type'     => 'text',
						'title'    => esc_html__( 'Page title bar :: Responsive padding', 'manual' ),
						'subtitle' => esc_html__( 'Re-adjust the top/bottom spacing for page title bar', 'manual' ),
						'desc'     => __( 'Example: 100px 0px 100px 0px (top, right, bottom, left) <br><br><strong style="color:#e6614b;">IMPORTANT: Make sure the value of RIGHT, LEFT is always 0px</strong>', 'manual' ), 
						'default'  => '',
					),
					array(
						'id'       => 'woocommerce_pagetitlebar_text_typography',
						'type'        => 'typography',
						'title'    => esc_html__( 'Title typography', 'manual' ),
						'subtitle' => esc_html__( 'Customize title text.', 'manual' ),
						'output'    => array('.noise-break.theme-woocommerce-cat-tag h1.custom_h1_head'),
						'google'      => true,
						'font-backup' => false,
						'text-align' => false,
						'text-transform' => true,
						'subsets'       => false, 
						'letter-spacing'=> true,  
						'all_styles'  => true,
						'font-backup' => true,
						'word-spacing' => true,
						'margin-top' => true,
						'margin-bottom' => true,
						'units'       => 'px',
					),
					array(
						'id'       => 'woocommerce_header_text_align',
						'type'     => 'select',
						'title'    => esc_html__( 'Text align', 'manual' ),
						'subtitle'    => esc_html__( 'Adjust the alignment of the text on the \'page title bar\'', 'manual' ),
						'options'  => array(
							'left' => esc_html__('Left', 'manual' ),
							'center' => esc_html__('Center', 'manual' ),
							'right' => esc_html__('Right', 'manual' ),
						),
						'default'  => 'center'
					),
					array(
						'id'       => 'woocommerce-disable-search-category-page',
						'type'     => 'switch',
						'title'    => esc_html__( 'Search box', 'manual' ),
						'default'  => false,
						'subtitle' => esc_html__('Choose to show or hide the search box in the specified \'page title bar\' area.', 'manual'),
						'on' => esc_html__( 'Disable', 'manual' ),
						'off' => esc_html__( 'Enable', 'manual' ),
					),
					array(
						'id'       => 'woocommerce-searchbox-display-position',
						'type'     => 'select',
						'title'    => esc_html__( 'Search box position', 'manual' ),
						'subtitle'    => esc_html__( 'Choose where to place the search box on the \'page title bar\'.', 'manual' ),
						'options'  => array(
							'center' => esc_html__('Exact Center','manual' ),
							'6' => esc_html__('50% Width','manual' ),
							'7' => esc_html__('58% Width','manual' ),
							'8' => esc_html__('66% Width','manual' ),
							'9' => esc_html__('75% Width','manual' ),
							'10' => esc_html__('83% Width','manual' ),
							'11' => esc_html__('91% Width','manual' ),
							'12' => esc_html__('100% Width','manual' ),
						),
						'default'  => 'center',
						'required' => array('woocommerce-disable-search-category-page','equals','0'),
						'class'  => 'theme-option-text-align-right',
					), 
					array(
						'id'       => 'woocommerce-pagetitlebar-searchbox-treanding-search-color',
						'type'     => 'color',
						'title'    => esc_html__( 'Title text color', 'manual' ),
						'subtitle'    => esc_html__( 'Trending search text title color', 'manual' ),
						'required' => array('woocommerce-disable-search-category-page','equals','0'),
						'output'    => array('.noise-break.theme-woocommerce-cat-tag .trending-search span.popular-keyword-title'),
						'class' => 'theme-option-text-align-right',
					),
					array(
						'id'       => 'woocommerce-pagetitlebar-searchbox-treanding-search-link-color',
						'type'     => 'link_color',
						'title'    => esc_html__( 'Link color', 'manual' ),
						'subtitle'    => esc_html__( 'The trending keyword link color', 'manual' ),
						'active'    => false, 
						'visited'   => false,
						'required' => array('woocommerce-disable-search-category-page','equals','0'),
						'output'    => array('.noise-break.theme-woocommerce-cat-tag .trending-search a.trending-search-popular-keyword'),  
						'class' => 'theme-option-text-align-right',
					),
					array(
						'id'       => 'woocommerce-disable-breadcrumb-cat-tag-page',
						'type'     => 'switch',
						'title'    => esc_html__( 'Breadcrumb', 'manual' ),
						'default'  => false,
						'subtitle' => esc_html__( 'Choose to show or hide the breadcrumb in the specified \'page title bar\' area.','manual' ),
						'on' => esc_html__( 'Disable', 'manual' ),
						'off' => esc_html__( 'Enable', 'manual' ),
					),
					array(
						'id'       => 'woocommerce_pagetitlebar_breadcrumb_link_color',
						'type'     => 'link_color',
						'title'    => esc_html__( 'Link color', 'manual' ),
						'subtitle' => esc_html__('Adjust the color of breadcrumb links if needed.', 'manual'),
						'required' => array('woocommerce-disable-breadcrumb-cat-tag-page','equals','0'),
						'output'    => array('.noise-break.theme-woocommerce-cat-tag #breadcrumbs a'),
						'active'  => false,
						'class' => 'theme-option-text-align-right',
					),
					array(
						'id'       => 'woocommerce_pagetitlebar_breadcrumb_link_seprator_color',
						'type'     => 'color_rgba',
						'title'    => esc_html__( 'Link seprator color', 'manual' ),
						'subtitle' => esc_html__('Adjust the color of breadcrumb link seprators if needed.', 'manual'),
						'required' => array('woocommerce-disable-breadcrumb-cat-tag-page','equals','0'),
						'output'    => array('.noise-break.theme-woocommerce-cat-tag #breadcrumbs span'),
						'class' => 'theme-option-text-align-right',
					),
					array(
						'id'       => 'woocommerce_pagetitlebar_breadcrumb_regular_text_color',
						'type'     => 'color_rgba',
						'title'    => esc_html__( 'Regular text color', 'manual' ),
						'subtitle' => esc_html__('Breadcrumb regular text color.', 'manual'),
						'required' => array('woocommerce-disable-breadcrumb-cat-tag-page','equals','0'),
						'output'    => array('.noise-break.theme-woocommerce-cat-tag #breadcrumbs'),
						'class' => 'theme-option-text-align-right',
					),
					array(
						'id'       => 'woocommerce-pagetitlebar-background-setup',
						'type' => 'background',
						'title'    => esc_html__( 'Background', 'manual' ),
						'subtitle' => esc_html__( 'Create the background for your category/tag page.', 'manual' ),
						'desc' => __( '<span style="color:red;">IMPORTANT:</span> If you select category-based images for the \'page title bar\', the uploaded image will be overridden by the image uploaded via \'Products > Category\' specifically for that category. Any images uploaded elsewhere will be disregarded.', 'manual' ),
					),
					array(
						'id'       => 'woocommerce-pagetitlebar-image-overlay',
						'type'     => 'color_rgba',
						'title'    => esc_html__( 'Background overlay', 'manual' ),
						'subtitle'    => esc_html__( 'Select the background overlay for your WooCommerce page title bar.', 'manual' ),
						'output'    => array('background' => '.noise-break.theme-woocommerce-cat-tag .page_opacity.header_custom_height_new'),
						'class' => 'theme-option-text-align-right',
					),
		
		)
		) );
		
		
		// - single page
		Redux::setSection( $opt_name, array(
        'title'            => esc_html__( 'Custom \'Page Title Bar\' - Single Product Page', 'manual' ),
        'id'               => 'woocommerce_custom_header_single_product_pg',
        'subsection'       => true,
        'customizer_width' => '450px',
        'fields'           => array(
		
					array(
						'id'       => 'woocommerce_singlepg_pagetitlebar_header_menu',
						'type'     => 'switch',
						'title'    => esc_html__( 'Customize the header menu', 'manual' ),
						'subtitle' => esc_html__('Modify the main header, including the logo and menu colors, if needed.', 'manual'),
						'default'  => false,
					),
					array(
						'id'       => 'woocommerce_singlepg_pagetitlebar_header_background_colorbg',
						'type'     => 'color_rgba',
						'title'    => esc_html__( 'Background color', 'manual' ),
						'subtitle'    => esc_html__( 'Set the header background.', 'manual' ),
						'output'    => array('background' => '.navbar-inverse.theme-woocommerce-single-product'),
						'required' => array('woocommerce_singlepg_pagetitlebar_header_menu','equals','1'),
						'class' => 'theme-option-text-align-right',			
					),
					array(
						'id'       => 'woocommerce_singlepg_pagetitlebar_header_first_level_menu_text_color',
						'type'     => 'link_color',
						'title'    => esc_html__( 'Menu link color', 'manual' ),
						'subtitle' => esc_html__('Text color for the first level of the navigation menu.', 'manual'),
						'active'    => false, 
						'visited'   => false,
						'output'    => array('.navbar-inverse.theme-woocommerce-single-product .navbar-nav>li>a'), 
						'required' => array('woocommerce_singlepg_pagetitlebar_header_menu','equals','1'),
						'class' => 'theme-option-text-align-right',
					),
					array(
						'id'       => 'woocommerce_singlepg_pagetitlebar_header_flip_logo',
						'type'     => 'switch',
						'title'    => esc_html__( 'Flip logo', 'manual' ),
						'subtitle' => esc_html__('Switch from the \'primary logo\' to the \'secondary logo,\' if necessary.', 'manual'),
						'default'  => false,
						'class' => 'theme-option-text-align-right',
						'required' => array('woocommerce_singlepg_pagetitlebar_header_menu','equals','1'),
					),
					array(
						'id'       => 'woocommerce_singlepg_pagetitlebar_header_shadow',
						'type'     => 'switch',
						'title'    => esc_html__('Header shadow', 'manual' ),
						'desc' => esc_html__('Please note that this function is effective only when the header shadow is enabled in the \'Header Menu > Main Header\' settings.', 'manual'),
						'subtitle' => esc_html__('Turn the default header shadow on or off.', 'manual'),
						'default'  => false,
						'class' => 'theme-option-text-align-right',
						'required' => array('woocommerce_singlepg_pagetitlebar_header_menu','equals','1'),
					),
					array(
						'id'       => 'woocommerce_singlepg_pagetitlebar_header_menu_border_btm',
						'type'     => 'border',
						'title'    => esc_html__( 'Header border bottom', 'manual' ),
						'subtitle' => esc_html__('Re-adjust header border bottom', 'manual'),
						'color_alpha'  => true,
						'left'  => false,
						'right'  => false,
						'top'  => false,
						'class' => 'theme-option-text-align-right',
						'required' => array('woocommerce_singlepg_pagetitlebar_header_menu','equals','1'),
						'output'    => array('.navbar.theme-woocommerce-single-product'),
					),
					array(
						'id'       => 'woocommerce_singlepg_pagetitlebar_header_menu_border_top',
						'type'     => 'border',
						'title'    => esc_html__( 'Header border top', 'manual' ),
						'subtitle' => esc_html__('Re-adjust header border top', 'manual'),
						'desc' => esc_html__('If \'Menu position\' is set to \'Logo on Top\' and \'Menu Below Logo\' in \'Theme > Options > Header Menu > Main Header\', then this feature will work properly.', 'manual'),
						'color_alpha'  => true,
						'left'  => false,
						'right'  => false,
						'bottom'  => false,
						'required' => array('woocommerce_singlepg_pagetitlebar_header_menu','equals','1'),
						'class' => 'theme-option-text-align-right',
						'output'    => array('.navbar.theme-woocommerce-single-product .navbar-collapse.collapse'),
					),
					array(
						'id'       => 'woosingle_headermenu_hamburger_searchbox',
						'type'     => 'switch',
						'title'    => esc_html__( 'Hide the search box in the Hamburger menu.', 'manual' ),
						'desc' => esc_html__('This feature will only function if enabled \'Search Box in Hamburger Menu\' in the \'Theme Options\' under \'Header Menu\' in the \'Main Header\' section.', 'manual'),
						'default'  => false,
						'required' => array('woocommerce_singlepg_pagetitlebar_header_menu','equals','1'),
						'on' => esc_html__( 'Hide', 'manual' ),
						'off' => esc_html__( 'Theme Default', 'manual' ),
						'class' => 'theme-option-text-align-right',
					),
					array(
						'id'       => 'onoff-woocommerce-singlepg-title-bar',
						'type'     => 'switch',
						'title'    => esc_html__('Page title bar', 'manual' ),
						'subtitle' => __('Enable/Disable page title bar', 'manual'),
						'desc' => __('Note: Disabling the page title bar will change the menu style to the default setting, meaning that no transparent menu style will be used.', 'manual'),
						'default'  => true,
						'on'       => esc_html__( 'Enable', 'manual' ),
						'off'      => esc_html__( 'Disable', 'manual' ),
					),
					// -------------- Page Title Bar Controls --------------
					array(
						'id'       => 'woocommerce-singlepg-title-bar-controls',
						'type'     => 'section',
						'title'    => esc_html__( 'Page Title Bar', 'manual' ),
						'indent'   => true, 
						'required' => array('onoff-woocommerce-singlepg-title-bar','equals','1'),  
					),
					array(
						'id'       => 'woocommerce-singlepg-header-height',
						'type'     => 'text',
						'title'    => esc_html__( 'Page title bar :: padding', 'manual' ),
						'subtitle'    => esc_html__( 'Re-adjust the space above and below the \'Page Title Bar\' on your WooCommerce single product page.', 'manual' ),
						'desc' => __('Example: 120px 0px 120px 0px (top, right, bottom, left) <br><br><strong style="color:#e6614b;">IMPORTANT: Make sure the value of RIGHT, LEFT is always 0px</strong>', 'manual' ),
						'default'  => '25px 0px 25px 0px',
					),
					array(
						'id'       => 'woocommerce-singlepg-responsive-header-height',
						'type'     => 'text',
						'title'    => esc_html__( 'Page title bar :: Responsive padding', 'manual' ),
						'subtitle' => esc_html__( 'Re-adjust the top/bottom spacing for page title bar', 'manual' ),
						'desc'     => __( 'Example: 100px 0px 100px 0px (top, right, bottom, left) <br><br><strong style="color:#e6614b;">IMPORTANT: Make sure the value of RIGHT, LEFT is always 0px</strong>', 'manual' ), 
						'default'  => '25px 0px 25px 0px',
					),
					array(
						'id'       => 'woocommerce_singlepg_header_text_align',
						'type'     => 'select',
						'title'    => esc_html__( 'Breadcrumb align', 'manual' ),
						'subtitle'    => esc_html__( 'Adjust the alignment of the text on the \'page title bar\'', 'manual' ),
						'options'  => array(
							'left' => esc_html__('Left', 'manual' ),
							'center' => esc_html__('Center', 'manual' ),
							'right' => esc_html__('Right', 'manual' ),
						),
						'default'  => 'left'
					),
					array(
						'id'       => 'woocommerce_singlepg_pagetitlebar_breadcrumb_link_color',
						'type'     => 'link_color',
						'title'    => esc_html__( 'Link color', 'manual' ),
						'subtitle' => esc_html__('Adjust the color of breadcrumb links if needed.', 'manual'),
						'output'    => array('.noise-break.theme-woocommerce-single-product #breadcrumbs a'),
						'active'  => false,
						'class' => 'theme-option-text-align-right',
					),
					array(
						'id'       => 'woocommerce_singlepg_pagetitlebar_breadcrumb_link_seprator_color',
						'type'     => 'color_rgba',
						'title'    => esc_html__( 'Link seprator color', 'manual' ),
						'subtitle' => esc_html__('Adjust the color of breadcrumb link seprators if needed.', 'manual'),
						'output'    => array('.noise-break.theme-woocommerce-single-product #breadcrumbs span'),
						'class' => 'theme-option-text-align-right',
					),
					array(
						'id'       => 'woocommerce_singlepg_pagetitlebar_breadcrumb_regular_text_color',
						'type'     => 'color_rgba',
						'title'    => esc_html__( 'Regular text color', 'manual' ),
						'subtitle' => esc_html__('Breadcrumb regular text color.', 'manual'),
						'output'    => array('.noise-break.theme-woocommerce-single-product #breadcrumbs'),
						'class' => 'theme-option-text-align-right',
					),
					array(
						'id'       => 'woocommerce-singlepg-pagetitlebar-background-setup',
						'type' => 'background',
						'title'    => esc_html__( 'Background', 'manual' ),
						'subtitle' => esc_html__( 'Create the background for your product page.', 'manual' ),
					),
					array(
						'id'       => 'woocommerce-singlepg-pagetitlebar-image-overlay',
						'type'     => 'color_rgba',
						'title'    => esc_html__( 'Background overlay', 'manual' ),
						'subtitle'    => esc_html__( 'Select the background overlay for your WooCommerce page title bar.', 'manual' ),
						'output'    => array('background' => '.noise-break.theme-woocommerce-single-product .page_opacity.header_custom_height_new'),
						'class' => 'theme-option-text-align-right',
					),
		
		)
		) );

	
}

		
/********************************************************
*******  START - PAGE TEMPLATE "Home Page" SETTINGS *****
*********************************************************/
	 
	Redux::setSection( $opt_name, array(
		'title'            => esc_html__( 'Page Template "Home Page" Settings', 'manual' ),
		'id'               => 'homeconfg',
		'desc'             => esc_html__( 'These are really basic fields!', 'manual' ),
		'customizer_width' => '400px',
		'icon'             => 'el el-home'
	) );
		
	// Help Section	
	Redux::setSection( $opt_name, array(
		'title'            => esc_html__( 'Help Block', 'manual' ),
		'id'               => 'help-section',
		'subsection'       => true,
		'customizer_width' => '450px',
		'fields'           => array(
			array(
				'id'       => 'home-help-section-status',
				'type'     => 'switch',
				'title'    => esc_html__( 'Help block', 'manual' ),
				'subtitle'  => __( 'Turn on/off the help block.', 'manual' ),
				'default'  => true,
				'on' => esc_html__( 'Enable', 'manual' ),
				'off' => esc_html__( 'Disable', 'manual' ),
			),
			array(
				'id'       => 'home-help-section-mindisplay-blocks',
				'type'     => 'select',
				'title'    => esc_html__( 'Desktop view block selection', 'manual' ),
				'subtitle' => esc_html__( 'Choose how many blocks to show on the desktop view.', 'manual' ),
				'options'  => array(
					'3' => esc_html__('Block 3','manual' ),
					'4' => esc_html__('Block 4','manual' ),
				),
				'default'  => '4',
				'required' => array('home-help-section-status','equals','1'),
				'class'  => 'theme-option-text-align-right',
			),
			array(
				'id'       => 'home-help-section-title-main',
				'type'     => 'text',
				'title'    => esc_html__( 'Title', 'manual' ),
				'subtitle' => esc_html__( 'Main title text', 'manual' ),
				'default'  => 'Help Desk',
				'required' => array('home-help-section-status','equals','1'),
				'class'  => 'theme-option-text-align-right',
			),
			array(
				'id'       => 'home-help-section-title-typography',
				'type'        => 'typography',
				'title'    => esc_html__( 'Title typography', 'manual' ),
				'subtitle' => esc_html__( 'Customize main title text.', 'manual' ),
				'output'    => array('.static-homepage-help-blocks h2'),
				'required' => array('home-help-section-status','equals','1'),
				'google'      => true,
				'font-backup' => false,
				'text-align' => false,
				'text-transform' => true,
				'subsets'       => false, 
				'letter-spacing'=> true,  
				'all_styles'  => true,
				'font-backup' => true,
				'word-spacing' => true,
				'margin-top' => true,
				'margin-bottom' => true,
				'units'       => 'px',
				'class'  => 'theme-option-text-align-right',
			),
		    array(
				'id'      => 'home-help-section-msg-short',
				'type'    => 'textarea',
				'title'   => esc_html__( 'Sub title', 'manual' ),
				'subtitle' => esc_html__( 'A smaller title below the main title but above the blocks.', 'manual' ),
				'default' => esc_html__('Easily create Documentation, Knowledge-base, FAQ, Forum and more using page layouts and the tools we provide.','manual' ),
				'required' => array('home-help-section-status','equals','1'),
				'class'  => 'theme-option-text-align-right',
			),
			array(
				'id'       => 'home-help-section-subtitle-typography',
				'type'     => 'typography',
				'title'    => esc_html__( 'Sub-title typography', 'manual' ),
				'subtitle' => esc_html__( 'Customize sub-title text.', 'manual' ),
				'output'    => array('.static-homepage-help-blocks p.subtitle'),
				'required' => array('home-help-section-status','equals','1'),
				'google'      => true,
				'font-backup' => false,
				'text-align' => false,
				'text-transform' => true,
				'subsets'       => false, 
				'letter-spacing'=> true,  
				'all_styles'  => true,
				'font-backup' => true,
				'word-spacing' => true,
				'margin-top' => true,
				'margin-bottom' => true,
				'units'       => 'px',
				'class'  => 'theme-option-text-align-right',
			),
			// Repeater
			array(
				'id'           => 'home-help-blocks',
				'class'  => 'theme-option-text-align-right',
				'type'         => 'repeater',
				'title'        => esc_html__( 'Blocks', 'manual' ),
				'subtitle'     => esc_html__( 'Generate help blocks.', 'manual' ),
				'group_values' => true, 
				'limit'        => 12, 
				'sortable'     => true,
				'required' => array('home-help-section-status','equals','1'),
				'fields'         => array(
					array(
						'id'          => 'block_title',
						'type'        => 'text',
						'placeholder' => esc_html__( 'Title', 'manual' ),
					),
					array(
						'id'   => 'block_desc',
						'type' => 'textarea',
						'placeholder' => esc_html__( 'Description', 'manual' ),
					),
					array(
						'id'          => 'block_link_text',
						'type'        => 'text',
						'placeholder' => esc_html__( 'Link text', 'manual' ),
					),
					array(
						'id'          => 'block_link_url',
						'type'        => 'text',
						'placeholder' => esc_html__( 'Link URL', 'manual' ),
					),
					array(
						'id'    => 'block_bg_color',
						'type'  => 'color',
						'transparent'  => false,
						'title' => esc_html__( 'Box background color', 'manual' ),
					),
					array(
						'id'    => 'block_text_title_color',
						'type'  => 'color',
						'transparent'  => false,
						'title' => esc_html__( 'Title color', 'manual' ),
						'default'  => '#100549',
					),
					array(
						'id'    => 'block_text_desc_color',
						'type'  => 'color',
						'transparent'  => false,
						'title' => esc_html__( 'Description color', 'manual' ),
						'default'  => '#333333',
					),
					array(
						'id'    => 'block_link_color',
						'type'  => 'link_color',
						'visited'  => false,
						'active'  => false,
						'title' => esc_html__( 'Link color', 'manual' ),
					),
					array(
						'id'          => 'block_icon',
						'type'        => 'text',
						'placeholder' => esc_html__( 'fa-solid fa-check', 'manual' ),
						'title' => esc_html__( 'Icon', 'manual' ),
						'desc' => __('Enter <a href="https://fontawesome.com/search?m=free&o=r" target="_blank">fontawesome</a> name (eg: fa-solid fa-check) -OR- <br>Enter <a href="https://www.elegantthemes.com/blog/resources/elegant-icon-font" target="_blank">elegant icon font</a> name -OR- <br>Enter <a href="https://evelynmora.com/elements/et-line-icons/" target="_blank">et line font</a> name', 'manual' ),
					),
					array(
						'id'    => 'block_icon_color',
						'type'  => 'color',
						'transparent'  => false,
						'title' => esc_html__( 'Icon color', 'manual' ),
					),
					array(
						'id'       => 'block_title_font_size',
						'type'     => 'text',
						'title'    => esc_html__( 'Icon font size', 'manual' ),
						'default'  => '60px',
					),
					array(
						'id'       => 'block_custom_icon',
						'type'     => 'media',
						'title'    => esc_html__( 'Custom icon', 'manual' ),
						'url' => false,
					),
				)
		   ),
		)
	) );
	
	// Testimonials	
	Redux::setSection( $opt_name, array(
		'title'            => esc_html__( 'Testimonials', 'manual' ),
		'id'               => 'home-testimonials-section',
		'subsection'       => true,
		'customizer_width' => '450px',
		'fields'           => array(
				array(
					'id'       => 'home-testimonials-status',
					'type'     => 'switch',
					'title'    => esc_html__( 'Testimonial', 'manual' ),
					'subtitle'    => esc_html__( 'Turn on/off the testimonial block', 'manual' ),
					'default'  => true,
					'on' => esc_html__( 'Enable', 'manual' ),
					'off' => esc_html__( 'Disable', 'manual' ),
				),
				array(
					'id'       => 'testimonials-bg',
					'type'     => 'background',
					'title'    => esc_html__( 'Background', 'manual' ),
					'subtitle' => esc_html__( 'Select the background for your testimonial block.', 'manual' ),
					'output'    => array('.static-homepage-testo-block'),
					'required' => array('home-testimonials-status','equals','1'),
					'class'  => 'theme-option-text-align-right',
				),
				array(
					'id'       => 'testimonials-overlay-color',
					'type'      => 'color_rgba',
					'title'    => esc_html__( 'Background overlay', 'manual' ),
					'subtitle' => esc_html__( 'Select the background overlay for your testimonial block.', 'manual' ),
					'output'    => array('background' => '.static-homepage-testo-block-overlay'),
					'required' => array('home-testimonials-status','equals','1'),
					'class'  => 'theme-option-text-align-right',
					'default'   => array(
										'color'     => '#373835',
										'alpha'     => 0.79
									),
				),
				array(
					'id'       => 'testimonials-message-typography',
					'type'        => 'typography',
					'title'    => esc_html__( 'Message', 'manual' ),
					'subtitle' => esc_html__( 'Customize testimonials message.', 'manual' ),
					'output'    => array('.static-homepage-testo-block p.testo-title'),
					'required' => array('home-testimonials-status','equals','1'),
					'class'  => 'theme-option-text-align-right',
					'google'      => true,
					'font-backup' => false,
					'text-align' => false,
					'text-transform' => true,
					'subsets'       => false, 
					'letter-spacing'=> true,  
					'all_styles'  => true,
					'font-backup' => true,
					'word-spacing' => true,
					'units'       => 'px',
					'default'     => array(
						'font-size'   => '30px',
						'line-height' => '50px',
						'color' => '#FFFFFF',
					),
				),
				array(
					'id'       => 'testimonials-persons-typography',
					'type'        => 'typography',
					'title'    => esc_html__( 'Person', 'manual' ),
					'subtitle' => esc_html__( 'Customize person name.', 'manual' ),
					'output'   => array('.static-homepage-testo-block .testimonial-cite'),
					'required' => array('home-testimonials-status','equals','1'),
					'class'  => 'theme-option-text-align-right',
					'google'      => true,
					'font-backup' => false,
					'text-align' => false,
					'text-transform' => true,
					'subsets'       => false, 
					'letter-spacing'=> true,  
					'all_styles'  => true,
					'font-backup' => true,
					'word-spacing' => true,
					'units'       => 'px',
					'default'     => array(
						'font-size'   => '14px',
						'line-height' => '1.5px',
						'text-transform' => 'uppercase',
						'letter-spacing' => '',
						'color' => '#FFFFFF',
					),
				),
				// Repeater
				array(
					'id'           => 'home-testimonials-blocks',
					'class'  => 'theme-option-text-align-right',
					'type'         => 'repeater',
					'title'        => esc_html__( 'Testimonials', 'manual' ),
					'subtitle'     => esc_html__( 'Put customer reviews in the block.', 'manual' ),
					'group_values' => true, 
					'limit'        => 12, 
					'sortable'     => true,
					'required' => array('home-testimonials-status','equals','1'),
					'fields'         => array(
						array(
							'id'          => 'block_title',
							'type'        => 'text',
							'placeholder' => esc_html__( 'Person name', 'manual' ),
						),
						array(
							'id'   => 'block_desc',
							'type' => 'textarea',
							'placeholder' => esc_html__( 'Message', 'manual' ),
						),
					)
			   ),
		)
	) );
	
	// Organization Blocks	
	Redux::setSection( $opt_name, array(
		'title'            => esc_html__( 'Org Blocks', 'manual' ),
		'id'               => 'home-org-blocks-section',
		'subsection'       => true,
		'customizer_width' => '450px',
		'fields'           => array(
			array(
				'id'       => 'home-org-block-status',
				'type'     => 'switch',
				'title'    => esc_html__( 'Org blocks', 'manual' ),
				'default'  => true,
				'on' => esc_html__( 'Enable', 'manual' ),
				'off' => esc_html__( 'Disable', 'manual' ),
				'subtitle'    => esc_html__( 'Turn on/off the organization blocks', 'manual' ),
			),
			array(
				'id'       => 'home-org-block-main-title',
				'type'     => 'text',
				'title'    => esc_html__( 'Title', 'manual' ),
				'subtitle' => esc_html__( 'Main title text', 'manual' ),
				'default'  => 'Why People Love Us',
				'required' => array('home-org-block-status','equals','1'),
				'class'  => 'theme-option-text-align-right',
			),
			array(
				'id'       => 'home-org-block-main-title-typography',
				'type'        => 'typography',
				'title'    => esc_html__( 'Title typography', 'manual' ),
				'subtitle' => esc_html__( 'Customize main title text.', 'manual' ),
				'output'    => array('.static-homepage-org-blocks h2'),
				'required' => array('home-org-block-status','equals','1'),
				'class'  => 'theme-option-text-align-right',
				'google'      => true,
				'font-backup' => false,
				'text-align' => false,
				'text-transform' => true,
				'subsets'       => false, 
				'letter-spacing'=> true,  
				'all_styles'  => true,
				'font-backup' => true,
				'word-spacing' => true,
				'margin-top' => true,
				'margin-bottom' => true,
				'units'       => 'px',
			),
		    array(
				'id'      => 'home-org-block-sub-title',
				'type'    => 'textarea',
				'title'   => esc_html__( 'Sub title', 'manual' ),
				'class'  => 'theme-option-text-align-right',
				'subtitle' => esc_html__( 'A smaller title below the main title but above the blocks.', 'manual' ),
				'default' => 'Loaded with awesome features like Documentation, Knowledgebase, Forum & more!',
				'required' => array('home-org-block-status','equals','1'),
			),
			array(
				'id'       => 'home-org-block-sub-title-typography',
				'type'        => 'typography',
				'title'    => esc_html__( 'Sub-title typography', 'manual' ),
				'class'  => 'theme-option-text-align-right',
				'subtitle' => esc_html__( 'Customize sub title text.', 'manual' ),
				'output'    => array('.static-homepage-org-blocks p.desc'),
				'required' => array('home-org-block-status','equals','1'),
				'google'      => true,
				'font-backup' => false,
				'text-align' => false,
				'text-transform' => true,
				'subsets'       => false, 
				'letter-spacing'=> true,  
				'all_styles'  => true,
				'font-backup' => true,
				'word-spacing' => true,
				'margin-top' => true,
				'margin-bottom' => true,
				'units'       => 'px',
			),
			array(
				'id'       => 'home-org-block-background-url',
				'class'  => 'theme-option-text-align-right',
				'type'     => 'media',  
				'url' => false,
				'title'    => esc_html__( 'Sidebar image', 'manual' ),
				'subtitle' => esc_html__( 'Picture on the left side of the screen.', 'manual' ),
				'required' => array('home-org-block-status','equals','1'),
			),
			array(
				'id'           => 'home-org-blocks',
				'class'        => 'theme-option-text-align-right',
				'type'         => 'repeater',
				'title'        => esc_html__( 'Blocks', 'manual' ),
				'subtitle'     => esc_html__( 'Generate org blocks.', 'manual' ),
				'group_values' => true, 
				'limit'        => 6, 
				'sortable'     => true,
				'required' => array('home-org-block-status','equals','1'),
				'fields'         => array(
					array(
						'id'          => 'org_block_title',
						'type'        => 'text',
						'placeholder' => esc_html__( 'Title', 'manual' ),
					),
					array(
						'id'   => 'org_block_desc',
						'type' => 'text',
						'placeholder' => esc_html__( 'Description', 'manual' ),
					),
					array(
						'id'          => 'org_block_url',
						'type'        => 'text',
						'placeholder' => esc_html__( 'Link URL', 'manual' ),
					),
					array(
						'id'    => 'org_block_title_color',
						'type'  => 'color',
						'default'  => '#100549',
						'transparent'  => false,
						'title' => esc_html__( 'Title color', 'manual' ),
					),
					array(
						'id'    => 'org_block_desc_color',
						'type'  => 'color',
						'default'  => '#333333',
						'transparent'  => false,
						'title' => esc_html__( 'Description color', 'manual' ),
					),
					array(
						'id'          => 'org_block_icon',
						'type'        => 'text',
						'placeholder' => esc_html__( 'fa-solid fa-check', 'manual' ),
						'title' => esc_html__( 'Icon', 'manual' ),
						'desc' => __('Enter <a href="https://fontawesome.com/search?m=free&o=r" target="_blank">fontawesome</a> name (eg: fa-solid fa-check) -OR- <br>Enter <a href="https://www.elegantthemes.com/blog/resources/elegant-icon-font" target="_blank">elegant icon font</a> name -OR- <br>Enter <a href="https://evelynmora.com/elements/et-line-icons/" target="_blank">et line font</a> name', 'manual' ),
					),
					array(
						'id'    => 'org_block_icon_color',
						'type'  => 'color',
						'transparent'  => false,
						'title' => esc_html__( 'Icon color', 'manual' ),
					),
					array(
						'id'       => 'org_block_font_size',
						'type'     => 'text',
						'title'    => esc_html__( 'Icon font size', 'manual' ),
						'default'  => '56px',
					),
					array(
						'id'       => 'org_block_custom_icon',
						'type'     => 'media',
						'title'    => esc_html__( 'Custom icon', 'manual' ),
						'url' => false,
					),
					)
		   ),
		)
	) );
		
	// Message Bar	
	Redux::setSection( $opt_name, array(
		'title'            => esc_html__( 'Message Bar', 'manual' ),
		'id'               => 'home-message-bar-section',
		'subsection'       => true,
		'customizer_width' => '450px',
		'fields'           => array(
		
			array(
				'id'       => 'de-message-bar',
				'type'     => 'switch',
				'title'    => esc_html__( 'Message bar', 'manual' ),
				'default'  => true,
				'on' => esc_html__( 'Enable', 'manual' ),
				'off' => esc_html__( 'Disable', 'manual' ),
				'subtitle'    => esc_html__( 'Turn on/off the message bar', 'manual' ),
			),
			array(
				'id'       => 'message-bar-main-title',
				'type'     => 'text',
				'title'    => esc_html__( 'Title', 'manual' ),
				'class'        => 'theme-option-text-align-right',
				'subtitle' => esc_html__( 'Main title text', 'manual' ),
				'default'  => 'Didn\'t find any solution?',
				'required' => array('de-message-bar','equals','1'),
			),
			array(
				'id'       => 'message-bar-main-title-typography',
				'type'        => 'typography',
				'title'    => esc_html__( 'Title typography', 'manual' ),
				'class'        => 'theme-option-text-align-right',
				'subtitle' => esc_html__( 'Customize main title text.', 'manual' ),
				'output'    => array('.static-homepage-message-bar-block h2'),
				'required' => array('de-message-bar','equals','1'),
				'google'      => true,
				'font-backup' => false,
				'text-align' => false,
				'text-transform' => true,
				'subsets'       => false, 
				'letter-spacing'=> true,  
				'all_styles'  => true,
				'font-backup' => true,
				'word-spacing' => true,
				'margin-top' => true,
				'margin-bottom' => true,
				'units'       => 'px',
			),
			array(
				'id'      => 'message-bar-sub-title',
				'type'    => 'textarea',
				'title'   => esc_html__( 'Sub title', 'manual' ),
				'class'        => 'theme-option-text-align-right',
				'default' => 'Loaded with awesome features like Documentation, Knowledgebase, Forum & more!',
				'subtitle' => esc_html__( 'A smaller title below the main title but above the blocks.', 'manual' ),
				'required' => array('de-message-bar','equals','1'),
			),
			array(
				'id'       => 'message-bar-sub-title-typography',
				'type'        => 'typography',
				'title'    => esc_html__( 'Sub-title typography', 'manual' ),
				'class'        => 'theme-option-text-align-right',
				'subtitle' => esc_html__( 'Customize sub title text.', 'manual' ),
				'output'    => array('.static-homepage-message-bar-block p.desc'),
				'required' => array('de-message-bar','equals','1'),
				'google'      => true,
				'font-backup' => false,
				'text-align' => false,
				'text-transform' => true,
				'subsets'       => false, 
				'letter-spacing'=> true,  
				'all_styles'  => true,
				'font-backup' => true,
				'word-spacing' => true,
				'margin-top' => true,
				'margin-bottom' => true,
				'units'       => 'px',
			),
			array(
				'id'       => 'message-bar-bottom-display-text',
				'type'     => 'text',
				'title'    => esc_html__( 'Bottom text', 'manual' ),
				'class'        => 'theme-option-text-align-right',
				'subtitle' => esc_html__( 'Text at the bottom', 'manual' ),
				'default'  => 'Go To Live Chat',
				'required' => array('de-message-bar','equals','1'),
			),
			array(
				'id'       => 'message-bar-bottom-typography',
				'type'     => 'typography',
				'title'    => esc_html__( 'Bottom text typography', 'manual' ),
				'class'        => 'theme-option-text-align-right',
				'subtitle' => esc_html__( 'Customize bottom text.', 'manual' ),
				'output'    => array('p.home-message-darkblue-bar'),
				'required' => array('de-message-bar','equals','1'),
				'google'      => true,
				'font-backup' => false,
				'text-align' => false,
				'text-transform' => true,
				'subsets'       => false, 
				'letter-spacing'=> true,  
				'all_styles'  => true,
				'font-backup' => true,
				'word-spacing' => true,
				'color' => false,
				'units' => 'px',
			),
			array(
				'id'       => 'message-bar-bottom-url',
				'type'     => 'text',
				'title'    => esc_html__( 'Bottom text URL', 'manual' ),
				'class'        => 'theme-option-text-align-right',
				'default' => '#',
				'subtitle' => esc_html__( 'URL located at the bottom.', 'manual' ),
				'required' => array('de-message-bar','equals','1'),
			),
			array(
				'id'       => 'message_bar_botton_color',
				'type'     => 'link_color',
				'class'        => 'theme-option-text-align-right',
				'title'    => esc_html__( 'Background color', 'manual' ),
				'subtitle'  => esc_html__('Botton background color', 'manual'),
				'active'    => false, 
				'visited'   => false, 
				'required' => array('de-message-bar','equals','1'),
				'default'  => array(
					'regular' => '#46b289',
					'hover'   => '#001040',
				)
			),
			array(
				'id'       => 'message_bar_botton_text_color',
				'type'     => 'link_color',
				'class'        => 'theme-option-text-align-right',
				'title'    => esc_html__( 'Text color', 'manual' ),
				'subtitle'  => esc_html__('Botton text color', 'manual'),
				'active'    => false, 
				'visited'   => false,
				'output'    => array('p.home-message-darkblue-bar a'), 
				'required' => array('de-message-bar','equals','1'),
				'default'  => array(
					'regular' => '#ffffff',
					'hover'   => '#ffffff',
				)
			),
		)
	) );
	 
	// Fun Act
	Redux::setSection( $opt_name, array(
		'title'            => esc_html__( 'Fun Act', 'manual' ),
		'id'               => 'home-funact-section',
		'subsection'       => true,
		'customizer_width' => '450px',
		'fields'           => array(
		
				array(
					'id'       => 'home-funact-status',
					'type'     => 'switch',
					'title'    => esc_html__( 'Fun act', 'manual' ),
					'default'  => true,
					'on' => esc_html__( 'Enable', 'manual' ),
					'off' => esc_html__( 'Disable', 'manual' ),
					'subtitle'    => esc_html__( 'Turn on/off the fun act', 'manual' ),
				),
				array(
					'id'       => 'home-funact-bg',
					'type'     => 'background',
					'class'        => 'theme-option-text-align-right',
					'title'    => esc_html__( 'Background', 'manual' ),
					'subtitle' => esc_html__( 'Select the background for your fun act block.', 'manual' ),
					'output'    => array('.static-homepage-funact-block'),
					'required' => array('home-funact-status','equals','1'),
				),
				array(
					'id'       => 'home-funact-overlay-color',
					'type'      => 'color_rgba',
					'class'        => 'theme-option-text-align-right',
					'title'    => esc_html__( 'Background overlay', 'manual' ),
					'subtitle' => esc_html__( 'Select the background overlay for your fun act block.', 'manual' ),
					'output'    => array('background' => '.static-homepage-funact-block-overlay'),
					'required' => array('home-funact-status','equals','1'),
					'default'   => array(
										'color'     => '#373835',
										'alpha'     => 0.55
									),
				),
				array(
					'id'       => 'home-funact-main-title',
					'type'     => 'text',
					'class'        => 'theme-option-text-align-right',
					'title'    => esc_html__( 'Title', 'manual' ),
					'subtitle'    => esc_html__( 'Main title text', 'manual' ),
					'default'  => 'Our Status',
					'required' => array('home-funact-status','equals','1'),
				),
				array(
					'id'       => 'home-funact-main-title-typography',
					'type'     => 'typography',
					'class'        => 'theme-option-text-align-right',
					'title'    => esc_html__( 'Title typography', 'manual' ),
					'subtitle' => esc_html__( 'Customize main title text.', 'manual' ),
					'output'    => array('.static-homepage-funact-block h2'),
					'required' => array('home-funact-status','equals','1'),
					'google'      => true,
					'font-backup' => false,
					'text-align' => false,
					'text-transform' => true,
					'subsets'       => false, 
					'letter-spacing'=> true,  
					'all_styles'  => true,
					'font-backup' => true,
					'word-spacing' => true,
					'margin-top' => true,
					'margin-bottom' => true,
					'units'       => 'px',
					'default'     => array(
						'color' => '#FFFFFF',
					),
				),
				array(
					'id'      => 'home-funact-sub-title',
					'type'    => 'textarea',
					'class'        => 'theme-option-text-align-right',
					'title'   => esc_html__( 'Sub Title', 'manual' ),
					'subtitle'    => esc_html__( 'A smaller title below the main title but above the blocks.', 'manual' ),
					'default' => 'Loaded with awesome features like Documentation, Knowledgebase, Forum & more!',
					'required' => array('home-funact-status','equals','1'),
				),
				array(
					'id'       => 'home-funact-sub-title-typography',
					'type'     => 'typography',
					'class'        => 'theme-option-text-align-right',
					'title'    => esc_html__( 'Sub title typography', 'manual' ),
					'subtitle' => esc_html__( 'Customize sub title text.', 'manual' ),
					'output'    => array('.static-homepage-funact-block p.desc'),
					'required' => array('home-funact-status','equals','1'),
					'google'      => true,
					'font-backup' => false,
					'text-align' => false,
					'text-transform' => true,
					'subsets'       => false, 
					'letter-spacing'=> true,  
					'all_styles'  => true,
					'font-backup' => true,
					'word-spacing' => true,
					'margin-top' => true,
					'margin-bottom' => true,
					'units'       => 'px',
					'default'     => array(
						'color' => '#FFFFFF',
					),
				),
				array(
				'id'           => 'home-funact-stats',
				'type'         => 'repeater',
				'class'        => 'theme-option-text-align-right',
				'title'        => esc_html__( 'Fun act', 'manual' ),
				'subtitle'     => esc_html__( 'Define organization fun act.', 'manual' ),
				'group_values' => true, 
				'limit'        => 4, 
				'sortable'     => true,
				'required' => array('home-funact-status','equals','1'),
				'fields'         => array(
					array(
						'id'          => 'fun_act_title',
						'type'        => 'text',
						'placeholder' => esc_html__( 'Title (fun act)', 'manual' ),
					),
					array(
						'id'   => 'fun_act_number',
						'type' => 'text',
						'placeholder' => esc_html__( 'Number', 'manual' ),
					),
					array(
						'id'    => 'fun_act_title_color',
						'type'  => 'color',
						'default'  => '#ffffff',
						'transparent'  => false,
						'title' => esc_html__( 'Title color', 'manual' ),
					),
					array(
						'id'    => 'fun_act_number_color',
						'type'  => 'color',
						'default'  => '#ffffff',
						'transparent'  => false,
						'title' => esc_html__( 'Number color', 'manual' ),
					),
					)
		  	 ),
			 array(
				'id'       => 'home-funact-funact-title-typography',
				'type'     => 'typography',
				'class'        => 'theme-option-text-align-right',
				'title'    => esc_html__( 'Fun act typography', 'manual' ),
				'subtitle' => esc_html__( 'Customize fun act text.', 'manual' ),
				'output'    => array('.static-homepage-funact-block .counter-text.countdown'),
				'required' => array('home-funact-status','equals','1'),
				'google'      => true,
				'font-backup' => false,
				'text-align' => false,
				'text-transform' => true,
				'subsets'       => false, 
				'letter-spacing'=> true,  
				'all_styles'  => true,
				'font-backup' => true,
				'word-spacing' => true,
				'color' => false,
				'units'       => 'px',
				'default'     => array(
					'font-weight' => '500',
					'text-transform' => 'uppercase',
					'letter-spacing' => '1px',
				),
			),
			array(
				'id'       => 'home-funact-funact-number-typography',
				'type'     => 'typography',
				'class'        => 'theme-option-text-align-right',
				'title'    => esc_html__( 'Fun act number', 'manual' ),
				'subtitle' => esc_html__( 'Customize number text.', 'manual' ),
				'output'    => array('.static-homepage-funact-block .counter-number'),
				'required' => array('home-funact-status','equals','1'),
				'google'      => true,
				'font-backup' => false,
				'text-align' => false,
				'text-transform' => true,
				'subsets'       => false, 
				'letter-spacing'=> true,  
				'all_styles'  => true,
				'font-backup' => true,
				'word-spacing' => true,
				'color' => false,
				'units'       => 'px',
				'default'     => array(
					'font-family' => 'Dosis',
					'font-weight' => '700',
					'font-size' => '60px',
					'line-height' => '60px',
				),
			),
		)
	) );
		

/*******************************************
*******  THEME OPTIONS  - CUSTOM STYLE *****
********************************************/

		Redux::setSection( $opt_name, array(
			'title'            => esc_html__( 'Extra - Settings', 'manual' ),
			'id'               => 'manual-theme-custom-style',
			'customizer_width' => '400px',
			'icon'             => 'el el-cogs'
		) );
		
		// NOTIFICATION
		Redux::setSection( $opt_name, array(
		'title'            => esc_html__( 'Notification Bar', 'manual' ),
		'id'               => 'footer-notification-bar',
		'subsection'  => true,
		'fields'           => array(
		
				array(
					'id'       => 'footer-notification-status',
					'type'     => 'switch',
					'title'    => esc_html__( 'Notification bar', 'manual' ),
					'subtitle'    => esc_html__( 'Turn on/off the notification bar.', 'manual' ),
					'default'  => true,
					'on' => esc_html__( 'Enable', 'manual' ),
					'off' => esc_html__( 'Disable', 'manual' ),
				),
				array(
					'id'       => 'footer-notification-bar-background',
					'type'     => 'background',
					'title'    => esc_html__( 'Background', 'manual' ),
					'subtitle'    => esc_html__( 'Set up the background for the notification bar.', 'manual' ),
					'required' => array('footer-notification-status','equals',true),
					'output'   => array('#footer-info.footer-notification-bar'),
					'class'  => 'theme-option-text-align-right',
					'default'  => array(
						'background-color' => '#5AA773',
					),
				),
				array(
					'id'       => 'footer-notification-bar-overlay-color',
					'type'      => 'color_rgba',
					'title'    => esc_html__( 'Background overlay', 'manual' ),
					'subtitle' => esc_html__( 'Select the background overlay for your notification bar.', 'manual' ),
					'output'    => array('background-color' => '#footer-info.footer-notification-bar .overlay'),
					'required' => array('footer-notification-status','equals',true),
					'class'  => 'theme-option-text-align-right',
				),
				array(
					'id'       => 'footer-notification-bar-message-typography',
					'type'     => 'typography',
					'title'    => esc_html__( 'Message typography', 'manual' ),
					'subtitle' => esc_html__( 'Customize message text.', 'manual' ),
					'output'    => array('#footer-info.footer-notification-bar .footer-msg-bar'),
					'required' => array('footer-notification-status','equals',true),
					'class'  => 'theme-option-text-align-right',
					'google'      => true,
					'font-backup' => false,
					'text-align' => false,
					'text-transform' => true,
					'subsets'       => false, 
					'letter-spacing'=> true,  
					'all_styles'  => true,
					'font-backup' => true,
					'word-spacing' => true,
					'margin-top' => true,
					'margin-bottom' => true,
					'units'       => 'px',
					'default'     => array(
						'color' => '#FFFFFF',
					),
				),
				array(
					'id'      => 'footer-text',
					'type'    => 'editor',
					'title'   => esc_html__( 'Message', 'manual' ),
					'subtitle' => esc_html__( 'Notification message.', 'manual' ),
					'class'  => 'theme-option-text-align-right',
					'required' => array('footer-notification-status','equals',true),
					'default' => 'Support staff monitor the community forum and email 9 AM - 6 PM, Sunday to Friday. Please be patient when posting an issue as staff may not be in the same timezone as you.',
					'args'    => array(
						'wpautop'       => false,
						'media_buttons' => false,
						'textarea_rows' => 5,
						'teeny'         => false,
						'quicktags'     => true,
					)
				),
			
			)
		) );
			
		
		// TOC
		Redux::setSection( $opt_name, array(
			'title'            => esc_html__( 'Table Of Content', 'manual' ),
			'id'               => 'table-of-content-settings',
			'subsection'  => true,
			'fields'           => array(
				array(
					'id'       => 'toc-link',
					'type'     => 'switch',
					'title'    => __('TOC hyperlink','manual'),
					'subtitle' => esc_html__('Hyperlink type', 'manual'),
					'desc' => __('If the \'Random Link\' setting is enabled in the system, it will create hyperlinks with random alphanumeric strings like \'1080401117-ghwge2\' for the table of contents. However, if the \'Title Link\' option is selected, the system will create title links based on the content within the h2, h3, h4, and h5 tags. <br><br><span style="color:red;">Please note that the \'Title Link\' feature may not function correctly for site languages such as Chinese or Japanese or others</span>.', 'manual'),
					'default'  => true,
					'on' => esc_html__( 'Random Link', 'manual' ),
					'off' => esc_html__( 'Title Link', 'manual' ),
				),
	
			)
		) );
					
		// GO UP ARROW
		Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Go Up Arrow', 'manual' ),
		'id'     => 'manual-theme-go-up-style',
		'subsection'  => true,
		'fields' => array(
				// start
				array(
					'id'            => 'go_up_arrow_font_size',
					'type'          => 'slider',
					'title'         => esc_html__( 'Icon font size', 'manual' ),
					'subtitle'         => esc_html__( 'Customize the icon font size based on your preferences.', 'manual' ),
					'default'       => 24,
					'min'           => 1,
					'step'          => 1,
					'max'           => 60,
					'display_value' => 'label',
					'desc' => esc_html__( 'Default: 24px', 'manual' ),
					'display_value' => 'text',
				),
				array(
					'id'       => 'go_up_arrow_icon_style',
					'type'     => 'text',
					'title'    => esc_html__( 'Icon name', 'manual' ),
					'desc'     => __( 'Enter <a href=\'http://fortawesome.github.io/Font-Awesome/icons/\' target=\"_blank\">fontawesome</a> name (eg: far fa-arrow-alt-circle-up) -OR- <br>Enter <a href=\'https://www.elegantthemes.com/blog/resources/elegant-icon-font\' target=\"_blank\">elegant icon font</a> name -OR- <br>Enter <a href=\'http://demo.wpsmartapps.com/themes/manual/et-line-font/\' target=\"_blank\">et line font</a> name', 'manual' ),
					'default'  => 'far fa-arrow-alt-circle-up',
					'subtitle' => esc_html__( 'Pick an icon style that goes well with your design.', 'manual' ),
				),
				array(
					'id'       => 'manual-go-up-icon-color',
					'type'     => 'color_rgba',
					'title'    => esc_html__( 'Icon color', 'manual' ),
					'subtitle' => esc_html__( 'Pick an icon color that goes well with your design.', 'manual' ),
					'default'  => array(
						'color' => '#3e51e4',
						'alpha' => '1'
					),
					'mode'     => 'background',
				),
				// eof section
			)
		) );
		
		// SOCIAL SHARE
		Redux::setSection( $opt_name, array(
        'title'  => esc_html__( 'Social Share', 'manual' ),
        'id'     => 'manual-theme-general-social-share',
		'subsection'  => true,
        'fields' => array(
		
			array(
				'id'       => 'theme-social-box',
				'type'     => 'switch',
				'title'    => esc_html__( 'Social share', 'manual' ),
				'default'  => true,
				'subtitle' => esc_html__( 'Turn on or off the social share buttons that appear at the end of every post (affects all posts).', 'manual' ),
				'desc' => __( '<span style="color:red;">Use the ON|OFF option to disable the "Social Share" feature separately on the blog, knowledge base, and documentation sections.</span>', 'manual' ),
			),
			array (
				'subtitle' => esc_html__('This subject will be the default when visitors attempt to email their favorite read post to their friends.', 'manual'),
				'id' => 'theme-social-box-mailto-subject',
				'type' => 'text',
				'title' => esc_html__('Email subject', 'manual'),
				'default' => esc_html__('Awesome Post', 'manual'),
				'required' => array('theme-social-box','equals',true),
				'class'  => 'theme-option-text-align-right',
			),
			array(
                'id'       => 'theme-social-share-displaycrl-status',
                'type'     => 'sortable',
				'mode'     => 'checkbox',
                'title'    => esc_html__( 'Social share icons', 'manual' ),
                'subtitle' => esc_html__( 'Adjust the order or control the appearance of social share buttons.', 'manual' ),
				'required' => array('theme-social-box','equals',true),
				'class'  => 'theme-option-text-align-right',
				'options'  => array(
                    'twitter' => esc_html__('Twitter','manual' ),
                    'facebook' => esc_html__('Facebook','manual' ),
                    'pinterest' => esc_html__('Pinterest','manual' ),
                    'google-plus' => esc_html__('Google Plus','manual' ),
                    'email' => esc_html__('Email','manual' ),
                    'linkedin' => esc_html__('LinkedIn','manual' ),
                ),
                'default'  => array(
                    'twitter' => true,
                    'facebook' => true,
                    'pinterest' => true,
                    'google-plus' => true,
                    'email' => true,
                    'linkedin' => false,
                )
            ),
		)
	) );



/********************************************
*******  START - CUSTOM CODE  SECTION   *****
*********************************************/

	 Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Custom Code', 'manual' ),
        'id'         => 'manual-editor',
        'subsection' => false,
		'icon'       => 'el el-css',
        'fields'     => array(
							  
            array(
                'id'       => 'manual-editor-css',
                'type'     => 'ace_editor',
                'title'    => esc_html__( 'CSS Custom Code', 'manual' ),
                'subtitle' => esc_html__( 'Change theme design using your own custom code', 'manual' ),
                'mode'     => 'css',
                'theme'    => 'monokai',
            ),
			
            array(
                'id'       => 'manual-editor-js',
                'type'     => 'ace_editor',
                'title'    => esc_html__( 'JS Code', 'manual' ),
                'subtitle' => esc_html__( 'Paste your JS code here.', 'manual' ),
                'mode'     => 'javascript',
                'theme'    => 'chrome',
            ),
			
        )
    ) );


/**********************************************
*******  //  END OF - THEME OPTIONS  //   *****
***********************************************/
	 
    /**
     * Removes the demo link and the notice of integrated demo from the redux-framework plugin
     */
    if ( ! function_exists( 'remove_demo' ) ) {
        function remove_demo() {
            // Used to hide the demo mode link from the plugin page. Only used when Redux is a plugin.
            if ( class_exists( 'ReduxFrameworkPlugin' ) ) {
                remove_filter( 'plugin_row_meta', array(
                    ReduxFrameworkPlugin::instance(),
                    'plugin_metalinks'
                ), null, 2 );

                // Used to hide the activation notice informing users of the demo panel. Only used when Redux is a plugin.
                remove_action( 'admin_notices', array( ReduxFrameworkPlugin::instance(), 'admin_notices' ) );
            }
        }
    }

?>